/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.jdbc.BaseWiremockTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="core")
public class SessionUtilWiremockIT
extends BaseWiremockTest {
    private static final int DECREASED_LOGIN_TIMEOUT = 5;
    private static final String OKTA_VANITY_PATH = "/okta-stub/vanity-url";
    private static final String OKTA_AUTH_API_ENDPOINT = "/okta-stub/vanity-url/api/v1";
    private static final String OKTA_SAML_RESPONSE_SUBPATH = "/sso/saml";
    private static final String ALWAYS_429_IN_FEDERATED_STEP_3 = "/wiremock/mappings/session/session-util-wiremock-it-always-429-in-federated-step-3.json";
    private static final String ALWAYS_429_IN_FEDERATED_STEP_4 = "/wiremock/mappings/session/session-util-wiremock-it-always-429-in-federated-step-4.json";
    private static final String MULTIPLE_429_IN_FEDERATED_STEP_3 = "/wiremock/mappings/session/session-util-wiremock-it-multiple-429-in-federated-step-3.json";
    private static final String MULTIPLE_429_IN_FEDERATED_STEP_4 = "/wiremock/mappings/session/session-util-wiremock-it-multiple-429-in-federated-step-4.json";
    private static final long EXPECTED_MIN_RETRY_DELAY_MS = 1000L;
    private final String WIREMOCK_HOST_WITH_HTTPS = "https://localhost";
    private final String WIREMOCK_HOST_WITH_HTTPS_AND_PORT = "https://localhost:" + wiremockHttpsPort;

    private SFLoginInput createOktaLoginInputBase() {
        SFLoginInput input = new SFLoginInput();
        input.setServerUrl(this.WIREMOCK_HOST_WITH_HTTPS_AND_PORT);
        input.setUserName("MOCK_USERNAME");
        input.setPassword("MOCK_PASSWORD");
        input.setAccountName("MOCK_ACCOUNT_NAME");
        input.setAppId("MOCK_APP_ID");
        input.setOCSPMode(OCSPMode.FAIL_OPEN);
        input.setHttpClientSettingsKey(new HttpClientSettingsKey(OCSPMode.FAIL_OPEN));
        input.setLoginTimeout(1000);
        input.setSessionParameters(new HashMap());
        input.setAuthenticator(this.WIREMOCK_HOST_WITH_HTTPS_AND_PORT + OKTA_VANITY_PATH);
        return input;
    }

    private Map<SFSessionProperty, Object> initConnectionPropertiesMap() {
        HashMap<SFSessionProperty, Object> connectionPropertiesMap = new HashMap<SFSessionProperty, Object>();
        connectionPropertiesMap.put(SFSessionProperty.TRACING, "ALL");
        return connectionPropertiesMap;
    }

    @Test
    public void testOktaRetryWaitsUsingDefaultRetryStrategyWhen429InFederatedStep3() throws Throwable {
        HashMap<String, Object> placeholders = new HashMap<String, Object>();
        placeholders.put("{{WIREMOCK_HOST_WITH_HTTPS_AND_PORT}}", this.WIREMOCK_HOST_WITH_HTTPS_AND_PORT);
        String wireMockMapping = this.getWireMockMappingFromFile(MULTIPLE_429_IN_FEDERATED_STEP_3, placeholders);
        this.importMapping(wireMockMapping);
        this.setCustomTrustStorePropertyPath();
        SFLoginInput loginInput = this.createOktaLoginInputBase();
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.initConnectionPropertiesMap();
        try {
            SessionUtil.openSession((SFLoginInput)loginInput, connectionPropertiesMap, (String)"ALL");
        }
        catch (SnowflakeSQLException ex) {
            Assertions.fail((String)("SessionUtil test failed with error: " + ex.getMessage()));
        }
        List<BaseWiremockTest.MinimalServeEvent> allEvents = this.getAllServeEvents();
        List<BaseWiremockTest.MinimalServeEvent> vanityUrlCalls = allEvents.stream().filter(e -> e.getRequest().getUrl().contains(OKTA_AUTH_API_ENDPOINT)).sorted(Comparator.comparing(e -> e.getRequest().getLoggedDate())).collect(Collectors.toList());
        MatcherAssert.assertThat((String)("Expected multiple calls to /okta-stub/vanity-url/api/v1, got " + vanityUrlCalls.size()), (Object)vanityUrlCalls.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(2)));
        this.assertRequestsToWiremockHaveDelay(vanityUrlCalls, 1000L);
    }

    @Test
    public void testOktaRetryWaitsUsingDefaultRetryStrategyWhen429InFederatedStep4() throws Throwable {
        HashMap<String, Object> placeholders = new HashMap<String, Object>();
        placeholders.put("{{WIREMOCK_HOST_WITH_HTTPS_AND_PORT}}", this.WIREMOCK_HOST_WITH_HTTPS_AND_PORT);
        String wireMockMapping = this.getWireMockMappingFromFile(MULTIPLE_429_IN_FEDERATED_STEP_4, placeholders);
        this.importMapping(wireMockMapping);
        this.setCustomTrustStorePropertyPath();
        SFLoginInput loginInput = this.createOktaLoginInputBase();
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.initConnectionPropertiesMap();
        try {
            SessionUtil.openSession((SFLoginInput)loginInput, connectionPropertiesMap, (String)"ALL");
        }
        catch (SnowflakeSQLException ex) {
            Assertions.fail((String)ex.getMessage());
        }
        List<BaseWiremockTest.MinimalServeEvent> allEvents = this.getAllServeEvents();
        List<BaseWiremockTest.MinimalServeEvent> vanityUrlCalls = allEvents.stream().filter(e -> e.getRequest().getUrl().contains(OKTA_SAML_RESPONSE_SUBPATH)).sorted(Comparator.comparing(e -> e.getRequest().getLoggedDate())).collect(Collectors.toList());
        MatcherAssert.assertThat((String)("Expected multiple calls to /sso/saml, got " + vanityUrlCalls.size()), (Object)vanityUrlCalls.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(2)));
        this.assertRequestsToWiremockHaveDelay(vanityUrlCalls, 1000L);
        this.assertRequestsToWiremockHaveDifferentValuesOfParameter(vanityUrlCalls, "onetimetoken");
    }

    @Test
    public void testOktaRetriesUntilTimeoutThenRaisesAuthTimeoutExceptionWhen429InFederatedStep3() throws Throwable {
        HashMap<String, Object> placeholders = new HashMap<String, Object>();
        placeholders.put("{{WIREMOCK_HOST_WITH_HTTPS_AND_PORT}}", this.WIREMOCK_HOST_WITH_HTTPS_AND_PORT);
        String wireMockMapping = this.getWireMockMappingFromFile(ALWAYS_429_IN_FEDERATED_STEP_3, placeholders);
        this.importMapping(wireMockMapping);
        this.setCustomTrustStorePropertyPath();
        SFLoginInput loginInput = this.createOktaLoginInputBase();
        loginInput.setLoginTimeout(5);
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.initConnectionPropertiesMap();
        try {
            SessionUtil.openSession((SFLoginInput)loginInput, connectionPropertiesMap, (String)"ALL");
        }
        catch (SnowflakeSQLException ex) {
            MatcherAssert.assertThat((String)"When timeout for login in retrieving OKTA auth response is reached NETWORK_ERROR should be raised", (Object)ex.getErrorCode(), (Matcher)Matchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
        }
    }

    @Test
    public void testOktaRetriesUntilTimeoutThenRaisesAuthTimeoutExceptionWhen429InFederatedStep4() throws Throwable {
        int ALLOWED_DIFFERENCE_BETWEEN_LOGIN_TIMEOUT_AND_ACTUAL_DURATION_IN_MS = 500;
        HashMap<String, Object> placeholders = new HashMap<String, Object>();
        placeholders.put("{{WIREMOCK_HOST_WITH_HTTPS_AND_PORT}}", this.WIREMOCK_HOST_WITH_HTTPS_AND_PORT);
        String wireMockMapping = this.getWireMockMappingFromFile(ALWAYS_429_IN_FEDERATED_STEP_4, placeholders);
        this.importMapping(wireMockMapping);
        this.setCustomTrustStorePropertyPath();
        SFLoginInput loginInput = this.createOktaLoginInputBase();
        loginInput.setLoginTimeout(5);
        Map<SFSessionProperty, Object> connectionPropertiesMap = this.initConnectionPropertiesMap();
        try {
            SessionUtil.openSession((SFLoginInput)loginInput, connectionPropertiesMap, (String)"ALL");
        }
        catch (SnowflakeSQLException ex) {
            MatcherAssert.assertThat((String)"When timeout for login in retrieving OKTA auth response is reached NETWORK_ERROR should be raised", (Object)ex.getErrorCode(), (Matcher)Matchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
        }
        List<BaseWiremockTest.MinimalServeEvent> allEvents = this.getAllServeEvents();
        List<BaseWiremockTest.MinimalServeEvent> vanityUrlCalls = allEvents.stream().filter(e -> e.getRequest().getUrl().contains(OKTA_VANITY_PATH)).sorted(Comparator.comparing(e -> e.getRequest().getLoggedDate())).collect(Collectors.toList());
        this.assertThatTotalLoginTimeoutIsKeptWhenRetrying(vanityUrlCalls, loginInput.getLoginTimeout(), 500L);
    }

    private void assertThatTotalLoginTimeoutIsKeptWhenRetrying(List<BaseWiremockTest.MinimalServeEvent> requestEvents, long loginTimeout, long allowedDifferenceInMs) {
        int SECONDS_TO_MS_FACTOR = 1000;
        long firstRequestTime = requestEvents.get(0).getRequest().getLoggedDate().getTime();
        long lastRequestTime = requestEvents.get(requestEvents.size() - 1).getRequest().getLoggedDate().getTime();
        long approximatedDurationOfOktaRetriesBasedOnLogsInMs = lastRequestTime - firstRequestTime;
        long differenceBetweenTimeoutAndCalculatedDurationInMs = Math.abs(loginTimeout * 1000L - approximatedDurationOfOktaRetriesBasedOnLogsInMs);
        MatcherAssert.assertThat((String)String.format("Retrying calls to okta lasted %d ms, while login timeout was set to %d ms.", approximatedDurationOfOktaRetriesBasedOnLogsInMs, loginTimeout), (Object)allowedDifferenceInMs, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(differenceBetweenTimeoutAndCalculatedDurationInMs)));
    }

    private void assertRequestsToWiremockHaveDelay(List<BaseWiremockTest.MinimalServeEvent> requestEvents, long minExpectedDelayBetweenCalls) {
        for (int i = 1; i < requestEvents.size(); ++i) {
            long t1 = requestEvents.get(i - 1).getRequest().getLoggedDate().getTime();
            long t2 = requestEvents.get(i).getRequest().getLoggedDate().getTime();
            long deltaMillis = t2 - t1;
            MatcherAssert.assertThat((String)String.format("Consecutive calls were only %d ms apart (index %d -> %d).", deltaMillis, i - 1, i), (Object)deltaMillis, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(minExpectedDelayBetweenCalls)));
        }
    }

    private void assertRequestsToWiremockHaveDifferentValuesOfParameter(List<BaseWiremockTest.MinimalServeEvent> requestEvents, String parameterName) {
        List paramValues = requestEvents.stream().filter(e -> e.getRequest().getQueryParams().containsKey(parameterName)).map(e -> e.getRequest().getQueryParams().get(parameterName).firstValue()).collect(Collectors.toList());
        long distinctCount = paramValues.stream().distinct().count();
        MatcherAssert.assertThat((String)("Found duplicate value(s) for parameter '" + parameterName + "'. Values: " + paramValues), (Object)distinctCount, (Matcher)Matchers.equalTo((Object)paramValues.size()));
    }
}

