/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.core.CredentialManager;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SecureStorageManager;
import net.snowflake.client.core.SecureStorageWindowsManager;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.jdbc.SnowflakeBasicDataSource;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class SnowflakeMFACacheTest {
    private static final ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
    private static final String[] mockedMfaToken = new String[]{"mockedMfaToken0", "mockedMfaToken1"};
    private static final String host = "TESTACCOUNT.SNOWFLAKECOMPUTING.COM";
    private static final String account = "testaccount";
    private static final String user = "testuser";
    private static final String pwd = "testpassword";
    private static final String authenticator = "username_password_mfa";
    private static final boolean client_request_mfa_token = true;

    private ObjectNode getNormalMockedHttpResponse(boolean success, int mfaTokenIdx) {
        ObjectNode respNode = mapper.createObjectNode();
        ObjectNode dataNode = mapper.createObjectNode();
        ArrayNode paraArray = mapper.createArrayNode();
        ObjectNode autocommit = mapper.createObjectNode();
        autocommit.put("name", "AUTOCOMMIT");
        autocommit.put("value", true);
        paraArray.add((JsonNode)autocommit);
        dataNode.set("parameters", (JsonNode)paraArray);
        dataNode.put("masterToken", "mockedMasterToken");
        dataNode.put("token", "mockedToken");
        if (mfaTokenIdx >= 0) {
            dataNode.put("mfaToken", mockedMfaToken[mfaTokenIdx]);
        }
        respNode.set("data", (JsonNode)dataNode);
        respNode.put("success", success);
        respNode.put("message", "msg");
        return respNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode parseRequest(HttpPost post) throws IOException {
        String theString;
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            try (InputStream ins = post.getEntity().getContent();){
                IOUtils.copy((InputStream)ins, (Writer)writer, (String)"UTF-8");
            }
            theString = writer.toString();
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        JsonNode jsonNode = mapper.readTree(theString);
        return jsonNode;
    }

    private Properties getBaseProp() {
        Properties prop = new Properties();
        prop.put("account", account);
        prop.put("user", user);
        prop.put("password", pwd);
        prop.put("authenticator", authenticator);
        prop.put("CLIENT_REQUEST_MFA_TOKEN", (Object)true);
        return prop;
    }

    @Test
    public void testMFAFunctionality() throws SQLException {
        SessionUtil.deleteMfaTokenCache((String)host, (String)user);
        try (MockedStatic mockedHttpUtil = Mockito.mockStatic(HttpUtil.class);){
            mockedHttpUtil.when(() -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)ArgumentMatchers.any(HttpPost.class)), (int)ArgumentMatchers.anyInt(), (int)ArgumentMatchers.anyInt(), (int)ArgumentMatchers.anyInt(), (int)ArgumentMatchers.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)ArgumentMatchers.any(HttpClientSettingsKey.class)))).thenAnswer((Answer)new Answer<String>(){
                int callCount = 0;

                public String answer(InvocationOnMock invocation) throws Throwable {
                    String res;
                    Object[] args = invocation.getArguments();
                    if (this.callCount == 0) {
                        JsonNode jsonNode = SnowflakeMFACacheTest.this.parseRequest((HttpPost)args[0]);
                        Assertions.assertTrue((boolean)jsonNode.path("data").path("SESSION_PARAMETERS").path("CLIENT_REQUEST_MFA_TOKEN").asBoolean());
                        res = SnowflakeMFACacheTest.this.getNormalMockedHttpResponse(true, 0).toString();
                    } else if (this.callCount == 1) {
                        res = SnowflakeMFACacheTest.this.getNormalMockedHttpResponse(true, -1).toString();
                    } else if (this.callCount == 2) {
                        JsonNode jsonNode = SnowflakeMFACacheTest.this.parseRequest((HttpPost)args[0]);
                        Assertions.assertTrue((boolean)jsonNode.path("data").path("SESSION_PARAMETERS").path("CLIENT_REQUEST_MFA_TOKEN").asBoolean());
                        Assertions.assertEquals((Object)mockedMfaToken[0], (Object)jsonNode.path("data").path("TOKEN").asText());
                        res = SnowflakeMFACacheTest.this.getNormalMockedHttpResponse(true, 1).toString();
                    } else if (this.callCount == 3) {
                        res = SnowflakeMFACacheTest.this.getNormalMockedHttpResponse(true, -1).toString();
                    } else if (this.callCount == 4) {
                        JsonNode jsonNode = SnowflakeMFACacheTest.this.parseRequest((HttpPost)args[0]);
                        Assertions.assertTrue((boolean)jsonNode.path("data").path("SESSION_PARAMETERS").path("CLIENT_REQUEST_MFA_TOKEN").asBoolean());
                        Assertions.assertEquals((Object)mockedMfaToken[1], (Object)jsonNode.path("data").path("TOKEN").asText());
                        res = SnowflakeMFACacheTest.this.getNormalMockedHttpResponse(true, -1).toString();
                    } else if (this.callCount == 5) {
                        res = SnowflakeMFACacheTest.this.getNormalMockedHttpResponse(true, -1).toString();
                    } else if (this.callCount == 6) {
                        res = SnowflakeMFACacheTest.this.getNormalMockedHttpResponse(false, -1).toString();
                    } else if (this.callCount == 7) {
                        JsonNode jsonNode = SnowflakeMFACacheTest.this.parseRequest((HttpPost)args[0]);
                        Assertions.assertTrue((boolean)jsonNode.path("data").path("SESSION_PARAMETERS").path("CLIENT_REQUEST_MFA_TOKEN").asBoolean());
                        Assertions.assertEquals((Object)"", (Object)jsonNode.path("data").path("TOKEN").asText());
                        res = SnowflakeMFACacheTest.this.getNormalMockedHttpResponse(true, -1).toString();
                    } else {
                        res = this.callCount == 8 ? SnowflakeMFACacheTest.this.getNormalMockedHttpResponse(true, -1).toString() : SnowflakeMFACacheTest.this.getNormalMockedHttpResponse(false, -1).toString();
                    }
                    ++this.callCount;
                    return res;
                }
            });
            Properties prop = this.getBaseProp();
            String url = "jdbc:snowflake://testaccount.snowflakecomputing.com";
            Connection con = DriverManager.getConnection(url, prop);
            con.close();
            Connection con1 = DriverManager.getConnection(url, prop);
            con1.close();
            Connection con2 = DriverManager.getConnection(url, prop);
            con2.close();
            Assertions.assertThrows(SnowflakeSQLException.class, () -> DriverManager.getConnection(url, prop));
            Connection con4 = DriverManager.getConnection(url, prop);
            con4.close();
        }
        SessionUtil.deleteMfaTokenCache((String)host, (String)user);
    }

    private void unavailableLSSWindowsTestBody() throws SQLException {
        SessionUtil.deleteMfaTokenCache((String)host, (String)user);
        try (MockedStatic mockedHttpUtil = Mockito.mockStatic(HttpUtil.class);){
            mockedHttpUtil.when(() -> HttpUtil.executeGeneralRequest((HttpRequestBase)((HttpRequestBase)ArgumentMatchers.any(HttpPost.class)), (int)ArgumentMatchers.anyInt(), (int)ArgumentMatchers.anyInt(), (int)ArgumentMatchers.anyInt(), (int)ArgumentMatchers.anyInt(), (HttpClientSettingsKey)((HttpClientSettingsKey)ArgumentMatchers.any(HttpClientSettingsKey.class)))).thenAnswer((Answer)new Answer<String>(){
                int callCount = 0;

                private String validationHelper(Object[] args) throws IOException {
                    JsonNode node = SnowflakeMFACacheTest.this.parseRequest((HttpPost)args[0]);
                    Assertions.assertTrue((boolean)node.path("data").path("SESSION_PARAMETERS").path("CLIENT_REQUEST_MFA_TOKEN").asBoolean());
                    Assertions.assertEquals((Object)"", (Object)node.path("data").path("TOKEN").asText());
                    return SnowflakeMFACacheTest.this.getNormalMockedHttpResponse(true, 0).toString();
                }

                public String answer(InvocationOnMock invocation) throws Throwable {
                    String res = "";
                    Object[] args = invocation.getArguments();
                    if (this.callCount == 0) {
                        res = this.validationHelper(args);
                    } else if (this.callCount == 1) {
                        res = SnowflakeMFACacheTest.this.getNormalMockedHttpResponse(true, -1).toString();
                    } else if (this.callCount == 2) {
                        res = this.validationHelper(args);
                    } else if (this.callCount == 3) {
                        res = SnowflakeMFACacheTest.this.getNormalMockedHttpResponse(true, -1).toString();
                    }
                    ++this.callCount;
                    return res;
                }
            });
            Properties prop = this.getBaseProp();
            String url = "jdbc:snowflake://testaccount.snowflakecomputing.com";
            Connection con = DriverManager.getConnection(url, prop);
            con.close();
            Connection con1 = DriverManager.getConnection(url, prop);
            con1.close();
        }
        SessionUtil.deleteMfaTokenCache((String)host, (String)user);
    }

    private void testUnavailableLSSWindowsHelper() throws SQLException {
        try {
            SecureStorageWindowsManager.Advapi32LibManager.setInstance((SecureStorageWindowsManager.Advapi32Lib)new MockUnavailableAdvapi32Lib());
            SecureStorageWindowsManager manager = SecureStorageWindowsManager.builder();
            CredentialManager.injectSecureStorageManager((SecureStorageManager)manager);
            this.unavailableLSSWindowsTestBody();
        }
        finally {
            SecureStorageWindowsManager.Advapi32LibManager.resetInstance();
        }
    }

    @Test
    public void testUnavailableLocalSecureStorage() throws SQLException {
        try {
            this.testUnavailableLSSWindowsHelper();
        }
        finally {
            CredentialManager.resetSecureStorageManager();
        }
    }

    @Test
    @Disabled
    public void testEnableClientRequestMfaToken() throws SQLException {
        Map<String, String> params = AbstractDriverIT.getConnectionParameters();
        SnowflakeBasicDataSource ds = new SnowflakeBasicDataSource();
        ds.setServerName(params.get("host"));
        ds.setAccount(params.get("account"));
        ds.setPortNumber(Integer.parseInt(params.get("port")));
        ds.setUser(params.get("user"));
        ds.setPassword(params.get("password"));
        ds.setEnableClientRequestMfaToken(false);
        for (int i = 0; i < 3; ++i) {
            try (Connection con = ds.getConnection();
                 ResultSet rs = con.createStatement().executeQuery("SELECT 1");){
                Assertions.assertTrue((boolean)rs.next());
                continue;
            }
        }
    }

    class MockUnavailableAdvapi32Lib
    implements SecureStorageWindowsManager.Advapi32Lib {
        MockUnavailableAdvapi32Lib() {
        }

        public boolean CredReadW(String targetName, int type, int flags, PointerByReference pcred) {
            return false;
        }

        public boolean CredWriteW(SecureStorageWindowsManager.SecureStorageWindowsCredential cred, int flags) {
            return false;
        }

        public boolean CredDeleteW(String targetName, int type, int flags) {
            return false;
        }

        public void CredFree(Pointer cred) {
        }
    }
}

