/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.TimeZone;
import net.snowflake.client.TestUtil;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.BaseConverterTest;
import net.snowflake.client.core.arrow.BigIntToFixedConverter;
import net.snowflake.client.core.arrow.BigIntToScaledFixedConverter;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BigIntToFixedConverterTest
extends BaseConverterTest {
    private BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private Random random = new Random();
    private ByteBuffer bb;

    @Test
    public void testFixedNoScale() throws SFException {
        int rowCount = 1000;
        ArrayList<Long> expectedValues = new ArrayList<Long>();
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        for (int i = 0; i < 1000; ++i) {
            expectedValues.add(this.random.nextLong());
        }
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "0");
        FieldType fieldType = new FieldType(true, Types.MinorType.BIGINT.getType(), null, customFieldMeta);
        BigIntVector vector = new BigIntVector("col_one", fieldType, this.allocator);
        for (int i = 0; i < 1000; ++i) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                vector.setNull(i);
                nullValIndex.add(i);
                continue;
            }
            vector.setSafe(i, ((Long)expectedValues.get(i)).longValue());
        }
        BigIntToFixedConverter converter = new BigIntToFixedConverter((ValueVector)vector, 0, (DataConversionContext)this);
        for (int i = 0; i < 1000; ++i) {
            long longVal = converter.toLong(i);
            Object longObject = converter.toObject(i);
            String longString = converter.toString(i);
            if (longString != null) {
                Assertions.assertFalse((boolean)converter.isNull(i));
            } else {
                Assertions.assertTrue((boolean)converter.isNull(i));
            }
            if (nullValIndex.contains(i)) {
                MatcherAssert.assertThat((Object)longVal, (Matcher)CoreMatchers.is((Object)0L));
                MatcherAssert.assertThat((Object)longObject, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)longString, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)converter.toBytes(i), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                continue;
            }
            MatcherAssert.assertThat((Object)longVal, (Matcher)CoreMatchers.is((Object)((Long)expectedValues.get(i))));
            MatcherAssert.assertThat((Object)longObject, (Matcher)CoreMatchers.is(expectedValues.get(i)));
            MatcherAssert.assertThat((Object)longString, (Matcher)CoreMatchers.is((Object)((Long)expectedValues.get(i)).toString()));
            this.bb = ByteBuffer.wrap(converter.toBytes(i));
            MatcherAssert.assertThat((Object)longVal, (Matcher)CoreMatchers.is((Object)this.bb.getLong()));
        }
        vector.clear();
    }

    @Test
    public void testFixedWithScale() throws SFException {
        int rowCount = 1000;
        ArrayList<Long> expectedValues = new ArrayList<Long>();
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        for (int i = 0; i < 1000; ++i) {
            expectedValues.add(this.random.nextLong());
        }
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "3");
        FieldType fieldType = new FieldType(true, Types.MinorType.BIGINT.getType(), null, customFieldMeta);
        BigIntVector vector = new BigIntVector("col_one", fieldType, this.allocator);
        for (int i = 0; i < 1000; ++i) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                vector.setNull(i);
                nullValIndex.add(i);
                continue;
            }
            vector.setSafe(i, ((Long)expectedValues.get(i)).longValue());
        }
        BigIntToScaledFixedConverter converter = new BigIntToScaledFixedConverter((ValueVector)vector, 0, (DataConversionContext)this, 3);
        for (int i = 0; i < 1000; ++i) {
            BigDecimal bigDecimalVal = converter.toBigDecimal(i);
            Object objectVal = converter.toObject(i);
            String stringVal = converter.toString(i);
            if (nullValIndex.contains(i)) {
                MatcherAssert.assertThat((Object)bigDecimalVal, (Matcher)CoreMatchers.nullValue());
                MatcherAssert.assertThat((Object)objectVal, (Matcher)CoreMatchers.nullValue());
                MatcherAssert.assertThat((Object)stringVal, (Matcher)CoreMatchers.nullValue());
                MatcherAssert.assertThat((Object)converter.toBytes(i), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                continue;
            }
            BigDecimal expectedVal = BigDecimal.valueOf((Long)expectedValues.get(i), 3);
            MatcherAssert.assertThat((Object)bigDecimalVal, (Matcher)CoreMatchers.is((Object)expectedVal));
            MatcherAssert.assertThat((Object)objectVal, (Matcher)CoreMatchers.is((Object)expectedVal));
            MatcherAssert.assertThat((Object)stringVal, (Matcher)CoreMatchers.is((Object)expectedVal.toString()));
            MatcherAssert.assertThat((Object)converter.toBytes(i), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
        vector.clear();
    }

    @Test
    public void testInvalidConversion() {
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "3");
        FieldType fieldType = new FieldType(true, Types.MinorType.BIGINT.getType(), null, customFieldMeta);
        BigIntVector vector = new BigIntVector("col_one", fieldType, this.allocator);
        vector.setSafe(0, 123456789L);
        BigIntToScaledFixedConverter converter = new BigIntToScaledFixedConverter((ValueVector)vector, 0, (DataConversionContext)this, 3);
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> BigIntToFixedConverterTest.lambda$testInvalidConversion$0((ArrowVectorConverter)converter));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> BigIntToFixedConverterTest.lambda$testInvalidConversion$1((ArrowVectorConverter)converter));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> BigIntToFixedConverterTest.lambda$testInvalidConversion$2((ArrowVectorConverter)converter));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> BigIntToFixedConverterTest.lambda$testInvalidConversion$3((ArrowVectorConverter)converter));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> BigIntToFixedConverterTest.lambda$testInvalidConversion$4((ArrowVectorConverter)converter));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> this.lambda$testInvalidConversion$5((ArrowVectorConverter)converter));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> BigIntToFixedConverterTest.lambda$testInvalidConversion$6((ArrowVectorConverter)converter));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> BigIntToFixedConverterTest.lambda$testInvalidConversion$7((ArrowVectorConverter)converter));
        vector.clear();
    }

    @Test
    public void testGetSmallerIntegralType() throws SFException {
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "0");
        FieldType fieldType = new FieldType(true, Types.MinorType.BIGINT.getType(), null, customFieldMeta);
        BigIntVector vectorFoo = new BigIntVector("col_one", fieldType, this.allocator);
        vectorFoo.setSafe(0, 0x80000002L);
        vectorFoo.setSafe(1, -2147483650L);
        BigIntToFixedConverter converterFoo = new BigIntToFixedConverter((ValueVector)vectorFoo, 0, (DataConversionContext)this);
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> BigIntToFixedConverterTest.lambda$testGetSmallerIntegralType$8((ArrowVectorConverter)converterFoo));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> BigIntToFixedConverterTest.lambda$testGetSmallerIntegralType$9((ArrowVectorConverter)converterFoo));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> BigIntToFixedConverterTest.lambda$testGetSmallerIntegralType$10((ArrowVectorConverter)converterFoo));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> BigIntToFixedConverterTest.lambda$testGetSmallerIntegralType$11((ArrowVectorConverter)converterFoo));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> BigIntToFixedConverterTest.lambda$testGetSmallerIntegralType$12((ArrowVectorConverter)converterFoo));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> BigIntToFixedConverterTest.lambda$testGetSmallerIntegralType$13((ArrowVectorConverter)converterFoo));
        vectorFoo.clear();
        BigIntVector vectorBar = new BigIntVector("col_one", fieldType, this.allocator);
        vectorBar.setSafe(0, 10L);
        vectorBar.setSafe(1, -10L);
        BigIntToFixedConverter converterBar = new BigIntToFixedConverter((ValueVector)vectorBar, 0, (DataConversionContext)this);
        MatcherAssert.assertThat((Object)converterBar.toByte(0), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)converterBar.toByte(1), (Matcher)CoreMatchers.is((Object)-10));
        MatcherAssert.assertThat((Object)converterBar.toShort(0), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)converterBar.toShort(1), (Matcher)CoreMatchers.is((Object)-10));
        MatcherAssert.assertThat((Object)converterBar.toInt(0), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat((Object)converterBar.toInt(1), (Matcher)CoreMatchers.is((Object)-10));
        vectorBar.clear();
    }

    @Test
    public void testGetBooleanNoScale() throws SFException {
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "0");
        FieldType fieldType = new FieldType(true, Types.MinorType.BIGINT.getType(), null, customFieldMeta);
        BigIntVector vector = new BigIntVector("col_one", fieldType, this.allocator);
        vector.setSafe(0, 0L);
        vector.setSafe(1, 1L);
        vector.setNull(2);
        vector.setSafe(3, 5L);
        BigIntToFixedConverter converter = new BigIntToFixedConverter((ValueVector)vector, 0, (DataConversionContext)this);
        MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(0)));
        MatcherAssert.assertThat((Object)true, (Matcher)CoreMatchers.is((Object)converter.toBoolean(1)));
        MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(2)));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> BigIntToFixedConverterTest.lambda$testGetBooleanNoScale$14((ArrowVectorConverter)converter));
        vector.close();
    }

    @Test
    public void testGetBooleanWithScale() throws SFException {
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "FIXED");
        customFieldMeta.put("precision", "10");
        customFieldMeta.put("scale", "3");
        FieldType fieldType = new FieldType(true, Types.MinorType.BIGINT.getType(), null, customFieldMeta);
        BigIntVector vector = new BigIntVector("col_one", fieldType, this.allocator);
        vector.setSafe(0, 0L);
        vector.setSafe(1, 1L);
        vector.setNull(2);
        vector.setSafe(3, 5L);
        BigIntToScaledFixedConverter converter = new BigIntToScaledFixedConverter((ValueVector)vector, 0, (DataConversionContext)this, 3);
        MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(0)));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> BigIntToFixedConverterTest.lambda$testGetBooleanWithScale$15((ArrowVectorConverter)converter));
        MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(2)));
        TestUtil.assertSFException(this.invalidConversionErrorCode, () -> BigIntToFixedConverterTest.lambda$testGetBooleanWithScale$16((ArrowVectorConverter)converter));
        vector.close();
    }

    private static /* synthetic */ void lambda$testGetBooleanWithScale$16(ArrowVectorConverter converter) throws SFException {
        converter.toBoolean(3);
    }

    private static /* synthetic */ void lambda$testGetBooleanWithScale$15(ArrowVectorConverter converter) throws SFException {
        converter.toBoolean(3);
    }

    private static /* synthetic */ void lambda$testGetBooleanNoScale$14(ArrowVectorConverter converter) throws SFException {
        converter.toBoolean(3);
    }

    private static /* synthetic */ void lambda$testGetSmallerIntegralType$13(ArrowVectorConverter converterFoo) throws SFException {
        converterFoo.toByte(1);
    }

    private static /* synthetic */ void lambda$testGetSmallerIntegralType$12(ArrowVectorConverter converterFoo) throws SFException {
        converterFoo.toShort(1);
    }

    private static /* synthetic */ void lambda$testGetSmallerIntegralType$11(ArrowVectorConverter converterFoo) throws SFException {
        converterFoo.toInt(1);
    }

    private static /* synthetic */ void lambda$testGetSmallerIntegralType$10(ArrowVectorConverter converterFoo) throws SFException {
        converterFoo.toByte(0);
    }

    private static /* synthetic */ void lambda$testGetSmallerIntegralType$9(ArrowVectorConverter converterFoo) throws SFException {
        converterFoo.toShort(0);
    }

    private static /* synthetic */ void lambda$testGetSmallerIntegralType$8(ArrowVectorConverter converterFoo) throws SFException {
        converterFoo.toInt(0);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$7(ArrowVectorConverter converter) throws SFException {
        converter.toTimestamp(0, TimeZone.getDefault());
    }

    private static /* synthetic */ void lambda$testInvalidConversion$6(ArrowVectorConverter converter) throws SFException {
        converter.toTime(0);
    }

    private /* synthetic */ void lambda$testInvalidConversion$5(ArrowVectorConverter converter) throws SFException {
        converter.toDate(0, this.getTimeZone(), false);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$4(ArrowVectorConverter converter) throws SFException {
        converter.toByte(0);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$3(ArrowVectorConverter converter) throws SFException {
        converter.toShort(0);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$2(ArrowVectorConverter converter) throws SFException {
        converter.toInt(0);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$1(ArrowVectorConverter converter) throws SFException {
        converter.toLong(0);
    }

    private static /* synthetic */ void lambda$testInvalidConversion$0(ArrowVectorConverter converter) throws SFException {
        converter.toBoolean(0);
    }
}

