/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.sql.Time;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.snowflake.client.TestUtil;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.BaseConverterTest;
import net.snowflake.client.core.arrow.BigIntToTimeConverter;
import net.snowflake.client.providers.TimezoneProvider;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class BigIntToTimeConverterTest
extends BaseConverterTest {
    private BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private Random random = new Random();
    private int scale = 9;

    public void setTimezone(String tz) {
        System.setProperty("user.timezone", tz);
    }

    @AfterAll
    public static void clearTimezone() {
        System.clearProperty("user.timezone");
    }

    @ParameterizedTest(name="{0}")
    @ArgumentsSource(value=TimezoneProvider.class)
    public void testTime(String tz) throws SFException {
        this.setTimezone(tz);
        long[] testTimesInt64 = new long[]{12345678000000L};
        String[] testTimesJson = new String[]{"12345.678000000"};
        Time[] expectedTimes = new Time[]{new Time(12345678L)};
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "TIME");
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        FieldType fieldType = new FieldType(true, Types.MinorType.BIGINT.getType(), null, customFieldMeta);
        BigIntVector vector = new BigIntVector("date", fieldType, this.allocator);
        int i = 0;
        int j = 0;
        while (i < testTimesInt64.length) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                vector.setNull(j);
                nullValIndex.add(j);
            } else {
                vector.setSafe(j, testTimesInt64[i++]);
            }
            ++j;
        }
        BigIntToTimeConverter converter = new BigIntToTimeConverter((ValueVector)vector, 0, (DataConversionContext)this);
        int rowCount = j;
        i = 0;
        for (j = 0; j < rowCount; ++j) {
            String strVal = converter.toString(j);
            Time time = converter.toTime(j);
            Object obj = converter.toObject(j);
            Time oldTime = new Time(ResultUtil.getSFTime((String)testTimesJson[i], (int)this.scale, (SFBaseSession)new SFSession()).getFractionalSeconds(3));
            if (strVal != null) {
                Assertions.assertFalse((boolean)converter.isNull(j));
            } else {
                Assertions.assertTrue((boolean)converter.isNull(j));
            }
            if (nullValIndex.contains(j)) {
                MatcherAssert.assertThat((Object)obj, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)strVal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(j)));
                MatcherAssert.assertThat((Object)converter.toBytes(j), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                continue;
            }
            MatcherAssert.assertThat((Object)expectedTimes[i], (Matcher)CoreMatchers.is((Object)time));
            MatcherAssert.assertThat((Object)expectedTimes[i], (Matcher)CoreMatchers.is((Object)((Time)obj)));
            MatcherAssert.assertThat((Object)oldTime, (Matcher)CoreMatchers.is((Object)time));
            MatcherAssert.assertThat((Object)oldTime, (Matcher)CoreMatchers.is((Object)((Time)obj)));
            int x = j;
            TestUtil.assertSFException(this.invalidConversionErrorCode, () -> BigIntToTimeConverterTest.lambda$testTime$0((ArrowVectorConverter)converter, x));
        }
        vector.clear();
    }

    private static /* synthetic */ void lambda$testTime$0(ArrowVectorConverter converter, int x) throws SFException {
        converter.toBoolean(x);
    }
}

