/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.TimeZone;
import net.snowflake.client.TestUtil;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.BaseConverterTest;
import net.snowflake.client.core.arrow.BigIntToTimestampLTZConverter;
import net.snowflake.client.providers.TimezoneProvider;
import net.snowflake.common.core.SFTimestamp;
import net.snowflake.common.core.SnowflakeDateTimeFormat;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class BigIntToTimestampLTZConverterTest
extends BaseConverterTest {
    private BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private Random random = new Random();
    private int oldScale = 9;

    @ParameterizedTest
    @ArgumentsSource(value=TimezoneProvider.class)
    public void testTimestampLTZ(String timezone) throws SFException {
        System.setProperty("user.timezone", timezone);
        long[] testTimestampsInt64 = new long[]{1546391837L, 15463918370L, 154639183700L, 1546391837000L, 15463918370000L, 154639183700000L, 1546391837000000L};
        int[] testScales = new int[]{0, 1, 2, 3, 4, 5, 6};
        String[] testTimesJson = new String[]{"1546391837.000000000"};
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "TIMESTAMP");
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        FieldType fieldType = new FieldType(true, Types.MinorType.BIGINT.getType(), null, customFieldMeta);
        BigIntVector vector = new BigIntVector("timestamp", fieldType, this.allocator);
        int i = 0;
        int j = 0;
        while (i < testTimestampsInt64.length) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                vector.setNull(j);
                nullValIndex.add(j);
            } else {
                vector.setSafe(j, testTimestampsInt64[i++]);
            }
            ++j;
        }
        BigIntToTimestampLTZConverter converter = new BigIntToTimestampLTZConverter((ValueVector)vector, 0, (DataConversionContext)this);
        int rowCount = j;
        i = 0;
        this.setScale(testScales[i]);
        for (j = 0; j < rowCount; ++j) {
            Timestamp ts = converter.toTimestamp(j, this.getTimeZone());
            Date date = converter.toDate(j, this.getTimeZone(), false);
            Time time = converter.toTime(j);
            String tsStr = converter.toString(j);
            if (tsStr != null) {
                Assertions.assertFalse((boolean)converter.isNull(j));
            } else {
                Assertions.assertTrue((boolean)converter.isNull(j));
            }
            if (nullValIndex.contains(j)) {
                MatcherAssert.assertThat((Object)ts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)date, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(j)));
                MatcherAssert.assertThat((Object)converter.toBytes(j), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                continue;
            }
            SFTimestamp sfTimestamp = ResultUtil.getSFTimestamp((String)testTimesJson[0], (int)this.oldScale, (int)50000, (long)this.getResultVersion(), (TimeZone)this.getTimeZone(), (SFBaseSession)this.getSession());
            Timestamp oldTs = sfTimestamp.getTimestamp();
            oldTs = ResultUtil.adjustTimestamp((Timestamp)oldTs);
            Date oldDate = new Date(oldTs.getTime());
            SFTimestamp sfTS = ResultUtil.getSFTimestamp((String)testTimesJson[0], (int)this.oldScale, (int)50000, (long)this.getResultVersion(), (TimeZone)this.getTimeZone(), (SFBaseSession)this.getSession());
            String timestampStr = ResultUtil.getSFTimestampAsString((SFTimestamp)sfTS, (int)50000, (int)this.oldScale, (SnowflakeDateTimeFormat)this.getTimestampNTZFormatter(), (SnowflakeDateTimeFormat)this.getTimestampLTZFormatter(), (SnowflakeDateTimeFormat)this.getTimestampTZFormatter(), (SFBaseSession)this.getSession());
            Time oldTime = new Time(oldTs.getTime());
            MatcherAssert.assertThat((Object)oldDate, (Matcher)CoreMatchers.is((Object)date));
            MatcherAssert.assertThat((Object)oldTs, (Matcher)CoreMatchers.is((Object)ts));
            MatcherAssert.assertThat((Object)oldTime, (Matcher)CoreMatchers.is((Object)time));
            MatcherAssert.assertThat((Object)timestampStr, (Matcher)CoreMatchers.is((Object)tsStr));
            MatcherAssert.assertThat((Object)converter.toBytes(j), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            if (++i < testScales.length) {
                this.setScale(testScales[i]);
            }
            int x = j;
            TestUtil.assertSFException(this.invalidConversionErrorCode, () -> BigIntToTimestampLTZConverterTest.lambda$testTimestampLTZ$0((ArrowVectorConverter)converter, x));
        }
        vector.clear();
    }

    private static /* synthetic */ void lambda$testTimestampLTZ$0(ArrowVectorConverter converter, int x) throws SFException {
        converter.toBoolean(x);
    }
}

