/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.sql.Date;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import net.snowflake.client.TestUtil;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.ArrowResultUtil;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.BaseConverterTest;
import net.snowflake.client.core.arrow.DateConverter;
import net.snowflake.client.core.json.DateTimeConverter;
import net.snowflake.client.providers.TimezoneProvider;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class DateConverterTest
extends BaseConverterTest {
    private BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private Random random = new Random();
    int[] testDates = new int[]{-8865, -719162, -354285, -244712, -208156, -171664, -135107, 0, 16911};
    String[] expectedDates = new String[]{"1945-09-24", "0001-01-01", "1000-01-01", "1300-01-01", "1400-02-02", "1500-01-01", "1600-02-03", "1970-01-01", "2016-04-20"};
    Map<String, List<Object>> timezoneDatesData = new HashMap<String, List<Object>>(){
        {
            this.put("UTC", Arrays.asList("2016-04-20", 0));
            this.put("America/Los_Angeles", Arrays.asList("2016-04-20", -7));
            this.put("America/New_York", Arrays.asList("2016-04-20", -4));
            this.put("Pacific/Honolulu", Arrays.asList("2016-04-20", -10));
            this.put("Asia/Singapore", Arrays.asList("2016-04-19", 8));
            this.put("CET", Arrays.asList("2016-04-19", 2));
            this.put("GMT+0200", Arrays.asList("2016-04-19", 2));
        }
    };
    public static final int MILLIS_IN_ONE_HOUR = 3600000;
    private TimeZone defaultTimeZone;

    private static void setTimeZone(String tz) {
        System.setProperty("user.timezone", tz);
    }

    @BeforeEach
    public void getDefaultTimeZone() {
        this.defaultTimeZone = TimeZone.getDefault();
    }

    @AfterEach
    public void restoreDefaultTimeZone() {
        TimeZone.setDefault(this.defaultTimeZone);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TimezoneProvider.class)
    public void testDate(String tz) throws SFException {
        DateConverterTest.setTimeZone(tz);
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "DATE");
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        FieldType fieldType = new FieldType(true, Types.MinorType.DATEDAY.getType(), null, customFieldMeta);
        DateDayVector vector = new DateDayVector("date", fieldType, this.allocator);
        int i = 0;
        int j = 0;
        while (i < this.testDates.length) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                vector.setNull(j);
                nullValIndex.add(j);
            } else {
                vector.setSafe(j, this.testDates[i++]);
            }
            ++j;
        }
        DateConverter converter = new DateConverter((ValueVector)vector, 0, (DataConversionContext)this, false);
        int rowCount = j;
        i = 0;
        for (j = 0; j < rowCount; ++j) {
            int intVal = converter.toInt(j);
            String strVal = converter.toString(j);
            Object obj = converter.toObject(j);
            if (strVal != null) {
                Assertions.assertFalse((boolean)converter.isNull(j));
            } else {
                Assertions.assertTrue((boolean)converter.isNull(j));
            }
            Date oldObj = ArrowResultUtil.getDate((int)intVal, (TimeZone)TimeZone.getTimeZone("UTC"), (TimeZone)TimeZone.getDefault());
            if (nullValIndex.contains(j)) {
                MatcherAssert.assertThat((Object)intVal, (Matcher)CoreMatchers.is((Object)0));
                MatcherAssert.assertThat((Object)obj, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)strVal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(j)));
                MatcherAssert.assertThat((Object)converter.toBytes(j), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                continue;
            }
            MatcherAssert.assertThat((Object)intVal, (Matcher)CoreMatchers.is((Object)this.testDates[i]));
            MatcherAssert.assertThat((Object)((Date)obj).getTime(), (Matcher)CoreMatchers.is((Object)oldObj.getTime()));
            MatcherAssert.assertThat((Object)obj.toString(), (Matcher)CoreMatchers.is((Object)this.expectedDates[i]));
            MatcherAssert.assertThat((Object)((Date)obj).getTime(), (Matcher)CoreMatchers.is((Object)oldObj.getTime()));
            MatcherAssert.assertThat((Object)((Object)oldObj).toString(), (Matcher)CoreMatchers.is((Object)this.expectedDates[i++]));
            int x = j;
            TestUtil.assertSFException(this.invalidConversionErrorCode, () -> DateConverterTest.lambda$testDate$0((ArrowVectorConverter)converter, x));
        }
        vector.clear();
    }

    @ParameterizedTest
    @ArgumentsSource(value=TimezoneProvider.class)
    public void testRandomDates(String tz) throws SFException {
        DateConverterTest.setTimeZone(tz);
        int dateBound = 50000;
        int rowCount = 50000;
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "DATE");
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        FieldType fieldType = new FieldType(true, Types.MinorType.DATEDAY.getType(), null, customFieldMeta);
        DateDayVector vector = new DateDayVector("date", fieldType, this.allocator);
        int[] rawDates = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                nullValIndex.add(i);
                vector.setNull(i);
                continue;
            }
            rawDates[i] = this.random.nextInt(dateBound) - dateBound / 2;
            vector.setSafe(i, rawDates[i]);
        }
        DateConverter converter = new DateConverter((ValueVector)vector, 0, (DataConversionContext)this, false);
        for (int i = 0; i < rowCount; ++i) {
            int intVal = converter.toInt(i);
            String strVal = converter.toString(i);
            Date obj = converter.toDate(i, this.getTimeZone(), false);
            String str = converter.toString(i);
            if (nullValIndex.contains(i)) {
                MatcherAssert.assertThat((Object)intVal, (Matcher)CoreMatchers.is((Object)0));
                MatcherAssert.assertThat((Object)strVal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)obj, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                continue;
            }
            Date oldObj = ArrowResultUtil.getDate((int)intVal);
            MatcherAssert.assertThat((Object)intVal, (Matcher)CoreMatchers.is((Object)rawDates[i]));
            MatcherAssert.assertThat((Object)obj.getTime(), (Matcher)CoreMatchers.is((Object)oldObj.getTime()));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=TimezoneProvider.class)
    public void testTimezoneDates(String tz) throws SFException {
        DateConverterTest.setTimeZone(tz);
        int testDay = 16911;
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "DATE");
        FieldType fieldType = new FieldType(true, Types.MinorType.DATEDAY.getType(), null, customFieldMeta);
        DateDayVector vector = new DateDayVector("date", fieldType, this.allocator);
        vector.setSafe(0, testDay);
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        DateConverter converter = new DateConverter((ValueVector)vector, 0, (DataConversionContext)this, true);
        converter.setUseSessionTimezone(true);
        converter.setSessionTimeZone(TimeZone.getTimeZone(tz));
        Object obj = converter.toObject(0);
        DateTimeConverter jsonConverter = new DateTimeConverter(TimeZone.getTimeZone(tz), (SFBaseSession)this.getSession(), 0L, true, false, true, true);
        Date jsonDate = jsonConverter.getDate((Object)Integer.toString(testDay), 91, 91, TimeZone.getTimeZone(tz), 0);
        Date utcObj = ArrowResultUtil.getDate((int)testDay, (TimeZone)TimeZone.getTimeZone("UTC"), (TimeZone)TimeZone.getTimeZone(tz));
        List<Object> testValues = this.timezoneDatesData.get(tz);
        Assertions.assertTrue((boolean)(testValues.get(0) instanceof String));
        Assertions.assertTrue((boolean)(testValues.get(1) instanceof Integer));
        MatcherAssert.assertThat((Object)obj.toString(), (Matcher)CoreMatchers.is((Object)"2016-04-20"));
        MatcherAssert.assertThat((Object)jsonDate.toString(), (Matcher)CoreMatchers.is((Object)obj.toString()));
        MatcherAssert.assertThat((Object)((Object)utcObj).toString(), (Matcher)CoreMatchers.is((Object)testValues.get(0)));
        MatcherAssert.assertThat((Object)((Date)obj).getTime(), (Matcher)CoreMatchers.is((Object)(utcObj.getTime() + (long)((Integer)testValues.get(1) * 3600000))));
        vector.clear();
    }

    private static /* synthetic */ void lambda$testDate$0(ArrowVectorConverter converter, int x) throws SFException {
        converter.toBoolean(x);
    }
}

