/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.sql.Time;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.snowflake.client.TestUtil;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.BaseConverterTest;
import net.snowflake.client.core.arrow.IntToTimeConverter;
import net.snowflake.client.providers.TimezoneProvider;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class IntToTimeConverterTest
extends BaseConverterTest {
    private BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private Random random = new Random();
    private int scale = 3;

    public IntToTimeConverterTest() {
        this.setScale(this.scale);
    }

    @ParameterizedTest
    @ArgumentsSource(value=TimezoneProvider.class)
    public void testTime(String timezone) throws SFException {
        System.setProperty("user.timezone", timezone);
        int[] testTimesInt = new int[]{12345678};
        String[] testTimesJson = new String[]{"12345.678"};
        Time[] expectedTimes = new Time[]{new Time(12345678L)};
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "TIME");
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        FieldType fieldType = new FieldType(true, Types.MinorType.INT.getType(), null, customFieldMeta);
        IntVector vector = new IntVector("date", fieldType, this.allocator);
        int i = 0;
        int j = 0;
        while (i < testTimesInt.length) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                vector.setNull(j);
                nullValIndex.add(j);
            } else {
                vector.setSafe(j, testTimesInt[i++]);
            }
            ++j;
        }
        IntToTimeConverter converter = new IntToTimeConverter((ValueVector)vector, 0, (DataConversionContext)this);
        int rowCount = j;
        i = 0;
        for (j = 0; j < rowCount; ++j) {
            String strVal = converter.toString(j);
            Time time = converter.toTime(j);
            Object obj = converter.toObject(j);
            Time oldTime = new Time(ResultUtil.getSFTime((String)testTimesJson[i], (int)this.scale, (SFBaseSession)new SFSession()).getFractionalSeconds(3));
            if (strVal != null) {
                Assertions.assertFalse((boolean)converter.isNull(j));
            } else {
                Assertions.assertTrue((boolean)converter.isNull(j));
            }
            if (nullValIndex.contains(j)) {
                MatcherAssert.assertThat((Object)obj, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)strVal, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(j)));
                MatcherAssert.assertThat((Object)converter.toBytes(j), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)0, (Matcher)CoreMatchers.is((Object)converter.toInt(j)));
                continue;
            }
            MatcherAssert.assertThat((Object)expectedTimes[i], (Matcher)CoreMatchers.is((Object)time));
            MatcherAssert.assertThat((Object)expectedTimes[i], (Matcher)CoreMatchers.is((Object)((Time)obj)));
            MatcherAssert.assertThat((Object)oldTime, (Matcher)CoreMatchers.is((Object)time));
            MatcherAssert.assertThat((Object)oldTime, (Matcher)CoreMatchers.is((Object)((Time)obj)));
            int x = j;
            TestUtil.assertSFException(this.invalidConversionErrorCode, () -> IntToTimeConverterTest.lambda$testTime$0((ArrowVectorConverter)converter, x));
            MatcherAssert.assertThat((Object)converter.toBytes(j), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
        vector.clear();
    }

    private static /* synthetic */ void lambda$testTime$0(ArrowVectorConverter converter, int x) throws SFException {
        converter.toBoolean(x);
    }
}

