/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.TimeZone;
import java.util.stream.Stream;
import net.snowflake.client.TestUtil;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.BaseConverterTest;
import net.snowflake.client.core.arrow.ThreeFieldStructToTimestampTZConverter;
import net.snowflake.common.core.SFTimestamp;
import net.snowflake.common.core.SnowflakeDateTimeFormat;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class ThreeFieldStructToTimestampTZConverterTest
extends BaseConverterTest {
    private BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private Random random = new Random();
    private int oldScale = 9;

    private static void setTimezone(String tz) {
        System.setProperty("user.timezone", tz);
    }

    @AfterAll
    public static void clearTimezone() {
        System.clearProperty("user.timezone");
    }

    @ParameterizedTest
    @ArgumentsSource(value=TimezoneProvider.class)
    public void testTimestampTZ(String tz, long[] testSecondsInt64, int[] testNanos, int[] testTimeZoneIndices, String[] testTimesJson) throws SFException {
        ThreeFieldStructToTimestampTZConverterTest.setTimezone(tz);
        HashMap<String, String> customFieldMeta = new HashMap<String, String>();
        customFieldMeta.put("logicalType", "TIMESTAMP");
        HashSet<Integer> nullValIndex = new HashSet<Integer>();
        FieldType fieldType = new FieldType(true, Types.MinorType.BIGINT.getType(), null, customFieldMeta);
        FieldType fieldType2 = new FieldType(true, Types.MinorType.INT.getType(), null, customFieldMeta);
        FieldType fieldType3 = new FieldType(true, Types.MinorType.INT.getType(), null, customFieldMeta);
        StructVector structVector = StructVector.empty((String)"testVector", (BufferAllocator)this.allocator);
        LinkedList<Field> fieldList = new LinkedList<Field>();
        Field bigIntField = new Field("epoch", fieldType, null);
        Field fractionField = new Field("fraction", fieldType2, null);
        Field timeZoneIndexField = new Field("timezone", fieldType3, null);
        fieldList.add(bigIntField);
        fieldList.add(fractionField);
        fieldList.add(timeZoneIndexField);
        structVector.initializeChildrenFromFields(fieldList);
        BigIntVector seconds = (BigIntVector)structVector.getChild("epoch", BigIntVector.class);
        IntVector nanos = (IntVector)structVector.getChild("fraction", IntVector.class);
        IntVector timeZoneIdx = (IntVector)structVector.getChild("timezone", IntVector.class);
        int i = 0;
        int j = 0;
        while (i < testSecondsInt64.length) {
            boolean isNull = this.random.nextBoolean();
            if (isNull) {
                seconds.setNull(j);
                nanos.setNull(j);
                timeZoneIdx.setNull(j);
                nullValIndex.add(j);
            } else {
                seconds.setSafe(j, testSecondsInt64[i]);
                nanos.setSafe(j, testNanos[i]);
                timeZoneIdx.setSafe(j, testTimeZoneIndices[i++]);
                structVector.setIndexDefined(j);
            }
            ++j;
        }
        structVector.setValueCount(j);
        ThreeFieldStructToTimestampTZConverter converter = new ThreeFieldStructToTimestampTZConverter((ValueVector)structVector, 0, (DataConversionContext)this);
        int rowCount = j;
        i = 0;
        this.setScale(testNanos[i]);
        for (j = 0; j < rowCount; ++j) {
            Timestamp ts = converter.toTimestamp(j, this.getTimeZone());
            Date date = converter.toDate(j, this.getTimeZone(), false);
            Time time = converter.toTime(j);
            String tsStr = converter.toString(j);
            if (tsStr != null) {
                Assertions.assertFalse((boolean)converter.isNull(j));
            } else {
                Assertions.assertTrue((boolean)converter.isNull(j));
            }
            if (nullValIndex.contains(j)) {
                MatcherAssert.assertThat((Object)ts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)date, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                MatcherAssert.assertThat((Object)false, (Matcher)CoreMatchers.is((Object)converter.toBoolean(j)));
                MatcherAssert.assertThat((Object)converter.toBytes(j), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                continue;
            }
            SFTimestamp sfTimestamp = ResultUtil.getSFTimestamp((String)testTimesJson[i], (int)this.oldScale, (int)50001, (long)this.getResultVersion(), (TimeZone)this.getTimeZone(), (SFBaseSession)this.getSession());
            Timestamp oldTs = sfTimestamp.getTimestamp();
            oldTs = ResultUtil.adjustTimestamp((Timestamp)oldTs);
            Date oldDate = new Date(oldTs.getTime());
            SFTimestamp sfTS = ResultUtil.getSFTimestamp((String)testTimesJson[i], (int)this.oldScale, (int)50001, (long)this.getResultVersion(), (TimeZone)this.getTimeZone(), (SFBaseSession)this.getSession());
            String timestampStr = ResultUtil.getSFTimestampAsString((SFTimestamp)sfTS, (int)50001, (int)this.oldScale, (SnowflakeDateTimeFormat)this.getTimestampNTZFormatter(), (SnowflakeDateTimeFormat)this.getTimestampLTZFormatter(), (SnowflakeDateTimeFormat)this.getTimestampTZFormatter(), (SFBaseSession)this.getSession());
            Time oldTime = new Time(oldTs.getTime());
            MatcherAssert.assertThat((Object)oldDate, (Matcher)CoreMatchers.is((Object)date));
            MatcherAssert.assertThat((Object)oldTs, (Matcher)CoreMatchers.is((Object)ts));
            MatcherAssert.assertThat((Object)oldTime, (Matcher)CoreMatchers.is((Object)time));
            MatcherAssert.assertThat((Object)timestampStr, (Matcher)CoreMatchers.is((Object)tsStr));
            int x = j;
            TestUtil.assertSFException(this.invalidConversionErrorCode, () -> ThreeFieldStructToTimestampTZConverterTest.lambda$testTimestampTZ$0((ArrowVectorConverter)converter, x));
            TestUtil.assertSFException(this.invalidConversionErrorCode, () -> ThreeFieldStructToTimestampTZConverterTest.lambda$testTimestampTZ$1((ArrowVectorConverter)converter, x));
            if (++i >= testNanos.length) continue;
            this.setScale(testNanos[i]);
        }
        structVector.clear();
    }

    private static /* synthetic */ void lambda$testTimestampTZ$1(ArrowVectorConverter converter, int x) throws SFException {
        converter.toBytes(x);
    }

    private static /* synthetic */ void lambda$testTimestampTZ$0(ArrowVectorConverter converter, int x) throws SFException {
        converter.toBoolean(x);
    }

    private static class TimezoneProvider
    implements ArgumentsProvider {
        private TimezoneProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            ArrayList<String> timezones = new ArrayList<String>(){
                {
                    this.add("America/Los_Angeles");
                    this.add("America/New_York");
                    this.add("Pacific/Honolulu");
                    this.add("Asia/Singapore");
                    this.add("MESZ");
                    this.add("MEZ");
                    this.add("UTC");
                }
            };
            Stream<Object> args = Stream.empty();
            for (String timezone : timezones) {
                args = Stream.concat(args, Stream.of(Arguments.argumentSet((String)timezone, (Object[])new Object[]{timezone, new long[]{1546391837L, 1546391837L, 0L, 123L, -12346L, -12345L}, new int[]{0, 10, 100, 456, 876543211, 0}, new int[]{960, 1440, 960, 960, 1440, 1440}, new String[]{"1546391837.000000000 960", "1546391837.000000010 1440", "0.000000100 960", "123.000000456 960", "-12345.123456789 1440", "-12345.000000000 1440"}}), Arguments.argumentSet((String)(timezone + " Overflow"), (Object[])new Object[]{timezone, new long[]{1546391837L}, new int[]{0}, new int[]{960}, new String[]{"1546391837.000000000 960"}})));
            }
            return args;
        }
    }
}

