/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.auth.oauth;

import com.nimbusds.oauth2.sdk.id.State;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.auth.oauth.AuthorizationCodeRedirectRequestHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class AuthorizationCodeRedirectRequestHandlerTest {
    CompletableFuture<String> authorizationCodeFutureMock = (CompletableFuture)Mockito.mock(CompletableFuture.class);

    @Test
    public void shouldReturnSuccessResponse() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", "some authorization code");
        params.put("state", "abc");
        String response = AuthorizationCodeRedirectRequestHandler.handleRedirectRequest(params, this.authorizationCodeFutureMock, (State)new State("abc"));
        ((CompletableFuture)Mockito.verify(this.authorizationCodeFutureMock)).complete("some authorization code");
        Assertions.assertEquals((Object)"Authorization completed successfully.", (Object)response);
    }

    @Test
    public void shouldReturnRandomErrorResponse() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("error", "some random error");
        String response = AuthorizationCodeRedirectRequestHandler.handleRedirectRequest(params, this.authorizationCodeFutureMock, (State)new State("abc"));
        ((CompletableFuture)Mockito.verify(this.authorizationCodeFutureMock)).completeExceptionally((Throwable)Mockito.any(SFException.class));
        Assertions.assertEquals((Object)"Authorization error: some random error", (Object)response);
    }

    @Test
    public void shouldReturnEscapedErrorResponse() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("error", "<script>some malicious script<script>");
        String response = AuthorizationCodeRedirectRequestHandler.handleRedirectRequest(params, this.authorizationCodeFutureMock, (State)new State("abc"));
        ((CompletableFuture)Mockito.verify(this.authorizationCodeFutureMock)).completeExceptionally((Throwable)Mockito.any(SFException.class));
        Assertions.assertEquals((Object)"Authorization error: &lt;script&gt;some malicious script&lt;script&gt;", (Object)response);
    }

    @Test
    public void shouldReturnInvalidStateErrorResponse() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("authorization_code", "some authorization code");
        params.put("state", "invalid state");
        String response = AuthorizationCodeRedirectRequestHandler.handleRedirectRequest(params, this.authorizationCodeFutureMock, (State)new State("abc"));
        ((CompletableFuture)Mockito.verify(this.authorizationCodeFutureMock)).completeExceptionally((Throwable)Mockito.any(SFException.class));
        Assertions.assertEquals((Object)"Authorization error: invalid authorization request redirection state", (Object)response);
    }

    @Test
    public void shouldReturnAuthorizationCodeAbsentErrorResponse() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("state", "abc");
        params.put("some-random-param", "some-value");
        String response = AuthorizationCodeRedirectRequestHandler.handleRedirectRequest(params, this.authorizationCodeFutureMock, (State)new State("abc"));
        ((CompletableFuture)Mockito.verify(this.authorizationCodeFutureMock)).completeExceptionally((Throwable)Mockito.any(SFException.class));
        Assertions.assertEquals((Object)"Authorization error: authorization code has not been returned to the driver.", (Object)response);
    }
}

