/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.auth.oauth;

import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import net.snowflake.client.core.SFOauthLoginInput;
import net.snowflake.client.core.auth.oauth.OAuthUtil;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OAuthUtilTest {
    private static final String BASE_SERVER_URL_FROM_LOGIN_INPUT = "http://some.snowflake.server.com";
    public static final String ROLE_FROM_LOGIN_INPUT = "ANALYST";

    @Test
    public void shouldCreateDefaultAuthorizationUrl() {
        SFOauthLoginInput loginInput = this.createLoginInputStub(null, null, null, null);
        URI authorizationUrl = OAuthUtil.getAuthorizationUrl((SFOauthLoginInput)loginInput, (String)BASE_SERVER_URL_FROM_LOGIN_INPUT);
        Assertions.assertNotNull((Object)authorizationUrl);
        Assertions.assertEquals((Object)"http://some.snowflake.server.com/oauth/authorize", (Object)authorizationUrl.toString());
    }

    @Test
    public void shouldCreateUserSuppliedAuthorizationUrl() {
        SFOauthLoginInput loginInput = this.createLoginInputStub("http://some.external.authorization.url.com/authz", null, null, null);
        URI tokenRequestUrl = OAuthUtil.getAuthorizationUrl((SFOauthLoginInput)loginInput, (String)BASE_SERVER_URL_FROM_LOGIN_INPUT);
        Assertions.assertNotNull((Object)tokenRequestUrl);
        Assertions.assertEquals((Object)"http://some.external.authorization.url.com/authz", (Object)tokenRequestUrl.toString());
    }

    @Test
    public void shouldCreateDefaultTokenRequestUrl() {
        SFOauthLoginInput loginInput = this.createLoginInputStub(null, null, null, null);
        URI tokenRequestUrl = OAuthUtil.getTokenRequestUrl((SFOauthLoginInput)loginInput, (String)BASE_SERVER_URL_FROM_LOGIN_INPUT);
        Assertions.assertNotNull((Object)tokenRequestUrl);
        Assertions.assertEquals((Object)"http://some.snowflake.server.com/oauth/token-request", (Object)tokenRequestUrl.toString());
    }

    @Test
    public void shouldCreateUserSuppliedTokenRequestUrl() {
        SFOauthLoginInput loginInput = this.createLoginInputStub(null, "http://some.external.authorization.url.com/token-request", null, null);
        URI tokenRequestUrl = OAuthUtil.getTokenRequestUrl((SFOauthLoginInput)loginInput, (String)BASE_SERVER_URL_FROM_LOGIN_INPUT);
        Assertions.assertNotNull((Object)tokenRequestUrl);
        Assertions.assertEquals((Object)"http://some.external.authorization.url.com/token-request", (Object)tokenRequestUrl.toString());
    }

    @Test
    public void shouldCreateDefaultScope() {
        SFOauthLoginInput loginInput = this.createLoginInputStub(null, null, null, null);
        String scope = OAuthUtil.getScope((SFOauthLoginInput)loginInput, (String)ROLE_FROM_LOGIN_INPUT);
        Assertions.assertNotNull((Object)scope);
        Assertions.assertEquals((Object)"session:role:ANALYST", (Object)scope);
    }

    @Test
    public void shouldCreateUserSuppliedScope() {
        SFOauthLoginInput loginInput = this.createLoginInputStub(null, null, "some:custom:SCOPE", null);
        String scope = OAuthUtil.getScope((SFOauthLoginInput)loginInput, (String)ROLE_FROM_LOGIN_INPUT);
        Assertions.assertNotNull((Object)scope);
        Assertions.assertEquals((Object)"some:custom:SCOPE", (Object)scope);
    }

    @Test
    public void shouldCreateDefaultRedirectUri() throws IOException {
        SFOauthLoginInput loginInput = this.createLoginInputStub(null, null, null, null);
        URI redirectUri = OAuthUtil.buildRedirectUri((SFOauthLoginInput)loginInput);
        Assertions.assertNotNull((Object)redirectUri);
        Assertions.assertTrue((boolean)redirectUri.toString().matches("^http://127.0.0.1:([0-9]*)/"), (String)("Invalid redirect URI: " + redirectUri));
    }

    @Test
    public void shouldCreateCustomRedirectUri() throws IOException {
        SFOauthLoginInput loginInput = this.createLoginInputStub(null, null, null, "http://localhost:8989/some-endpoint");
        URI redirectUri = OAuthUtil.buildRedirectUri((SFOauthLoginInput)loginInput);
        Assertions.assertNotNull((Object)redirectUri);
        Assertions.assertEquals((Object)"http://localhost:8989/some-endpoint", (Object)redirectUri.toString());
    }

    @Test
    public void shouldConvertToBaseAuthorizationRequest() throws IOException {
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, URI.create("https://some.snowflake.server.com/oauth/token"));
        httpRequest.setAccept("application/json");
        httpRequest.setAuthorization("Bearer some-token");
        httpRequest.setBody("{\"grant_type\":\"authorization_code\",\"code\":\"some-code\"}");
        HttpRequestBase httpRequestBase = OAuthUtil.convertToBaseRequest((HTTPRequest)httpRequest);
        Assertions.assertNotNull((Object)httpRequestBase);
        Assertions.assertEquals(HttpPost.class, httpRequestBase.getClass());
        Assertions.assertEquals((Object)"https://some.snowflake.server.com/oauth/token", (Object)httpRequestBase.getURI().toString());
        Header[] allHeaders = httpRequestBase.getAllHeaders();
        Assertions.assertNotNull((Object)allHeaders);
        Assertions.assertEquals((int)2, (int)allHeaders.length);
        Assertions.assertEquals((Object)"Accept", (Object)allHeaders[0].getName());
        Assertions.assertEquals((Object)"application/json", (Object)allHeaders[0].getValue());
        Assertions.assertEquals((Object)"Authorization", (Object)allHeaders[1].getName());
        Assertions.assertEquals((Object)"Bearer some-token", (Object)allHeaders[1].getValue());
        StringWriter writer = new StringWriter();
        try (InputStream ins = ((HttpPost)httpRequestBase).getEntity().getContent();){
            IOUtils.copy((InputStream)ins, (Writer)writer, (String)"UTF-8");
        }
        Assertions.assertEquals((Object)"{\"grant_type\":\"authorization_code\",\"code\":\"some-code\"}", (Object)writer.toString());
    }

    private SFOauthLoginInput createLoginInputStub(String oauthAuthorizationUrl, String oauthTokenRequestUrl, String scope, String redirectUri) {
        return new SFOauthLoginInput(null, null, redirectUri, oauthAuthorizationUrl, oauthTokenRequestUrl, scope);
    }
}

