/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.json;

import java.math.BigDecimal;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.json.NumberConverter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class NumberConverterTest {
    private final NumberConverter numberConverter = new NumberConverter();

    @Test
    public void testByteFromNumber() {
        MatcherAssert.assertThat((Object)this.numberConverter.getByte((Object)1), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.numberConverter.getByte((Object)258), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this.numberConverter.getByte((Object)-1), (Matcher)Matchers.equalTo((Object)-1));
    }

    @Test
    public void testByteFromString() {
        MatcherAssert.assertThat((Object)this.numberConverter.getByte((Object)"1"), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.numberConverter.getByte((Object)"-1"), (Matcher)Matchers.equalTo((Object)-1));
    }

    @Test
    public void testShortFromNumber() throws SFException {
        MatcherAssert.assertThat((Object)this.numberConverter.getShort((Object)1, 4), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.numberConverter.getShort((Object)2.5, 8), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this.numberConverter.getShort((Object)Float.valueOf(3.4f), 6), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void testShortFromString() throws SFException {
        MatcherAssert.assertThat((Object)this.numberConverter.getShort((Object)"1", 4), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.numberConverter.getShort((Object)"2.5", 8), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this.numberConverter.getShort((Object)"3.4", 6), (Matcher)Matchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)this.numberConverter.getShort((Object)"4.5.6", 6), (Matcher)Matchers.equalTo((Object)4));
    }

    @Test
    public void testIntFromNumber() throws SFException {
        MatcherAssert.assertThat((Object)this.numberConverter.getInt((Object)1, 4), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.numberConverter.getInt((Object)2.5, 8), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this.numberConverter.getInt((Object)Float.valueOf(3.4f), 6), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void testIntFromString() throws SFException {
        MatcherAssert.assertThat((Object)this.numberConverter.getInt((Object)"1", 4), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.numberConverter.getInt((Object)"2.5", 8), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this.numberConverter.getInt((Object)"3.4", 6), (Matcher)Matchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)this.numberConverter.getInt((Object)"4.5.6", 6), (Matcher)Matchers.equalTo((Object)4));
    }

    @Test
    public void testLongFromNumber() throws SFException {
        MatcherAssert.assertThat((Object)this.numberConverter.getLong((Object)1, 4), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)this.numberConverter.getLong((Object)2.5, 8), (Matcher)Matchers.equalTo((Object)2L));
        MatcherAssert.assertThat((Object)this.numberConverter.getLong((Object)Float.valueOf(3.4f), 6), (Matcher)Matchers.equalTo((Object)3L));
    }

    @Test
    public void testLongFromString() throws SFException {
        MatcherAssert.assertThat((Object)this.numberConverter.getLong((Object)"1", 4), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)this.numberConverter.getLong((Object)"2.5", 8), (Matcher)Matchers.equalTo((Object)2L));
        MatcherAssert.assertThat((Object)this.numberConverter.getLong((Object)"3.4", 6), (Matcher)Matchers.equalTo((Object)3L));
        MatcherAssert.assertThat((Object)this.numberConverter.getLong((Object)"4.5.6", 6), (Matcher)Matchers.equalTo((Object)4L));
    }

    @Test
    public void testBigDecimalFromNumber() throws SFException {
        MatcherAssert.assertThat((Object)this.numberConverter.getBigDecimal((Object)1, 4), (Matcher)Matchers.equalTo((Object)BigDecimal.ONE));
        MatcherAssert.assertThat((Object)this.numberConverter.getBigDecimal((Object)1, -5), (Matcher)Matchers.equalTo((Object)BigDecimal.ONE));
        MatcherAssert.assertThat((Object)this.numberConverter.getBigDecimal((Object)1.5, 6), (Matcher)Matchers.equalTo((Object)new BigDecimal("1.5")));
    }

    @Test
    public void testBigDecimalFromString() throws SFException {
        MatcherAssert.assertThat((Object)this.numberConverter.getBigDecimal((Object)"1", 4), (Matcher)Matchers.equalTo((Object)BigDecimal.ONE));
        MatcherAssert.assertThat((Object)this.numberConverter.getBigDecimal((Object)"1", -5), (Matcher)Matchers.equalTo((Object)BigDecimal.ONE));
        MatcherAssert.assertThat((Object)this.numberConverter.getBigDecimal((Object)"1.5", 6), (Matcher)Matchers.equalTo((Object)new BigDecimal("1.5")));
    }

    @Test
    public void testBigDecimalWithScaleFromNumber() throws SFException {
        MatcherAssert.assertThat((Object)this.numberConverter.getBigDecimal((Object)1, 4), (Matcher)Matchers.equalTo((Object)BigDecimal.ONE));
        MatcherAssert.assertThat((Object)this.numberConverter.getBigDecimal((Object)1, -5), (Matcher)Matchers.equalTo((Object)BigDecimal.ONE));
        MatcherAssert.assertThat((Object)this.numberConverter.getBigDecimal((Object)1.5, 6), (Matcher)Matchers.equalTo((Object)new BigDecimal("1.5")));
        MatcherAssert.assertThat((Object)this.numberConverter.getBigDecimal((Object)1.50001, 6, Integer.valueOf(1)), (Matcher)Matchers.equalTo((Object)new BigDecimal("1.5")));
        MatcherAssert.assertThat((Object)this.numberConverter.getBigDecimal((Object)1.50001, 6, Integer.valueOf(5)), (Matcher)Matchers.equalTo((Object)new BigDecimal("1.50001")));
    }

    @Test
    public void testBigDecimalWithScaleFromString() throws SFException {
        MatcherAssert.assertThat((Object)this.numberConverter.getBigDecimal((Object)"1", 4), (Matcher)Matchers.equalTo((Object)BigDecimal.ONE));
        MatcherAssert.assertThat((Object)this.numberConverter.getBigDecimal((Object)"1", -5), (Matcher)Matchers.equalTo((Object)BigDecimal.ONE));
        MatcherAssert.assertThat((Object)this.numberConverter.getBigDecimal((Object)"1.5", 6), (Matcher)Matchers.equalTo((Object)new BigDecimal("1.5")));
        MatcherAssert.assertThat((Object)this.numberConverter.getBigDecimal((Object)"1.50001", 6, Integer.valueOf(1)), (Matcher)Matchers.equalTo((Object)new BigDecimal("1.5")));
        MatcherAssert.assertThat((Object)this.numberConverter.getBigDecimal((Object)"1.50001", 6, Integer.valueOf(5)), (Matcher)Matchers.equalTo((Object)new BigDecimal("1.50001")));
    }

    @Test
    public void testFloatFromNumber() throws SFException {
        MatcherAssert.assertThat((Object)Float.valueOf(this.numberConverter.getFloat((Object)1, 4)), (Matcher)Matchers.equalTo((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(this.numberConverter.getFloat((Object)1, -5)), (Matcher)Matchers.equalTo((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(this.numberConverter.getFloat((Object)1.5, 6)), (Matcher)Matchers.equalTo((Object)Float.valueOf(1.5f)));
        MatcherAssert.assertThat((Object)Float.valueOf(this.numberConverter.getFloat((Object)1.5, 8)), (Matcher)Matchers.equalTo((Object)Float.valueOf(1.5f)));
    }

    @Test
    public void testFloatFromString() throws SFException {
        MatcherAssert.assertThat((Object)Float.valueOf(this.numberConverter.getFloat((Object)"1", 4)), (Matcher)Matchers.equalTo((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(this.numberConverter.getFloat((Object)"1", -5)), (Matcher)Matchers.equalTo((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(this.numberConverter.getFloat((Object)"1.5", 6)), (Matcher)Matchers.equalTo((Object)Float.valueOf(1.5f)));
        MatcherAssert.assertThat((Object)Float.valueOf(this.numberConverter.getFloat((Object)"1.5", 8)), (Matcher)Matchers.equalTo((Object)Float.valueOf(1.5f)));
        MatcherAssert.assertThat((Object)Float.valueOf(this.numberConverter.getFloat((Object)"inf", 6)), (Matcher)Matchers.equalTo((Object)Float.valueOf(Float.POSITIVE_INFINITY)));
        MatcherAssert.assertThat((Object)Float.valueOf(this.numberConverter.getFloat((Object)"-inf", 6)), (Matcher)Matchers.equalTo((Object)Float.valueOf(Float.NEGATIVE_INFINITY)));
    }

    @Test
    public void testDoubleFromNumber() throws SFException {
        MatcherAssert.assertThat((Object)this.numberConverter.getDouble((Object)1, 4), (Matcher)Matchers.equalTo((Object)1.0));
        MatcherAssert.assertThat((Object)this.numberConverter.getDouble((Object)1, -5), (Matcher)Matchers.equalTo((Object)1.0));
        MatcherAssert.assertThat((Object)this.numberConverter.getDouble((Object)1.5, 6), (Matcher)Matchers.equalTo((Object)1.5));
        MatcherAssert.assertThat((Object)this.numberConverter.getDouble((Object)1.5, 8), (Matcher)Matchers.equalTo((Object)1.5));
    }

    @Test
    public void testDoubleFromString() throws SFException {
        MatcherAssert.assertThat((Object)this.numberConverter.getDouble((Object)"1", 4), (Matcher)Matchers.equalTo((Object)1.0));
        MatcherAssert.assertThat((Object)this.numberConverter.getDouble((Object)"1", -5), (Matcher)Matchers.equalTo((Object)1.0));
        MatcherAssert.assertThat((Object)this.numberConverter.getDouble((Object)"1.5", 6), (Matcher)Matchers.equalTo((Object)1.5));
        MatcherAssert.assertThat((Object)this.numberConverter.getDouble((Object)"1.5", 8), (Matcher)Matchers.equalTo((Object)1.5));
        MatcherAssert.assertThat((Object)this.numberConverter.getDouble((Object)"inf", 6), (Matcher)Matchers.equalTo((Object)Double.POSITIVE_INFINITY));
        MatcherAssert.assertThat((Object)this.numberConverter.getDouble((Object)"-inf", 6), (Matcher)Matchers.equalTo((Object)Double.NEGATIVE_INFINITY));
    }

    @Test
    public void testBigIntFromNumber() throws SFException {
        MatcherAssert.assertThat((Object)this.numberConverter.getBigInt((Object)1, -5), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)this.numberConverter.getBigInt((Object)Long.MAX_VALUE, -5), (Matcher)Matchers.equalTo((Object)Long.MAX_VALUE));
    }

    @Test
    public void testBigIntFromString() throws SFException {
        MatcherAssert.assertThat((Object)this.numberConverter.getBigInt((Object)"1", -5), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)this.numberConverter.getBigInt((Object)"9223372036854775807", -5), (Matcher)Matchers.equalTo((Object)Long.MAX_VALUE));
        MatcherAssert.assertThat((Object)this.numberConverter.getBigInt((Object)"9223372036854775808", -5), (Matcher)Matchers.equalTo((Object)new BigDecimal("9223372036854775808")));
    }
}

