/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.AssumptionUtils;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;

public abstract class BaseWiremockTest {
    protected static final SFLogger logger = SFLoggerFactory.getLogger(BaseWiremockTest.class);
    protected static final String WIREMOCK_HOME_DIR = ".wiremock";
    protected static final String WIREMOCK_M2_PATH = "/.m2/repository/org/wiremock/wiremock-standalone/3.8.0/wiremock-standalone-3.8.0.jar";
    protected static final String WIREMOCK_HOST = "localhost";
    protected static final String TRUST_STORE_PROPERTY = "javax.net.ssl.trustStore";
    protected static final String MAPPINGS_BASE_DIR = "/wiremock/mappings";
    protected static int wiremockHttpPort;
    protected static int wiremockHttpsPort;
    private static String originalTrustStorePath;
    protected static Process wiremockStandalone;

    @BeforeAll
    public static void setUpClass() {
        AssumptionUtils.assumeNotRunningOnJava8();
        AssumptionUtils.assumeNotRunningOnJava21();
        AssumptionUtils.assumeNotRunningOnGithubActionsMac();
        originalTrustStorePath = SnowflakeUtil.systemGetProperty((String)TRUST_STORE_PROPERTY);
        BaseWiremockTest.startWiremockStandAlone();
    }

    @AfterEach
    public void tearDown() {
        BaseWiremockTest.restoreTrustStorePathProperty();
        this.resetWiremock();
        HttpUtil.httpClient.clear();
    }

    @AfterAll
    public static void tearDownClass() {
        BaseWiremockTest.stopWiremockStandAlone();
    }

    protected static void startWiremockStandAlone() {
        Awaitility.await().alias("wait for wiremock responding").atMost(Duration.ofSeconds(10L)).until(() -> {
            try {
                wiremockHttpPort = BaseWiremockTest.findFreePort();
                wiremockHttpsPort = BaseWiremockTest.findFreePort();
                wiremockStandalone = new ProcessBuilder("java", "-jar", BaseWiremockTest.getWiremockStandAlonePath(), "--root-dir", System.getProperty("user.dir") + File.separator + WIREMOCK_HOME_DIR + File.separator, "--enable-browser-proxying", "--proxy-pass-through", "false", "--port", String.valueOf(wiremockHttpPort), "--https-port", String.valueOf(wiremockHttpsPort), "--https-keystore", BaseWiremockTest.getResourceURL("wiremock" + File.separator + "ca-cert.jks"), "--ca-keystore", BaseWiremockTest.getResourceURL("wiremock" + File.separator + "ca-cert.jks")).inheritIO().start();
                BaseWiremockTest.waitForWiremock();
                return true;
            }
            catch (Exception e) {
                logger.warn("Failed to start wiremock, retrying: ", (Throwable)e);
                return false;
            }
        });
    }

    protected void resetWiremock() {
        HttpPost postRequest = new HttpPost("http://localhost:" + this.getAdminPort() + "/__admin/reset");
        try (CloseableHttpClient client = HttpClients.createDefault();
             CloseableHttpResponse response = client.execute((HttpUriRequest)postRequest);){
            Assertions.assertEquals((int)200, (int)response.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getWiremockStandAlonePath() {
        return System.getProperty("user.home") + WIREMOCK_M2_PATH;
    }

    private static void waitForWiremock() {
        Awaitility.await().pollDelay(Duration.ofSeconds(1L)).atMost(Duration.ofSeconds(3L)).until(BaseWiremockTest::isWiremockResponding);
    }

    private static boolean isWiremockResponding() {
        boolean bl;
        block8: {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            try {
                HttpGet request = new HttpGet(String.format("http://%s:%d/__admin/mappings", WIREMOCK_HOST, wiremockHttpPort));
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                boolean bl2 = bl = response.getStatusLine().getStatusCode() == 200;
                if (httpClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.warn("Waiting for wiremock to respond: ", (Throwable)e);
                    return false;
                }
            }
            httpClient.close();
        }
        return bl;
    }

    protected static void stopWiremockStandAlone() {
        if (wiremockStandalone != null) {
            wiremockStandalone.destroyForcibly();
            Awaitility.await().alias("stop wiremock").atMost(Duration.ofSeconds(10L)).until(() -> !wiremockStandalone.isAlive());
        }
    }

    private static int findFreePort() {
        try {
            ServerSocket socket = new ServerSocket(0);
            int port = socket.getLocalPort();
            socket.close();
            return port;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Properties getProperties() {
        Map<String, String> params = AbstractDriverIT.getConnectionParameters();
        Properties props = new Properties();
        props.put("host", params.get("host"));
        props.put("port", params.get("port"));
        props.put("account", params.get("account"));
        props.put("user", params.get("user"));
        props.put("role", params.get("role"));
        props.put("password", params.get("password"));
        props.put("warehouse", params.get("warehouse"));
        props.put("db", params.get("database"));
        props.put("ssl", params.get("ssl"));
        props.put("insecureMode", (Object)true);
        return props;
    }

    protected HttpPost createWiremockPostRequest(String body, String path) {
        StringEntity entity;
        HttpPost postRequest = new HttpPost("http://localhost:" + this.getAdminPort() + path);
        try {
            entity = new StringEntity(body);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        postRequest.setEntity((HttpEntity)entity);
        postRequest.setHeader("Accept", "application/json");
        postRequest.setHeader("Content-type", "application/json");
        return postRequest;
    }

    protected static void restoreTrustStorePathProperty() {
        if (originalTrustStorePath != null) {
            System.setProperty(TRUST_STORE_PROPERTY, originalTrustStorePath);
        } else {
            System.clearProperty(TRUST_STORE_PROPERTY);
        }
    }

    private int getAdminPort() {
        return wiremockHttpPort;
    }

    private static String getResourceURL(String relativePath) {
        return Paths.get(SnowflakeUtil.systemGetProperty((String)"user.dir"), "src", "test", "resources", relativePath).toAbsolutePath().toString();
    }

    protected void setCustomTrustStorePropertyPath() {
        System.setProperty(TRUST_STORE_PROPERTY, BaseWiremockTest.getResourceURL("wiremock" + File.separator + "ca-cert.jks"));
    }

    protected void importMapping(String mappingImport) {
        HttpPost request = this.createWiremockPostRequest(mappingImport, "/__admin/mappings/import");
        try (CloseableHttpClient httpClient = HttpClients.createDefault();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            Assumptions.assumeTrue((response.getStatusLine().getStatusCode() == 200 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            logger.error("Importing mapping failed", (Throwable)e);
            Assumptions.abort((String)"Importing mapping failed");
        }
    }

    protected void addMapping(String mapping) {
        HttpPost postRequest = this.createWiremockPostRequest(mapping, "/__admin/mappings");
        try (CloseableHttpClient client = HttpClients.createDefault();
             CloseableHttpResponse response = client.execute((HttpUriRequest)postRequest);){
            Assertions.assertEquals((int)201, (int)response.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private String readJSONFromFile(String filePath) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String getWireMockMappingFromFile(String mappingPath, Map<String, Object> placeholdersMappings) throws IOException {
        String jsonContent = this.readJSONFromFile(mappingPath);
        for (Map.Entry<String, Object> entry : placeholdersMappings.entrySet()) {
            jsonContent = jsonContent.replace(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return jsonContent;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected List<MinimalServeEvent> getAllServeEvents() {
        String url = "http://localhost:" + this.getAdminPort() + "/__admin/requests";
        try (CloseableHttpClient client = HttpClients.createDefault();){
            List<MinimalServeEvent> list;
            block14: {
                HttpGet request = new HttpGet(url);
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                try {
                    String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    ObjectMapper mapper = new ObjectMapper();
                    ServeEventsWrapper wrapper = (ServeEventsWrapper)mapper.readValue(json, ServeEventsWrapper.class);
                    list = wrapper.getRequests();
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get serve events from WireMock", e);
        }
    }

    protected void importMappingFromResources(String relativePath) {
        try (InputStream is = BaseWiremockTest.class.getResourceAsStream(relativePath);){
            String scenario = IOUtils.toString((InputStream)Objects.requireNonNull(is), (String)StandardCharsets.UTF_8.name());
            this.importMapping(scenario);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ServeEventsWrapper {
        private List<MinimalServeEvent> requests = new ArrayList<MinimalServeEvent>();

        public List<MinimalServeEvent> getRequests() {
            return this.requests;
        }

        public void setRequests(List<MinimalServeEvent> requests) {
            this.requests = requests;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class MinimalServeEvent {
        private MinimalRequest request;

        public MinimalRequest getRequest() {
            return this.request;
        }

        public void setRequest(MinimalRequest request) {
            this.request = request;
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class MinimalQueryParameter {
            private List<String> values;

            public List<String> getValues() {
                return this.values;
            }

            public void setValues(List<String> values) {
                this.values = values;
            }

            public String firstValue() {
                return this.values != null && !this.values.isEmpty() ? this.values.get(0) : null;
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class MinimalRequest {
            private String url;
            private Date loggedDate;
            private Map<String, MinimalQueryParameter> queryParams;

            public String getUrl() {
                return this.url;
            }

            public void setUrl(String url) {
                this.url = url;
            }

            public Date getLoggedDate() {
                return this.loggedDate;
            }

            public void setLoggedDate(Date loggedDate) {
                this.loggedDate = loggedDate;
            }

            public Map<String, MinimalQueryParameter> getQueryParams() {
                return this.queryParams;
            }

            public void setQueryParams(Map<String, MinimalQueryParameter> queryParams) {
                this.queryParams = queryParams;
            }
        }
    }
}

