/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.snowflake.client.TestUtil;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.BatchExecutionIT;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.util.ThrowingCallable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="statement")
public class BatchExecutionLatestIT
extends BaseJDBCTest {
    @Test
    public void testClearingBatchAfterStatementExecution() throws SQLException {
        String tableName = TestUtil.randomTableName("SNOW-1853752");
        int itemsInBatch = 3;
        Properties properties = new Properties();
        properties.put("CLEAR_BATCH_ONLY_AFTER_SUCCESSFUL_EXECUTION", (Object)true);
        try (Connection connection = BatchExecutionLatestIT.getConnection(properties);
             Statement statement = connection.createStatement();){
            statement.execute(String.format("CREATE OR REPLACE TABLE %s(id int, s varchar(2))", tableName));
            List<ThrowingCallable> executeMethods = Arrays.asList(() -> statement.executeBatch().length, () -> statement.executeLargeBatch().length);
            for (ThrowingCallable executeMethod : executeMethods) {
                for (int i : TestUtil.randomIntList(itemsInBatch, 10)) {
                    statement.addBatch(String.format("INSERT INTO %s(id, s) VALUES (%d, 's%d')", tableName, i, i));
                }
                Assertions.assertEquals((int)itemsInBatch, (Integer)((Integer)executeMethod.call()));
                Assertions.assertEquals((int)0, (Integer)((Integer)executeMethod.call()));
                for (int i : TestUtil.randomIntList(itemsInBatch, 10)) {
                    statement.addBatch(String.format("INSERT INTO %s(id, s) VALUES (%d, 'longer string %d')", tableName, i, i));
                }
                Assertions.assertThrows(BatchUpdateException.class, () -> ((ThrowingCallable)executeMethod).call());
                Assertions.assertThrows(BatchUpdateException.class, () -> ((ThrowingCallable)executeMethod).call());
                statement.clearBatch();
            }
        }
    }

    @Test
    public void testClearingBatchAfterPreparedStatementExecutionWithArrayBinding() throws SQLException {
        String tableName = TestUtil.randomTableName("SNOW-1853752");
        int itemsInBatch = 3;
        Properties properties = new Properties();
        properties.put("CLEAR_BATCH_ONLY_AFTER_SUCCESSFUL_EXECUTION", (Object)true);
        try (Connection connection = BatchExecutionLatestIT.getConnection(properties);
             Statement statement = connection.createStatement();){
            statement.execute(String.format("CREATE OR REPLACE TABLE %s(id int, s varchar(2))", tableName));
            try (PreparedStatement preparedStatement = connection.prepareStatement(String.format("INSERT INTO %s(id, s) VALUES (?, ?)", tableName));){
                List<ThrowingCallable> executeMethods = Arrays.asList(() -> preparedStatement.executeBatch().length, () -> preparedStatement.executeLargeBatch().length);
                for (ThrowingCallable executeMethod : executeMethods) {
                    for (int i : TestUtil.randomIntList(itemsInBatch, 10)) {
                        preparedStatement.setInt(1, i);
                        preparedStatement.setString(2, "s" + i);
                        preparedStatement.addBatch();
                    }
                    Assertions.assertEquals((int)itemsInBatch, (Integer)((Integer)executeMethod.call()));
                    Assertions.assertEquals((int)0, (Integer)((Integer)executeMethod.call()));
                    for (int i : TestUtil.randomIntList(itemsInBatch, 10)) {
                        preparedStatement.setInt(1, i * 10);
                        preparedStatement.setString(2, "longer string " + i);
                        preparedStatement.addBatch();
                    }
                    Assertions.assertThrows(SnowflakeSQLException.class, () -> ((ThrowingCallable)executeMethod).call());
                    Assertions.assertThrows(SnowflakeSQLException.class, () -> ((ThrowingCallable)executeMethod).call());
                    preparedStatement.clearBatch();
                }
            }
        }
    }

    @Test
    @Disabled(value="TODO SNOW-1878297 NULLIF should cause turning off array binding on server side")
    public void testClearingBatchAfterPreparedStatementExecutionWithoutArrayBinding() throws SQLException {
        String tableName = TestUtil.randomTableName("SNOW-1853752");
        int itemsInBatch = 3;
        Properties properties = new Properties();
        properties.put("CLEAR_BATCH_ONLY_AFTER_SUCCESSFUL_EXECUTION", (Object)true);
        try (Connection connection = BatchExecutionLatestIT.getConnection(properties);
             Statement statement = connection.createStatement();){
            statement.execute(String.format("CREATE OR REPLACE TABLE %s(id int, s varchar(2))", tableName));
            try (PreparedStatement preparedStatement = connection.prepareStatement(String.format("INSERT INTO %s(id, s) VALUES (?, NULLIF(?, ''))", tableName));){
                List<ThrowingCallable> executeMethods = Arrays.asList(() -> preparedStatement.executeBatch().length, () -> preparedStatement.executeLargeBatch().length);
                for (ThrowingCallable executeMethod : executeMethods) {
                    for (int i : TestUtil.randomIntList(itemsInBatch, 10)) {
                        preparedStatement.setInt(1, i);
                        preparedStatement.setString(2, "s" + i);
                        preparedStatement.addBatch();
                    }
                    Assertions.assertEquals((int)itemsInBatch, (Integer)((Integer)executeMethod.call()));
                    Assertions.assertEquals((int)0, (Integer)((Integer)executeMethod.call()));
                    for (int i : TestUtil.randomIntList(itemsInBatch, 10)) {
                        preparedStatement.setInt(1, i * 10);
                        preparedStatement.setString(2, "longer string " + i);
                        preparedStatement.addBatch();
                    }
                    Assertions.assertThrows(BatchUpdateException.class, () -> ((ThrowingCallable)executeMethod).call());
                    Assertions.assertThrows(BatchUpdateException.class, () -> ((ThrowingCallable)executeMethod).call());
                    preparedStatement.clearBatch();
                }
            }
        }
    }

    @Test
    public void testClearingBatchAfterPreparedStatementExecutionWithArrayBindingDefaultBehaviour() throws SQLException {
        String tableName = TestUtil.randomTableName("SNOW-1853752");
        int itemsInBatch = 3;
        try (Connection connection = BatchExecutionLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(String.format("CREATE OR REPLACE TABLE %s(id int, s varchar(2))", tableName));
            try (PreparedStatement preparedStatement = connection.prepareStatement(String.format("INSERT INTO %s(id, s) VALUES (?, ?)", tableName));){
                List<BatchExecutionIT.ThrowingCallable> executeMethods = Arrays.asList(() -> preparedStatement.executeBatch().length, () -> preparedStatement.executeLargeBatch().length);
                for (BatchExecutionIT.ThrowingCallable executeMethod : executeMethods) {
                    for (int i : TestUtil.randomIntList(itemsInBatch, 10)) {
                        preparedStatement.setInt(1, i);
                        preparedStatement.setString(2, "s" + i);
                        preparedStatement.addBatch();
                    }
                    Assertions.assertEquals((int)itemsInBatch, (Integer)((Integer)executeMethod.call()));
                    Assertions.assertEquals((int)0, (Integer)((Integer)executeMethod.call()));
                    for (int i : TestUtil.randomIntList(itemsInBatch, 10)) {
                        preparedStatement.setInt(1, i * 10);
                        preparedStatement.setString(2, "longer string " + i);
                        preparedStatement.addBatch();
                    }
                    Assertions.assertThrows(SnowflakeSQLException.class, executeMethod::call);
                    Assertions.assertEquals((int)0, (Integer)((Integer)executeMethod.call()));
                    preparedStatement.clearBatch();
                }
            }
        }
    }

    @Test
    @Disabled(value="TODO SNOW-1878297 NULLIF should cause turning off array binding on server side")
    public void testClearingBatchAfterPreparedStatementExecutionWithoutArrayBindingDefaultBehaviour() throws SQLException {
        String tableName = TestUtil.randomTableName("SNOW-1853752");
        int itemsInBatch = 3;
        try (Connection connection = BatchExecutionLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(String.format("CREATE OR REPLACE TABLE %s(id int, s varchar(2))", tableName));
            try (PreparedStatement preparedStatement = connection.prepareStatement(String.format("INSERT INTO %s(id, s) VALUES (?, NULLIF(?, ''))", tableName));){
                List<BatchExecutionIT.ThrowingCallable> executeMethods = Arrays.asList(() -> preparedStatement.executeBatch().length, () -> preparedStatement.executeLargeBatch().length);
                for (BatchExecutionIT.ThrowingCallable executeMethod : executeMethods) {
                    for (int i : TestUtil.randomIntList(itemsInBatch, 10)) {
                        preparedStatement.setInt(1, i);
                        preparedStatement.setString(2, "s" + i);
                        preparedStatement.addBatch();
                    }
                    Assertions.assertEquals((int)itemsInBatch, (Integer)((Integer)executeMethod.call()));
                    Assertions.assertEquals((int)0, (Integer)((Integer)executeMethod.call()));
                    for (int i : TestUtil.randomIntList(itemsInBatch, 10)) {
                        preparedStatement.setInt(1, i * 10);
                        preparedStatement.setString(2, "longer string " + i);
                        preparedStatement.addBatch();
                    }
                    Assertions.assertThrows(BatchUpdateException.class, executeMethod::call);
                    Assertions.assertEquals((int)0, (Integer)((Integer)executeMethod.call()));
                    preparedStatement.clearBatch();
                }
            }
        }
    }
}

