/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.ParameterBindingDTO;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.bind.BindUploader;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakePreparedStatementV1;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="others")
public class BindUploaderIT
extends BaseJDBCTest {
    BindUploader bindUploader;
    Connection conn;
    SFSession session;
    TimeZone prevTimeZone;
    private static final String createTableSQL = "create or replace table test_binduploader(col1 INTEGER, col2 INTEGER, col3 DOUBLE, col4 DOUBLE, col5 DOUBLE, col6 VARCHAR, col7 BINARY, col8 DATE, col9 TIME, col10 TIMESTAMP)";
    static final String dummyInsert = "insert into test_binduploader VALUES(?,?,?,?,?,?,?,?,?,?)";
    private static final String deleteTableSQL = "drop table if exists test_binduploader";
    static final Object[] row1 = new Object[]{42, 1234L, Float.valueOf(12.34f), 12.34, new BigDecimal(42), "row1", new byte[]{-128, 127}, new Date(0L), new Time(0L), new Timestamp(0L)};
    private static final Object[] row2 = new Object[]{420, 12340L, Float.valueOf(120.34f), 120.34, new BigDecimal(420), "row2", new byte[]{127, -128}, new Date(1L), new Time(1L), new Timestamp(1L)};
    static final String csv1 = "42,1234,12.34,12.34,42,row1,807F,1970-01-01,00:00:00.000000000,1970-01-01 00:00:00.000000000 Z";
    static final String csv2 = "420,12340,120.34,120.34,420,row2,7F80,1970-01-01,00:00:00.001000000,1970-01-01 00:00:00.001000000 Z";
    static final String STAGE_DIR = "binduploaderit";
    static final String SELECT_FROM_STAGE = "select $1, $2, $3, $4, $5, $6, $7, $8, $9, $10 from '@SYSTEM$BIND/binduploaderit' ORDER BY $1 ASC";

    @BeforeAll
    public static void classSetUp() throws Exception {
        Connection connection = BindUploaderIT.getConnection();
        connection.createStatement().execute(createTableSQL);
        connection.close();
    }

    @AfterAll
    public static void classTearDown() throws Exception {
        Connection connection = BindUploaderIT.getConnection();
        connection.createStatement().execute(deleteTableSQL);
        connection.close();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.conn = BindUploaderIT.getConnection();
        this.session = this.conn.unwrap(SnowflakeConnectionV1.class).getSfSession();
        this.bindUploader = BindUploader.newInstance((SFBaseSession)this.session, (String)STAGE_DIR);
        this.prevTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    @AfterEach
    public void tearDown() throws SQLException {
        this.conn.close();
        this.bindUploader.close();
        TimeZone.setDefault(this.prevTimeZone);
    }

    static Map<String, ParameterBindingDTO> getBindings(Connection conn) throws SQLException {
        SnowflakePreparedStatementV1 stmt = (SnowflakePreparedStatementV1)conn.prepareStatement(dummyInsert);
        BindUploaderIT.bind(stmt, row1);
        BindUploaderIT.bind(stmt, row2);
        return stmt.getBatchParameterBindings();
    }

    static void bind(SnowflakePreparedStatementV1 stmt, Object[] row) throws SQLException {
        stmt.setInt(1, ((Integer)row[0]).intValue());
        stmt.setLong(2, ((Long)row[1]).longValue());
        stmt.setFloat(3, ((Float)row[2]).floatValue());
        stmt.setDouble(4, ((Double)row[3]).doubleValue());
        stmt.setBigDecimal(5, (BigDecimal)row[4]);
        stmt.setString(6, (String)row[5]);
        stmt.setBytes(7, (byte[])row[6]);
        stmt.setDate(8, (Date)row[7]);
        stmt.setTime(9, (Time)row[8]);
        stmt.setTimestamp(10, (Timestamp)row[9]);
        stmt.addBatch();
    }

    static String parseRow(ResultSet rs) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= 10; ++i) {
            sb.append(rs.getString(i));
            if (i == 10) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    @Test
    public void testIsArrayBindEmpty() {
        HashMap map = new HashMap();
        Assertions.assertFalse((boolean)BindUploader.isArrayBind(map));
    }

    @Test
    public void testIsArrayBindNull() {
        Assertions.assertFalse((boolean)BindUploader.isArrayBind(null));
    }

    @Test
    public void testIsArrayBindNonArray() {
        HashMap<String, ParameterBindingDTO> map = new HashMap<String, ParameterBindingDTO>();
        map.put("1", new ParameterBindingDTO("", (Object)"string value"));
        Assertions.assertFalse((boolean)BindUploader.isArrayBind(map));
    }

    @Test
    public void testIsArrayBindEmptyArray() {
        HashMap<String, ParameterBindingDTO> map = new HashMap<String, ParameterBindingDTO>();
        map.put("1", new ParameterBindingDTO("", new ArrayList()));
        Assertions.assertTrue((boolean)BindUploader.isArrayBind(map));
    }

    @Test
    public void testIsArrayBindNonEmptyArray() {
        HashMap<String, ParameterBindingDTO> map = new HashMap<String, ParameterBindingDTO>();
        ArrayList<String> list = new ArrayList<String>();
        list.add("bind value");
        map.put("1", new ParameterBindingDTO("", list));
        list.add("another bind value");
        Assertions.assertTrue((boolean)BindUploader.isArrayBind(map));
    }

    @Test
    public void tetArrayBindValueCountEmpty() {
        HashMap map = new HashMap();
        Assertions.assertEquals((int)0, (int)BindUploader.arrayBindValueCount(map));
    }

    @Test
    public void testArrayBindValueCountNull() {
        Assertions.assertEquals((int)0, (int)BindUploader.arrayBindValueCount(null));
    }

    @Test
    public void testArrayBindValueCountNonArray() {
        HashMap<String, ParameterBindingDTO> map = new HashMap<String, ParameterBindingDTO>();
        map.put("1", new ParameterBindingDTO("", (Object)"string value"));
        Assertions.assertEquals((int)0, (int)BindUploader.arrayBindValueCount(map));
    }

    @Test
    public void testArrayBindValueCountEmptyArray() {
        HashMap<String, ParameterBindingDTO> map = new HashMap<String, ParameterBindingDTO>();
        map.put("1", new ParameterBindingDTO("", new ArrayList()));
        Assertions.assertEquals((int)0, (int)BindUploader.arrayBindValueCount(map));
    }

    @Test
    public void testArrayBindValueCountNonEmptyArray() {
        HashMap<String, ParameterBindingDTO> map = new HashMap<String, ParameterBindingDTO>();
        ArrayList<String> list = new ArrayList<String>();
        list.add("bind value");
        list.add("another bind value");
        map.put("1", new ParameterBindingDTO("", list));
        Assertions.assertEquals((int)2, (int)BindUploader.arrayBindValueCount(map));
    }
}

