/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.core.structs.SnowflakeObjectTypeFactories;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ResultSetFormatType;
import net.snowflake.client.jdbc.SnowflakeBaseResultSet;
import net.snowflake.client.jdbc.SnowflakePreparedStatementV1;
import net.snowflake.client.jdbc.structuredtypes.sqldata.AllTypesClass;
import net.snowflake.client.jdbc.structuredtypes.sqldata.SimpleClass;
import net.snowflake.client.providers.ResultFormatProvider;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="resultSet")
public class BindingAndInsertingStructuredTypesLatestIT
extends BaseJDBCTest {
    public Connection init(ResultSetFormatType queryResultFormat) throws SQLException {
        Connection conn = BaseJDBCTest.getConnection(0);
        try (Statement stmt = conn.createStatement();){
            stmt.execute("alter session set ENABLE_STRUCTURED_TYPES_IN_CLIENT_RESPONSE = true");
            stmt.execute("alter session set IGNORE_CLIENT_VESRION_IN_STRUCTURED_TYPES_RESPONSE = true");
            stmt.execute("alter session set ENABLE_STRUCTURED_TYPES_IN_BINDS = enable");
            stmt.execute("alter session set ENABLE_OBJECT_TYPED_BINDS = true");
            stmt.execute("alter session set enable_structured_types_in_fdn_tables=true");
            stmt.execute("ALTER SESSION SET TIMEZONE = 'Europe/Warsaw'");
            stmt.execute("alter session set jdbc_query_result_format = '" + queryResultFormat.sessionParameterTypeValue + "'");
            if (queryResultFormat == ResultSetFormatType.NATIVE_ARROW) {
                stmt.execute("alter session set ENABLE_STRUCTURED_TYPES_NATIVE_ARROW_FORMAT = true");
                stmt.execute("alter session set FORCE_ENABLE_STRUCTURED_TYPES_NATIVE_ARROW_FORMAT = true");
            }
        }
        return conn;
    }

    @BeforeEach
    public void setup() {
        SnowflakeObjectTypeFactories.register(SimpleClass.class, SimpleClass::new);
        SnowflakeObjectTypeFactories.register(AllTypesClass.class, AllTypesClass::new);
    }

    @AfterEach
    public void clean() {
        SnowflakeObjectTypeFactories.unregister(SimpleClass.class);
        SnowflakeObjectTypeFactories.unregister(AllTypesClass.class);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testWriteObject(ResultSetFormatType queryResultFormat) throws SQLException {
        SimpleClass sc = new SimpleClass("text1", 2);
        SimpleClass sc2 = new SimpleClass("text2", 3);
        try (Connection connection = this.init(queryResultFormat);){
            Statement statement = connection.createStatement();
            statement.execute("CREATE OR REPLACE TABLE test_table (ob OBJECT(string varchar, intValue NUMBER))");
            try (SnowflakePreparedStatementV1 stmt = (SnowflakePreparedStatementV1)connection.prepareStatement("insert into test_table select ?");
                 SnowflakePreparedStatementV1 stmt3 = (SnowflakePreparedStatementV1)connection.prepareStatement("SELECT ob FROM test_table where ob = ?");){
                stmt.setObject(1, (Object)sc);
                stmt.executeUpdate();
                stmt.setObject(1, (Object)sc2);
                stmt.executeUpdate();
                stmt3.setObject(1, (Object)sc2);
                try (ResultSet resultSet = stmt3.executeQuery();){
                    resultSet.next();
                    SimpleClass object = resultSet.getObject(1, SimpleClass.class);
                    Assertions.assertEquals((Object)"text2", (Object)object.getString());
                    Assertions.assertEquals((Integer)Integer.valueOf("3"), (Integer)object.getIntValue());
                    Assertions.assertFalse((boolean)resultSet.next());
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testWriteNullObject(ResultSetFormatType queryResultFormat) throws SQLException {
        Assumptions.assumeTrue((queryResultFormat != ResultSetFormatType.NATIVE_ARROW ? 1 : 0) != 0);
        try (Connection connection = this.init(queryResultFormat);
             Statement statement = connection.createStatement();
             SnowflakePreparedStatementV1 stmtement2 = (SnowflakePreparedStatementV1)connection.prepareStatement("insert into test_table select null");
             SnowflakePreparedStatementV1 statement3 = (SnowflakePreparedStatementV1)connection.prepareStatement("SELECT * FROM test_table");){
            statement.execute("CREATE OR REPLACE TABLE test_table (ob OBJECT(string varchar, intValue NUMBER))");
            stmtement2.executeUpdate();
            try (ResultSet resultSet = statement3.executeQuery();){
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertNull((Object)resultSet.getObject(1));
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testWriteObjectBindingNull(ResultSetFormatType queryResultFormat) throws SQLException {
        try (Connection connection = this.init(queryResultFormat);
             Statement statement = connection.createStatement();
             SnowflakePreparedStatementV1 stmt = (SnowflakePreparedStatementV1)connection.prepareStatement("insert into test_table select ?");
             SnowflakePreparedStatementV1 stmt2 = (SnowflakePreparedStatementV1)connection.prepareStatement("SELECT * FROM test_table");){
            statement.execute("CREATE OR REPLACE TABLE test_table (ob OBJECT(string varchar, intValue NUMBER))");
            stmt.setObject(1, null);
            stmt.executeUpdate();
            try (ResultSet resultSet = stmt2.executeQuery();){
                resultSet.next();
                SimpleClass object = resultSet.getObject(1, SimpleClass.class);
                Assertions.assertNull((Object)object);
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testWriteObjectAllTypes(ResultSetFormatType queryResultFormat) throws SQLException {
        TimeZone.setDefault(TimeZone.getTimeZone(ZoneOffset.UTC));
        try (Connection connection = this.init(queryResultFormat);
             Statement statement = connection.createStatement();
             SnowflakePreparedStatementV1 stmt = (SnowflakePreparedStatementV1)connection.prepareStatement("insert into test_all_types_object select ?");
             SnowflakePreparedStatementV1 stmt2 = (SnowflakePreparedStatementV1)connection.prepareStatement("select * from test_all_types_object where ob=?");){
            statement.execute(" CREATE OR REPLACE TABLE test_all_types_object (                 ob OBJECT(string VARCHAR,                   b TINYINT,                   s SMALLINT,                   i INTEGER,                   l BIGINT,                   f FLOAT,                   d DOUBLE,                   bd NUMBER(38,2),                   bool BOOLEAN,                   timestampLtz TIMESTAMP_LTZ,                   timestampNtz TIMESTAMP_NTZ,                   timestampTz TIMESTAMP_TZ,                   date DATE,                  time TIME,                    binary BINARY,                   simpleClass OBJECT(string VARCHAR, intValue INTEGER)                  ) )");
            AllTypesClass allTypeInstance = new AllTypesClass("string", "1".getBytes(StandardCharsets.UTF_8)[0], Short.valueOf("2"), 3, 4L, Float.valueOf(1.1f), 2.24, new BigDecimal("999999999999999999999999999999999999.55"), Boolean.TRUE, Timestamp.valueOf(LocalDateTime.of(2021, 12, 22, 9, 43, 44)), BindingAndInsertingStructuredTypesLatestIT.toTimestamp(ZonedDateTime.of(2021, 12, 23, 9, 44, 44, 0, ZoneId.of("UTC"))), BindingAndInsertingStructuredTypesLatestIT.toTimestamp(ZonedDateTime.of(2021, 12, 23, 9, 44, 44, 0, ZoneId.of("Asia/Tokyo"))), Date.valueOf("2023-12-24"), Time.valueOf("12:34:56"), new byte[]{97, 98, 99}, new SimpleClass("testString", 2));
            stmt.setObject(1, (Object)allTypeInstance);
            stmt.executeUpdate();
            statement.execute("ALTER SESSION SET TIMEZONE = 'Europe/Warsaw'");
            stmt2.setObject(1, (Object)allTypeInstance);
            try (ResultSet resultSet = stmt2.executeQuery();){
                resultSet.next();
                AllTypesClass object = resultSet.getObject(1, AllTypesClass.class);
                Assertions.assertEquals((Object)"string", (Object)object.getString());
                Assertions.assertEquals((long)49L, (long)object.getB().byteValue());
                Assertions.assertEquals((long)2L, (long)object.getS().shortValue());
                Assertions.assertEquals((long)3L, (long)object.getI().intValue());
                Assertions.assertEquals((long)4L, (long)object.getL());
                Assertions.assertEquals((double)1.1, (double)object.getF().floatValue(), (double)0.01);
                Assertions.assertEquals((double)2.24, (double)object.getD(), (double)0.01);
                Assertions.assertEquals((Object)new BigDecimal("999999999999999999999999999999999999.55"), (Object)object.getBd());
                Assertions.assertEquals((Object)Boolean.TRUE, (Object)object.getBool());
                Assertions.assertEquals((Object)Timestamp.valueOf(LocalDateTime.of(2021, 12, 22, 9, 43, 44)), (Object)object.getTimestampLtz());
                Assertions.assertEquals((Object)Timestamp.valueOf(LocalDateTime.of(2021, 12, 23, 9, 44, 44)), (Object)object.getTimestampNtz());
                Assertions.assertEquals((Object)BindingAndInsertingStructuredTypesLatestIT.toTimestamp(ZonedDateTime.of(2021, 12, 23, 9, 44, 44, 0, ZoneId.of("Asia/Tokyo"))), (Object)object.getTimestampTz());
                Assertions.assertEquals((Object)Time.valueOf(LocalTime.of(12, 34, 56)), (Object)object.getTime());
                Assertions.assertArrayEquals((byte[])new byte[]{97, 98, 99}, (byte[])object.getBinary());
                Assertions.assertEquals((Object)"testString", (Object)object.getSimpleClass().getString());
                Assertions.assertEquals((Integer)Integer.valueOf("2"), (Integer)object.getSimpleClass().getIntValue());
            }
        }
    }

    public static Timestamp toTimestamp(ZonedDateTime dateTime) {
        return new Timestamp(dateTime.toInstant().getEpochSecond() * 1000L);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testWriteArray(ResultSetFormatType queryResultFormat) throws SQLException {
        try (Connection connection = this.init(queryResultFormat);
             Statement statement = connection.createStatement();
             SnowflakePreparedStatementV1 stmt = (SnowflakePreparedStatementV1)connection.prepareStatement("INSERT INTO array_of_integers (arrayInt) SELECT ?;");){
            statement.execute(" CREATE OR REPLACE TABLE array_of_integers(arrayInt ARRAY(INTEGER))");
            Array array = connection.createArrayOf("INTEGER", new Integer[]{1, 2, 3});
            Array arrayFromLowerCaseType = connection.createArrayOf("integer", new Integer[]{1, 2, 3});
            stmt.setArray(1, array);
            stmt.executeUpdate();
            stmt.setArray(1, arrayFromLowerCaseType);
            stmt.executeUpdate();
            try (ResultSet resultSet = statement.executeQuery("SELECT * from array_of_integers");){
                resultSet.next();
                Object[] resultArray = (Long[])resultSet.getArray(1).getArray();
                Assertions.assertEquals((Long)1L, (Long)resultArray[0]);
                Assertions.assertEquals((Long)2L, (Long)resultArray[1]);
                Assertions.assertEquals((Long)3L, (Long)resultArray[2]);
                resultSet.next();
                Object[] resultArrayFromLowerCaseType = (Long[])resultSet.getArray(1).getArray();
                Assertions.assertArrayEquals((Object[])resultArray, (Object[])resultArrayFromLowerCaseType);
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testWriteArrayNoBinds(ResultSetFormatType queryResultFormat) throws SQLException {
        try (Connection connection = this.init(queryResultFormat);
             Statement statement = connection.createStatement();
             SnowflakePreparedStatementV1 stmt = (SnowflakePreparedStatementV1)connection.prepareStatement("insert into array_of_integers select ([1, 2, 3]::array(integer));");){
            statement.execute(" CREATE OR REPLACE TABLE array_of_integers(arrayInt ARRAY(INTEGER))");
            stmt.executeUpdate();
            try (ResultSet resultSet = statement.executeQuery("SELECT * from array_of_integers");){
                resultSet.next();
                Long[] resultArray = (Long[])resultSet.getArray(1).getArray();
                Assertions.assertEquals((Long)1L, (Long)resultArray[0]);
                Assertions.assertEquals((Long)2L, (Long)resultArray[1]);
                Assertions.assertEquals((Long)3L, (Long)resultArray[2]);
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testWriteMapOfSqlData(ResultSetFormatType queryResultFormat) throws SQLException {
        try (Connection connection = this.init(queryResultFormat);
             Statement statement = connection.createStatement();
             SnowflakePreparedStatementV1 stmt = (SnowflakePreparedStatementV1)connection.prepareStatement("INSERT INTO map_of_objects (mapp) SELECT ?;");
             SnowflakePreparedStatementV1 stmt2 = (SnowflakePreparedStatementV1)connection.prepareStatement("select * from map_of_objects where mapp=?");){
            statement.execute(" CREATE OR REPLACE TABLE map_of_objects(mapp MAP(VARCHAR, OBJECT(string VARCHAR, intValue INTEGER)))");
            Map<String, SimpleClass> mapStruct = Stream.of({"x", new SimpleClass("string1", 1)}, {"y", new SimpleClass("string2", 2)}).collect(Collectors.toMap(data -> (String)data[0], data -> (SimpleClass)data[1]));
            stmt.setMap(1, mapStruct, 2002);
            stmt.executeUpdate();
            stmt2.setMap(1, mapStruct, 2002);
            try (ResultSet resultSet = stmt2.executeQuery();){
                resultSet.next();
                Map map = resultSet.unwrap(SnowflakeBaseResultSet.class).getMap(1, SimpleClass.class);
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=ResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testWriteMapOfInteger(ResultSetFormatType queryResultFormat) throws SQLException {
        try (Connection connection = this.init(queryResultFormat);
             Statement statement = connection.createStatement();
             SnowflakePreparedStatementV1 stmt = (SnowflakePreparedStatementV1)connection.prepareStatement("INSERT INTO map_of_objects (mapp) SELECT ?;");
             SnowflakePreparedStatementV1 stmt2 = (SnowflakePreparedStatementV1)connection.prepareStatement("select * from map_of_objects where mapp=?");){
            statement.execute(" CREATE OR REPLACE TABLE map_of_objects(mapp MAP(VARCHAR, INTEGER))");
            HashMap<String, Integer> mapStruct = new HashMap<String, Integer>();
            mapStruct.put("x", 1);
            mapStruct.put("y", 2);
            stmt.setMap(1, mapStruct, 4);
            stmt.executeUpdate();
            stmt2.setMap(1, mapStruct, 4);
            try (ResultSet resultSet = stmt2.executeQuery();){
                resultSet.next();
                Map map = resultSet.unwrap(SnowflakeBaseResultSet.class).getMap(1, Integer.class);
            }
        }
    }
}

