/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.stream.Stream;
import net.snowflake.client.jdbc.BaseJDBCWithSharedConnectionIT;
import net.snowflake.client.jdbc.SnowflakeType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="others")
public class BindingDataIT
extends BaseJDBCWithSharedConnectionIT {
    static TimeZone timeZone;

    @BeforeAll
    public static void setTimeZone() {
        timeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    @AfterAll
    public static void resetTimeZone() {
        TimeZone.setDefault(timeZone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(shorts={0, 1, -1, -32768, 32767})
    public void testBindShort(short shortValue) throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_bind_short(c1 number)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into test_bind_short values (?)");){
                    preparedStatement.setShort(1, shortValue);
                    Assertions.assertEquals((int)1, (int)preparedStatement.executeUpdate());
                }
                preparedStatement = connection.prepareStatement("select * from test_bind_short where c1 = ?");
                try {
                    preparedStatement.setShort(1, shortValue);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                        MatcherAssert.assertThat((Object)resultSet.getShort("C1"), (Matcher)CoreMatchers.is((Object)shortValue));
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists test_bind_short");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(shorts={0, 1, -1, -32768, 32767})
    public void testBindShortViaSetObject(short shortValue) throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_bind_short(c1 number)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into test_bind_short values (?)");){
                    preparedStatement.setObject(1, new Short(shortValue));
                    preparedStatement.executeUpdate();
                }
                preparedStatement = connection.prepareStatement("select * from test_bind_short where c1 = ?");
                try {
                    preparedStatement.setObject(1, new Short(shortValue));
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                        MatcherAssert.assertThat((Object)resultSet.getShort("C1"), (Matcher)CoreMatchers.is((Object)shortValue));
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists test_bind_short");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(ints={0, 1, -1, -2147483648, 0x7FFFFFFF})
    public void testBindInt(int intValue) throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_bind_int(c1 number)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into test_bind_int values (?)");){
                    preparedStatement.setInt(1, intValue);
                    preparedStatement.executeUpdate();
                }
                preparedStatement = connection.prepareStatement("select * from test_bind_int where c1 = ?");
                try {
                    preparedStatement.setInt(1, intValue);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                        MatcherAssert.assertThat((Object)resultSet.getInt("C1"), (Matcher)CoreMatchers.is((Object)intValue));
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists test_bind_int");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(bytes={0, 1, -1, 127, -128})
    public void testBindByte(byte byteValue) throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_bind_byte(c1 integer)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into test_bind_byte values (?)");){
                    preparedStatement.setByte(1, byteValue);
                    preparedStatement.executeUpdate();
                }
                preparedStatement = connection.prepareStatement("select * from test_bind_byte where c1 = ?");
                try {
                    preparedStatement.setInt(1, byteValue);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                        MatcherAssert.assertThat((Object)resultSet.getByte("C1"), (Matcher)CoreMatchers.is((Object)byteValue));
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists test_bind_byte");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBindNull() throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_bind_null(id number, val number)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into test_bind_null values (?, ?)");){
                    preparedStatement.setInt(1, 0);
                    preparedStatement.setBigDecimal(2, null);
                    preparedStatement.addBatch();
                    preparedStatement.setInt(1, 1);
                    preparedStatement.setNull(1, 4);
                    preparedStatement.addBatch();
                    preparedStatement.setInt(1, 2);
                    preparedStatement.setObject(1, null, -5);
                    preparedStatement.addBatch();
                    preparedStatement.setInt(1, 3);
                    preparedStatement.setObject(1, null, -5, 0);
                    preparedStatement.addBatch();
                    preparedStatement.executeBatch();
                    try (ResultSet rs = statement.executeQuery("select * from test_bind_null order by id asc");){
                        int count = 0;
                        while (rs.next()) {
                            MatcherAssert.assertThat((Object)rs.getBigDecimal("VAL"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                            ++count;
                        }
                        MatcherAssert.assertThat((Object)count, (Matcher)CoreMatchers.is((Object)4));
                    }
                }
            }
            finally {
                statement.execute("drop table if exists test_bind_null");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=TimeProvider.class)
    public void testBindTime(Time timeVal) throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_bind_time(c1 time)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into test_bind_time values (?)");){
                    preparedStatement.setTime(1, timeVal);
                    preparedStatement.executeUpdate();
                }
                preparedStatement = connection.prepareStatement("select * from test_bind_time where c1 = ?");
                try {
                    preparedStatement.setTime(1, timeVal);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                        MatcherAssert.assertThat((Object)resultSet.getTime("C1"), (Matcher)CoreMatchers.is((Object)timeVal));
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists test_bind_time");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=TimeProvider.class)
    public void testBindTimeWithCalendar(Time timeVal) throws SQLException {
        Calendar utcCal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        Calendar laCal = Calendar.getInstance(TimeZone.getTimeZone("PST"));
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_bind_time_calendar(c1 time)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into test_bind_time_calendar values (?)");){
                    preparedStatement.setTime(1, timeVal, laCal);
                    preparedStatement.executeUpdate();
                }
                preparedStatement = connection.prepareStatement("select * from test_bind_time_calendar where c1 = ?");
                try {
                    preparedStatement.setTime(1, timeVal, laCal);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                        MatcherAssert.assertThat((Object)resultSet.getTime("C1", utcCal), (Matcher)CoreMatchers.is((Object)timeVal));
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists test_bind_time_calendar");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=TimeProvider.class)
    public void testBindTimeViaSetObject(Time timeVal) throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_bind_time(c1 time)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into test_bind_time values (?)");){
                    preparedStatement.setObject(1, (Object)timeVal, 92);
                    preparedStatement.executeUpdate();
                }
                preparedStatement = connection.prepareStatement("select * from test_bind_time where c1 = ?");
                try {
                    preparedStatement.setObject(1, (Object)timeVal, 92);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                        MatcherAssert.assertThat((Object)resultSet.getTime("C1"), (Matcher)CoreMatchers.is((Object)timeVal));
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists test_bind_time");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=TimeProvider.class)
    public void testBindTimeViaSetObjectCast(Time timeVal) throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_bind_time(c1 time)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into test_bind_time values (?)");){
                    preparedStatement.setObject(1, timeVal);
                    preparedStatement.executeUpdate();
                }
                preparedStatement = connection.prepareStatement("select * from test_bind_time where c1 = ?");
                try {
                    preparedStatement.setObject(1, timeVal);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                        MatcherAssert.assertThat((Object)resultSet.getTime("C1"), (Matcher)CoreMatchers.is((Object)timeVal));
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists test_bind_time");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=DateProvider.class)
    public void testBindDate(Date dateValue) throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_bind_date(c1 date)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into test_bind_date values (?)");){
                    preparedStatement.setDate(1, dateValue);
                    preparedStatement.executeUpdate();
                }
                preparedStatement = connection.prepareStatement("select * from test_bind_date where c1 = ?");
                try {
                    preparedStatement.setDate(1, dateValue);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                        MatcherAssert.assertThat((Object)resultSet.getDate("C1"), (Matcher)CoreMatchers.is((Object)dateValue));
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists test_bind_date");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=DateProvider.class)
    public void testBindDateWithCalendar(Date dateValue) throws SQLException {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_bind_date(c1 date)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into test_bind_date values (?)");){
                    preparedStatement.setDate(1, dateValue, calendar);
                    preparedStatement.executeUpdate();
                }
                preparedStatement = connection.prepareStatement("select * from test_bind_date where c1 = ?");
                try {
                    preparedStatement.setDate(1, dateValue, calendar);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                        MatcherAssert.assertThat((Object)resultSet.getDate("C1"), (Matcher)CoreMatchers.is((Object)dateValue));
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists test_bind_date");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(ints={0, 1, -1, -2147483648, 0x7FFFFFFF})
    public void testBindObjectWithScaleZero(int intValue) throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_bind_object_0(c1 number)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into test_bind_object_0 values (?)");){
                    preparedStatement.setObject(1, (Object)intValue, 2, 0);
                    preparedStatement.executeUpdate();
                }
                preparedStatement = connection.prepareStatement("select * from test_bind_object_0 where c1 = ?");
                try {
                    preparedStatement.setObject(1, (Object)intValue, 2, 0);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                        MatcherAssert.assertThat((Object)resultSet.getInt("C1"), (Matcher)CoreMatchers.is((Object)intValue));
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists test_bind_object_0");
            }
        }
    }

    @Test
    public void testBindNullForAllTypes() throws Throwable {
        try (Statement statement = connection.createStatement();){
            statement.execute("create or replace table TEST_BIND_ALL_TYPES(C0 string,C1 number(20, 3), C2 INTEGER, C3 double, C4 varchar(1000),C5 string, C6 date, C7 time, C8 timestamp_ntz, C9 timestamp_ltz, C10 timestamp_tz,C11 BINARY, C12 BOOLEAN)");
            for (SnowflakeType.JavaSQLType t : SnowflakeType.JavaSQLType.ALL_TYPES) {
                PreparedStatement preparedStatement = connection.prepareStatement("insert into TEST_BIND_ALL_TYPES values(?, ?,?,?, ?,?,?, ?,?,?, ?,?,?)");
                try {
                    preparedStatement.setString(1, t.toString());
                    for (int i = 2; i <= 13; ++i) {
                        preparedStatement.setNull(i, t.getType());
                    }
                    preparedStatement.executeUpdate();
                }
                finally {
                    if (preparedStatement == null) continue;
                    preparedStatement.close();
                }
            }
            try (ResultSet result = statement.executeQuery("select * from TEST_BIND_ALL_TYPES");){
                while (result.next()) {
                    String testType = result.getString(1);
                    for (int i = 2; i <= 13; ++i) {
                        Assertions.assertNull((Object)result.getString(i), (String)String.format("Java Type: %s is not null", testType));
                    }
                }
            }
        }
    }

    static class DateProvider
    implements ArgumentsProvider {
        DateProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            return Stream.of(Arguments.of((Object[])new Object[]{Date.valueOf("2000-01-01")}), Arguments.of((Object[])new Object[]{Date.valueOf("3000-01-01")}), Arguments.of((Object[])new Object[]{Date.valueOf("1970-01-01")}), Arguments.of((Object[])new Object[]{Date.valueOf("1969-01-01")}), Arguments.of((Object[])new Object[]{Date.valueOf("1500-01-01")}), Arguments.of((Object[])new Object[]{Date.valueOf("1400-01-01")}), Arguments.of((Object[])new Object[]{Date.valueOf("1000-01-01")}));
        }
    }

    static class TimeProvider
    implements ArgumentsProvider {
        TimeProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            return Stream.of(Arguments.of((Object[])new Object[]{Time.valueOf("00:00:00")}), Arguments.of((Object[])new Object[]{Time.valueOf("12:34:56")}), Arguments.of((Object[])new Object[]{Time.valueOf("12:00:00")}), Arguments.of((Object[])new Object[]{Time.valueOf("11:59:59")}), Arguments.of((Object[])new Object[]{Time.valueOf("15:30:00")}), Arguments.of((Object[])new Object[]{Time.valueOf("13:01:01")}));
        }
    }
}

