/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.CallableStatementITBase;
import net.snowflake.client.providers.SimpleResultFormatProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="statement")
public class CallableStatementIT
extends CallableStatementITBase {
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testPrepareCall(String queryResultFormat) throws SQLException {
        try (Connection connection = CallableStatementIT.getConnection(queryResultFormat);){
            ResultSet rs;
            try (CallableStatement callableStatement = connection.prepareCall("call square_it(5)");){
                MatcherAssert.assertThat((Object)callableStatement.getParameterMetaData().getParameterCount(), (Matcher)CoreMatchers.is((Object)0));
            }
            callableStatement = connection.prepareCall("call square_it(?)");
            try {
                MatcherAssert.assertThat((Object)callableStatement.getParameterMetaData().getParameterType(1), (Matcher)CoreMatchers.is((Object)12));
                callableStatement.getParameterMetaData().getParameterTypeName(1);
                MatcherAssert.assertThat((Object)callableStatement.getParameterMetaData().getParameterTypeName(1), (Matcher)CoreMatchers.is((Object)"text"));
                callableStatement.setFloat(1, 7.0f);
                rs = callableStatement.executeQuery();
                try {
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((float)49.0f, (float)rs.getFloat(1), (float)1.0f);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            callableStatement = connection.prepareCall("call add_nums(?,?)");
            try {
                callableStatement.setDouble(1, 32.0);
                callableStatement.setDouble(2, 15.0);
                rs = callableStatement.executeQuery();
                try {
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((double)47.0, (double)rs.getDouble(1), (double)0.5);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
        }
    }

    @Test
    public void testFeatureNotSupportedException() throws Throwable {
        try (Connection connection = CallableStatementIT.getConnection();){
            CallableStatement callableStatement = connection.prepareCall("select ?");
            this.expectFeatureNotSupportedException(() -> callableStatement.registerOutParameter(1, 4));
            this.expectFeatureNotSupportedException(() -> callableStatement.registerOutParameter(1, 4, 1));
            this.expectFeatureNotSupportedException(() -> callableStatement.registerOutParameter(1, 4, "int"));
            this.expectFeatureNotSupportedException(() -> callableStatement.registerOutParameter("param_name", 4));
            this.expectFeatureNotSupportedException(() -> callableStatement.registerOutParameter("param_name", 4, 1));
            this.expectFeatureNotSupportedException(() -> callableStatement.registerOutParameter("param_name", 4, "int"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getArray("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getArray(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getBigDecimal("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getBigDecimal(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getBlob("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getBlob(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getBoolean("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getBoolean(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getByte("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getByte(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getBytes("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getBytes(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getCharacterStream("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getCharacterStream(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getClob("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getClob(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getDate("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getDate(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getDate("param_name", Calendar.getInstance()));
            this.expectFeatureNotSupportedException(() -> callableStatement.getDate(1, Calendar.getInstance()));
            this.expectFeatureNotSupportedException(() -> callableStatement.getDouble("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getDouble(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getFloat("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getFloat(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getInt("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getInt(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getLong("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getLong(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getNCharacterStream("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getNCharacterStream(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getNClob("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getNClob(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getNString("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getNString(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getObject("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getObject(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getObject(1, String.class));
            this.expectFeatureNotSupportedException(() -> callableStatement.getObject(1, new HashMap()));
            this.expectFeatureNotSupportedException(() -> callableStatement.getObject("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getObject("param_name", String.class));
            this.expectFeatureNotSupportedException(() -> callableStatement.getObject("param_name", new HashMap()));
            this.expectFeatureNotSupportedException(() -> callableStatement.getRef("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getRef(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getRowId("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getRowId(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getShort("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getShort(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getSQLXML("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getSQLXML(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getString("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getString(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getTime("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getTime(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getTime("param_name", Calendar.getInstance()));
            this.expectFeatureNotSupportedException(() -> callableStatement.getTime(1, Calendar.getInstance()));
            this.expectFeatureNotSupportedException(() -> callableStatement.getTimestamp("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getTimestamp(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.getTimestamp("param_name", Calendar.getInstance()));
            this.expectFeatureNotSupportedException(() -> callableStatement.getTimestamp(1, Calendar.getInstance()));
            this.expectFeatureNotSupportedException(() -> callableStatement.getURL("param_name"));
            this.expectFeatureNotSupportedException(() -> callableStatement.getURL(1));
            this.expectFeatureNotSupportedException(() -> callableStatement.setAsciiStream("param_name", (InputStream)new BaseJDBCTest.FakeInputStream()));
            this.expectFeatureNotSupportedException(() -> callableStatement.setAsciiStream("param_name", (InputStream)new BaseJDBCTest.FakeInputStream(), 1));
            this.expectFeatureNotSupportedException(() -> callableStatement.setBigDecimal("param_name", BigDecimal.ONE));
            this.expectFeatureNotSupportedException(() -> callableStatement.setBinaryStream("param_name", (InputStream)new BaseJDBCTest.FakeInputStream()));
            this.expectFeatureNotSupportedException(() -> callableStatement.setBinaryStream("param_name", (InputStream)new BaseJDBCTest.FakeInputStream(), 1));
            this.expectFeatureNotSupportedException(() -> callableStatement.setBinaryStream("param_name", (InputStream)new BaseJDBCTest.FakeInputStream(), 5213L));
            this.expectFeatureNotSupportedException(() -> callableStatement.setBlob("param_name", (InputStream)new BaseJDBCTest.FakeInputStream()));
            this.expectFeatureNotSupportedException(() -> callableStatement.setBlob("param_name", (InputStream)new BaseJDBCTest.FakeInputStream(), 1L));
            this.expectFeatureNotSupportedException(() -> callableStatement.setBlob("param_name", (Blob)new BaseJDBCTest.FakeBlob()));
            this.expectFeatureNotSupportedException(() -> callableStatement.setBoolean("param_name", true));
            this.expectFeatureNotSupportedException(() -> callableStatement.setByte("param_name", (byte)6));
            this.expectFeatureNotSupportedException(() -> callableStatement.setBytes("param_name", "bytes".getBytes()));
            this.expectFeatureNotSupportedException(() -> callableStatement.setCharacterStream("param_name", (Reader)new BaseJDBCTest.FakeReader()));
            this.expectFeatureNotSupportedException(() -> callableStatement.setCharacterStream("param_name", (Reader)new BaseJDBCTest.FakeReader(), 1));
            this.expectFeatureNotSupportedException(() -> callableStatement.setCharacterStream("param_name", (Reader)new BaseJDBCTest.FakeReader(), 1L));
            this.expectFeatureNotSupportedException(() -> callableStatement.setClob("param_name", (Reader)new BaseJDBCTest.FakeReader()));
            this.expectFeatureNotSupportedException(() -> callableStatement.setClob("param_name", (Reader)new BaseJDBCTest.FakeReader(), 1L));
            this.expectFeatureNotSupportedException(() -> callableStatement.setClob("param_name", (Clob)new BaseJDBCTest.FakeNClob()));
            this.expectFeatureNotSupportedException(() -> callableStatement.setDate("param_name", Date.valueOf("2019-07-07")));
            this.expectFeatureNotSupportedException(() -> callableStatement.setDate("param_name", Date.valueOf("2019-07-07"), Calendar.getInstance()));
            this.expectFeatureNotSupportedException(() -> callableStatement.setDouble("param_name", 3.0));
            this.expectFeatureNotSupportedException(() -> callableStatement.setFloat("param_name", 3.0f));
            this.expectFeatureNotSupportedException(() -> callableStatement.setInt("param_name", 3));
            this.expectFeatureNotSupportedException(() -> callableStatement.setLong("param_name", 3L));
            this.expectFeatureNotSupportedException(() -> callableStatement.setNCharacterStream("param_name", (Reader)new BaseJDBCTest.FakeReader()));
            this.expectFeatureNotSupportedException(() -> callableStatement.setNCharacterStream("param_name", (Reader)new BaseJDBCTest.FakeReader(), 1L));
            this.expectFeatureNotSupportedException(() -> callableStatement.setNClob("param_name", (NClob)new BaseJDBCTest.FakeNClob()));
            this.expectFeatureNotSupportedException(() -> callableStatement.setNClob("param_name", (Reader)new BaseJDBCTest.FakeReader(), 1L));
            this.expectFeatureNotSupportedException(() -> callableStatement.setNClob("param_name", (Reader)new BaseJDBCTest.FakeReader()));
            this.expectFeatureNotSupportedException(() -> callableStatement.setNString("param_name", "test"));
            this.expectFeatureNotSupportedException(() -> callableStatement.setNull("param_name", 0));
            this.expectFeatureNotSupportedException(() -> callableStatement.setNull("param_name", 0, "null"));
            this.expectFeatureNotSupportedException(() -> callableStatement.setObject("param_name", new Object()));
            this.expectFeatureNotSupportedException(() -> callableStatement.setObject("param_name", new Object(), 2000));
            this.expectFeatureNotSupportedException(() -> callableStatement.setObject("param_name", new Object(), 2000, 2));
            this.expectFeatureNotSupportedException(() -> callableStatement.setRowId("param_name", (RowId)new BaseJDBCTest.FakeRowId()));
            this.expectFeatureNotSupportedException(() -> callableStatement.setShort("param_name", (short)1));
            this.expectFeatureNotSupportedException(() -> callableStatement.setSQLXML("param_name", (SQLXML)new BaseJDBCTest.FakeSQLXML()));
            this.expectFeatureNotSupportedException(() -> callableStatement.setString("param_name", "test"));
            this.expectFeatureNotSupportedException(() -> callableStatement.setTime("param_name", new Time(50L)));
            this.expectFeatureNotSupportedException(() -> callableStatement.setTime("param_name", new Time(50L), Calendar.getInstance()));
            this.expectFeatureNotSupportedException(() -> callableStatement.setTimestamp("param_name", new Timestamp(50L)));
            this.expectFeatureNotSupportedException(() -> callableStatement.setTimestamp("param_name", new Timestamp(50L), Calendar.getInstance()));
            URL fakeURL = new URL("http://localhost:8888/");
            this.expectFeatureNotSupportedException(() -> callableStatement.setURL(1, fakeURL));
            this.expectFeatureNotSupportedException(() -> callableStatement.wasNull());
        }
    }
}

