/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.AssumptionUtils;
import net.snowflake.client.TestUtil;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.BaseJDBCWithSharedConnectionIT;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeBasicDataSource;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializable;
import org.apache.commons.codec.binary.Base64;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="connection")
public class ConnectionIT
extends BaseJDBCWithSharedConnectionIT {
    public static final int INVALID_CONNECTION_INFO_CODE = 390100;
    private static final int SESSION_CREATION_OBJECT_DOES_NOT_EXIST_NOT_AUTHORIZED = 390201;
    private static final int ROLE_IN_CONNECT_STRING_DOES_NOT_EXIST = 390189;
    public static final int BAD_REQUEST_GS_CODE = 390400;
    public static final int NETWORK_ERROR_CODE = 200015;
    public static final int WAIT_FOR_TELEMETRY_REPORT_IN_MILLISECS = 5000;
    String errorMessage = null;
    @TempDir
    private File tmpFolder;

    @Test
    public void testSimpleConnection() throws SQLException {
        Connection con = ConnectionIT.getConnection();
        try (Statement statement = con.createStatement();
             ResultSet resultSet = statement.executeQuery("show parameters");){
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertFalse((boolean)con.isClosed());
        }
        con.close();
        Assertions.assertTrue((boolean)con.isClosed());
        con.close();
    }

    @Test
    @Disabled
    public void test300ConnectionsWithSingleClientInstance() throws SQLException {
        int size = 300;
        try (Statement statement = connection.createStatement();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            statement.execute("create or replace table bigTable(rowNum number,rando number) as (select seq4(),uniform(1, 10, random()) from table(generator(rowcount=>10000000)) v)");
            statement.execute("create or replace table conTable(colA number)");
            ExecutorService taskRunner = Executors.newFixedThreadPool(size);
            for (int i = 0; i < size; ++i) {
                ConcurrentConnections newTask = new ConcurrentConnections();
                taskRunner.submit(newTask);
            }
            Assertions.assertEquals(null, (Object)this.errorMessage);
            taskRunner.shutdownNow();
        }
    }

    @Test
    public void testLoginTimeoutViaDataSource() throws SQLException {
        SnowflakeBasicDataSource ds = new SnowflakeBasicDataSource();
        ds.setUrl("jdbc:snowflake://fakeaccount.snowflakecomputing.com");
        ds.setUser("fakeUser");
        ds.setPassword("fakePassword");
        ds.setAccount("fakeAccount");
        ds.setLoginTimeout(10);
        long startLoginTime = System.currentTimeMillis();
        SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> ds.getConnection());
        MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
        long endLoginTime = System.currentTimeMillis();
        Assertions.assertTrue((endLoginTime - startLoginTime < 30000L ? 1 : 0) != 0);
    }

    @Disabled(value="Disable due to changed error response in backend. Follow up: SNOW-2021007")
    @Test
    public void testProdConnectivity() throws SQLException {
        String[] deploymentUrls = new String[]{"jdbc:snowflake://sfcsupport.snowflakecomputing.com", "jdbc:snowflake://sfcsupportva.us-east-1.snowflakecomputing.com", "jdbc:snowflake://sfcsupporteu.eu-central-1.snowflakecomputing.com"};
        Properties properties = new Properties();
        properties.put("user", "fakeuser");
        properties.put("password", "fakepwd");
        properties.put("account", "fakeaccount");
        for (String url : deploymentUrls) {
            SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> DriverManager.getConnection(url, properties));
            MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.is((Object)390100), CoreMatchers.is((Object)390400)}));
        }
    }

    @Test
    public void testSetCatalogSchema() throws Throwable {
        try (Statement statement = connection.createStatement();){
            String db = connection.getCatalog();
            String schema = connection.getSchema();
            connection.setCatalog(db);
            connection.setSchema("PUBLIC");
            try (ResultSet rst = statement.executeQuery("select current_schema()");){
                Assertions.assertTrue((boolean)rst.next());
                Assertions.assertEquals((Object)"PUBLIC", (Object)rst.getString(1));
                Assertions.assertEquals((Object)db, (Object)connection.getCatalog());
                Assertions.assertEquals((Object)"PUBLIC", (Object)connection.getSchema());
            }
            connection.setSchema(schema);
            rst = statement.executeQuery("select current_schema()");
            try {
                Assertions.assertTrue((boolean)rst.next());
                Assertions.assertEquals((Object)schema, (Object)rst.getString(1));
            }
            finally {
                if (rst != null) {
                    rst.close();
                }
            }
        }
    }

    @Test
    public void testDataCompletenessInLowMemory() throws Exception {
        try (Connection connection = ConnectionIT.getConnection();
             Statement statement = connection.createStatement();){
            for (int i = 0; i < 6; ++i) {
                int resultSize = 1000000 + i;
                statement.execute("ALTER SESSION SET CLIENT_MEMORY_LIMIT=10");
                try (ResultSet resultSet = statement.executeQuery("select randstr(80, random()) from table(generator(rowcount => " + resultSize + "))");){
                    int size = 0;
                    while (resultSet.next()) {
                        ++size;
                    }
                    System.out.println("Total records: " + size);
                    Assertions.assertEquals((int)size, (int)resultSize);
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testConnectionGetAndSetDBAndSchema() throws SQLException {
        String SECOND_DATABASE = "SECOND_DATABASE";
        String SECOND_SCHEMA = "SECOND_SCHEMA";
        try (Statement statement = connection.createStatement();){
            try {
                String database = TestUtil.systemGetEnv("SNOWFLAKE_TEST_DATABASE").toUpperCase();
                String schema = TestUtil.systemGetEnv("SNOWFLAKE_TEST_SCHEMA").toUpperCase();
                Assertions.assertEquals((Object)database, (Object)connection.getCatalog());
                Assertions.assertEquals((Object)schema, (Object)connection.getSchema());
                statement.execute(String.format("create or replace database %s", "SECOND_DATABASE"));
                statement.execute(String.format("create or replace schema %s", "SECOND_SCHEMA"));
                statement.execute(String.format("use database %s", database));
                connection.setCatalog("SECOND_DATABASE");
                Assertions.assertEquals((Object)"SECOND_DATABASE", (Object)connection.getCatalog());
                Assertions.assertEquals((Object)"PUBLIC", (Object)connection.getSchema());
                connection.setSchema("SECOND_SCHEMA");
                Assertions.assertEquals((Object)"SECOND_SCHEMA", (Object)connection.getSchema());
                statement.execute(String.format("use database %s", database));
                statement.execute(String.format("use schema %s", schema));
                Assertions.assertEquals((Object)database, (Object)connection.getCatalog());
                Assertions.assertEquals((Object)schema, (Object)connection.getSchema());
            }
            catch (Throwable throwable) {
                statement.execute(String.format("drop database if exists %s", "SECOND_DATABASE"));
                throw throwable;
            }
            statement.execute(String.format("drop database if exists %s", "SECOND_DATABASE"));
        }
    }

    @Test
    public void testConnectionClientInfo() throws SQLException {
        Properties property = connection.getClientInfo();
        Assertions.assertEquals((int)0, (int)property.size());
        Properties clientInfo = new Properties();
        clientInfo.setProperty("name", "Peter");
        clientInfo.setProperty("description", "SNOWFLAKE JDBC");
        SQLClientInfoException e = (SQLClientInfoException)Assertions.assertThrows(SQLClientInfoException.class, () -> connection.setClientInfo(clientInfo));
        Assertions.assertEquals((Object)"22023", (Object)e.getSQLState());
        Assertions.assertEquals((int)200047, (int)e.getErrorCode());
        Assertions.assertEquals((int)2, (int)e.getFailedProperties().size());
        e = (SQLClientInfoException)Assertions.assertThrows(SQLClientInfoException.class, () -> connection.setClientInfo("ApplicationName", "valueA"));
        Assertions.assertEquals((Object)"22023", (Object)e.getSQLState());
        Assertions.assertEquals((int)200047, (int)e.getErrorCode());
        Assertions.assertEquals((int)1, (int)e.getFailedProperties().size());
    }

    @Test
    public void testNetworkTimeout() throws SQLException {
        int millis = connection.getNetworkTimeout();
        Assertions.assertEquals((int)0, (int)millis);
        connection.setNetworkTimeout(null, 200);
        Assertions.assertEquals((int)200, (int)connection.getNetworkTimeout());
        connection.setNetworkTimeout(null, 0);
        Assertions.assertEquals((int)0, (int)millis);
    }

    @Test
    public void testAbort() throws SQLException {
        Connection con = ConnectionIT.getConnection();
        Assertions.assertTrue((!con.isClosed() ? 1 : 0) != 0);
        con.abort(null);
        Assertions.assertTrue((boolean)con.isClosed());
    }

    @Test
    public void testSetQueryTimeoutInConnectionStr() throws SQLException {
        Properties properties = new Properties();
        properties.put("queryTimeout", "5");
        try (Connection connection = ConnectionIT.getConnection(properties);
             Statement statement = connection.createStatement();){
            SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> statement.executeQuery("select count(*) from table(generator(timeLimit => 1000000))"));
            Assertions.assertEquals((Object)"57014", (Object)e.getSQLState());
            Assertions.assertEquals((Object)"SQL execution canceled", (Object)e.getMessage());
        }
    }

    @Test
    public void testConnectViaDataSource() throws SQLException {
        ResultSet resultSet;
        Statement statement;
        SnowflakeBasicDataSource ds = new SnowflakeBasicDataSource();
        Map<String, String> params = ConnectionIT.getConnectionParameters();
        String account = params.get("account");
        String host = params.get("host");
        String port = params.get("port");
        String user = params.get("user");
        String password = params.get("password");
        String ssl = params.get("ssl");
        String connectStr = String.format("jdbc:snowflake://%s:%s", host, port);
        ds.setUrl(connectStr);
        ds.setAccount(account);
        ds.setSsl("on".equals(ssl));
        try (Connection connection = ds.getConnection(user, password);){
            statement = connection.createStatement();
            try {
                resultSet = statement.executeQuery("select 1");
                try {
                    resultSet.next();
                    MatcherAssert.assertThat((String)"select 1", (Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)1));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        ds = new SnowflakeBasicDataSource();
        ds.setServerName(params.get("host"));
        ds.setSsl("on".equals(ssl));
        ds.setAccount(account);
        ds.setPortNumber(Integer.parseInt(port));
        connection = ds.getConnection(params.get("user"), params.get("password"));
        try {
            statement = connection.createStatement();
            try {
                resultSet = statement.executeQuery("select 1");
                try {
                    resultSet.next();
                    MatcherAssert.assertThat((String)"select 1", (Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)1));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Test
    @Disabled
    public void testDataSourceOktaSerialization() throws Exception {
        Map<String, String> params = ConnectionIT.getConnectionParameters();
        SnowflakeBasicDataSource ds = new SnowflakeBasicDataSource();
        ds.setServerName(params.get("host"));
        ds.setSsl("on".equals(params.get("ssl")));
        ds.setAccount(params.get("account"));
        ds.setPortNumber(Integer.parseInt(params.get("port")));
        ds.setUser(params.get("ssoUser"));
        ds.setPassword(params.get("ssoPassword"));
        ds.setAuthenticator("https://snowflakecomputing.okta.com/");
        try (Connection con = ds.getConnection();
             Statement statement = con.createStatement();
             ResultSet resultSet = statement.executeQuery("select 1");){
            resultSet.next();
            MatcherAssert.assertThat((String)"select 1", (Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)1));
            File serializedFile = new File(this.tmpFolder, "serializedStuff.ser");
            serializedFile.createNewFile();
            try (FileOutputStream outputFile = new FileOutputStream(serializedFile);
                 ObjectOutputStream out = new ObjectOutputStream(outputFile);){
                out.writeObject(ds);
            }
            try (FileInputStream inputFile = new FileInputStream(serializedFile);
                 ObjectInputStream in = new ObjectInputStream(inputFile);){
                SnowflakeBasicDataSource ds2 = (SnowflakeBasicDataSource)in.readObject();
                try (Connection connection = ds2.getConnection();
                     Statement statement2 = connection.createStatement();
                     ResultSet resultSet2 = statement2.executeQuery("select 1");){
                    resultSet2.next();
                    MatcherAssert.assertThat((String)"select 1", (Object)resultSet2.getInt(1), (Matcher)CoreMatchers.equalTo((Object)1));
                }
            }
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testConnectUsingKeyPair() throws Exception {
        Statement statement;
        Map<String, String> parameters = ConnectionIT.getConnectionParameters();
        String testUser = parameters.get("user");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        keyPairGenerator.initialize(2048, random);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        try (Connection connection = ConnectionIT.getConnection();
             Statement statement2 = connection.createStatement();){
            statement2.execute("use role accountadmin");
            String encodePublicKey = Base64.encodeBase64String((byte[])publicKey.getEncoded());
            statement2.execute(String.format("alter user %s set rsa_public_key='%s'", testUser, encodePublicKey));
        }
        String uri = parameters.get("uri");
        Properties properties = new Properties();
        properties.put("account", parameters.get("account"));
        properties.put("user", testUser);
        properties.put("ssl", parameters.get("ssl"));
        properties.put("port", parameters.get("port"));
        properties.put("privateKey", privateKey);
        try (Connection connection = DriverManager.getConnection(uri, properties);){
            Assertions.assertFalse((boolean)connection.isClosed());
        }
        SnowflakeBasicDataSource ds = new SnowflakeBasicDataSource();
        ds.setUrl(uri);
        ds.setAccount(parameters.get("account"));
        ds.setUser(parameters.get("user"));
        ds.setSsl("on".equals(parameters.get("ssl")));
        ds.setPortNumber(Integer.valueOf(parameters.get("port")).intValue());
        ds.setPrivateKey(privateKey);
        try (Connection con = ds.getConnection();){
            Assertions.assertFalse((boolean)con.isClosed());
        }
        keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey2 = keyPair.getPublic();
        PrivateKey privateKey2 = keyPair.getPrivate();
        properties.put("privateKey", privateKey2);
        SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> DriverManager.getConnection(uri, properties));
        Assertions.assertEquals((int)390144, (int)e.getErrorCode());
        try (Connection connection = ConnectionIT.getConnection();){
            statement = connection.createStatement();
            try {
                statement.execute("use role accountadmin");
                String encodePublicKey2 = Base64.encodeBase64String((byte[])publicKey2.getEncoded());
                statement.execute(String.format("alter user %s set rsa_public_key_2='%s'", testUser, encodePublicKey2));
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        connection = DriverManager.getConnection(uri, properties);
        try {
            Assertions.assertFalse((boolean)connection.isClosed());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        connection = ConnectionIT.getConnection();
        try {
            statement = connection.createStatement();
            try {
                statement.execute("use role accountadmin");
                statement.execute(String.format("alter user %s unset rsa_public_key", testUser));
                statement.execute(String.format("alter user %s unset rsa_public_key_2", testUser));
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Test
    public void testBadPrivateKey() throws Exception {
        Map<String, String> parameters = ConnectionIT.getConnectionParameters();
        String testUser = parameters.get("user");
        String uri = parameters.get("uri");
        Properties properties = new Properties();
        properties.put("account", parameters.get("account"));
        properties.put("user", testUser);
        properties.put("ssl", parameters.get("ssl"));
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA");
        PrivateKey dsaPrivateKey = keyPairGenerator.generateKeyPair().getPrivate();
        SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> {
            properties.put("privateKey", "bad string");
            DriverManager.getConnection(uri, properties);
        });
        MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.INVALID_PARAMETER_TYPE.getMessageCode()));
        e = (SQLException)Assertions.assertThrows(SQLException.class, () -> {
            properties.put("privateKey", dsaPrivateKey);
            DriverManager.getConnection(uri, properties);
        });
        MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.INVALID_OR_UNSUPPORTED_PRIVATE_KEY.getMessageCode()));
    }

    @Test
    @DontRunOnGithubActions
    public void testDifferentKeyLength() throws Exception {
        Map<String, String> parameters = ConnectionIT.getConnectionParameters();
        String testUser = parameters.get("user");
        Integer[] testCases = new Integer[]{2048, 4096, 8192};
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        for (Integer keyLength : testCases) {
            keyPairGenerator.initialize(keyLength, random);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PublicKey publicKey = keyPair.getPublic();
            PrivateKey privateKey = keyPair.getPrivate();
            try (Connection connection = ConnectionIT.getConnection();
                 Statement statement = connection.createStatement();){
                statement.execute("use role accountadmin");
                String encodePublicKey = Base64.encodeBase64String((byte[])publicKey.getEncoded());
                statement.execute(String.format("alter user %s set rsa_public_key='%s'", testUser, encodePublicKey));
            }
            String uri = parameters.get("uri");
            Properties properties = new Properties();
            properties.put("account", parameters.get("account"));
            properties.put("user", testUser);
            properties.put("ssl", parameters.get("ssl"));
            properties.put("port", parameters.get("port"));
            properties.put("role", "accountadmin");
            properties.put("privateKey", privateKey);
            try (Connection connection = DriverManager.getConnection(uri, properties);){
                Assertions.assertFalse((boolean)connection.isClosed());
            }
            connection = ConnectionIT.getConnection();
            try (Statement statement = connection.createStatement();){
                statement.execute("use role accountadmin");
                statement.execute(String.format("alter user %s unset rsa_public_key", testUser));
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
    }

    @Disabled(value="Disable due to changed error response in backend. Follow up: SNOW-2021007")
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testInsecureMode(boolean insecureModeInProperties) {
        String deploymentUrl;
        Properties properties = new Properties();
        properties.put("user", "fakeuser");
        properties.put("password", "fakepwd");
        properties.put("account", "fakeaccount");
        if (insecureModeInProperties) {
            properties.put("insecureMode", (Object)true);
            deploymentUrl = "jdbc:snowflake://sfcsupport.snowflakecomputing.com";
        } else {
            deploymentUrl = "jdbc:snowflake://sfcsupport.snowflakecomputing.com?insecureMode=true";
        }
        SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> DriverManager.getConnection(deploymentUrl, properties));
        MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.is((Object)390100), CoreMatchers.is((Object)390400)}));
    }

    @Test
    public void testClientMemoryParameters() throws Exception {
        Properties paramProperties = new Properties();
        paramProperties.put("CLIENT_PREFETCH_THREADS", "6");
        paramProperties.put("CLIENT_RESULT_CHUNK_SIZE", (Object)48);
        paramProperties.put("CLIENT_MEMORY_LIMIT", (Object)1000);
        try (Connection connection = ConnectionIT.getConnection(paramProperties);
             Statement statement = connection.createStatement();){
            Enumeration<?> enums = paramProperties.propertyNames();
            while (enums.hasMoreElements()) {
                String key = (String)enums.nextElement();
                ResultSet rs = statement.executeQuery(String.format("show parameters like '%s'", key));
                try {
                    Assertions.assertTrue((boolean)rs.next());
                    String value = rs.getString("value");
                    MatcherAssert.assertThat((String)key, (Object)value, (Matcher)CoreMatchers.equalTo((Object)paramProperties.get(key).toString()));
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientMemoryJvmParameters() throws Exception {
        Properties paramProperties = new Properties();
        paramProperties.put("CLIENT_PREFETCH_THREADS", "6");
        paramProperties.put("CLIENT_RESULT_CHUNK_SIZE", (Object)48);
        paramProperties.put("CLIENT_MEMORY_LIMIT", (Object)1000L);
        System.setProperty("net.snowflake.jdbc.clientPrefetchThreads", paramProperties.get("CLIENT_PREFETCH_THREADS").toString());
        System.setProperty("net.snowflake.jdbc.clientResultChunkSize", paramProperties.get("CLIENT_RESULT_CHUNK_SIZE").toString());
        System.setProperty("net.snowflake.jdbc.clientMemoryLimit", paramProperties.get("CLIENT_MEMORY_LIMIT").toString());
        try (Connection connection = ConnectionIT.getConnection();
             Statement statement = connection.createStatement();){
            Enumeration<?> enums = paramProperties.propertyNames();
            while (enums.hasMoreElements()) {
                String key = (String)enums.nextElement();
                ResultSet rs = statement.executeQuery(String.format("show parameters like '%s'", key));
                try {
                    Assertions.assertTrue((boolean)rs.next());
                    String value = rs.getString("value");
                    MatcherAssert.assertThat((String)key, (Object)value, (Matcher)CoreMatchers.equalTo((Object)paramProperties.get(key).toString()));
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
        }
        finally {
            System.clearProperty("net.snowflake.jdbc.clientPrefetchThreads");
            System.clearProperty("net.snowflake.jdbc.clientResultChunkSize");
            System.clearProperty("net.snowflake.jdbc.clientMemoryLimit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientMixedMemoryJvmParameters() throws Exception {
        Properties paramProperties = new Properties();
        paramProperties.put("CLIENT_PREFETCH_THREADS", "6");
        paramProperties.put("CLIENT_RESULT_CHUNK_SIZE", (Object)48);
        paramProperties.put("CLIENT_MEMORY_LIMIT", (Object)1000L);
        System.setProperty("net.snowflake.jdbc.clientPrefetchThreads", paramProperties.get("CLIENT_PREFETCH_THREADS").toString());
        System.setProperty("net.snowflake.jdbc.clientResultChunkSize", paramProperties.get("CLIENT_RESULT_CHUNK_SIZE").toString());
        System.setProperty("net.snowflake.jdbc.clientMemoryLimit", paramProperties.get("CLIENT_MEMORY_LIMIT").toString());
        paramProperties.put("CLIENT_PREFETCH_THREADS", "8");
        paramProperties.put("CLIENT_RESULT_CHUNK_SIZE", (Object)64);
        paramProperties.put("CLIENT_MEMORY_LIMIT", (Object)2000L);
        try (Connection connection = ConnectionIT.getConnection(paramProperties);
             Statement statement = connection.createStatement();){
            Enumeration<?> enums = paramProperties.propertyNames();
            while (enums.hasMoreElements()) {
                String key = (String)enums.nextElement();
                ResultSet rs = statement.executeQuery(String.format("show parameters like '%s'", key));
                try {
                    Assertions.assertTrue((boolean)rs.next());
                    String value = rs.getString("value");
                    MatcherAssert.assertThat((String)key, (Object)value, (Matcher)CoreMatchers.equalTo((Object)paramProperties.get(key).toString()));
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
        }
        finally {
            System.clearProperty("net.snowflake.jdbc.clientPrefetchThreads");
            System.clearProperty("net.snowflake.jdbc.clientResultChunkSize");
            System.clearProperty("net.snowflake.jdbc.clientMemoryLimit");
        }
    }

    @Test
    public void testHeartbeatFrequencyTooLarge() throws Exception {
        Properties paramProperties = new Properties();
        paramProperties.put("CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY", (Object)4000);
        try (Connection connection = ConnectionIT.getConnection(paramProperties);
             Statement statement = connection.createStatement();){
            connection.getClientInfo("CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY");
            Enumeration<?> enums = paramProperties.propertyNames();
            while (enums.hasMoreElements()) {
                String key = (String)enums.nextElement();
                ResultSet rs = statement.executeQuery(String.format("show parameters like '%s'", key));
                try {
                    Assertions.assertTrue((boolean)rs.next());
                    String value = rs.getString("value");
                    MatcherAssert.assertThat((String)key, (Object)value, (Matcher)CoreMatchers.equalTo((Object)"3600"));
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            SFSession session = connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
            Assertions.assertEquals((int)3600, (int)session.getHeartbeatFrequency());
        }
    }

    @Test
    public void testNativeSQL() throws Throwable {
        Assertions.assertEquals((Object)"select 1", (Object)connection.nativeSQL("select 1"));
    }

    @Test
    public void testGetTypeMap() throws Throwable {
        Assertions.assertEquals(Collections.emptyMap(), connection.getTypeMap());
    }

    @Test
    public void testHolderbility() throws Throwable {
        try (Connection connection = ConnectionIT.getConnection();){
            try {
                connection.setHoldability(1);
            }
            catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                // empty catch block
            }
            Assertions.assertEquals((int)2, (int)connection.getHoldability());
        }
    }

    @Test
    public void testIsValid() throws Throwable {
        try (Connection connection = ConnectionIT.getConnection();){
            Assertions.assertTrue((boolean)connection.isValid(10));
            Assertions.assertThrows(SQLException.class, () -> Assertions.assertTrue((boolean)connection.isValid(-10)));
        }
    }

    @Test
    public void testUnwrapper() throws Throwable {
        try (Connection connection = ConnectionIT.getConnection();){
            boolean canUnwrap = connection.isWrapperFor(SnowflakeConnectionV1.class);
            Assertions.assertTrue((boolean)canUnwrap);
            SnowflakeConnectionV1 sfconnection = connection.unwrap(SnowflakeConnectionV1.class);
            sfconnection.createStatement();
            Assertions.assertThrows(SQLException.class, () -> connection.unwrap(SnowflakeDriver.class));
        }
    }

    @Test
    public void testStatementsAndResultSetsClosedByConnection() throws SQLException {
        Connection connection = ConnectionIT.getConnection();
        Statement statement1 = connection.createStatement();
        Statement statement2 = connection.createStatement();
        ResultSet rs1 = statement2.executeQuery("select 2;");
        ResultSet rs2 = statement2.executeQuery("select 2;");
        ResultSet rs3 = statement2.executeQuery("select 2;");
        PreparedStatement statement3 = connection.prepareStatement("select 2;");
        connection.close();
        Assertions.assertTrue((boolean)statement1.isClosed());
        Assertions.assertTrue((boolean)statement2.isClosed());
        Assertions.assertTrue((boolean)statement3.isClosed());
        Assertions.assertTrue((boolean)rs1.isClosed());
        Assertions.assertTrue((boolean)rs2.isClosed());
        Assertions.assertTrue((boolean)rs3.isClosed());
    }

    @Test
    public void testReadDateAfterSplittingResultSet() throws Exception {
        Connection conn = ConnectionIT.getConnection();
        try (Statement statement = conn.createStatement();){
            statement.execute("create or replace table table_with_date (int_c int, date_c date)");
            statement.execute("insert into table_with_date values (1, '2015-10-25')");
            try (ResultSet rs = statement.executeQuery("select * from table_with_date");){
                SnowflakeResultSet resultSet = rs.unwrap(SnowflakeResultSet.class);
                long arbitrarySizeInBytes = 1024L;
                List serializables = resultSet.getResultSetSerializables(1024L);
                ArrayList<Date> dates = new ArrayList<Date>();
                for (SnowflakeResultSetSerializable s : serializables) {
                    ResultSet srs = s.getResultSet();
                    srs.next();
                    dates.add(srs.getDate(2));
                }
                Assertions.assertEquals((int)1, (int)dates.size());
                Assertions.assertEquals((Object)"2015-10-25", (Object)((java.util.Date)dates.get(0)).toString());
            }
        }
    }

    @Test
    public void testResultSetsClosedByStatement() throws SQLException {
        Statement statement2 = connection.createStatement();
        ResultSet rs1 = statement2.executeQuery("select 2;");
        ResultSet rs2 = statement2.executeQuery("select 2;");
        ResultSet rs3 = statement2.executeQuery("select 2;");
        PreparedStatement statement3 = connection.prepareStatement("select 2;");
        ResultSet rs4 = statement3.executeQuery();
        Assertions.assertFalse((boolean)rs1.isClosed());
        Assertions.assertFalse((boolean)rs2.isClosed());
        Assertions.assertFalse((boolean)rs3.isClosed());
        Assertions.assertFalse((boolean)rs4.isClosed());
        statement2.close();
        statement3.close();
        Assertions.assertTrue((boolean)rs1.isClosed());
        Assertions.assertTrue((boolean)rs2.isClosed());
        Assertions.assertTrue((boolean)rs3.isClosed());
        Assertions.assertTrue((boolean)rs4.isClosed());
    }

    @ParameterizedTest
    @CsvSource(value={"db,390201", "schema,390201", "warehouse,390201", "role,390189"})
    public void testValidateDefaultParameters(String propertyName, int expectedErrorCode) throws Throwable {
        Map<String, String> params = ConnectionIT.getConnectionParameters();
        Properties props = this.setCommonConnectionParameters(true);
        props.put(propertyName, "NOT_EXISTS");
        SQLException ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> DriverManager.getConnection((String)params.get("uri"), props));
        Assertions.assertEquals((int)ex.getErrorCode(), (int)expectedErrorCode, (String)"error code");
    }

    @Test
    public void testNoValidateDefaultParameters() throws Throwable {
        Map<String, String> params = ConnectionIT.getConnectionParameters();
        Properties props = this.setCommonConnectionParameters(false);
        props.put("db", "NOT_EXISTS");
        DriverManager.getConnection(params.get("uri"), props);
        props = this.setCommonConnectionParameters(false);
        props.put("schema", "NOT_EXISTS");
        DriverManager.getConnection(params.get("uri"), props);
        props = this.setCommonConnectionParameters(false);
        props.put("warehouse", "NOT_EXISTS");
        DriverManager.getConnection(params.get("uri"), props);
        props = this.setCommonConnectionParameters(false);
        props.put("role", "NOT_EXISTS");
        Properties finalProps = props;
        SQLException ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> DriverManager.getConnection((String)params.get("uri"), finalProps));
        Assertions.assertEquals((int)ex.getErrorCode(), (int)390189, (String)"error code");
    }

    @Disabled
    @Test
    public void testOrgAccountUrl() throws SQLException {
        Properties props = new Properties();
        props.put("user", "admin");
        props.put("password", "Password1");
        props.put("role", "accountadmin");
        props.put("timezone", "UTC");
        try (Connection con = DriverManager.getConnection("jdbc:snowflake://amoghorgurl-keypairauth_test_alias.testdns.snowflakecomputing.com", props);
             Statement statement = con.createStatement();){
            statement.execute("select 1");
        }
    }

    @Disabled
    @Test
    public void testOrgAccountUrlWithKeyPair() throws SQLException, NoSuchAlgorithmException {
        String uri = "jdbc:snowflake://amoghorgurl-keypairauth_test_alias.testdns.snowflakecomputing.com";
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        keyPairGenerator.initialize(2048, random);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        Properties props = new Properties();
        props.put("user", "admin");
        props.put("password", "Password1");
        props.put("role", "accountadmin");
        props.put("timezone", "UTC");
        try (Connection connection = DriverManager.getConnection(uri, props);
             Statement statement = connection.createStatement();){
            String encodePublicKey = Base64.encodeBase64String((byte[])publicKey.getEncoded());
            statement.execute(String.format("alter user %s set rsa_public_key='%s'", "admin", encodePublicKey));
        }
        props.remove("password");
        props.put("privateKey", privateKey);
        connection = DriverManager.getConnection(uri, props);
        if (connection != null) {
            connection.close();
        }
    }

    private Properties kvMap2Properties(Map<String, String> params, boolean validateDefaultParameters) {
        Properties props = new Properties();
        props.put("validateDefaultParameters", (Object)validateDefaultParameters);
        props.put("account", params.get("account"));
        props.put("ssl", params.get("ssl"));
        props.put("role", params.get("role"));
        props.put("user", params.get("user"));
        props.put("password", params.get("password"));
        props.put("db", params.get("database"));
        props.put("schema", params.get("schema"));
        props.put("warehouse", params.get("warehouse"));
        return props;
    }

    private Properties setCommonConnectionParameters(boolean validateDefaultParameters) {
        Map<String, String> params = ConnectionIT.getConnectionParameters();
        return this.kvMap2Properties(params, validateDefaultParameters);
    }

    @Test
    public void testFailOverOrgAccount() throws SQLException {
        AssumptionUtils.assumeRunningOnGithubActions();
        Map<String, String> kvParams = ConnectionIT.getConnectionParameters(null, "ORG");
        Properties connProps = this.kvMap2Properties(kvParams, false);
        String uri = kvParams.get("uri");
        try (Connection con = DriverManager.getConnection(uri, connProps);
             Statement statement = con.createStatement();){
            statement.execute("select 1");
        }
    }

    private class ConcurrentConnections
    implements Runnable {
        ConcurrentConnections() {
        }

        @Override
        public void run() {
            try (Connection con = AbstractDriverIT.getConnection();
                 Statement statement = con.createStatement();){
                statement.executeQuery("select * from bigTable");
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }
}

