/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="connection")
public class ConnectionPoolingIT {
    private BasicDataSource bds = null;
    private ComboPooledDataSource cpds = null;
    private final String connectStr;
    private final String account;
    private final String user;
    private final String password;
    private final String database;
    private final String schema;
    private final String ssl;
    private GenericObjectPool connectionPool = null;

    public ConnectionPoolingIT() {
        Map<String, String> params = BaseJDBCTest.getConnectionParameters();
        this.connectStr = params.get("uri");
        this.account = params.get("account");
        this.user = params.get("user");
        this.password = params.get("password");
        this.database = params.get("database");
        this.schema = params.get("schema");
        this.ssl = params.get("ssl");
    }

    @BeforeEach
    public void setUp() throws SQLException {
        try (Connection connection = BaseJDBCTest.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("create or replace table test_pooling(colA string)");
            statement.execute("insert into test_pooling values('test_str')");
        }
    }

    @AfterEach
    public void tearDown() throws SQLException {
        try (Connection connection = BaseJDBCTest.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("drop table if exists TEST_POOLING");
        }
    }

    private void setUpDBCPConnection() {
        this.bds = new BasicDataSource();
        this.bds.setDriverClassName("net.snowflake.client.jdbc.SnowflakeDriver");
        this.bds.setUsername(this.user);
        this.bds.setPassword(this.password);
        this.bds.setUrl(this.connectStr);
        String propertyString = String.format("ssl=%s;db=%s;schema=%s;account=%s;", this.ssl, this.database, this.schema, this.account);
        this.bds.setConnectionProperties(propertyString);
    }

    @Test
    public void testDBCPConnection() throws SQLException, Exception {
        this.setUpDBCPConnection();
        for (int i = 0; i < 10; ++i) {
            Thread t = new Thread(new queryUsingPool(this.bds));
            t.join();
        }
    }

    private PoolingDataSource setUpPoolingDataSource() throws Exception {
        Class.forName("net.snowflake.client.jdbc.SnowflakeDriver");
        this.connectionPool = new GenericObjectPool();
        this.connectionPool.setMaxActive(20);
        return new PoolingDataSource((ObjectPool)this.connectionPool);
    }

    public GenericObjectPool getConnectionPool() {
        return this.connectionPool;
    }

    @Test
    public void testPoolingDataSource() throws Exception, SQLException {
        PoolingDataSource pds = this.setUpPoolingDataSource();
        for (int i = 0; i < 10; ++i) {
            Thread t = new Thread(new queryUsingPool(pds));
            t.join();
        }
    }

    private void setUpC3P0Connection() throws PropertyVetoException, SQLException {
        Properties connectionProperties = this.setUpConnectionProperty();
        this.cpds = new ComboPooledDataSource();
        this.cpds.setDriverClass("net.snowflake.client.jdbc.SnowflakeDriver");
        this.cpds.setJdbcUrl(this.connectStr);
        this.cpds.setProperties(connectionProperties);
    }

    @Test
    public void testC3P0ConnectionPool() throws Exception {
        this.setUpC3P0Connection();
        for (int i = 0; i < 10; ++i) {
            Thread t = new Thread(new queryUsingPool(this.cpds));
            t.join();
        }
    }

    @Test
    public void testHikariConnectionPool() throws Exception {
        HikariDataSource ds = this.initHikariDataSource();
        for (int i = 0; i < 10; ++i) {
            Thread t = new Thread(new queryUsingPool(ds));
            t.join();
        }
    }

    private HikariDataSource initHikariDataSource() throws SQLException {
        HikariConfig config = new HikariConfig();
        config.setDriverClassName("net.snowflake.client.jdbc.SnowflakeDriver");
        config.setDataSourceProperties(this.setUpConnectionProperty());
        config.setJdbcUrl(this.connectStr);
        return new HikariDataSource(config);
    }

    private Properties setUpConnectionProperty() {
        Properties properties = new Properties();
        properties.put("user", this.user);
        properties.put("password", this.password);
        properties.put("account", this.account);
        properties.put("db", this.database);
        properties.put("schema", this.schema);
        properties.put("ssl", this.ssl);
        return properties;
    }

    private static class queryUsingPool
    implements Runnable {
        ComboPooledDataSource cpds = null;
        BasicDataSource bds = null;
        PoolingDataSource pds = null;
        HikariDataSource hds = null;

        queryUsingPool(ComboPooledDataSource cpds) {
            this.cpds = cpds;
        }

        queryUsingPool(BasicDataSource bds) {
            this.bds = bds;
        }

        queryUsingPool(PoolingDataSource pds) {
            this.pds = pds;
        }

        queryUsingPool(HikariDataSource hds) {
            this.hds = hds;
        }

        @Override
        public void run() {
            Connection con = null;
            try {
                if (this.cpds != null) {
                    con = this.cpds.getConnection();
                } else if (this.bds != null) {
                    con = this.bds.getConnection();
                } else if (this.pds != null) {
                    con = this.pds.getConnection();
                } else if (this.hds != null) {
                    con = this.hds.getConnection();
                }
                try (Statement st = con.createStatement();
                     ResultSet resultSet = st.executeQuery("SELECT * FROM test_pooling");){
                    while (resultSet.next()) {
                        Assertions.assertEquals((Object)"test_str", (Object)resultSet.getString(1));
                    }
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }
}

