/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.File;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpProtocol;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeDriverIT;
import net.snowflake.client.jdbc.SnowflakeUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="others")
public class CustomProxyLatestIT {
    @TempDir
    private File tmpFolder;

    @Test
    @Disabled
    public void test2ProxiesWithSameJVM() throws SQLException {
        ResultSet rs;
        Statement stmt;
        Properties props = new Properties();
        props.put("user", "USER");
        props.put("password", "PASSWORD");
        props.put("useProxy", (Object)true);
        props.put("proxyHost", "localhost");
        props.put("proxyPort", "8080");
        try (Connection con1 = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);){
            stmt = con1.createStatement();
            try {
                rs = stmt.executeQuery("select 1");
                try {
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((int)1, (int)rs.getInt(1));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        props.put("proxyPort", "8081");
        try (Connection con2 = DriverManager.getConnection("jdbc:snowflake://aztestaccount.east-us-2.azure.snowflakecomputing.com", props);
             Statement statement = con2.createStatement();){
            rs = statement.executeQuery("select 2");
            try {
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)2, (int)rs.getInt(1));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        props.put("proxyPort", "8080");
        try (Connection con3 = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);){
            stmt = con3.createStatement();
            try {
                rs = stmt.executeQuery("select 1");
                try {
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((int)1, (int)rs.getInt(1));
                    Assertions.assertEquals((int)2, (int)HttpUtil.httpClient.size());
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    @Test
    @Disabled
    public void testTLSIssue() throws SQLException {
        ResultSet rs;
        Statement stmt;
        Properties props = new Properties();
        props.put("user", "USER");
        props.put("password", "PASSWORD");
        props.put("tracing", "ALL");
        props.put("useProxy", (Object)true);
        props.put("proxyHost", "localhost");
        props.put("proxyPort", "3128");
        props.put("proxyProtocol", "https");
        try (Connection con = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);){
            stmt = con.createStatement();
            try {
                rs = stmt.executeQuery("select 1");
                try {
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((int)1, (int)rs.getInt(1));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        props.put("useProxy", (Object)false);
        System.setProperty("http.useProxy", "true");
        System.setProperty("http.proxyHost", "localhost");
        System.setProperty("http.proxyPort", "3128");
        con = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
        try {
            stmt = con.createStatement();
            try {
                rs = stmt.executeQuery("select 1");
                try {
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((int)1, (int)rs.getInt(1));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
    }

    @Test
    @Disabled
    public void testJVMParamsWithNonProxyHostsHonored() throws SQLException {
        Properties props = new Properties();
        props.put("user", "USER");
        props.put("password", "PASSWORD");
        props.put("tracing", "ALL");
        System.setProperty("http.useProxy", "true");
        System.setProperty("https.proxyHost", "localhost");
        System.setProperty("https.proxyPort", "3128");
        System.setProperty("http.nonProxyHosts", "*");
        try (Connection con = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
             Statement stmt = con.createStatement();
             ResultSet rs = stmt.executeQuery("select 1");){
            Assertions.assertTrue((boolean)rs.next());
            Assertions.assertEquals((int)1, (int)rs.getInt(1));
        }
    }

    @Test
    @Disabled
    public void testTLSIssueWithConnectionStringAgainstS3() throws ClassNotFoundException, SQLException {
        String connectionUrl = "jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=3128&useProxy=true&proxyProtocol=https";
        this.runProxyConnection(connectionUrl);
    }

    @Test
    @Disabled
    public void testNonProxyHostAltering() throws SQLException {
        ResultSet rs;
        Properties props = new Properties();
        props.put("user", "USER");
        props.put("password", "PASSWORD");
        props.put("useProxy", (Object)true);
        props.put("proxyHost", "localhost");
        props.put("proxyPort", "8080");
        props.put("nonProxyHosts", "*.snowflakecomputing.com");
        try (Connection con = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
             Statement stmt = con.createStatement();){
            rs = stmt.executeQuery("select 1");
            try {
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)1, (int)rs.getInt(1));
                HttpUtil.httpClient.entrySet().forEach(entry -> Assertions.assertEquals((Object)".foo.com|.baz.com", (Object)((HttpClientSettingsKey)entry.getKey()).getNonProxyHosts()));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        props.put("nonProxyHosts", "*.snowflakecomputing.com");
        con = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
        try (Statement statement = con.createStatement();){
            rs = statement.executeQuery("select 2");
            try {
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)2, (int)rs.getInt(1));
                Assertions.assertEquals((int)1, (int)HttpUtil.httpClient.size());
                HttpUtil.httpClient.entrySet().forEach(entry -> Assertions.assertEquals((Object)"*.snowflakecomputing.com", (Object)((HttpClientSettingsKey)entry.getKey()).getNonProxyHosts()));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
    }

    @Test
    @Disabled
    public void testSizeOfHttpClientNoProxies() throws SQLException {
        Properties props = new Properties();
        props.put("user", "USER");
        props.put("password", "PASSWORD");
        try (Connection con = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
             Statement stmt = con.createStatement();
             ResultSet rs = stmt.executeQuery("select 1");){
            Assertions.assertTrue((boolean)rs.next());
            Assertions.assertEquals((int)1, (int)rs.getInt(1));
        }
        props.put("useProxy", (Object)false);
        props.put("proxyHost", "localhost");
        props.put("proxyPort", "8080");
        con = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
        try {
            Assertions.assertEquals((int)1, (int)HttpUtil.httpClient.size());
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
        props.put("ocspFailOpen", "false");
        con = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);
        try {
            Assertions.assertEquals((int)2, (int)HttpUtil.httpClient.size());
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
    }

    @Test
    @Disabled
    public void testCorrectProxySettingFromConnectionString() throws ClassNotFoundException, SQLException {
        String connectionUrl = "jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=8080&useProxy=true";
        this.runProxyConnection(connectionUrl);
        connectionUrl = "jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=8080&proxyUser=testuser1&proxyPassword=test&useProxy=true";
        this.runProxyConnection(connectionUrl);
    }

    @Test
    @Disabled
    public void testWrongProxyPortSettingFromConnectionString() throws ClassNotFoundException, SQLException {
        String connectionUrl = "jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=31281&proxyUser=testuser1&proxyPassword=test&nonProxyHosts=*.foo.com|localhost&useProxy=true";
        this.runProxyConnection(connectionUrl);
    }

    @Test
    @Disabled
    public void testWrongProxyPasswordSettingFromConnectionString() throws ClassNotFoundException, SQLException {
        String connectionUrl = "jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=3128&proxyUser=testuser2&proxyPassword=test111&nonProxyHosts=*.foo.com|localhost&useProxy=true";
        try {
            this.runProxyConnection(connectionUrl);
        }
        catch (SQLException e) {
            MatcherAssert.assertThat((String)"JDBC driver encountered communication error", (Object)e.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
        }
    }

    @Test
    @Disabled
    public void testInvalidProxyPortFromConnectionString() throws ClassNotFoundException, SQLException {
        String connectionUrl = "jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyUser=testuser1&proxyPassword=test&nonProxyHosts=*.foo.com|localhost&useProxy=true";
        try {
            this.runProxyConnection(connectionUrl);
        }
        catch (SQLException e) {
            MatcherAssert.assertThat((String)"invalid proxy error", (Object)e.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.INVALID_PROXY_PROPERTIES.getMessageCode()));
        }
    }

    @Test
    @Disabled
    public void testNonProxyHostsFromConnectionString() throws ClassNotFoundException, SQLException {
        String connectionUrl = "jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=31281&proxyUser=testuser1&proxyPassword=test&nonProxyHosts=*.snowflakecomputing.com|localhost&useProxy=true";
        this.runProxyConnection(connectionUrl);
    }

    @Test
    @Disabled
    public void testWrongNonProxyHostsFromConnectionString() throws ClassNotFoundException, SQLException {
        String connectionUrl = "jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=31281&proxyUser=testuser1&proxyPassword=test&nonProxyHosts=*.foo.com|localhost&useProxy=true";
        this.runProxyConnection(connectionUrl);
    }

    @Test
    @Disabled
    public void testUnsetJvmPropertiesForInvalidSettings() throws SQLException {
        Properties props = new Properties();
        props.put("user", "USER");
        props.put("password", "PASSWORD");
        props.put("tracing", "ALL");
        System.setProperty("proxyHost", "localhost");
        System.setProperty("proxyPort", "3128");
        try (Connection con = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);){
            Assertions.assertEquals((Object)System.getProperty("proxyHost"), null);
            Assertions.assertEquals((Object)System.getProperty("proxyPort"), null);
        }
    }

    public void runProxyConnection(String connectionUrl) throws ClassNotFoundException, SQLException {
        Authenticator.setDefault(new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                System.out.println("RequestorType: " + (Object)((Object)this.getRequestorType()));
                System.out.println("Protocol: " + this.getRequestingProtocol().toLowerCase());
                return new PasswordAuthentication(SnowflakeUtil.systemGetProperty((String)"http.proxyUser"), SnowflakeUtil.systemGetProperty((String)"http.proxyPassword").toCharArray());
            }
        });
        System.setProperty("http.useProxy", "true");
        System.setProperty("https.proxyHost", "localhost");
        System.setProperty("https.proxyPort", "3128");
        String user = "USER";
        String passwd = "PASSWORD";
        Properties _connectionProperties = new Properties();
        _connectionProperties.put("user", user);
        _connectionProperties.put("password", passwd);
        _connectionProperties.put("role", "accountadmin");
        _connectionProperties.put("database", "SNOWHOUSE_IMPORT");
        _connectionProperties.put("schema", "DEV");
        Class.forName("net.snowflake.client.jdbc.SnowflakeDriver");
        long counter = 0L;
        try (Connection con = DriverManager.getConnection(connectionUrl, _connectionProperties);
             Statement stmt = con.createStatement();){
            stmt.execute("use warehouse TINY_WAREHOUSE");
            stmt.execute("CREATE OR REPLACE STAGE testPutGet_stage");
            Assertions.assertTrue((boolean)stmt.execute("PUT file://" + AbstractDriverIT.getFullPathFileInResource("orders_100.csv") + " @testPutGet_stage"), (String)"Failed to put a file");
            String sql = "select $1 from values(1),(3),(5),(7)";
            try (ResultSet res = stmt.executeQuery(sql);){
                while (res.next()) {
                    System.out.println("value: " + res.getInt(1));
                }
                System.out.println("OK - " + counter);
            }
        }
        ++counter;
    }

    @Test
    @Disabled
    public void testProxyConnectionWithAzure() throws ClassNotFoundException, SQLException {
        String connectionUrl = "jdbc:snowflake://aztestaccount.east-us-2.azure.snowflakecomputing.com/?tracing=ALL";
        this.runAzureProxyConnection(connectionUrl, true, true);
    }

    @Test
    @Disabled
    public void testProxyConnectionWithAzureWithConnectionString() throws ClassNotFoundException, SQLException {
        String connectionUrl = "jdbc:snowflake://aztestaccount.east-us-2.azure.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=8080&proxyUser=testuser1&proxyPassword=test&useProxy=true";
        this.runAzureProxyConnection(connectionUrl, false, true);
    }

    @ParameterizedTest
    @ValueSource(strings={"jdbc:snowflake://aztestaccount.east-us-2.azure.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=&proxyUser=testuser1&proxyPassword=test&useProxy=true", "jdbc:snowflake://aztestaccount.east-us-2.azure.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=cheese&proxyUser=testuser1&proxyPassword=test&useProxy=true", "jdbc:snowflake://aztestaccount.east-us-2.azure.snowflakecomputing.com/?tracing=ALL&proxyHost=&proxyPort=3128&proxyUser=testuser1&proxyPassword=test&useProxy=true", "jdbc:snowflake://aztestaccount.east-us-2.azure.snowflakecomputing.com/?tracing=ALL&proxyUser=testuser1&proxyPassword=test&useProxy=true"})
    @Disabled
    public void testProxyConnectionWithoutProxyPortOrHost(String connectionUrl) {
        SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> this.runAzureProxyConnection(connectionUrl, false, true));
        Assertions.assertEquals((Object)"08000", (Object)e.getSQLState());
    }

    @Test
    @Disabled
    public void testProxyConnectionWithJVMParameters() throws SQLException, ClassNotFoundException {
        String connectionUrl = "jdbc:snowflake://aztestaccount.east-us-2.azure.snowflakecomputing.com/?tracing=ALL";
        System.setProperty("http.useProxy", "true");
        System.setProperty("http.proxyHost", "localhost");
        System.setProperty("http.proxyPort", "8080");
        System.setProperty("http.nonProxyHosts", "*.snowflakecomputing.com");
        SnowflakeUtil.systemSetEnv((String)"NO_PROXY", (String)"*.google.com");
        this.runAzureProxyConnection(connectionUrl, false, false);
        SnowflakeUtil.systemUnsetEnv((String)"NO_PROXY");
    }

    @Test
    @Disabled
    public void testProxyConnectionWithAzureWithWrongConnectionString() throws ClassNotFoundException {
        String connectionUrl = "jdbc:snowflake://aztestaccount.east-us-2.azure.snowflakecomputing.com/?tracing=ALL&proxyHost=localhost&proxyPort=31281&proxyUser=testuser1&proxyPassword=test&nonProxyHosts=*.foo.com%7Clocalhost&useProxy=true";
        try {
            this.runAzureProxyConnection(connectionUrl, false, true);
        }
        catch (SQLException e) {
            MatcherAssert.assertThat((String)"JDBC driver encountered communication error", (Object)e.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.NETWORK_ERROR.getMessageCode()));
        }
    }

    @Test
    @Disabled
    public void testSetJVMProxyHttp() throws SQLException {
        Properties props = new Properties();
        props.put("user", "USER");
        props.put("password", "PASSWORD");
        System.setProperty("http.useProxy", "true");
        System.setProperty("http.proxyHost", "localhost");
        System.setProperty("http.proxyPort", "3128");
        System.setProperty("http.nonProxyHosts", "*");
        System.setProperty("http.proxyProtocol", "http");
        try (Connection con = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);){
            SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
            HttpClientSettingsKey clientSettingsKey = sfSession.getHttpClientKey();
            Assertions.assertEquals((Object)HttpProtocol.HTTP, (Object)clientSettingsKey.getProxyHttpProtocol());
        }
    }

    @Test
    @Disabled
    public void testSetJVMProxyHttps() throws SQLException {
        Properties props = new Properties();
        props.put("user", "USER");
        props.put("password", "PASSWORD");
        System.setProperty("http.useProxy", "true");
        System.setProperty("https.proxyHost", "localhost");
        System.setProperty("https.proxyPort", "3128");
        System.setProperty("http.nonProxyHosts", "*");
        System.setProperty("http.proxyProtocol", "https");
        try (Connection con = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);){
            SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
            HttpClientSettingsKey clientSettingsKey = sfSession.getHttpClientKey();
            Assertions.assertEquals((Object)HttpProtocol.HTTPS, (Object)clientSettingsKey.getProxyHttpProtocol());
        }
    }

    @Test
    @Disabled
    public void testSetJVMProxyDefaultHttps() throws SQLException {
        Properties props = new Properties();
        props.put("user", "USER");
        props.put("password", "PASSWORD");
        System.setProperty("http.useProxy", "true");
        System.setProperty("https.proxyHost", "localhost");
        System.setProperty("https.proxyPort", "3128");
        System.setProperty("http.nonProxyHosts", "*");
        try (Connection con = DriverManager.getConnection("jdbc:snowflake://s3testaccount.us-east-1.snowflakecomputing.com", props);){
            SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
            HttpClientSettingsKey clientSettingsKey = sfSession.getHttpClientKey();
            Assertions.assertEquals((Object)HttpProtocol.HTTPS, (Object)clientSettingsKey.getProxyHttpProtocol());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAzureProxyConnection(String connectionUrl, boolean usesProperties, boolean usesIncorrectJVMProperties) throws ClassNotFoundException, SQLException {
        block19: {
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    System.out.println("RequestorType: " + (Object)((Object)this.getRequestorType()));
                    System.out.println("Protocol: " + this.getRequestingProtocol().toLowerCase());
                    return new PasswordAuthentication(SnowflakeUtil.systemGetProperty((String)"http.proxyUser"), SnowflakeUtil.systemGetProperty((String)"http.proxyPassword").toCharArray());
                }
            });
            if (usesIncorrectJVMProperties) {
                System.setProperty("http.useProxy", "true");
                System.setProperty("http.proxyHost", "fakehost");
                System.setProperty("http.proxyPort", "8081");
                System.setProperty("https.proxyHost", "fakehost");
                System.setProperty("https.proxyPort", "8081");
            }
            String user = "USER";
            String passwd = "PASSWORD";
            Properties _connectionProperties = new Properties();
            _connectionProperties.put("user", user);
            _connectionProperties.put("password", passwd);
            _connectionProperties.put("role", "SYSADMIN");
            _connectionProperties.put("tracing", "ALL");
            if (usesProperties) {
                _connectionProperties.put("useProxy", (Object)true);
                _connectionProperties.put("proxyHost", "localhost");
                _connectionProperties.put("proxyPort", "8080");
                _connectionProperties.put("proxyUser", "testuser1");
                _connectionProperties.put("proxyPassword", "test");
            }
            Class.forName("net.snowflake.client.jdbc.SnowflakeDriver");
            String fileName = "test_copy.csv";
            try (Connection con = DriverManager.getConnection(connectionUrl, _connectionProperties);
                 Statement stmt = con.createStatement();){
                try {
                    stmt.execute("create or replace warehouse MEGTEST");
                    stmt.execute("use database MEGDB");
                    stmt.execute("use schema MEGSCHEMA");
                    stmt.execute("CREATE OR REPLACE STAGE testPutGet_stage");
                    String TEST_DATA_FILE = "orders_100.csv";
                    String sourceFilePath = AbstractDriverIT.getFullPathFileInResource(TEST_DATA_FILE);
                    File destFolder = new File(this.tmpFolder, "dest");
                    destFolder.mkdirs();
                    String destFolderCanonicalPath = destFolder.getCanonicalPath();
                    String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
                    Assertions.assertTrue((boolean)stmt.execute("PUT file://" + sourceFilePath + " @testPutGet_stage"), (String)"Failed to put a file");
                    SnowflakeDriverIT.findFile(stmt, "ls @testPutGet_stage/");
                    Assertions.assertTrue((boolean)stmt.execute("GET @testPutGet_stage 'file://" + destFolderCanonicalPath + "' parallel=8"), (String)"Failed to get a file");
                    File downloaded = new File(destFolderCanonicalPathWithSeparator + TEST_DATA_FILE + ".gz");
                    Assertions.assertTrue((boolean)downloaded.exists());
                    Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + TEST_DATA_FILE + ".gz");
                    p.waitFor();
                    File original = new File(sourceFilePath);
                    File unzipped = new File(destFolderCanonicalPathWithSeparator + TEST_DATA_FILE);
                    Assertions.assertEquals((long)original.length(), (long)unzipped.length());
                }
                catch (Throwable t) {
                    try {
                        t.printStackTrace();
                        break block19;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        stmt.execute("DROP STAGE IF EXISTS testGetPut_stage");
                    }
                }
                stmt.execute("DROP STAGE IF EXISTS testGetPut_stage");
            }
        }
    }
}

