/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import net.snowflake.client.TestUtil;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.jdbc.BaseJDBCWithSharedConnectionIT;
import net.snowflake.client.jdbc.DBMetadataResultSetMetadata;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeDatabaseMetaData;
import net.snowflake.client.jdbc.SnowflakeType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="others")
public class DatabaseMetaDataIT
extends BaseJDBCWithSharedConnectionIT {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)(?:\\.\\d+)+\\s*.*");
    private static final String PI_PROCEDURE = "create or replace procedure GETPI()\n    returns float not null\n    language javascript\n    as\n    $$\n    return 3.1415926;\n    $$\n    ;";
    private static final String STPROC1_PROCEDURE = "create or replace procedure stproc1(param1 float, param2 string)\n    returns table(retval varchar)\n    language javascript\n    as\n    $$\n    var sql_command = \"Hello, world!\"\n    $$\n    ;";
    public static final int EXPECTED_MAX_CHAR_LENGTH = 0x1000000;
    public static final int EXPECTED_MAX_BINARY_LENGTH = 0x800000;

    @Test
    public void testGetConnection() throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        Assertions.assertEquals((Object)connection, (Object)metaData.getConnection());
    }

    @Test
    public void testDatabaseAndDriverInfo() throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        Assertions.assertEquals((Object)"Snowflake", (Object)metaData.getDatabaseProductName());
        Assertions.assertEquals((Object)"Snowflake", (Object)metaData.getDriverName());
        String driverVersion = metaData.getDriverVersion();
        java.util.regex.Matcher m = VERSION_PATTERN.matcher(driverVersion);
        Assertions.assertTrue((boolean)m.matches());
        int majorVersion = metaData.getDriverMajorVersion();
        int minorVersion = metaData.getDriverMinorVersion();
        Assertions.assertEquals((Object)m.group(1), (Object)String.valueOf(majorVersion));
        Assertions.assertEquals((Object)m.group(2), (Object)String.valueOf(minorVersion));
    }

    @Test
    public void testGetCatalogs() throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        Assertions.assertEquals((Object)".", (Object)metaData.getCatalogSeparator());
        Assertions.assertEquals((Object)"database", (Object)metaData.getCatalogTerm());
        ResultSet resultSet = metaData.getCatalogs();
        DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_CATALOGS);
        Assertions.assertTrue((boolean)resultSet.isBeforeFirst());
        int cnt = 0;
        HashSet<String> allVisibleDatabases = new HashSet<String>();
        while (resultSet.next()) {
            allVisibleDatabases.add(resultSet.getString(1));
            if (cnt == 0) {
                Assertions.assertTrue((boolean)resultSet.isFirst());
            }
            ++cnt;
            Assertions.assertThrows(SQLFeatureNotSupportedException.class, resultSet::isLast);
            Assertions.assertThrows(SQLFeatureNotSupportedException.class, resultSet::isAfterLast);
        }
        MatcherAssert.assertThat((Object)cnt, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        SQLException ex = (SQLException)Assertions.assertThrows(SQLException.class, resultSet::isAfterLast);
        Assertions.assertEquals((int)ErrorCode.RESULTSET_ALREADY_CLOSED.getMessageCode(), (int)ex.getErrorCode());
        resultSet.close();
        resultSet.next();
        List<String> allAccessibleDatabases = this.getInfoBySQL("select database_name from information_schema.databases");
        Assertions.assertTrue((boolean)allVisibleDatabases.containsAll(allAccessibleDatabases));
    }

    @Test
    public void testGetSchemas() throws Throwable {
        DatabaseMetaData metaData = connection.getMetaData();
        String currentSchema = connection.getSchema();
        Assertions.assertEquals((Object)"schema", (Object)metaData.getSchemaTerm());
        HashSet<String> schemas = new HashSet<String>();
        try (ResultSet resultSet = metaData.getSchemas();){
            DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_SCHEMAS);
            while (resultSet.next()) {
                String schema = resultSet.getString(1);
                if (!currentSchema.equals(schema) && TestUtil.isSchemaGeneratedInTests(schema)) continue;
                schemas.add(schema);
            }
        }
        MatcherAssert.assertThat((Object)schemas.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        HashSet<String> schemasInDb = new HashSet<String>();
        try (ResultSet resultSet = metaData.getSchemas(connection.getCatalog(), "%");){
            while (resultSet.next()) {
                String schema = resultSet.getString(1);
                if (!currentSchema.equals(schema) && TestUtil.isSchemaGeneratedInTests(schema)) continue;
                schemasInDb.add(schema);
            }
        }
        MatcherAssert.assertThat((Object)schemasInDb.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        MatcherAssert.assertThat((Object)schemas.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(schemasInDb.size())));
        schemasInDb.forEach(schemaInDb -> MatcherAssert.assertThat((Object)schemas, (Matcher)Matchers.hasItem((Object)schemaInDb)));
        Assertions.assertTrue((boolean)schemas.contains(currentSchema));
        Assertions.assertTrue((boolean)schemasInDb.contains(currentSchema));
        try (Connection connection = DatabaseMetaDataIT.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("alter SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=true");
            DatabaseMetaData metaData2 = connection.getMetaData();
            Assertions.assertEquals((Object)"schema", (Object)metaData2.getSchemaTerm());
            try (ResultSet resultSet = metaData2.getSchemas();){
                HashSet<String> schemas2 = new HashSet<String>();
                while (resultSet.next()) {
                    schemas2.add(resultSet.getString(1));
                }
                MatcherAssert.assertThat((Object)schemas2.size(), (Matcher)Matchers.equalTo((Object)1));
            }
        }
    }

    @Test
    public void testGetTableTypes() throws Throwable {
        DatabaseMetaData metaData = connection.getMetaData();
        try (ResultSet resultSet = metaData.getTableTypes();){
            HashSet<String> types = new HashSet<String>();
            while (resultSet.next()) {
                types.add(resultSet.getString(1));
            }
            Assertions.assertEquals((int)2, (int)types.size());
            Assertions.assertTrue((boolean)types.contains("TABLE"));
            Assertions.assertTrue((boolean)types.contains("VIEW"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testGetTables() throws Throwable {
        HashSet<String> tables = null;
        try (Statement statement = connection.createStatement();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            String targetTable = "T0";
            String targetView = "V0";
            try {
                statement.execute("create or replace table T0(C1 int)");
                statement.execute("create or replace view V0 as select 1 as C");
                DatabaseMetaData metaData = connection.getMetaData();
                try (ResultSet resultSet = metaData.getTables(database, schema, "%", new String[]{"TABLE"});){
                    DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_TABLES);
                    tables = new HashSet<String>();
                    while (resultSet.next()) {
                        tables.add(resultSet.getString(3));
                    }
                    Assertions.assertTrue((boolean)tables.contains("T0"));
                }
                resultSet = metaData.getTables(database, schema, "T0", new String[]{"TABLE"});
                try {
                    tables = new HashSet();
                    while (resultSet.next()) {
                        tables.add(resultSet.getString(3));
                    }
                    Assertions.assertEquals((Object)"T0", tables.iterator().next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metaData.getTables(database, schema, "%", new String[]{"VIEW"});
                try {
                    HashSet<String> views = new HashSet<String>();
                    while (resultSet.next()) {
                        views.add(resultSet.getString(3));
                    }
                    Assertions.assertTrue((boolean)views.contains("V0"));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metaData.getTablePrivileges(database, schema, "T0");
                try {
                    Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists T0");
                statement.execute("drop view if exists V0");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetPrimarykeys() throws Throwable {
        try (Statement statement = connection.createStatement();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            String targetTable = "T0";
            try {
                statement.execute("create or replace table T0(C1 int primary key, C2 string)");
                DatabaseMetaData metaData = connection.getMetaData();
                try (ResultSet resultSet = metaData.getPrimaryKeys(database, schema, "T0");){
                    DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_PRIMARY_KEYS);
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T0", (Object)resultSet.getString("TABLE_NAME"));
                    Assertions.assertEquals((Object)"C1", (Object)resultSet.getString("COLUMN_NAME"));
                    Assertions.assertEquals((int)1, (int)resultSet.getInt("KEY_SEQ"));
                    Assertions.assertNotEquals((Object)"", (Object)resultSet.getString("PK_NAME"));
                }
            }
            finally {
                statement.execute("drop table if exists T0");
            }
        }
    }

    static void verifyResultSetMetaDataColumns(ResultSet resultSet, DBMetadataResultSetMetadata metadata) throws SQLException {
        int numCol = metadata.getColumnNames().size();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Assertions.assertEquals((int)numCol, (int)resultSetMetaData.getColumnCount());
        for (int col = 1; col <= numCol; ++col) {
            List colNames = metadata.getColumnNames();
            List colTypeNames = metadata.getColumnTypeNames();
            List colTypes = metadata.getColumnTypes();
            Assertions.assertEquals((Object)"", (Object)resultSetMetaData.getCatalogName(col));
            Assertions.assertEquals((Object)"", (Object)resultSetMetaData.getSchemaName(col));
            Assertions.assertEquals((Object)"T", (Object)resultSetMetaData.getTableName(col));
            Assertions.assertEquals(colNames.get(col - 1), (Object)resultSetMetaData.getColumnName(col));
            Assertions.assertEquals(colNames.get(col - 1), (Object)resultSetMetaData.getColumnLabel(col));
            Assertions.assertEquals((Object)SnowflakeType.javaTypeToClassName((int)resultSetMetaData.getColumnType(col)), (Object)resultSetMetaData.getColumnClassName(col));
            Assertions.assertEquals((int)25, (int)resultSetMetaData.getColumnDisplaySize(col));
            Assertions.assertEquals((int)((Integer)colTypes.get(col - 1)), (int)resultSetMetaData.getColumnType(col));
            Assertions.assertEquals(colTypeNames.get(col - 1), (Object)resultSetMetaData.getColumnTypeName(col));
            Assertions.assertEquals((int)9, (int)resultSetMetaData.getPrecision(col));
            Assertions.assertEquals((int)9, (int)resultSetMetaData.getScale(col));
            Assertions.assertEquals((Object)SnowflakeType.isJavaTypeSigned((int)resultSetMetaData.getColumnType(col)), (Object)resultSetMetaData.isSigned(col));
            Assertions.assertFalse((boolean)resultSetMetaData.isAutoIncrement(col));
            Assertions.assertFalse((boolean)resultSetMetaData.isCurrency(col));
            Assertions.assertTrue((boolean)resultSetMetaData.isReadOnly(col));
            Assertions.assertTrue((boolean)resultSetMetaData.isSearchable(col));
            Assertions.assertFalse((boolean)resultSetMetaData.isWritable(col));
            Assertions.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(col));
            Assertions.assertEquals((int)2, (int)resultSetMetaData.isNullable(col));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetImportedKeys() throws Throwable {
        try (Statement statement = connection.createStatement();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            String targetTable1 = "T0";
            String targetTable2 = "T1";
            try {
                statement.execute("create or replace table T0(C1 int primary key, C2 string)");
                statement.execute("create or replace table T1(C1 int primary key, C2 string, C3 int references T0)");
                DatabaseMetaData metaData = connection.getMetaData();
                try (ResultSet resultSet = metaData.getImportedKeys(database, schema, "T1");){
                    DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_FOREIGN_KEYS);
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("PKTABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("PKTABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T0", (Object)resultSet.getString("PKTABLE_NAME"));
                    Assertions.assertEquals((Object)"C1", (Object)resultSet.getString("PKCOLUMN_NAME"));
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("FKTABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("FKTABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T1", (Object)resultSet.getString("FKTABLE_NAME"));
                    Assertions.assertEquals((Object)"C3", (Object)resultSet.getString("FKCOLUMN_NAME"));
                    Assertions.assertEquals((int)1, (int)resultSet.getInt("KEY_SEQ"));
                    Assertions.assertNotEquals((Object)"", (Object)resultSet.getString("PK_NAME"));
                    Assertions.assertNotEquals((Object)"", (Object)resultSet.getString("FK_NAME"));
                    Assertions.assertEquals((int)3, (int)resultSet.getShort("UPDATE_RULE"));
                    Assertions.assertEquals((int)3, (int)resultSet.getShort("DELETE_RULE"));
                    Assertions.assertEquals((int)7, (int)resultSet.getShort("DEFERRABILITY"));
                }
            }
            finally {
                statement.execute("drop table if exists T0");
                statement.execute("drop table if exists T1");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetExportedKeys() throws Throwable {
        try (Statement statement = connection.createStatement();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            String targetTable1 = "T0";
            String targetTable2 = "T1";
            try {
                statement.execute("create or replace table T0(C1 int primary key, C2 string)");
                statement.execute("create or replace table T1(C1 int primary key, C2 string, C3 int references T0)");
                DatabaseMetaData metaData = connection.getMetaData();
                try (ResultSet resultSet = metaData.getExportedKeys(database, schema, "T0");){
                    DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_FOREIGN_KEYS);
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("PKTABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("PKTABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T0", (Object)resultSet.getString("PKTABLE_NAME"));
                    Assertions.assertEquals((Object)"C1", (Object)resultSet.getString("PKCOLUMN_NAME"));
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("FKTABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("FKTABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T1", (Object)resultSet.getString("FKTABLE_NAME"));
                    Assertions.assertEquals((Object)"C3", (Object)resultSet.getString("FKCOLUMN_NAME"));
                    Assertions.assertEquals((int)1, (int)resultSet.getInt("KEY_SEQ"));
                    Assertions.assertNotEquals((Object)"", (Object)resultSet.getString("PK_NAME"));
                    Assertions.assertNotEquals((Object)"", (Object)resultSet.getString("FK_NAME"));
                    Assertions.assertEquals((int)3, (int)resultSet.getShort("UPDATE_RULE"));
                    Assertions.assertEquals((int)3, (int)resultSet.getShort("DELETE_RULE"));
                    Assertions.assertEquals((int)7, (int)resultSet.getShort("DEFERRABILITY"));
                }
            }
            finally {
                statement.execute("drop table if exists T0");
                statement.execute("drop table if exists T1");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCrossReferences() throws Throwable {
        try (Statement statement = connection.createStatement();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            String targetTable1 = "T0";
            String targetTable2 = "T1";
            try {
                statement.execute("create or replace table T0(C1 int primary key, C2 string)");
                statement.execute("create or replace table T1(C1 int primary key, C2 string, C3 int references T0)");
                DatabaseMetaData metaData = connection.getMetaData();
                try (ResultSet resultSet = metaData.getCrossReference(database, schema, "T0", database, schema, "T1");){
                    DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_FOREIGN_KEYS);
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("PKTABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("PKTABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T0", (Object)resultSet.getString("PKTABLE_NAME"));
                    Assertions.assertEquals((Object)"C1", (Object)resultSet.getString("PKCOLUMN_NAME"));
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("FKTABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("FKTABLE_SCHEM"));
                    Assertions.assertEquals((Object)"T1", (Object)resultSet.getString("FKTABLE_NAME"));
                    Assertions.assertEquals((Object)"C3", (Object)resultSet.getString("FKCOLUMN_NAME"));
                    Assertions.assertEquals((int)1, (int)resultSet.getInt("KEY_SEQ"));
                    Assertions.assertNotEquals((Object)"", (Object)resultSet.getString("PK_NAME"));
                    Assertions.assertNotEquals((Object)"", (Object)resultSet.getString("FK_NAME"));
                    Assertions.assertEquals((int)3, (int)resultSet.getShort("UPDATE_RULE"));
                    Assertions.assertEquals((int)3, (int)resultSet.getShort("DELETE_RULE"));
                    Assertions.assertEquals((int)7, (int)resultSet.getShort("DEFERRABILITY"));
                }
            }
            finally {
                statement.execute("drop table if exists T0");
                statement.execute("drop table if exists T1");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetObjectsDoesNotExists() throws Throwable {
        try (Statement statement = connection.createStatement();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            String targetTable = "T0";
            String targetView = "V0";
            try {
                statement.execute("create or replace table T0(C1 int)");
                statement.execute("create or replace view V0 as select 1 as C");
                DatabaseMetaData metaData = connection.getMetaData();
                try (ResultSet resultSet = metaData.getTables(database, schema, "%", null);){
                    Assertions.assertTrue((this.getSizeOfResultSet(resultSet) > 0 ? 1 : 0) != 0);
                }
                resultSet = metaData.getTables(database, schema, "%", new String[]{"INVALID_TYPE"});
                try {
                    Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(resultSet));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metaData.getSchemas("DB_NOT_EXIST", "SCHEMA_NOT_EXIST");
                try {
                    Assertions.assertFalse((boolean)resultSet.next());
                    Assertions.assertTrue((boolean)resultSet.isClosed());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metaData.getTables("DB_NOT_EXIST", "SCHEMA_NOT_EXIST", "%", null);
                try {
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metaData.getTables(database, "SCHEMA\\_NOT\\_EXIST", "%", null);
                try {
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metaData.getColumns("DB_NOT_EXIST", "SCHEMA_NOT_EXIST", "%", "%");
                try {
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metaData.getColumns(database, "SCHEMA\\_NOT\\_EXIST", "%", "%");
                try {
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metaData.getColumns(database, schema, "TBL\\_NOT\\_EXIST", "%");
                try {
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists T0");
                statement.execute("drop view if exists V0");
            }
        }
    }

    @Test
    public void testTypeInfo() throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet resultSet = metaData.getTypeInfo();
        resultSet.next();
        Assertions.assertEquals((Object)"NUMBER", (Object)resultSet.getString(1));
        resultSet.next();
        Assertions.assertEquals((Object)"INTEGER", (Object)resultSet.getString(1));
        resultSet.next();
        Assertions.assertEquals((Object)"DOUBLE", (Object)resultSet.getString(1));
        resultSet.next();
        Assertions.assertEquals((Object)"VARCHAR", (Object)resultSet.getString(1));
        resultSet.next();
        Assertions.assertEquals((Object)"DATE", (Object)resultSet.getString(1));
        resultSet.next();
        Assertions.assertEquals((Object)"TIME", (Object)resultSet.getString(1));
        resultSet.next();
        Assertions.assertEquals((Object)"TIMESTAMP", (Object)resultSet.getString(1));
        resultSet.next();
        Assertions.assertEquals((Object)"BOOLEAN", (Object)resultSet.getString(1));
        Assertions.assertFalse((boolean)resultSet.next());
    }

    @Test
    public void testProcedure() throws Throwable {
        DatabaseMetaData metaData = connection.getMetaData();
        Assertions.assertEquals((Object)"procedure", (Object)metaData.getProcedureTerm());
        Assertions.assertTrue((boolean)metaData.supportsStoredProcedures());
        try (ResultSet resultSet = metaData.getProcedureColumns("%", "%", "%", "%");){
            Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(resultSet));
        }
        resultSet = metaData.getProcedures("%", "%", "%");
        try {
            Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(resultSet));
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testGetTablePrivileges() throws Exception {
        try (Statement statement = connection.createStatement();){
            String database = connection.getCatalog();
            String schema = connection.getSchema();
            try {
                statement.execute("create or replace table PRIVTEST(colA string, colB number, colC timestamp)");
                DatabaseMetaData metaData = connection.getMetaData();
                try (ResultSet resultSet = metaData.getTablePrivileges(database, schema, "PRIVTEST");){
                    DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_TABLE_PRIVILEGES);
                    resultSet.next();
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertEquals((Object)"PRIVTEST", (Object)resultSet.getString("TABLE_NAME"));
                    Assertions.assertEquals((Object)"SYSADMIN", (Object)resultSet.getString("GRANTOR"));
                    Assertions.assertEquals((Object)"SYSADMIN", (Object)resultSet.getString("GRANTEE"));
                    Assertions.assertEquals((Object)"OWNERSHIP", (Object)resultSet.getString("PRIVILEGE"));
                    Assertions.assertEquals((Object)"YES", (Object)resultSet.getString("IS_GRANTABLE"));
                }
                statement.execute("grant select on table PRIVTEST to role securityadmin");
                resultSet = metaData.getTablePrivileges(database, schema, "PRIVTEST");
                try {
                    resultSet.next();
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertEquals((Object)"PRIVTEST", (Object)resultSet.getString("TABLE_NAME"));
                    Assertions.assertEquals((Object)"SYSADMIN", (Object)resultSet.getString("GRANTOR"));
                    Assertions.assertEquals((Object)"SYSADMIN", (Object)resultSet.getString("GRANTEE"));
                    Assertions.assertEquals((Object)"OWNERSHIP", (Object)resultSet.getString("PRIVILEGE"));
                    Assertions.assertEquals((Object)"YES", (Object)resultSet.getString("IS_GRANTABLE"));
                    resultSet.next();
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("TABLE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("TABLE_SCHEM"));
                    Assertions.assertEquals((Object)"PRIVTEST", (Object)resultSet.getString("TABLE_NAME"));
                    Assertions.assertEquals((Object)"SYSADMIN", (Object)resultSet.getString("GRANTOR"));
                    Assertions.assertEquals((Object)"SECURITYADMIN", (Object)resultSet.getString("GRANTEE"));
                    Assertions.assertEquals((Object)"SELECT", (Object)resultSet.getString("PRIVILEGE"));
                    Assertions.assertEquals((Object)"NO", (Object)resultSet.getString("IS_GRANTABLE"));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metaData.getTablePrivileges(null, null, null);
                try {
                    Assertions.assertEquals((int)7, (int)resultSet.getMetaData().getColumnCount());
                    Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(resultSet));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists PRIVTEST");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetProcedures() throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                String database = connection.getCatalog();
                String schema = connection.getSchema();
                statement.execute(PI_PROCEDURE);
                DatabaseMetaData metaData = connection.getMetaData();
                try (ResultSet resultSet = metaData.getProcedures(database, schema, "GETPI");){
                    DatabaseMetaDataIT.verifyResultSetMetaDataColumns(resultSet, DBMetadataResultSetMetadata.GET_PROCEDURES);
                    resultSet.next();
                    Assertions.assertEquals((Object)"GETPI", (Object)resultSet.getString("PROCEDURE_NAME"));
                    Assertions.assertEquals((Object)database, (Object)resultSet.getString("PROCEDURE_CAT"));
                    Assertions.assertEquals((Object)schema, (Object)resultSet.getString("PROCEDURE_SCHEM"));
                    Assertions.assertEquals((Object)"GETPI", (Object)resultSet.getString("PROCEDURE_NAME"));
                    Assertions.assertEquals((Object)"user-defined procedure", (Object)resultSet.getString("REMARKS"));
                    Assertions.assertEquals((int)2, (int)resultSet.getShort("PROCEDURE_TYPE"));
                    Assertions.assertEquals((Object)"GETPI() RETURN FLOAT", (Object)resultSet.getString("SPECIFIC_NAME"));
                }
            }
            finally {
                statement.execute("drop procedure if exists GETPI()");
            }
        }
    }

    @Test
    public void testDatabaseMetadata() throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        String dbVersion = metaData.getDatabaseProductVersion();
        java.util.regex.Matcher m = VERSION_PATTERN.matcher(dbVersion);
        Assertions.assertTrue((boolean)m.matches());
        int majorVersion = metaData.getDatabaseMajorVersion();
        int minorVersion = metaData.getDatabaseMinorVersion();
        Assertions.assertEquals((Object)m.group(1), (Object)String.valueOf(majorVersion));
        Assertions.assertEquals((Object)m.group(2), (Object)String.valueOf(minorVersion));
        Assertions.assertFalse((boolean)Strings.isNullOrEmpty((String)metaData.getSQLKeywords()));
        Assertions.assertFalse((boolean)Strings.isNullOrEmpty((String)metaData.getNumericFunctions()));
        Assertions.assertFalse((boolean)Strings.isNullOrEmpty((String)metaData.getStringFunctions()));
        Assertions.assertFalse((boolean)Strings.isNullOrEmpty((String)metaData.getSystemFunctions()));
        Assertions.assertFalse((boolean)Strings.isNullOrEmpty((String)metaData.getTimeDateFunctions()));
        Assertions.assertEquals((Object)"\\", (Object)metaData.getSearchStringEscape());
        Assertions.assertTrue((boolean)metaData.getURL().startsWith("jdbc:snowflake://"));
        Assertions.assertFalse((boolean)metaData.allProceduresAreCallable());
        Assertions.assertTrue((boolean)metaData.allTablesAreSelectable());
        Assertions.assertTrue((boolean)metaData.dataDefinitionCausesTransactionCommit());
        Assertions.assertFalse((boolean)metaData.dataDefinitionIgnoredInTransactions());
        Assertions.assertFalse((boolean)metaData.deletesAreDetected(1));
        Assertions.assertTrue((boolean)metaData.doesMaxRowSizeIncludeBlobs());
        Assertions.assertTrue((boolean)metaData.supportsTransactions());
        Assertions.assertEquals((int)2, (int)metaData.getDefaultTransactionIsolation());
        Assertions.assertEquals((Object)"$", (Object)metaData.getExtraNameCharacters());
        Assertions.assertEquals((Object)"\"", (Object)metaData.getIdentifierQuoteString());
        Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(metaData.getIndexInfo(null, null, null, true, true)));
        MatcherAssert.assertThat((Object)metaData.getMaxBinaryLiteralLength(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0x800000)));
        Assertions.assertEquals((int)255, (int)metaData.getMaxCatalogNameLength());
        MatcherAssert.assertThat((Object)metaData.getMaxCharLiteralLength(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0x1000000)));
        Assertions.assertEquals((int)255, (int)metaData.getMaxColumnNameLength());
        Assertions.assertEquals((int)0, (int)metaData.getMaxColumnsInGroupBy());
        Assertions.assertEquals((int)0, (int)metaData.getMaxColumnsInIndex());
        Assertions.assertEquals((int)0, (int)metaData.getMaxColumnsInOrderBy());
        Assertions.assertEquals((int)0, (int)metaData.getMaxColumnsInSelect());
        Assertions.assertEquals((int)0, (int)metaData.getMaxColumnsInTable());
        Assertions.assertEquals((int)0, (int)metaData.getMaxConnections());
        Assertions.assertEquals((int)0, (int)metaData.getMaxCursorNameLength());
        Assertions.assertEquals((int)0, (int)metaData.getMaxIndexLength());
        Assertions.assertEquals((int)0, (int)metaData.getMaxProcedureNameLength());
        Assertions.assertEquals((int)0, (int)metaData.getMaxRowSize());
        Assertions.assertEquals((int)255, (int)metaData.getMaxSchemaNameLength());
        Assertions.assertEquals((int)0, (int)metaData.getMaxStatementLength());
        Assertions.assertEquals((int)0, (int)metaData.getMaxStatements());
        Assertions.assertEquals((int)255, (int)metaData.getMaxTableNameLength());
        Assertions.assertEquals((int)0, (int)metaData.getMaxTablesInSelect());
        Assertions.assertEquals((int)255, (int)metaData.getMaxUserNameLength());
        Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(metaData.getTablePrivileges(null, null, null)));
        Assertions.assertEquals((Object)TestUtil.systemGetEnv("SNOWFLAKE_TEST_USER"), (Object)metaData.getUserName());
        Assertions.assertFalse((boolean)metaData.insertsAreDetected(1));
        Assertions.assertTrue((boolean)metaData.isCatalogAtStart());
        Assertions.assertFalse((boolean)metaData.isReadOnly());
        Assertions.assertTrue((boolean)metaData.nullPlusNonNullIsNull());
        Assertions.assertFalse((boolean)metaData.nullsAreSortedAtEnd());
        Assertions.assertFalse((boolean)metaData.nullsAreSortedAtStart());
        Assertions.assertTrue((boolean)metaData.nullsAreSortedHigh());
        Assertions.assertFalse((boolean)metaData.nullsAreSortedLow());
        Assertions.assertFalse((boolean)metaData.othersDeletesAreVisible(1));
        Assertions.assertFalse((boolean)metaData.othersInsertsAreVisible(1));
        Assertions.assertFalse((boolean)metaData.othersUpdatesAreVisible(1));
        Assertions.assertFalse((boolean)metaData.ownDeletesAreVisible(1));
        Assertions.assertFalse((boolean)metaData.ownInsertsAreVisible(1));
        Assertions.assertFalse((boolean)metaData.ownUpdatesAreVisible(1004));
        Assertions.assertFalse((boolean)metaData.storesLowerCaseIdentifiers());
        Assertions.assertFalse((boolean)metaData.storesLowerCaseQuotedIdentifiers());
        Assertions.assertFalse((boolean)metaData.storesMixedCaseIdentifiers());
        Assertions.assertTrue((boolean)metaData.storesMixedCaseQuotedIdentifiers());
        Assertions.assertTrue((boolean)metaData.storesUpperCaseIdentifiers());
        Assertions.assertFalse((boolean)metaData.storesUpperCaseQuotedIdentifiers());
        Assertions.assertTrue((boolean)metaData.supportsAlterTableWithAddColumn());
        Assertions.assertTrue((boolean)metaData.supportsAlterTableWithDropColumn());
        Assertions.assertTrue((boolean)metaData.supportsANSI92EntryLevelSQL());
        Assertions.assertFalse((boolean)metaData.supportsANSI92FullSQL());
        Assertions.assertFalse((boolean)metaData.supportsANSI92IntermediateSQL());
        Assertions.assertTrue((boolean)metaData.supportsBatchUpdates());
        Assertions.assertTrue((boolean)metaData.supportsCatalogsInDataManipulation());
        Assertions.assertFalse((boolean)metaData.supportsCatalogsInIndexDefinitions());
        Assertions.assertFalse((boolean)metaData.supportsCatalogsInPrivilegeDefinitions());
        Assertions.assertFalse((boolean)metaData.supportsCatalogsInProcedureCalls());
        Assertions.assertTrue((boolean)metaData.supportsCatalogsInTableDefinitions());
        Assertions.assertTrue((boolean)metaData.supportsColumnAliasing());
        Assertions.assertFalse((boolean)metaData.supportsConvert());
        Assertions.assertFalse((boolean)metaData.supportsConvert(1, 2));
        Assertions.assertFalse((boolean)metaData.supportsCoreSQLGrammar());
        Assertions.assertTrue((boolean)metaData.supportsCorrelatedSubqueries());
        Assertions.assertTrue((boolean)metaData.supportsDataDefinitionAndDataManipulationTransactions());
        Assertions.assertFalse((boolean)metaData.supportsDataManipulationTransactionsOnly());
        Assertions.assertFalse((boolean)metaData.supportsDifferentTableCorrelationNames());
        Assertions.assertTrue((boolean)metaData.supportsExpressionsInOrderBy());
        Assertions.assertFalse((boolean)metaData.supportsExtendedSQLGrammar());
        Assertions.assertTrue((boolean)metaData.supportsFullOuterJoins());
        Assertions.assertFalse((boolean)metaData.supportsGetGeneratedKeys());
        Assertions.assertTrue((boolean)metaData.supportsGroupBy());
        Assertions.assertTrue((boolean)metaData.supportsGroupByBeyondSelect());
        Assertions.assertFalse((boolean)metaData.supportsGroupByUnrelated());
        Assertions.assertFalse((boolean)metaData.supportsIntegrityEnhancementFacility());
        Assertions.assertFalse((boolean)metaData.supportsLikeEscapeClause());
        Assertions.assertTrue((boolean)metaData.supportsLimitedOuterJoins());
        Assertions.assertFalse((boolean)metaData.supportsMinimumSQLGrammar());
        Assertions.assertFalse((boolean)metaData.supportsMixedCaseIdentifiers());
        Assertions.assertTrue((boolean)metaData.supportsMixedCaseQuotedIdentifiers());
        Assertions.assertFalse((boolean)metaData.supportsMultipleOpenResults());
        Assertions.assertFalse((boolean)metaData.supportsMultipleResultSets());
        Assertions.assertTrue((boolean)metaData.supportsMultipleTransactions());
        Assertions.assertFalse((boolean)metaData.supportsNamedParameters());
        Assertions.assertTrue((boolean)metaData.supportsNonNullableColumns());
        Assertions.assertFalse((boolean)metaData.supportsOpenCursorsAcrossCommit());
        Assertions.assertFalse((boolean)metaData.supportsOpenCursorsAcrossRollback());
        Assertions.assertFalse((boolean)metaData.supportsOpenStatementsAcrossCommit());
        Assertions.assertFalse((boolean)metaData.supportsOpenStatementsAcrossRollback());
        Assertions.assertTrue((boolean)metaData.supportsOrderByUnrelated());
        Assertions.assertTrue((boolean)metaData.supportsOuterJoins());
        Assertions.assertFalse((boolean)metaData.supportsPositionedDelete());
        Assertions.assertFalse((boolean)metaData.supportsPositionedUpdate());
        Assertions.assertTrue((boolean)metaData.supportsResultSetConcurrency(1003, 1007));
        Assertions.assertFalse((boolean)metaData.supportsResultSetConcurrency(1004, 1007));
        Assertions.assertTrue((boolean)metaData.supportsResultSetType(1003));
        Assertions.assertTrue((boolean)metaData.supportsResultSetHoldability(2));
        Assertions.assertFalse((boolean)metaData.supportsResultSetHoldability(1));
        Assertions.assertEquals((int)2, (int)metaData.getResultSetHoldability());
        Assertions.assertFalse((boolean)metaData.supportsSavepoints());
        Assertions.assertTrue((boolean)metaData.supportsSchemasInDataManipulation());
        Assertions.assertFalse((boolean)metaData.supportsSchemasInIndexDefinitions());
        Assertions.assertFalse((boolean)metaData.supportsSchemasInPrivilegeDefinitions());
        Assertions.assertFalse((boolean)metaData.supportsSchemasInProcedureCalls());
        Assertions.assertTrue((boolean)metaData.supportsSchemasInTableDefinitions());
        Assertions.assertFalse((boolean)metaData.supportsSelectForUpdate());
        Assertions.assertFalse((boolean)metaData.supportsStatementPooling());
        Assertions.assertTrue((boolean)metaData.supportsStoredFunctionsUsingCallSyntax());
        Assertions.assertTrue((boolean)metaData.supportsSubqueriesInComparisons());
        Assertions.assertTrue((boolean)metaData.supportsSubqueriesInExists());
        Assertions.assertTrue((boolean)metaData.supportsSubqueriesInIns());
        Assertions.assertFalse((boolean)metaData.supportsSubqueriesInQuantifieds());
        Assertions.assertTrue((boolean)metaData.supportsTableCorrelationNames());
        Assertions.assertTrue((boolean)metaData.supportsTransactionIsolationLevel(2));
        Assertions.assertFalse((boolean)metaData.supportsTransactionIsolationLevel(4));
        Assertions.assertFalse((boolean)metaData.supportsTransactionIsolationLevel(8));
        Assertions.assertFalse((boolean)metaData.supportsTransactionIsolationLevel(1));
        Assertions.assertTrue((boolean)metaData.supportsUnion());
        Assertions.assertTrue((boolean)metaData.supportsUnionAll());
        Assertions.assertFalse((boolean)metaData.updatesAreDetected(1));
        Assertions.assertFalse((boolean)metaData.usesLocalFilePerTable());
        Assertions.assertFalse((boolean)metaData.usesLocalFiles());
    }

    @Test
    public void testOtherEmptyTables() throws Throwable {
        DatabaseMetaData metaData = connection.getMetaData();
        try (ResultSet resultSet = metaData.getIndexInfo(null, null, null, true, true);){
            Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(resultSet));
        }
        resultSet = metaData.getUDTs(null, null, null, new int[0]);
        try {
            Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(resultSet));
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    @Test
    public void testFeatureNotSupportedException() throws Throwable {
        DatabaseMetaData metaData = connection.getMetaData();
        this.expectFeatureNotSupportedException(() -> metaData.getBestRowIdentifier(null, null, null, 0, true));
        this.expectFeatureNotSupportedException(() -> metaData.getVersionColumns(null, null, null));
        this.expectFeatureNotSupportedException(() -> metaData.getSuperTypes(null, null, null));
        this.expectFeatureNotSupportedException(() -> metaData.getSuperTables(null, null, null));
        this.expectFeatureNotSupportedException(() -> metaData.getAttributes(null, null, null, null));
        this.expectFeatureNotSupportedException(metaData::getRowIdLifetime);
        this.expectFeatureNotSupportedException(metaData::autoCommitFailureClosesAllResultSets);
        this.expectFeatureNotSupportedException(metaData::getClientInfoProperties);
        this.expectFeatureNotSupportedException(() -> metaData.getPseudoColumns(null, null, null, null));
        this.expectFeatureNotSupportedException(metaData::generatedKeyAlwaysReturned);
        this.expectFeatureNotSupportedException(() -> metaData.isWrapperFor(SnowflakeDatabaseMetaData.class));
    }
}

