/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeDatabaseMetaDataResultSet;
import net.snowflake.client.jdbc.SnowflakeLoggedFeatureNotSupportedException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="resultSet")
public class DatabaseMetaDataResultSetLatestIT
extends BaseJDBCTest {
    @Test
    public void testGetObjectNotSupported() throws SQLException {
        try (Connection con = DatabaseMetaDataResultSetLatestIT.getConnection();
             Statement st = con.createStatement();){
            Object[][] rows = new Object[][]{{Float.valueOf(1.2f)}};
            List<String> columnNames = Arrays.asList("float");
            List<String> columnTypeNames = Arrays.asList("FLOAT");
            List<Integer> columnTypes = Arrays.asList(6);
            try (SnowflakeDatabaseMetaDataResultSet resultSet = new SnowflakeDatabaseMetaDataResultSet(columnNames, columnTypeNames, columnTypes, rows, st);){
                resultSet.next();
                Assertions.assertThrows(SnowflakeLoggedFeatureNotSupportedException.class, () -> DatabaseMetaDataResultSetLatestIT.lambda$testGetObjectNotSupported$0((ResultSet)resultSet));
            }
        }
    }

    @Test
    public void testObjectColumn() throws SQLException {
        try (Connection connection = DatabaseMetaDataResultSetLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("CREATE OR REPLACE TABLE TABLEWITHOBJECTCOLUMN (    col OBJECT(      str VARCHAR,      num NUMBER(38,0)      )   )");
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet resultSet = metaData.getColumns(connection.getCatalog(), connection.getSchema(), "TABLEWITHOBJECTCOLUMN", null);){
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((Object)"OBJECT", (Object)resultSet.getObject("TYPE_NAME"));
                Assertions.assertFalse((boolean)resultSet.next());
            }
        }
    }

    private static /* synthetic */ void lambda$testGetObjectNotSupported$0(ResultSet resultSet) throws Throwable {
        Assertions.assertEquals((Object)Float.valueOf(1.2f), (Object)resultSet.getObject(1));
    }
}

