/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeFileTransferConfig;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadata;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadataV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileUploaderExpandFileNamesTest {
    @TempDir
    private File folder;
    private String localFSFileSep = SnowflakeUtil.systemGetProperty((String)"file.separator");

    @Test
    public void testProcessFileNames() throws Exception {
        new File(this.folder, "TestFileA").createNewFile();
        new File(this.folder, "TestFileB").createNewFile();
        String folderName = this.folder.getCanonicalPath();
        String originalUserDir = System.getProperty("user.dir");
        String originalUserHome = System.getProperty("user.home");
        System.setProperty("user.dir", folderName);
        System.setProperty("user.home", folderName);
        String[] locations = new String[]{folderName + File.separator + "Tes*Fil*A", folderName + File.separator + "TestFil?B", "~" + File.separator + "TestFileC", "TestFileD", folderName + File.separator + "TestFileE~"};
        Set files = SnowflakeFileTransferAgent.expandFileNames((String[])locations, null);
        Assertions.assertTrue((boolean)files.contains(folderName + File.separator + "TestFileA"));
        Assertions.assertTrue((boolean)files.contains(folderName + File.separator + "TestFileB"));
        Assertions.assertTrue((boolean)files.contains(folderName + File.separator + "TestFileC"));
        Assertions.assertTrue((boolean)files.contains(folderName + File.separator + "TestFileD"));
        Assertions.assertTrue((boolean)files.contains(folderName + File.separator + "TestFileE~"));
        if (originalUserHome != null) {
            System.setProperty("user.home", originalUserHome);
        } else {
            System.clearProperty("user.home");
        }
        if (originalUserDir != null) {
            System.setProperty("user.dir", originalUserDir);
        } else {
            System.clearProperty("user.dir");
        }
    }

    @Test
    public void testProcessFileNamesException() {
        SnowflakeFileTransferAgent.setInjectedFileTransferException((Throwable)new Exception());
        String[] locations = new String[]{"/Tes*Fil*A", "/TestFil?B", "~/TestFileC", "TestFileD"};
        SnowflakeSQLException err = (SnowflakeSQLException)Assertions.assertThrows(SnowflakeSQLException.class, () -> SnowflakeFileTransferAgent.expandFileNames((String[])locations, null));
        Assertions.assertEquals((int)200007, (int)err.getErrorCode());
        Assertions.assertEquals((Object)"22000", (Object)err.getSQLState());
        SnowflakeFileTransferAgent.setInjectedFileTransferException(null);
    }

    @Test
    public void testSnowflakeFileTransferConfig() throws Exception {
        SnowflakeFileTransferMetadataV1 metadata = new SnowflakeFileTransferMetadataV1("dummy_presigned_url", null, null, null, null, null, null);
        SnowflakeFileTransferConfig.Builder builder = SnowflakeFileTransferConfig.Builder.newInstance();
        int throwCount = 0;
        int expectedThrowCount = 3;
        try {
            builder.build();
        }
        catch (IllegalArgumentException ex) {
            ++throwCount;
        }
        builder.setSnowflakeFileTransferMetadata((SnowflakeFileTransferMetadata)metadata);
        try {
            builder.build();
        }
        catch (IllegalArgumentException ex) {
            ++throwCount;
        }
        InputStream input = new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        };
        builder.setUploadStream(input);
        try {
            builder.build();
        }
        catch (IllegalArgumentException ex) {
            ++throwCount;
        }
        builder.setOcspMode(OCSPMode.FAIL_CLOSED);
        builder.setRequireCompress(false);
        builder.setNetworkTimeoutInMilli(12345);
        builder.setPrefix("dummy_prefix");
        Properties props = new Properties();
        builder.setProxyProperties(props);
        builder.setDestFileName("dummy_dest_file_name");
        SnowflakeFileTransferConfig config = builder.build();
        Assertions.assertEquals((Object)metadata, (Object)config.getSnowflakeFileTransferMetadata());
        Assertions.assertEquals((Object)input, (Object)config.getUploadStream());
        Assertions.assertEquals((Object)OCSPMode.FAIL_CLOSED, (Object)config.getOcspMode());
        Assertions.assertFalse((boolean)config.getRequireCompress());
        Assertions.assertEquals((int)12345, (int)config.getNetworkTimeoutInMilli());
        Assertions.assertEquals((Object)props, (Object)config.getProxyProperties());
        Assertions.assertEquals((Object)"dummy_prefix", (Object)config.getPrefix());
        Assertions.assertEquals((Object)"dummy_dest_file_name", (Object)config.getDestFileName());
        Assertions.assertEquals((int)expectedThrowCount, (int)throwCount);
    }

    @Test
    public void testFileListingDoesNotFailOnMissingFilesOfAnotherPattern() throws Exception {
        new File(this.folder, "TestFiles").mkdirs();
        String folderName = this.folder.getCanonicalPath();
        int filePatterns = 10;
        int filesPerPattern = 100;
        IntStream.range(0, filesPerPattern * filePatterns).forEach(id -> {
            try {
                File file = new File(folderName + this.localFSFileSep + "foo" + id % filePatterns + "-" + UUID.randomUUID());
                Assertions.assertTrue((boolean)file.createNewFile());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        ExecutorService executorService = Executors.newFixedThreadPool(filePatterns / 3);
        ArrayList<Future<Set>> futures = new ArrayList<Future<Set>>();
        for (int i = 0; i < filePatterns; ++i) {
            String[] stringArray = new String[]{folderName + this.localFSFileSep + "foo" + i + "*"};
            Future<Set> future = executorService.submit(() -> {
                try {
                    Set strings = SnowflakeFileTransferAgent.expandFileNames((String[])locations, null);
                    strings.forEach(fileName -> {
                        try {
                            File file = new File((String)fileName);
                            Files.delete(file.toPath());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    return strings;
                }
                catch (SnowflakeSQLException e) {
                    throw new RuntimeException(e);
                }
            });
            futures.add(future);
        }
        executorService.shutdown();
        Assertions.assertTrue((boolean)executorService.awaitTermination(60L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)filePatterns, (int)futures.size());
        for (Future future : futures) {
            Assertions.assertTrue((boolean)future.isDone());
            Assertions.assertEquals((int)filesPerPattern, (int)((Set)future.get()).size());
        }
    }

    @Test
    public void testFileListingDoesNotFailOnNotExistingDirectory() throws Exception {
        new File(this.folder, "TestFiles").mkdirs();
        String folderName = this.folder.getCanonicalPath();
        String[] locations = new String[]{folderName + this.localFSFileSep + "foo*"};
        this.folder.delete();
        Set files = SnowflakeFileTransferAgent.expandFileNames((String[])locations, null);
        Assertions.assertTrue((boolean)files.isEmpty());
    }
}

