/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.util.Optional;
import java.util.stream.Stream;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.common.core.FileCompressionType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class FileUploaderMimeTypeToCompressionTypeTest {
    @ParameterizedTest
    @ArgumentsSource(value=MimeTypesProvider.class)
    public void testMimeTypeToCompressionType(String mimeType, FileCompressionType mimeSubType) throws Throwable {
        Optional foundCompType = SnowflakeFileTransferAgent.mimeTypeToCompressionType((String)mimeType);
        if (foundCompType.isPresent()) {
            Assertions.assertEquals((Object)mimeSubType, foundCompType.get());
        } else {
            Assertions.assertEquals((Object)mimeSubType, null);
        }
    }

    static class MimeTypesProvider
    implements ArgumentsProvider {
        MimeTypesProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            return Stream.of(Arguments.of((Object[])new Object[]{"text/", null}), Arguments.of((Object[])new Object[]{"text/csv", null}), Arguments.of((Object[])new Object[]{"snowflake/orc", FileCompressionType.ORC}), Arguments.of((Object[])new Object[]{"snowflake/orc;p=1", FileCompressionType.ORC}), Arguments.of((Object[])new Object[]{"snowflake/parquet", FileCompressionType.PARQUET}), Arguments.of((Object[])new Object[]{"application/zlib", FileCompressionType.DEFLATE}), Arguments.of((Object[])new Object[]{"application/x-bzip2", FileCompressionType.BZIP2}), Arguments.of((Object[])new Object[]{"application/zstd", FileCompressionType.ZSTD}), Arguments.of((Object[])new Object[]{"application/x-brotli", FileCompressionType.BROTLI}), Arguments.of((Object[])new Object[]{"application/x-lzip", FileCompressionType.LZIP}), Arguments.of((Object[])new Object[]{"application/x-lzma", FileCompressionType.LZMA}), Arguments.of((Object[])new Object[]{"application/x-xz", FileCompressionType.XZ}), Arguments.of((Object[])new Object[]{"application/x-compress", FileCompressionType.COMPRESS}), Arguments.of((Object[])new Object[]{"application/x-gzip", FileCompressionType.GZIP}));
        }
    }
}

