/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.junit.jupiter.api.BeforeAll;

abstract class FileUploaderPrep
extends BaseJDBCTest {
    private static final ObjectMapper mapper = new ObjectMapper();
    static JsonNode exampleS3JsonNode;
    static JsonNode exampleS3StageEndpointJsonNode;
    static JsonNode exampleAzureJsonNode;
    static JsonNode exampleGCSJsonNode;
    static JsonNode exampleGCSJsonNodeWithUseRegionalUrl;
    static JsonNode exampleGCSJsonNodeWithEndPoint;
    static List<JsonNode> exampleNodes;

    FileUploaderPrep() {
    }

    private static JsonNode readJsonFromFile(String name) throws IOException {
        try (InputStream is = FileUploaderPrep.class.getResourceAsStream("/FileUploaderPrep/" + name + ".json");){
            JsonNode jsonNode = mapper.readTree(is);
            return jsonNode;
        }
    }

    @BeforeAll
    public static void setup() throws Exception {
        exampleS3JsonNode = FileUploaderPrep.readJsonFromFile("exampleS3");
        exampleS3StageEndpointJsonNode = FileUploaderPrep.readJsonFromFile("exampleS3WithStageEndpoint");
        exampleAzureJsonNode = FileUploaderPrep.readJsonFromFile("exampleAzure");
        exampleGCSJsonNode = FileUploaderPrep.readJsonFromFile("exampleGCS");
        exampleGCSJsonNodeWithUseRegionalUrl = FileUploaderPrep.readJsonFromFile("exampleGCSWithUseRegionalUrl");
        exampleGCSJsonNodeWithEndPoint = FileUploaderPrep.readJsonFromFile("exampleGCSWithEndpoint");
        exampleNodes = Arrays.asList(exampleS3JsonNode, exampleAzureJsonNode, exampleGCSJsonNode, exampleGCSJsonNodeWithUseRegionalUrl, exampleGCSJsonNodeWithEndPoint);
    }
}

