/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeConnection;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="others")
public class GitRepositoryDownloadLatestIT
extends BaseJDBCTest {
    @Test
    @DontRunOnGithubActions
    public void shouldDownloadFileAndStreamFromGitRepository() throws Exception {
        try (Connection connection = GitRepositoryDownloadLatestIT.getConnection();){
            GitRepositoryDownloadLatestIT.prepareJdbcRepoInSnowflake(connection);
            String stageName = String.format("@%s.%s.JDBC", connection.getCatalog(), connection.getSchema());
            String fileName = ".pre-commit-config.yaml";
            String filePathInGitRepo = "branches/master/" + fileName;
            List<String> fetchedFileContent = GitRepositoryDownloadLatestIT.getContentFromFile(connection, stageName, filePathInGitRepo, fileName);
            List<String> fetchedStreamContent = GitRepositoryDownloadLatestIT.getContentFromStream(connection, stageName, filePathInGitRepo);
            Assertions.assertFalse((boolean)fetchedFileContent.isEmpty(), (String)"File content cannot be empty");
            Assertions.assertFalse((boolean)fetchedStreamContent.isEmpty(), (String)"Stream content cannot be empty");
            Assertions.assertEquals(fetchedFileContent, fetchedStreamContent);
        }
    }

    private static void prepareJdbcRepoInSnowflake(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("use role accountadmin");
            statement.execute("CREATE OR REPLACE API INTEGRATION gh_integration\n  API_PROVIDER = git_https_api\n  API_ALLOWED_PREFIXES = ('https://github.com/snowflakedb/snowflake-jdbc.git')\n  ENABLED = TRUE;");
            statement.execute("CREATE OR REPLACE GIT REPOSITORY jdbc\nORIGIN = 'https://github.com/snowflakedb/snowflake-jdbc.git'\nAPI_INTEGRATION = gh_integration;");
        }
    }

    /*
     * Exception decompiling
     */
    private static List<String> getContentFromFile(Connection connection, String stageName, String filePathInGitRepo, String fileName) throws IOException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<String> getContentFromStream(Connection connection, String stageName, String filePathInGitRepo) throws SQLException, IOException {
        SnowflakeConnection unwrap = connection.unwrap(SnowflakeConnection.class);
        try (InputStream inputStream = unwrap.downloadStream(stageName, filePathInGitRepo, false);){
            List list = IOUtils.readLines((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return list;
        }
    }
}

