/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import net.snowflake.client.annotations.DontRunOnJenkins;
import net.snowflake.client.core.UUIDUtils;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeDriverIT;
import org.apache.commons.text.RandomStringGenerator;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="statement")
public class LobSizeLatestIT
extends BaseJDBCTest {
    private static final Logger logger = Logger.getLogger(SnowflakeDriverIT.class.getName());
    private static final Map<Integer, String> LobSizeStringValues = new HashMap<Integer, String>();
    private static int maxLobSize = 0x1000000;
    private static int largeLobSize = maxLobSize / 2;
    private static int mediumLobSize = largeLobSize / 2;
    private static int smallLobSize = 16;
    private static int originLobSize = 0x1000000;
    private static String tableName = "my_lob_test";
    private static String executeInsert = "insert into " + tableName + " (c1, c2, c3) values (";
    private static String executePreparedStatementInsert = executeInsert + "?, ?, ?)";
    private static String selectQuery = "select * from " + tableName + " where c3=";

    @BeforeAll
    public static void setUp() throws SQLException {
        try (Connection con = BaseJDBCTest.getConnection();){
            maxLobSize = con.getMetaData().getMaxCharLiteralLength();
            logger.log(Level.INFO, "Using max lob size: " + maxLobSize);
            System.setProperty("net.snowflake.jdbc.objectMapper.maxJsonStringLength", Integer.toString((int)((double)maxLobSize * 1.5)));
            LobSizeStringValues.put(smallLobSize, LobSizeLatestIT.generateRandomString(smallLobSize));
            LobSizeStringValues.put(originLobSize, LobSizeLatestIT.generateRandomString(originLobSize));
            LobSizeStringValues.put(mediumLobSize, LobSizeLatestIT.generateRandomString(mediumLobSize));
            LobSizeStringValues.put(largeLobSize, LobSizeLatestIT.generateRandomString(largeLobSize));
            LobSizeStringValues.put(maxLobSize, LobSizeLatestIT.generateRandomString(maxLobSize));
        }
    }

    private static String generateRandomString(int stringSize) {
        RandomStringGenerator randomStringGenerator = new RandomStringGenerator.Builder().withinRange(97, 122).build();
        return randomStringGenerator.generate(stringSize);
    }

    private static void setResultFormat(Statement stmt, String format) throws SQLException {
        stmt.execute("alter session set jdbc_query_result_format = '" + format + "'");
    }

    private void createTable(int lobSize, Statement stmt) throws SQLException {
        String createTableQuery = "create or replace table " + tableName + " (c1 varchar, c2 varchar(" + lobSize + "), c3 varchar)";
        stmt.execute(createTableQuery);
    }

    private void insertQuery(String varCharValue, String uuidValue, Statement stmt) throws SQLException {
        stmt.executeUpdate(executeInsert + "'abc', '" + varCharValue + "', '" + uuidValue + "')");
    }

    private void preparedInsertQuery(String varCharValue, String uuidValue, Connection con) throws SQLException {
        try (PreparedStatement pstmt = con.prepareStatement(executePreparedStatementInsert);){
            pstmt.setString(1, "abc");
            pstmt.setString(2, varCharValue);
            pstmt.setString(3, uuidValue);
            pstmt.execute();
        }
    }

    @AfterAll
    public static void tearDown() throws SQLException {
        try (Connection con = BaseJDBCTest.getConnection();
             Statement stmt = con.createStatement();){
            stmt.execute("Drop table if exists " + tableName);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DataProvider.class)
    @DontRunOnJenkins
    public void testStandardInsertAndSelectWithMaxLobSizeEnabled(int lobSize, String resultFormat) throws SQLException {
        try (Connection con = BaseJDBCTest.getConnection();
             Statement stmt = con.createStatement();){
            this.createTable(lobSize, stmt);
            LobSizeLatestIT.setResultFormat(stmt, resultFormat);
            String varCharValue = LobSizeStringValues.get(lobSize);
            String uuidValue = UUIDUtils.getUUID().toString();
            this.insertQuery(varCharValue, uuidValue, stmt);
            try (ResultSet rs = stmt.executeQuery(selectQuery + "'" + uuidValue + "'");){
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)"abc", (Object)rs.getString(1));
                Assertions.assertEquals((Object)varCharValue, (Object)rs.getString(2));
                Assertions.assertEquals((Object)uuidValue, (Object)rs.getString(3));
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DataProvider.class)
    @DontRunOnJenkins
    public void testPreparedInsertWithMaxLobSizeEnabled(int lobSize, String resultFormat) throws SQLException {
        try (Connection con = BaseJDBCTest.getConnection();
             Statement stmt = con.createStatement();){
            this.createTable(lobSize, stmt);
            LobSizeLatestIT.setResultFormat(stmt, resultFormat);
            String maxVarCharValue = LobSizeStringValues.get(lobSize);
            String uuidValue = UUIDUtils.getUUID().toString();
            this.preparedInsertQuery(maxVarCharValue, uuidValue, con);
            try (ResultSet rs = stmt.executeQuery(selectQuery + "'" + uuidValue + "'");){
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)"abc", (Object)rs.getString(1));
                Assertions.assertEquals((Object)maxVarCharValue, (Object)rs.getString(2));
                Assertions.assertEquals((Object)uuidValue, (Object)rs.getString(3));
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=DataProvider.class)
    @DontRunOnJenkins
    public void testPutAndGet(int lobSize, String resultFormat) throws IOException, SQLException {
        File tempFile = File.createTempFile("LobSizeTest", ".csv");
        tempFile.deleteOnExit();
        String filePath = tempFile.getPath();
        String filePathEscaped = filePath.replace("\\", "\\\\");
        String fileName = tempFile.getName();
        String varCharValue = LobSizeStringValues.get(lobSize);
        String uuidValue = UUIDUtils.getUUID().toString();
        String fileInput = "abc," + varCharValue + "," + uuidValue;
        try (PrintWriter out = new PrintWriter(filePath);){
            out.println(fileInput);
        }
        try (Connection con = BaseJDBCTest.getConnection();
             Statement stmt = con.createStatement();){
            this.createTable(lobSize, stmt);
            LobSizeLatestIT.setResultFormat(stmt, resultFormat);
            if (lobSize > originLobSize) {
                stmt.execute("alter session set ALLOW_LARGE_LOBS_IN_EXTERNAL_SCAN = true");
            }
            String sqlPut = "PUT 'file://" + filePathEscaped + "' @%" + tableName;
            stmt.execute(sqlPut);
            try (ResultSet rsPut = stmt.getResultSet();){
                Assertions.assertTrue((boolean)rsPut.next());
                Assertions.assertEquals((Object)fileName, (Object)rsPut.getString(1));
                Assertions.assertEquals((Object)(fileName + ".gz"), (Object)rsPut.getString(2));
                Assertions.assertEquals((Object)"GZIP", (Object)rsPut.getString(6));
                Assertions.assertEquals((Object)"UPLOADED", (Object)rsPut.getString(7));
            }
            try (ResultSet rsFiles = stmt.executeQuery("ls @%" + tableName);){
                Assertions.assertTrue((boolean)rsFiles.next());
                Assertions.assertEquals((Object)(fileName + ".gz"), (Object)rsFiles.getString(1));
            }
            String copyInto = "copy into " + tableName + " from @%" + tableName + " file_format=(type=csv compression='gzip')";
            stmt.execute(copyInto);
            try (ResultSet rsCopy = stmt.executeQuery(selectQuery + "'" + uuidValue + "'");){
                Assertions.assertTrue((boolean)rsCopy.next());
                Assertions.assertEquals((Object)"abc", (Object)rsCopy.getString(1));
                Assertions.assertEquals((Object)varCharValue, (Object)rsCopy.getString(2));
                Assertions.assertEquals((Object)uuidValue, (Object)rsCopy.getString(3));
            }
            Path tempDir = Files.createTempDirectory("MaxLobTest", new FileAttribute[0]);
            tempDir.toFile().deleteOnExit();
            String pathToTempDir = tempDir.toString().replace("\\", "\\\\");
            String getSql = "get @%" + tableName + " 'file://" + pathToTempDir + "'";
            stmt.execute(getSql);
            try (ResultSet rsGet = stmt.getResultSet();){
                Assertions.assertTrue((boolean)rsGet.next());
                Assertions.assertEquals((Object)(fileName + ".gz"), (Object)rsGet.getString(1));
                Assertions.assertEquals((Object)"DOWNLOADED", (Object)rsGet.getString(3));
            }
        }
    }

    static class DataProvider
    implements ArgumentsProvider {
        DataProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            int[] lobSizes = new int[]{smallLobSize, originLobSize, mediumLobSize, largeLobSize, maxLobSize};
            String[] resultFormats = new String[]{"Arrow", "JSON"};
            ArrayList<Arguments> ret = new ArrayList<Arguments>();
            for (int size : lobSizes) {
                for (String format : resultFormats) {
                    ret.add(Arguments.of((Object[])new Object[]{size, format}));
                }
            }
            return ret.stream();
        }
    }
}

