/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.jdbc.BaseJDBCWithSharedConnectionIT;
import net.snowflake.client.jdbc.SnowflakeStatement;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="statement")
public class MultiStatementLatestIT
extends BaseJDBCWithSharedConnectionIT {
    protected static String queryResultFormat = "json";

    @BeforeEach
    public void setQueryResultFormat() throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.execute("alter session set jdbc_query_result_format = '" + queryResultFormat + "'");
        }
    }

    @Test
    public void testMultiStmtExecute() throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)3);
            String multiStmtQuery = "create or replace temporary table test_multi (cola int);\ninsert into test_multi VALUES (1), (2);\nselect cola from test_multi order by cola asc";
            boolean hasResultSet = statement.execute(multiStmtQuery);
            Assertions.assertFalse((boolean)hasResultSet);
            Assertions.assertNull((Object)statement.getResultSet());
            Assertions.assertEquals((int)0, (int)statement.getUpdateCount());
            Assertions.assertTrue((boolean)statement.getMoreResults());
            Assertions.assertNull((Object)statement.getResultSet());
            Assertions.assertEquals((int)2, (int)statement.getUpdateCount());
            Assertions.assertTrue((boolean)statement.getMoreResults());
            Assertions.assertEquals((int)-1, (int)statement.getUpdateCount());
            try (ResultSet rs = statement.getResultSet();){
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)1, (int)rs.getInt(1));
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)2, (int)rs.getInt(1));
                Assertions.assertFalse((boolean)rs.next());
                Assertions.assertFalse((boolean)statement.getMoreResults());
                Assertions.assertEquals((int)-1, (int)statement.getUpdateCount());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiStmtTransaction() throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_multi_txn(c1 number, c2 string) as select 10, 'z'");
                statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)4);
                String multiStmtQuery = "begin;\ndelete from test_multi_txn;\ninsert into test_multi_txn values (1, 'a'), (2, 'b');\ncommit";
                boolean hasResultSet = statement.execute(multiStmtQuery);
                Assertions.assertFalse((boolean)hasResultSet);
                Assertions.assertNull((Object)statement.getResultSet());
                Assertions.assertEquals((int)0, (int)statement.getUpdateCount());
                Assertions.assertTrue((boolean)statement.getMoreResults());
                Assertions.assertNull((Object)statement.getResultSet());
                Assertions.assertEquals((int)1, (int)statement.getUpdateCount());
                Assertions.assertTrue((boolean)statement.getMoreResults());
                Assertions.assertNull((Object)statement.getResultSet());
                Assertions.assertEquals((int)2, (int)statement.getUpdateCount());
                Assertions.assertFalse((boolean)statement.getMoreResults());
                Assertions.assertNull((Object)statement.getResultSet());
                Assertions.assertEquals((int)0, (int)statement.getUpdateCount());
                Assertions.assertFalse((boolean)statement.getMoreResults());
                Assertions.assertEquals((int)-1, (int)statement.getUpdateCount());
            }
            finally {
                statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
                statement.execute("drop table if exists test_multi_txn");
            }
        }
    }

    @Test
    public void testMultiStmtExecuteUpdate() throws SQLException {
        try (Statement statement = connection.createStatement();){
            String multiStmtQuery = "create or replace temporary table test_multi (cola int);\ninsert into test_multi VALUES (1), (2);\nselect cola from test_multi order by cola asc";
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)3);
            int rowCount = statement.executeUpdate(multiStmtQuery);
            Assertions.assertEquals((int)0, (int)rowCount);
            Assertions.assertNull((Object)statement.getResultSet());
            Assertions.assertEquals((int)0, (int)statement.getUpdateCount());
            Assertions.assertTrue((boolean)statement.getMoreResults());
            Assertions.assertNull((Object)statement.getResultSet());
            Assertions.assertEquals((int)2, (int)statement.getUpdateCount());
            Assertions.assertTrue((boolean)statement.getMoreResults());
            Assertions.assertEquals((int)-1, (int)statement.getUpdateCount());
            try (ResultSet rs = statement.getResultSet();){
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)1, (int)rs.getInt(1));
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)2, (int)rs.getInt(1));
                Assertions.assertFalse((boolean)rs.next());
                Assertions.assertFalse((boolean)statement.getMoreResults());
                Assertions.assertEquals((int)-1, (int)statement.getUpdateCount());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiStmtTransactionRollback() throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_multi_txn_rb(c1 number, c2 string) as select 10, 'z'");
                statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)4);
                String multiStmtQuery = "begin;\ndelete from test_multi_txn_rb;\nrollback;\nselect count(*) from test_multi_txn_rb";
                boolean hasResultSet = statement.execute(multiStmtQuery);
                Assertions.assertFalse((boolean)hasResultSet);
                Assertions.assertNull((Object)statement.getResultSet());
                Assertions.assertEquals((int)0, (int)statement.getUpdateCount());
                Assertions.assertTrue((boolean)statement.getMoreResults());
                Assertions.assertNull((Object)statement.getResultSet());
                Assertions.assertEquals((int)1, (int)statement.getUpdateCount());
                Assertions.assertTrue((boolean)statement.getMoreResults());
                Assertions.assertNull((Object)statement.getResultSet());
                Assertions.assertEquals((int)0, (int)statement.getUpdateCount());
                Assertions.assertTrue((boolean)statement.getMoreResults());
                Assertions.assertEquals((int)-1, (int)statement.getUpdateCount());
                try (ResultSet rs = statement.getResultSet();){
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((int)1, (int)rs.getInt(1));
                    Assertions.assertFalse((boolean)rs.next());
                    Assertions.assertFalse((boolean)statement.getMoreResults());
                    Assertions.assertEquals((int)-1, (int)statement.getUpdateCount());
                }
            }
            finally {
                statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)1);
                statement.execute("drop table if exists test_multi_txn_rb");
            }
        }
    }

    @Test
    public void testMultiStmtExecuteQuery() throws SQLException {
        try (Statement statement = connection.createStatement();){
            String multiStmtQuery = "select 1;\ncreate or replace temporary table test_multi (cola int);\ninsert into test_multi VALUES (1), (2);\nselect cola from test_multi order by cola asc";
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)4);
            try (ResultSet rs = statement.executeQuery(multiStmtQuery);){
                Assertions.assertNotNull((Object)rs);
                Assertions.assertNotNull((Object)statement.getResultSet());
                Assertions.assertEquals((int)-1, (int)statement.getUpdateCount());
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)1, (int)rs.getInt(1));
                Assertions.assertFalse((boolean)rs.next());
                Assertions.assertTrue((boolean)statement.getMoreResults());
                Assertions.assertNull((Object)statement.getResultSet());
                Assertions.assertEquals((int)0, (int)statement.getUpdateCount());
                Assertions.assertTrue((boolean)statement.getMoreResults());
                Assertions.assertNull((Object)statement.getResultSet());
                Assertions.assertEquals((int)2, (int)statement.getUpdateCount());
                Assertions.assertTrue((boolean)statement.getMoreResults());
                Assertions.assertEquals((int)-1, (int)statement.getUpdateCount());
            }
            rs = statement.getResultSet();
            try {
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)1, (int)rs.getInt(1));
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)2, (int)rs.getInt(1));
                Assertions.assertFalse((boolean)rs.next());
                Assertions.assertFalse((boolean)statement.getMoreResults());
                Assertions.assertEquals((int)-1, (int)statement.getUpdateCount());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testMultiStmtUpdateCount() throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)2);
            boolean isResultSet = statement.execute("CREATE OR REPLACE TEMPORARY TABLE TABLIST AS SELECT TABLE_SCHEMA, TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME LIKE 'K%' ORDER BY TABLE_SCHEMA, TABLE_NAME; SELECT * FROM TABLIST JOIN INFORMATION_SCHEMA.COLUMNS ON COLUMNS.TABLE_SCHEMA = TABLIST.TABLE_SCHEMA AND COLUMNS.TABLE_NAME = TABLIST.TABLE_NAME;");
            Assertions.assertEquals((Object)isResultSet, (Object)false);
            int statementUpdateCount = statement.getUpdateCount();
            Assertions.assertEquals((int)statementUpdateCount, (int)0);
            isResultSet = statement.getMoreResults();
            Assertions.assertEquals((Object)isResultSet, (Object)true);
            statementUpdateCount = statement.getUpdateCount();
            Assertions.assertEquals((int)statementUpdateCount, (int)-1);
        }
    }

    @Test
    public void testAnonymousBlocksUse() throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("create or replace table tab758262(c1 number)");
            int multistatementcount = 2;
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)multistatementcount);
            String multiStmtQuery = "begin\ninsert into tab758262 values (1);\nreturn 'done';\nend;\nselect * from tab758262;";
            statement.execute(multiStmtQuery);
            for (int i = 0; i < multistatementcount - 1; ++i) {
                Assertions.assertTrue((boolean)statement.getMoreResults());
            }
            try (ResultSet rs = statement.getResultSet();){
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)1, (int)rs.getInt(1));
            }
            multiStmtQuery = "insert into tab758262 values (25), (26);\nbegin\ninsert into tab758262 values (27);\nreturn 'done';\nend;\nselect * from tab758262;";
            multistatementcount = 3;
            statement.unwrap(SnowflakeStatement.class).setParameter("MULTI_STATEMENT_COUNT", (Object)multistatementcount);
            statement.execute(multiStmtQuery);
            for (int i = 0; i < multistatementcount - 1; ++i) {
                Assertions.assertTrue((boolean)statement.getMoreResults());
            }
            rs = statement.getResultSet();
            try {
                Assertions.assertEquals((int)4, (int)this.getSizeOfResultSet(rs));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }
}

