/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Properties;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.PreparedStatement0IT;
import net.snowflake.client.jdbc.SnowflakePreparedStatement;
import net.snowflake.client.jdbc.SnowflakePreparedStatementV1;
import net.snowflake.client.providers.SimpleResultFormatProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="statement")
public class PreparedStatement1IT
extends PreparedStatement0IT {
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetParameterMetaData(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);){
            try (PreparedStatement preparedStatement = connection.prepareStatement("update TEST_PREPST set COLC = 'newString' where ID = ?");){
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterCount(), (Matcher)CoreMatchers.is((Object)1));
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterType(1), (Matcher)CoreMatchers.is((Object)12));
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getPrecision(1), (Matcher)CoreMatchers.is((Object)0));
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getScale(1), (Matcher)CoreMatchers.is((Object)0));
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().isNullable(1), (Matcher)CoreMatchers.is((Object)0));
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterTypeName(1), (Matcher)CoreMatchers.is((Object)"text"));
            }
            preparedStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");
            try {
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterCount(), (Matcher)CoreMatchers.is((Object)6));
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterType(1), (Matcher)CoreMatchers.is((Object)12));
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterTypeName(1), (Matcher)CoreMatchers.is((Object)"text"));
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterType(6), (Matcher)CoreMatchers.is((Object)12));
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterTypeName(6), (Matcher)CoreMatchers.is((Object)"text"));
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            preparedStatement = connection.prepareStatement("select * from TEST_PREPST");
            try {
                MatcherAssert.assertThat((Object)preparedStatement.getParameterMetaData().getParameterCount(), (Matcher)CoreMatchers.is((Object)0));
                SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> preparedStatement.getParameterMetaData().getParameterType(3));
                MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.NUMERIC_VALUE_OUT_OF_RANGE.getMessageCode()));
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testInsertStageArrayBind(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            connection.createStatement().execute("create or replace table testStageArrayBind(c1 integer)");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into testStageArrayBind values (?)");){
                for (int i = 0; i < 70000; ++i) {
                    prepStatement.setInt(1, i);
                    prepStatement.addBatch();
                }
                prepStatement.executeBatch();
                try (ResultSet resultSet = statement.executeQuery("select * from testStageArrayBind order by c1 asc");){
                    int count = 0;
                    while (resultSet.next()) {
                        MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)count));
                        ++count;
                    }
                }
            }
        }
    }

    static void bindOneParamSet(PreparedStatement prepst, int id, double colA, float colB, String colC, long colD, short colE) throws SQLException {
        prepst.setInt(1, id);
        prepst.setDouble(2, colA);
        prepst.setFloat(3, colB);
        prepst.setString(4, colC);
        prepst.setLong(5, colD);
        prepst.setShort(6, colE);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testPrepareStatementWithKeys(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);){
            connection.createStatement().execute("create or replace table test_prepst(id INTEGER, colA DOUBLE, colB FLOAT, colC String,  colD NUMBER, col INTEGER)");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)", 2);){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                prepStatement.addBatch();
                prepStatement.executeBatch();
                try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                    Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testInsertBatch(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);){
            connection.createStatement().execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 0");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                prepStatement.addBatch();
                PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)1);
                prepStatement.addBatch();
                int[] countResult = prepStatement.executeBatch();
                Assertions.assertEquals((int)1, (int)countResult[0]);
                Assertions.assertEquals((int)1, (int)countResult[1]);
                Assertions.assertEquals((int)2, (int)prepStatement.getUpdateCount());
                Assertions.assertEquals((long)2L, (long)prepStatement.getLargeUpdateCount());
                try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                    Assertions.assertEquals((int)2, (int)this.getSizeOfResultSet(resultSet));
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testInsertBatchStage(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);){
            connection.createStatement().execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 12");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                prepStatement.addBatch();
                PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)1);
                prepStatement.addBatch();
                int[] countResult = prepStatement.executeBatch();
                Assertions.assertEquals((int)1, (int)countResult[0]);
                Assertions.assertEquals((int)1, (int)countResult[1]);
                try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                    Assertions.assertEquals((int)2, (int)this.getSizeOfResultSet(resultSet));
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testInsertBatchStageMultipleTimes(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);){
            connection.createStatement().execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 6");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                prepStatement.addBatch();
                int[] countResult = prepStatement.executeBatch();
                Assertions.assertEquals((int)1, (int)countResult.length);
                Assertions.assertEquals((int)1, (int)countResult[0]);
                Assertions.assertEquals((int)1, (int)prepStatement.getUpdateCount());
                Assertions.assertEquals((long)1L, (long)prepStatement.getLargeUpdateCount());
                PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)1);
                prepStatement.addBatch();
                countResult = prepStatement.executeBatch();
                Assertions.assertEquals((int)1, (int)countResult.length);
                Assertions.assertEquals((int)1, (int)countResult[0]);
                Assertions.assertEquals((int)1, (int)prepStatement.getUpdateCount());
                Assertions.assertEquals((long)1L, (long)prepStatement.getLargeUpdateCount());
                try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                    Assertions.assertEquals((int)2, (int)this.getSizeOfResultSet(resultSet));
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testStageBatchNull(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            int[] thresholds;
            for (int threshold : thresholds = new int[]{0, 6}) {
                statement.execute("DELETE FROM TEST_PREPST WHERE 1=1");
                statement.execute(String.format("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = %d", threshold));
                try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                    prepStatement.setNull(1, 4);
                    prepStatement.setNull(2, 8);
                    prepStatement.setNull(3, 6);
                    prepStatement.setNull(4, 12);
                    prepStatement.setNull(5, 2);
                    prepStatement.setNull(6, 4);
                    prepStatement.addBatch();
                    int[] countResult = prepStatement.executeBatch();
                    Assertions.assertEquals((int)1, (int)countResult.length);
                    Assertions.assertEquals((int)1, (int)countResult[0]);
                }
                try (ResultSet resultSet = statement.executeQuery("SELECT * FROM TEST_PREPST");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    String errorMessage = "Column should be null (" + (threshold > 0 ? "stage" : "non-stage") + ")";
                    resultSet.getInt(1);
                    Assertions.assertTrue((boolean)resultSet.wasNull(), (String)errorMessage);
                    resultSet.getDouble(2);
                    Assertions.assertTrue((boolean)resultSet.wasNull(), (String)errorMessage);
                    resultSet.getFloat(3);
                    Assertions.assertTrue((boolean)resultSet.wasNull(), (String)errorMessage);
                    resultSet.getString(4);
                    Assertions.assertTrue((boolean)resultSet.wasNull(), (String)errorMessage);
                    resultSet.getLong(5);
                    Assertions.assertTrue((boolean)resultSet.wasNull(), (String)errorMessage);
                    resultSet.getShort(6);
                    Assertions.assertTrue((boolean)resultSet.wasNull(), (String)errorMessage);
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testStageString(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            int[] thresholds = new int[]{0, 6};
            String[] rows = new String[]{null, "", "\"", ",", "\n", "\r\n", "\"\"", "null", "\\\n", "\",", "\\\",\\\""};
            for (int threshold : thresholds) {
                statement.execute("DELETE FROM TEST_PREPST WHERE 1=1");
                statement.execute(String.format("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = %d", threshold));
                try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                    for (int i = 0; i < rows.length; ++i) {
                        PreparedStatement1IT.bindOneParamSet(prepStatement, i, 0.0, 0.0f, rows[i], 0L, (short)0);
                        prepStatement.addBatch();
                    }
                    prepStatement.executeBatch();
                    try (ResultSet resultSet = statement.executeQuery("SELECT colC FROM TEST_PREPST ORDER BY id ASC");){
                        String errorMessage = "Strings should match (" + (threshold > 0 ? "stage" : "non-stage") + ")";
                        for (String row : rows) {
                            Assertions.assertTrue((boolean)resultSet.next());
                            Assertions.assertEquals((Object)row, (Object)resultSet.getString(1), (String)errorMessage);
                        }
                    }
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testIncorrectTypes(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            int[] thresholds;
            for (int threshold : thresholds = new int[]{0, 6}) {
                statement.execute("DELETE FROM TEST_PREPST WHERE 1=1");
                statement.execute(String.format("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = %d", threshold));
                try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                    prepStatement.setString(1, "notAnInt");
                    prepStatement.setDouble(2, 0.0);
                    prepStatement.setFloat(3, 0.0f);
                    prepStatement.setString(4, "");
                    prepStatement.setLong(5, 0L);
                    prepStatement.setShort(6, (short)0);
                    prepStatement.addBatch();
                    Assertions.assertThrows(SQLException.class, prepStatement::executeBatch);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testStageBatchTimestamps(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            Timestamp tsEpoch = new Timestamp(0L);
            Timestamp tsEpochMinusOneSec = new Timestamp(-1000L);
            Timestamp tsPast = new Timestamp(-2208988800100L);
            Timestamp tsFuture = new Timestamp(32503680000000L);
            Timestamp tsNow = new Timestamp(System.currentTimeMillis());
            Timestamp tsArbitrary = new Timestamp(862056000000L);
            Timestamp[] timestamps = new Timestamp[]{tsEpochMinusOneSec, tsEpoch, tsPast, tsFuture, tsNow, tsArbitrary, null};
            String[] tsTypes = new String[]{"TIMESTAMP_LTZ", "TIMESTAMP_NTZ"};
            try {
                for (String tsType : tsTypes) {
                    statement.execute("ALTER SESSION SET TIMESTAMP_TYPE_MAPPING = " + tsType);
                    statement.execute("ALTER SESSION SET CLIENT_TIMESTAMP_TYPE_MAPPING = " + tsType);
                    statement.execute("CREATE OR REPLACE TABLE test_prepst_ts (id INTEGER, tz TIMESTAMP)");
                    try (PreparedStatement prepStatement = connection.prepareStatement("INSERT INTO test_prepst_ts(id, tz) VALUES(?,?)");){
                        int i;
                        int[] countResult;
                        statement.executeQuery("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 0");
                        for (int i2 = 0; i2 < timestamps.length; ++i2) {
                            prepStatement.setInt(1, i2);
                            prepStatement.setTimestamp(2, timestamps[i2]);
                            prepStatement.addBatch();
                        }
                        for (int res : countResult = prepStatement.executeBatch()) {
                            Assertions.assertEquals((int)1, (int)res);
                        }
                        Timestamp[] nonStageResult = new Timestamp[timestamps.length];
                        try (ResultSet rsNonStage = statement.executeQuery("SELECT * FROM test_prepst_ts ORDER BY id ASC");){
                            for (i = 0; i < nonStageResult.length; ++i) {
                                Assertions.assertTrue((boolean)rsNonStage.next());
                                nonStageResult[i] = rsNonStage.getTimestamp(2);
                            }
                        }
                        statement.execute("DELETE FROM test_prepst_ts WHERE 1=1");
                        statement.execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 1");
                        for (int i3 = 0; i3 < timestamps.length; ++i3) {
                            prepStatement.setInt(1, i3);
                            prepStatement.setTimestamp(2, timestamps[i3]);
                            prepStatement.addBatch();
                        }
                        int[] i3 = countResult = prepStatement.executeBatch();
                        i = i3.length;
                        for (int res = 0; res < i; ++res) {
                            int res2 = i3[res];
                            Assertions.assertEquals((int)1, (int)res2);
                        }
                        Timestamp[] stageResult = new Timestamp[timestamps.length];
                        try (ResultSet rsStage = statement.executeQuery("SELECT * FROM test_prepst_ts ORDER BY id ASC");){
                            int i4;
                            for (i4 = 0; i4 < stageResult.length; ++i4) {
                                Assertions.assertTrue((boolean)rsStage.next());
                                stageResult[i4] = rsStage.getTimestamp(2);
                            }
                            for (i4 = 0; i4 < timestamps.length; ++i4) {
                                Assertions.assertEquals((Object)nonStageResult[i4], (Object)stageResult[i4], (String)("Stage binding timestamp should match non-stage binding timestamp (" + tsType + ")"));
                            }
                        }
                    }
                }
            }
            finally {
                statement.execute("DROP TABLE IF EXISTS test_prepst_ts");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testStageBatchTimes(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            Time tMidnight = new Time(0L);
            Time tNeg = new Time(-1L);
            Time tPos = new Time(1L);
            Time tNow = new Time(System.currentTimeMillis());
            Time tNoon = new Time(43200000L);
            Time[] times = new Time[]{tMidnight, tNeg, tPos, tNow, tNoon, null};
            try {
                statement.execute("CREATE OR REPLACE TABLE test_prepst_time (id INTEGER, tod TIME)");
                try (PreparedStatement prepStatement = connection.prepareStatement("INSERT INTO test_prepst_time(id, tod) VALUES(?,?)");){
                    int i;
                    int[] countResult;
                    statement.execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 0");
                    for (int i2 = 0; i2 < times.length; ++i2) {
                        prepStatement.setInt(1, i2);
                        prepStatement.setTime(2, times[i2]);
                        prepStatement.addBatch();
                    }
                    for (int res : countResult = prepStatement.executeBatch()) {
                        Assertions.assertEquals((int)1, (int)res);
                    }
                    Time[] nonStageResult = new Time[times.length];
                    ResultSet rsNonStage = statement.executeQuery("SELECT * FROM test_prepst_time ORDER BY id ASC");
                    for (i = 0; i < nonStageResult.length; ++i) {
                        Assertions.assertTrue((boolean)rsNonStage.next());
                        nonStageResult[i] = rsNonStage.getTime(2);
                    }
                    statement.execute("DELETE FROM test_prepst_time WHERE 1=1");
                    statement.execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 1");
                    for (i = 0; i < times.length; ++i) {
                        prepStatement.setInt(1, i);
                        prepStatement.setTime(2, times[i]);
                        prepStatement.addBatch();
                    }
                    for (int res : countResult = prepStatement.executeBatch()) {
                        Assertions.assertEquals((int)1, (int)res);
                    }
                    Time[] stageResult = new Time[times.length];
                    try (ResultSet rsStage = statement.executeQuery("SELECT * FROM test_prepst_time ORDER BY id ASC");){
                        int i3;
                        for (i3 = 0; i3 < stageResult.length; ++i3) {
                            Assertions.assertTrue((boolean)rsStage.next());
                            stageResult[i3] = rsStage.getTime(2);
                        }
                        for (i3 = 0; i3 < times.length; ++i3) {
                            Assertions.assertEquals((Object)nonStageResult[i3], (Object)stageResult[i3], (String)"Stage binding time should match non-stage binding time");
                        }
                    }
                }
            }
            finally {
                statement.execute("DROP TABLE IF EXISTS test_prepst_time");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testClearParameters(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
            PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
            prepStatement.clearParameters();
            int parameterSize = ((SnowflakePreparedStatementV1)prepStatement).getParameterBindings().size();
            MatcherAssert.assertThat((Object)parameterSize, (Matcher)CoreMatchers.is((Object)0));
            PreparedStatement1IT.bindOneParamSet(prepStatement, 3, 1.22, 1.2f, "hello", 12222L, (short)1);
            prepStatement.executeUpdate();
            try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((int)3, (int)resultSet.getInt(1));
                Assertions.assertFalse((boolean)resultSet.next());
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testClearBatch(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
            PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
            prepStatement.addBatch();
            PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)1);
            prepStatement.addBatch();
            prepStatement.clearBatch();
            int batchSize = ((SnowflakePreparedStatementV1)prepStatement).getBatchParameterBindings().size();
            MatcherAssert.assertThat((Object)batchSize, (Matcher)CoreMatchers.is((Object)0));
            PreparedStatement1IT.bindOneParamSet(prepStatement, 3, 1.22, 1.2f, "hello", 12222L, (short)1);
            prepStatement.addBatch();
            prepStatement.executeBatch();
            batchSize = ((SnowflakePreparedStatementV1)prepStatement).getBatchParameterBindings().size();
            MatcherAssert.assertThat((Object)batchSize, (Matcher)CoreMatchers.is((Object)0));
            try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((int)3, (int)resultSet.getInt(1));
                Assertions.assertFalse((boolean)resultSet.next());
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testInsertOneRow(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            statement.execute("CREATE OR REPLACE TABLE test_prepst_date (id INTEGER, d DATE)");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                Assertions.assertEquals((int)1, (int)prepStatement.executeUpdate());
            }
            try (ResultSet resultSet = statement.executeQuery("select * from TEST_PREPST");){
                Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
            }
            prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");
            try {
                PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)1);
                Assertions.assertFalse((boolean)prepStatement.execute());
                Assertions.assertEquals((int)1, (int)prepStatement.getUpdateCount());
                Assertions.assertEquals((long)1L, (long)prepStatement.getLargeUpdateCount());
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testUpdateOneRow(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            statement.execute("CREATE OR REPLACE TABLE test_prepst_date (id INTEGER, d DATE)");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                prepStatement.addBatch();
                PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)1);
                prepStatement.addBatch();
                prepStatement.executeBatch();
            }
            prepStatement = connection.prepareStatement("update TEST_PREPST set COLC = 'newString' where ID = ?");
            try {
                prepStatement.setInt(1, 1);
                int count = prepStatement.executeUpdate();
                Assertions.assertEquals((int)1, (int)count);
                try (ResultSet resultSet = statement.executeQuery("select * from TEST_PREPST");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"newString", (Object)resultSet.getString(4));
                }
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
            prepStatement = connection.prepareStatement("update TEST_PREPST set COLC = 'newString' where ID = ?");
            try {
                prepStatement.setInt(1, 2);
                Assertions.assertFalse((boolean)prepStatement.execute());
                Assertions.assertEquals((int)1, (int)prepStatement.getUpdateCount());
                Assertions.assertEquals((long)1L, (long)prepStatement.getLargeUpdateCount());
                try (ResultSet resultSet = statement.executeQuery("select * from TEST_PREPST");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"newString", (Object)resultSet.getString(4));
                }
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testDeleteOneRow(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            String qid1;
            statement.execute("CREATE OR REPLACE TABLE test_prepst_date (id INTEGER, d DATE)");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                prepStatement.addBatch();
                PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)1);
                prepStatement.addBatch();
                prepStatement.executeBatch();
            }
            try (PreparedStatement prepStatement = connection.prepareStatement("delete from TEST_PREPST where ID = ?");){
                prepStatement.setInt(1, 1);
                int count = prepStatement.executeUpdate();
                Assertions.assertEquals((int)1, (int)count);
                try (ResultSet resultSet = statement.executeQuery("select * from TEST_PREPST");){
                    Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
                }
                Assertions.assertTrue((boolean)prepStatement.isWrapperFor(SnowflakePreparedStatement.class));
                qid1 = prepStatement.unwrap(SnowflakePreparedStatement.class).getQueryID();
                Assertions.assertNotNull((Object)qid1);
            }
            prepStatement = connection.prepareStatement("delete from TEST_PREPST where ID = ?");
            try {
                prepStatement.setInt(1, 2);
                Assertions.assertFalse((boolean)prepStatement.execute());
                Assertions.assertEquals((int)1, (int)prepStatement.getUpdateCount());
                Assertions.assertEquals((long)1L, (long)prepStatement.getLargeUpdateCount());
                try (ResultSet resultSet = statement.executeQuery("select * from TEST_PREPST");){
                    Assertions.assertEquals((int)0, (int)this.getSizeOfResultSet(resultSet));
                    Assertions.assertTrue((boolean)prepStatement.isWrapperFor(SnowflakePreparedStatement.class));
                    String qid2 = prepStatement.unwrap(SnowflakePreparedStatement.class).getQueryID();
                    Assertions.assertNotNull((Object)qid2);
                    Assertions.assertNotEquals((Object)qid1, (Object)qid2);
                }
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testSelectOneRow(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);){
            ResultSet resultSet;
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                prepStatement.addBatch();
                PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)1);
                prepStatement.addBatch();
                prepStatement.executeBatch();
            }
            prepStatement = connection.prepareStatement("select * from TEST_PREPST where ID = ?");
            try {
                prepStatement.setInt(1, 2);
                resultSet = prepStatement.executeQuery();
                try {
                    Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
            prepStatement = connection.prepareStatement("select * from TEST_PREPST where ID = ?");
            try {
                prepStatement.setInt(1, 2);
                Assertions.assertTrue((boolean)prepStatement.execute());
                resultSet = prepStatement.getResultSet();
                try {
                    Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(resultSet));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testUpdateBatch(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);){
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                prepStatement.addBatch();
                PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)1);
                prepStatement.addBatch();
                prepStatement.executeBatch();
            }
            prepStatement = connection.prepareStatement("update TEST_PREPST set COLC = 'newString' where ID = ?");
            try {
                prepStatement.setInt(1, 1);
                prepStatement.addBatch();
                prepStatement.setInt(1, 2);
                prepStatement.addBatch();
                prepStatement.setInt(1, 3);
                prepStatement.addBatch();
                int[] counts = prepStatement.executeBatch();
                MatcherAssert.assertThat((Object)counts[0], (Matcher)CoreMatchers.is((Object)1));
                MatcherAssert.assertThat((Object)counts[1], (Matcher)CoreMatchers.is((Object)1));
                MatcherAssert.assertThat((Object)counts[2], (Matcher)CoreMatchers.is((Object)0));
                Assertions.assertEquals((int)0, (int)prepStatement.getUpdateCount());
                Assertions.assertEquals((long)0L, (long)prepStatement.getLargeUpdateCount());
                try (ResultSet resultSet = connection.createStatement().executeQuery("select * from TEST_PREPST");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    MatcherAssert.assertThat((Object)resultSet.getString(4), (Matcher)CoreMatchers.is((Object)"newString"));
                    Assertions.assertTrue((boolean)resultSet.next());
                    MatcherAssert.assertThat((Object)resultSet.getString(4), (Matcher)CoreMatchers.is((Object)"newString"));
                }
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testBatchInsertWithCacheEnabled(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            statement.execute("alter session set USE_CACHED_RESULT=true");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)1);
                prepStatement.addBatch();
                PreparedStatement1IT.bindOneParamSet(prepStatement, 2, 2.22222, 2.2f, "test2", 1221221123131L, (short)2);
                prepStatement.addBatch();
                int[] countResult = prepStatement.executeBatch();
                Assertions.assertEquals((int)1, (int)countResult[0]);
                Assertions.assertEquals((int)1, (int)countResult[1]);
                prepStatement.clearBatch();
                PreparedStatement1IT.bindOneParamSet(prepStatement, 3, 3.3333, 3.2f, "test3", 1221221123131L, (short)3);
                prepStatement.addBatch();
                PreparedStatement1IT.bindOneParamSet(prepStatement, 4, 4.4444, 4.2f, "test4", 1221221123131L, (short)4);
                prepStatement.addBatch();
                countResult = prepStatement.executeBatch();
                Assertions.assertEquals((int)1, (int)countResult[0]);
                Assertions.assertEquals((int)1, (int)countResult[1]);
                try (ResultSet resultSet = statement.executeQuery("select * from TEST_PREPST");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((int)1, (int)resultSet.getInt(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((int)2, (int)resultSet.getInt(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((int)3, (int)resultSet.getInt(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((int)4, (int)resultSet.getInt(1));
                    Assertions.assertFalse((boolean)resultSet.next());
                }
            }
        }
    }

    @Test
    @Disabled
    public void manualTestForPreparedStatementLogging() throws SQLException {
        Map<String, String> params = PreparedStatement1IT.getConnectionParameters();
        Properties props = new Properties();
        String uri = params.get("uri");
        props.put("account", params.get("account"));
        props.put("ssl", params.get("ssl"));
        props.put("database", params.get("database"));
        props.put("schema", params.get("schema"));
        props.put("user", params.get("user"));
        props.put("password", params.get("password"));
        props.put("tracing", "info");
        try (Connection con = DriverManager.getConnection(uri, props);
             Statement statement = con.createStatement();){
            statement.executeUpdate("alter session set CLIENT_ENABLE_LOG_INFO_STATEMENT_PARAMETERS=true");
            statement.execute("create or replace table test_prepst(id INTEGER, colA DOUBLE, colB FLOAT, colC String,  colD NUMBER, col INTEGER)");
            try (PreparedStatement prepStatement = con.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)", 2);){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                prepStatement.addBatch();
                prepStatement.executeBatch();
                statement.executeUpdate("alter session set CLIENT_ENABLE_LOG_INFO_STATEMENT_PARAMETERS=false");
            }
        }
    }
}

