/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.jdbc.PreparedStatement0IT;
import net.snowflake.client.jdbc.PreparedStatement1IT;
import net.snowflake.client.providers.SimpleResultFormatProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="statement")
public class PreparedStatement1LatestIT
extends PreparedStatement0IT {
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testPrepStWithCacheEnabled(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            ResultSet resultSet;
            statement.execute("alter session set USE_CACHED_RESULT=true");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                prepStatement.execute();
                prepStatement.execute();
                PreparedStatement1IT.bindOneParamSet(prepStatement, 100, 1.2222, 1.2f, "testA", 12122L, (short)12);
                prepStatement.execute();
            }
            try (ResultSet resultSet2 = statement.executeQuery("select * from test_prepst");){
                Assertions.assertTrue((boolean)resultSet2.next());
                Assertions.assertEquals((int)resultSet2.getInt(1), (int)1);
                Assertions.assertTrue((boolean)resultSet2.next());
                Assertions.assertEquals((int)resultSet2.getInt(1), (int)1);
                Assertions.assertTrue((boolean)resultSet2.next());
                Assertions.assertEquals((int)resultSet2.getInt(1), (int)100);
            }
            prepStatement = connection.prepareStatement("select id, id + ? from test_prepst where id  = ?");
            try {
                prepStatement.setInt(1, 1);
                prepStatement.setInt(2, 1);
                resultSet = prepStatement.executeQuery();
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((int)resultSet.getInt(2), (int)2);
                    prepStatement.setInt(1, 1);
                    prepStatement.setInt(2, 100);
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = prepStatement.executeQuery();
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((int)resultSet.getInt(2), (int)101);
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
            prepStatement = connection.prepareStatement("select seq4() from table(generator(rowcount=>100)) limit ?");
            try {
                prepStatement.setInt(1, 1);
                resultSet = prepStatement.executeQuery();
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertFalse((boolean)resultSet.next());
                    prepStatement.setInt(1, 3);
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = prepStatement.executeQuery();
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testInsertStageArrayBindWithTime(String queryResultFormat) throws SQLException {
        TimeZone originalTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            try {
                Time[][] timeValues;
                statement.execute("alter session set CLIENT_STAGE_ARRAY_BINDING_THRESHOLD=2");
                statement.execute("create or replace table testStageBindTime (c1 time, c2 time)");
                PreparedStatement prepSt = connection.prepareStatement("insert into testStageBindTime values (?, ?)");
                for (Time[] value : timeValues = new Time[][]{{new Time(0L), new Time(1L)}, {new Time(1000L), new Time(Integer.MAX_VALUE)}, {new Time(123456L), new Time(55555L)}, {Time.valueOf("01:02:00"), new Time(-100L)}}) {
                    prepSt.setTime(1, value[0]);
                    prepSt.setTime(2, value[1]);
                    prepSt.addBatch();
                }
                prepSt.executeBatch();
                try (ResultSet rs = statement.executeQuery("select * from testStageBindTime");){
                    for (Time[] timeValue : timeValues) {
                        Assertions.assertTrue((boolean)rs.next());
                        Assertions.assertEquals((Object)timeValue[0].toString(), (Object)rs.getTime(1).toString());
                        Assertions.assertEquals((Object)timeValue[1].toString(), (Object)rs.getTime(2).toString());
                    }
                }
            }
            finally {
                statement.execute("drop table if exists testStageBindTime");
                statement.execute("alter session unset CLIENT_STAGE_ARRAY_BINDING_THRESHOLD");
                TimeZone.setDefault(originalTimeZone);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testSetObjectForTimestampTypes(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            try {
                statement.execute("ALTER SESSION UNSET CLIENT_TIMESTAMP_TYPE_MAPPING");
                statement.execute("create or replace table TS (ntz TIMESTAMP_NTZ, ltz TIMESTAMP_LTZ)");
                PreparedStatement prepst = connection.prepareStatement("insert into TS values (?, ?)");
                String date1 = "2014-01-01 16:00:00";
                String date2 = "1945-11-12 5:25:00";
                Timestamp[] testTzs = new Timestamp[]{Timestamp.valueOf(date1), Timestamp.valueOf(date2)};
                for (int i = 0; i < testTzs.length; ++i) {
                    statement.execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 0");
                    prepst.setObject(1, (Object)testTzs[i], 50002);
                    prepst.setObject(2, (Object)testTzs[i], 50000);
                    prepst.addBatch();
                    prepst.executeBatch();
                    statement.execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 1");
                    prepst.setObject(1, (Object)testTzs[i], 50002);
                    prepst.setObject(2, (Object)testTzs[i], 50000);
                    prepst.addBatch();
                    prepst.executeBatch();
                }
                try (ResultSet rs = statement.executeQuery("select * from TS");){
                    for (int i = 0; i < testTzs.length; ++i) {
                        Assertions.assertTrue((boolean)rs.next());
                        Timestamp expectedNTZTs = rs.getTimestamp(1);
                        Timestamp expectedLTZTs = rs.getTimestamp(2);
                        Assertions.assertTrue((boolean)rs.next());
                        Assertions.assertEquals((Object)expectedNTZTs, (Object)rs.getTimestamp(1));
                        Assertions.assertEquals((Object)expectedLTZTs, (Object)rs.getTimestamp(2));
                    }
                }
            }
            finally {
                statement.execute("ALTER SESSION UNSET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD;");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testExecuteEmptyBatch(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);){
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                Assertions.assertEquals((int)0, (int)prepStatement.executeBatch().length, (String)"For empty batch, we should return int[0].");
            }
            connection.createStatement().execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 0");
            prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");
            try {
                Assertions.assertEquals((int)0, (int)prepStatement.executeBatch().length, (String)"For empty batch, we should return int[0].");
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testSetObjectMethodWithVarbinaryColumn(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);){
            connection.createStatement().execute("create or replace table test_binary(b VARBINARY)");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into test_binary(b) values (?)");){
                prepStatement.setObject(1, "HELLO WORLD".getBytes());
                prepStatement.execute();
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testSetObjectMethodWithBigIntegerColumn(String queryResultFormat) {
        try (Connection connection = this.getConn(queryResultFormat);){
            connection.createStatement().execute("create or replace table test_bigint(id NUMBER)");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into test_bigint(id) values(?)");){
                prepStatement.setObject(1, BigInteger.valueOf(9999L));
                int rows = prepStatement.executeUpdate();
                Assertions.assertTrue((rows == 1 ? 1 : 0) != 0, (String)"Row count doesn't match");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Assertions.fail((String)("testSetObjectMethodWithBigIntegerColumn failed with an exception message: " + e.getMessage()));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testSetObjectMethodWithLargeBigIntegerColumn(String queryResultFormat) {
        try (Connection connection = this.getConn(queryResultFormat);){
            connection.createStatement().execute("create or replace table test_bigint(id NUMBER)");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into test_bigint(id) values(?)");){
                BigInteger largeBigInt = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.TEN);
                prepStatement.setObject(1, largeBigInt);
                int rows = prepStatement.executeUpdate();
                Assertions.assertTrue((rows == 1 ? 1 : 0) != 0, (String)"Row count doesn't match");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Assertions.fail((String)("testSetObjectMethodWithLargeBigIntegerColumn failed with an exception message: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testBatchInsertWithTimestampInputFormatSet(String queryResultFormat) throws SQLException {
        TimeZone originalTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            try {
                statement.execute("alter session set TIMESTAMP_INPUT_FORMAT='YYYY-MM-DD HH24:MI:SS.FFTZH'");
                statement.execute("create or replace table testStageBindTypes (c1 date, c2 datetime, c3 timestamp)");
                java.util.Date today = new java.util.Date();
                Date sqldate = new Date(today.getDate());
                Timestamp todaySQL = new Timestamp(today.getTime());
                try (PreparedStatement prepSt = connection.prepareStatement("insert into testStageBindTypes values (?, ?, ?)");){
                    for (int i = 1; i < 30000; ++i) {
                        prepSt.setDate(1, sqldate);
                        prepSt.setDate(2, sqldate);
                        prepSt.setTimestamp(3, todaySQL);
                        prepSt.addBatch();
                    }
                    prepSt.executeBatch();
                }
            }
            finally {
                statement.execute("drop table if exists testStageBindTypes");
                statement.execute("alter session unset TIMESTAMP_INPUT_FORMAT");
            }
        }
        finally {
            TimeZone.setDefault(originalTimeZone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @Disabled
    public void testCallStatement(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            try {
                statement.executeQuery("ALTER SESSION SET USE_STATEMENT_TYPE_CALL_FOR_STORED_PROC_CALLS=true");
                statement.executeQuery("create or replace procedure\nTEST_SP_CALL_STMT_ENABLED(in1 float, in2 variant)\nreturns string language javascript as $$\nlet res = snowflake.execute({sqlText: 'select ? c1, ? c2', binds:[IN1, JSON.stringify(IN2)]});\nres.next();\nreturn res.getColumnValueAsString(1) + ' ' + res.getColumnValueAsString(2) + ' ' + IN2;\n$$;");
                try (PreparedStatement prepStatement = connection.prepareStatement("call TEST_SP_CALL_STMT_ENABLED(?, to_variant(?))");){
                    prepStatement.setDouble(1, 1.0);
                    prepStatement.setString(2, "[2,3]");
                    try (ResultSet rs = prepStatement.executeQuery();){
                        String result = "1 \"[2,3]\" [2,3]";
                        while (rs.next()) {
                            Assertions.assertEquals((Object)result, (Object)rs.getString(1));
                        }
                    }
                }
            }
            finally {
                statement.executeQuery("drop procedure if exists TEST_SP_CALL_STMT_ENABLED(float, variant)");
            }
        }
    }
}

