/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.jdbc.PreparedStatement0IT;
import net.snowflake.client.jdbc.PreparedStatement1IT;
import net.snowflake.client.jdbc.SnowflakePreparedStatement;
import net.snowflake.client.jdbc.SnowflakePreparedStatementV1;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaData;
import net.snowflake.client.providers.SimpleResultFormatProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="statement")
public class PreparedStatement2LatestIT
extends PreparedStatement0IT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testPrepareUDTF(String queryResultFormat) throws Exception {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table employee(id number, address text)");
                statement.execute("create or replace function employee_detail(sid number, addr text)\n returns table(id number, address text)\nLANGUAGE SQL\nas\n$$\nselect *\nfrom employee\nwhere  id=sid\n$$;");
                try (PreparedStatement prepStatement = connection.prepareStatement("select * from table(employee_detail(?, ?))");){
                    prepStatement.setInt(1, 1);
                    prepStatement.setString(2, "abc");
                    prepStatement.execute();
                }
                prepStatement = connection.prepareStatement("select * from table(employee_detail(?, 'abc'))");
                try {
                    prepStatement.setInt(1, 1);
                    prepStatement.execute();
                }
                finally {
                    if (prepStatement != null) {
                        prepStatement.close();
                    }
                }
                prepStatement = connection.prepareStatement("select * from table(employee_detail(?, 123))");
                try {
                    prepStatement.setInt(1, 1);
                    SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, prepStatement::execute);
                    MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)1044));
                }
                finally {
                    if (prepStatement != null) {
                        prepStatement.close();
                    }
                }
                statement.execute("create or replace function employee_detail(name text , addr text)\n returns table(id number)\nLANGUAGE SQL\nas\n$$\nselect id\nfrom employee\n$$;");
                prepStatement = connection.prepareStatement("select * from table(employee_detail(?, 'abc'))");
                try {
                    prepStatement.setInt(1, 1);
                    prepStatement.execute();
                }
                finally {
                    if (prepStatement != null) {
                        prepStatement.close();
                    }
                }
            }
            finally {
                statement.execute("drop function if exists employee_detail(number, text)");
                statement.execute("drop function if exists employee_detail(text, text)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testSelectWithBinding(String queryResultFormat) throws Throwable {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            try {
                ResultSet rs;
                statement.execute("create or replace table TESTNULL(created_time timestamp_ntz, mid int)");
                try (PreparedStatement ps = connection.prepareStatement("SELECT 1 FROM TESTNULL WHERE CREATED_TIME = TO_TIMESTAMP(?, 3) and MID = ?");){
                    ps.setObject(1, 0);
                    ps.setObject(2, null);
                    rs = ps.executeQuery();
                    try {
                        Assertions.assertFalse((boolean)rs.next());
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                ps = connection.prepareStatement("SELECT 1 FROM TESTNULL WHERE CREATED_TIME = TO_TIMESTAMP(?::NUMBER, 3) and MID = ?");
                try {
                    ps.setObject(1, 0);
                    ps.setObject(2, null);
                    rs = ps.executeQuery();
                    try {
                        Assertions.assertFalse((boolean)rs.next());
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists TESTNULL");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testLimitBind(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);){
            String stmtStr = "select seq4() from table(generator(rowcount=>100)) limit ?";
            try (PreparedStatement prepStatement = connection.prepareStatement(stmtStr);){
                prepStatement.setInt(1, 10);
                prepStatement.executeQuery();
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testConstOptLimitBind(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);){
            String stmtStr = "select 1 limit ? offset ?";
            try (PreparedStatement prepStatement = connection.prepareStatement(stmtStr);){
                prepStatement.setInt(1, 10);
                prepStatement.setInt(2, 0);
                try (ResultSet resultSet = prepStatement.executeQuery();){
                    Assertions.assertTrue((boolean)resultSet.next());
                    MatcherAssert.assertThat((Object)resultSet.getInt(1), (Matcher)CoreMatchers.is((Object)1));
                    MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)false));
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testTableFuncBindInput(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             PreparedStatement prepStatement = connection.prepareStatement("select 1 from table(generator(rowCount => ?))");){
            prepStatement.setInt(1, 2);
            try (ResultSet resultSet = prepStatement.executeQuery();){
                Assertions.assertEquals((int)2, (int)this.getSizeOfResultSet(resultSet));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testExecuteLargeBatch(String queryResultFormat) throws SQLException {
        try (Connection con = this.getConn(queryResultFormat);
             Statement statement = con.createStatement();){
            try {
                statement.execute("create or replace table mytab(id int)");
                try (PreparedStatement pstatement = con.prepareStatement("insert into mytab(id) values (?)");){
                    pstatement.setLong(1, 4L);
                    pstatement.addBatch();
                    pstatement.setLong(1, 5L);
                    pstatement.addBatch();
                    pstatement.setLong(1, 6L);
                    pstatement.addBatch();
                    pstatement.executeLargeBatch();
                    con.commit();
                    try (ResultSet resultSet = statement.executeQuery("select * from mytab");){
                        Assertions.assertTrue((boolean)resultSet.next());
                        Assertions.assertEquals((int)4, (int)resultSet.getInt(1));
                    }
                }
            }
            finally {
                statement.execute("drop table if exists mytab");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testRemoveExtraDescribeCalls(String queryResultFormat) throws SQLException {
        String queryId1 = null;
        String queryId2 = null;
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_uuid_with_bind(c1 number)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into test_uuid_with_bind values (?)");){
                    preparedStatement.setInt(1, 5);
                    Assertions.assertEquals((int)1, (int)preparedStatement.executeUpdate());
                    queryId1 = preparedStatement.unwrap(SnowflakePreparedStatement.class).getQueryID();
                    queryId2 = preparedStatement.getMetaData().unwrap(SnowflakeResultSetMetaData.class).getQueryID();
                    Assertions.assertEquals((Object)queryId1, (Object)queryId2);
                    preparedStatement.addBatch();
                }
                preparedStatement = connection.prepareStatement("select * from test_uuid_with_bind where c1 = ?");
                try {
                    Assertions.assertFalse((boolean)preparedStatement.unwrap(SnowflakePreparedStatementV1.class).isAlreadyDescribed());
                    preparedStatement.setInt(1, 5);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)CoreMatchers.is((Object)true));
                        queryId1 = preparedStatement.unwrap(SnowflakePreparedStatement.class).getQueryID();
                        queryId2 = preparedStatement.getMetaData().unwrap(SnowflakeResultSetMetaData.class).getQueryID();
                        String queryId3 = resultSet.unwrap(SnowflakeResultSet.class).getQueryID();
                        Assertions.assertEquals((Object)queryId1, (Object)queryId2);
                        Assertions.assertEquals((Object)queryId1, (Object)queryId3);
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists test_uuid_with_bind");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testRemoveExtraDescribeCallsSanityCheck(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);){
            String queryId1;
            try (PreparedStatement preparedStatement = connection.prepareStatement("create or replace table test_uuid_with_bind(c1 number, c2 string)");){
                preparedStatement.execute();
                queryId1 = preparedStatement.unwrap(SnowflakePreparedStatement.class).getQueryID();
            }
            preparedStatement = connection.prepareStatement("insert into test_uuid_with_bind values (?, ?)");
            try {
                Assertions.assertFalse((boolean)preparedStatement.unwrap(SnowflakePreparedStatementV1.class).isAlreadyDescribed());
                preparedStatement.setInt(1, 5);
                preparedStatement.setString(2, "hello");
                preparedStatement.addBatch();
                preparedStatement.setInt(1, 7);
                preparedStatement.setString(2, "hello1");
                preparedStatement.addBatch();
                String queryId2 = preparedStatement.getMetaData().unwrap(SnowflakeResultSetMetaData.class).getQueryID();
                Assertions.assertNotEquals((Object)queryId1, (Object)queryId2);
                preparedStatement.executeBatch();
                String queryId3 = preparedStatement.unwrap(SnowflakePreparedStatement.class).getQueryID();
                Assertions.assertNotEquals((Object)queryId2, (Object)queryId3);
                String queryId4 = preparedStatement.getMetaData().unwrap(SnowflakeResultSetMetaData.class).getQueryID();
                Assertions.assertEquals((Object)queryId2, (Object)queryId4);
                connection.createStatement().execute("drop table if exists test_uuid_with_bind");
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testAlreadyDescribedMultipleResults(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);){
            ResultSet rs;
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into TEST_PREPST values(?, ?, ?, ?, ?, ?)");){
                PreparedStatement1IT.bindOneParamSet(prepStatement, 1, 1.22222, 1.2f, "test", 12121212121L, (short)12);
                prepStatement.execute();
                Assertions.assertTrue((boolean)prepStatement.unwrap(SnowflakePreparedStatementV1.class).isAlreadyDescribed());
            }
            prepStatement = connection.prepareStatement("select * from TEST_PREPST where ID = ?");
            try {
                Assertions.assertFalse((boolean)prepStatement.unwrap(SnowflakePreparedStatementV1.class).isAlreadyDescribed());
                prepStatement.setInt(1, 1);
                rs = prepStatement.executeQuery();
                try {
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertTrue((boolean)prepStatement.unwrap(SnowflakePreparedStatementV1.class).isAlreadyDescribed());
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
            prepStatement = connection.prepareStatement("select * from TEST_PREPST");
            try {
                Assertions.assertFalse((boolean)prepStatement.unwrap(SnowflakePreparedStatementV1.class).isAlreadyDescribed());
                rs = prepStatement.executeQuery();
                try {
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertTrue((boolean)prepStatement.unwrap(SnowflakePreparedStatementV1.class).isAlreadyDescribed());
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (prepStatement != null) {
                    prepStatement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testConsecutiveBatchInsertError(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table testStageArrayBind(c1 integer, c2 string)");
                try (PreparedStatement prepStatement = connection.prepareStatement("insert into testStageArrayBind values (?, ?)");){
                    int i;
                    Assertions.assertFalse((boolean)prepStatement.unwrap(SnowflakePreparedStatementV1.class).isAlreadyDescribed());
                    Assertions.assertFalse((boolean)prepStatement.unwrap(SnowflakePreparedStatementV1.class).isArrayBindSupported());
                    for (i = 0; i < 35000; ++i) {
                        prepStatement.setInt(1, i);
                        prepStatement.setString(2, "test" + i);
                        prepStatement.addBatch();
                    }
                    prepStatement.executeBatch();
                    Assertions.assertTrue((boolean)prepStatement.unwrap(SnowflakePreparedStatementV1.class).isArrayBindSupported());
                    for (i = 0; i < 35000; ++i) {
                        prepStatement.setInt(1, i);
                        prepStatement.setString(2, "test" + i);
                        prepStatement.addBatch();
                    }
                    prepStatement.executeBatch();
                    Assertions.assertTrue((boolean)prepStatement.unwrap(SnowflakePreparedStatementV1.class).isArrayBindSupported());
                }
            }
            finally {
                statement.execute("drop table if exists testStageArrayBind");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testToString(String queryResultFormat) throws SQLException {
        try (Connection connection = this.getConn(queryResultFormat);
             PreparedStatement prepStatement = connection.prepareStatement("select current_version() --testing toString()");){
            Assertions.assertEquals((Object)"select current_version() --testing toString() - Query ID: null", (Object)prepStatement.toString());
            prepStatement.executeQuery();
            Assertions.assertTrue((boolean)prepStatement.toString().matches("select current_version\\(\\) --testing toString\\(\\) - Query ID: (\\d|\\w)+(-(\\d|\\w)+)+$"));
        }
    }
}

