/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="statement")
public class PreparedStatementFeatureNotSupportedIT
extends BaseJDBCTest {
    @Test
    public void testFeatureNotSupportedException() throws Throwable {
        try (Connection connection = PreparedStatementFeatureNotSupportedIT.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("select ?");){
            this.expectFeatureNotSupportedException(() -> preparedStatement.setAsciiStream(1, new BaseJDBCTest.FakeInputStream(this)));
            this.expectFeatureNotSupportedException(() -> preparedStatement.setAsciiStream(1, (InputStream)new BaseJDBCTest.FakeInputStream(this), 1));
            this.expectFeatureNotSupportedException(() -> preparedStatement.setBinaryStream(1, new BaseJDBCTest.FakeInputStream(this)));
            this.expectFeatureNotSupportedException(() -> preparedStatement.setBinaryStream(1, (InputStream)new BaseJDBCTest.FakeInputStream(this), 1));
            this.expectFeatureNotSupportedException(() -> preparedStatement.setCharacterStream(1, new BaseJDBCTest.FakeReader(this)));
            this.expectFeatureNotSupportedException(() -> preparedStatement.setCharacterStream(1, (Reader)new BaseJDBCTest.FakeReader(this), 1));
            this.expectFeatureNotSupportedException(() -> preparedStatement.setRef(1, new BaseJDBCTest.FakeRef(this)));
            this.expectFeatureNotSupportedException(() -> preparedStatement.setBlob(1, new BaseJDBCTest.FakeBlob(this)));
            URL fakeURL = new URL("http://localhost:8888/");
            this.expectFeatureNotSupportedException(() -> preparedStatement.setURL(1, fakeURL));
            this.expectFeatureNotSupportedException(() -> preparedStatement.setRowId(1, new BaseJDBCTest.FakeRowId(this)));
            this.expectFeatureNotSupportedException(() -> preparedStatement.setNString(1, "test"));
            this.expectFeatureNotSupportedException(() -> preparedStatement.setNCharacterStream(1, new BaseJDBCTest.FakeReader(this)));
            this.expectFeatureNotSupportedException(() -> preparedStatement.setNCharacterStream(1, new BaseJDBCTest.FakeReader(this), 1L));
            this.expectFeatureNotSupportedException(() -> preparedStatement.setNClob(1, new BaseJDBCTest.FakeNClob(this)));
            this.expectFeatureNotSupportedException(() -> preparedStatement.setNClob(1, new BaseJDBCTest.FakeReader(this), 1L));
            this.expectFeatureNotSupportedException(() -> preparedStatement.setClob(1, new BaseJDBCTest.FakeReader(this)));
            this.expectFeatureNotSupportedException(() -> preparedStatement.setClob(1, new BaseJDBCTest.FakeReader(this), 1L));
            this.expectFeatureNotSupportedException(() -> preparedStatement.setBlob(1, new BaseJDBCTest.FakeInputStream(this)));
            this.expectFeatureNotSupportedException(() -> preparedStatement.setBlob(1, new BaseJDBCTest.FakeInputStream(this), 1L));
            this.expectFeatureNotSupportedException(() -> preparedStatement.setSQLXML(1, new BaseJDBCTest.FakeSQLXML(this)));
            this.expectFeatureNotSupportedException(() -> preparedStatement.execute("insert into a values(1)", 1));
            this.expectFeatureNotSupportedException(() -> preparedStatement.execute("insert into a values(1)", new int[0]));
            this.expectFeatureNotSupportedException(() -> preparedStatement.execute("insert into a values(1)", new String[0]));
            this.expectFeatureNotSupportedException(() -> preparedStatement.executeUpdate("insert into a values(1)", 1));
            this.expectFeatureNotSupportedException(() -> preparedStatement.executeUpdate("insert into a values(1)", new int[0]));
            this.expectFeatureNotSupportedException(() -> preparedStatement.executeUpdate("insert into a values(1)", new String[0]));
            this.expectFeatureNotSupportedException(() -> preparedStatement.executeLargeUpdate("insert into a values(1)", 1));
            this.expectFeatureNotSupportedException(() -> preparedStatement.executeLargeUpdate("insert into a values(1)", new int[0]));
            this.expectFeatureNotSupportedException(() -> preparedStatement.executeLargeUpdate("insert into a values(1)", new String[0]));
        }
    }
}

