/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakePreparedStatementV1;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@Tag(value="statement")
public class PreparedStatementLargeUpdateLatestIT
extends BaseJDBCTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testLargeUpdate() throws Throwable {
        try (Connection con = PreparedStatementLargeUpdateLatestIT.getConnection();
             Statement statement = con.createStatement();){
            try {
                long expectedUpdateRows = 0x80000009L;
                statement.execute("create or replace table  test_large_update(c1 boolean)");
                try (PreparedStatement st = con.prepareStatement("insert into test_large_update select true from table(generator(rowcount=>" + expectedUpdateRows + "))");
                     PreparedStatement spyp = (PreparedStatement)Mockito.spy((Object)st);){
                    ((SnowflakePreparedStatementV1)Mockito.doReturn((Object)expectedUpdateRows).when((Object)((SnowflakePreparedStatementV1)spyp))).executeUpdateInternal((String)Mockito.any(String.class), (Map)Mockito.any(Map.class), ((Boolean)Mockito.any(Boolean.TYPE)).booleanValue(), (ExecTimeTelemetryData)Mockito.any(ExecTimeTelemetryData.class));
                    long updatedRows = spyp.executeLargeUpdate();
                    Assertions.assertEquals((long)expectedUpdateRows, (long)updatedRows);
                }
            }
            finally {
                statement.execute("drop table if exists test_large_update");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testExecuteLargeBatchOverIntMax() throws SQLException {
        try (Connection connection = PreparedStatementLargeUpdateLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table over_int_table (val string, id int)");
                try (PreparedStatement pstmt = connection.prepareStatement("UPDATE over_int_table SET ID=200");
                     PreparedStatement spyp = (PreparedStatement)Mockito.spy((Object)pstmt);){
                    long numRows = 0x80000009L;
                    ((SnowflakePreparedStatementV1)Mockito.doReturn((Object)numRows).when((Object)((SnowflakePreparedStatementV1)spyp))).executeUpdateInternal((String)Mockito.any(String.class), (Map)Mockito.any(Map.class), ((Boolean)Mockito.any(Boolean.TYPE)).booleanValue(), (ExecTimeTelemetryData)Mockito.any(ExecTimeTelemetryData.class));
                    pstmt.addBatch();
                    long[] queryResult = spyp.executeLargeBatch();
                    Assertions.assertEquals((int)1, (int)queryResult.length);
                    Assertions.assertEquals((long)numRows, (long)queryResult[0]);
                }
            }
            finally {
                statement.execute("drop table if exists over_int_table");
            }
        }
    }
}

