/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.util.Properties;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.jdbc.ResultSet0IT;
import net.snowflake.client.jdbc.SnowflakeChunkDownloader;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.providers.SimpleResultFormatProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="resultSet")
public class ResultSetIT
extends ResultSet0IT {
    private final String selectAllSQL = "select * from test_rs";
    private static final byte[] byteArrayTestCase1 = new byte[0];
    private static final byte[] byteArrayTestCase2 = new byte[]{-85, -51, 18};
    private static final byte[] byteArrayTestCase3 = new byte[]{0, -1, 66, 1};

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testFindColumn(String queryResultFormat) throws SQLException {
        try (Statement statement = this.createStatement(queryResultFormat);
             ResultSet resultSet = statement.executeQuery("select * from test_rs");){
            Assertions.assertEquals((int)1, (int)resultSet.findColumn("COLA"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetColumnClassNameForBinary(String queryResultFormat) throws Throwable {
        try (Statement statement = this.createStatement(queryResultFormat);){
            try {
                statement.execute("create or replace table bintable (b binary)");
                statement.execute("insert into bintable values ('00f1f2')");
                try (ResultSet resultSet = statement.executeQuery("select * from bintable");){
                    ResultSetMetaData metaData = resultSet.getMetaData();
                    Assertions.assertEquals((Object)SnowflakeType.BINARY_CLASS_NAME, (Object)metaData.getColumnClassName(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Class<?> klass = Class.forName(SnowflakeType.BINARY_CLASS_NAME);
                    Object ret0 = resultSet.getObject(1);
                    Assertions.assertEquals(ret0.getClass(), klass);
                    byte[] ret = (byte[])ret0;
                    Assertions.assertEquals((int)3, (int)ret.length);
                    Assertions.assertEquals((byte)ret[0], (byte)0);
                    Assertions.assertEquals((byte)ret[1], (byte)-15);
                    Assertions.assertEquals((byte)ret[2], (byte)-14);
                }
            }
            finally {
                statement.execute("drop table if exists bintable");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetMethod(String queryResultFormat) throws Throwable {
        String prepInsertString = "insert into test_get values(?, ?, ?, ?, ?, ?, ?, ?)";
        int bigInt = Integer.MAX_VALUE;
        long bigLong = Long.MAX_VALUE;
        short bigShort = Short.MAX_VALUE;
        String str = "hello";
        double bigDouble = Double.MAX_VALUE;
        float bigFloat = Float.MAX_VALUE;
        Clob clob = connection.createClob();
        clob.setString(1L, "hello world");
        try (Statement statement = this.createStatement(queryResultFormat);){
            try {
                statement.execute("create or replace table test_get(colA integer, colB number, colC number, colD string, colE double, colF float, colG boolean, colH text)");
                try (PreparedStatement prepStatement = connection.prepareStatement(prepInsertString);){
                    prepStatement.setInt(1, bigInt);
                    prepStatement.setLong(2, bigLong);
                    prepStatement.setLong(3, bigShort);
                    prepStatement.setString(4, str);
                    prepStatement.setDouble(5, bigDouble);
                    prepStatement.setFloat(6, bigFloat);
                    prepStatement.setBoolean(7, true);
                    prepStatement.setClob(8, clob);
                    prepStatement.execute();
                    statement.execute("select * from test_get");
                    try (ResultSet resultSet = statement.getResultSet();){
                        Assertions.assertTrue((boolean)resultSet.next());
                        Assertions.assertEquals((int)bigInt, (int)resultSet.getInt(1));
                        Assertions.assertEquals((int)bigInt, (int)resultSet.getInt("COLA"));
                        Assertions.assertEquals((long)bigLong, (long)resultSet.getLong(2));
                        Assertions.assertEquals((long)bigLong, (long)resultSet.getLong("COLB"));
                        Assertions.assertEquals((short)bigShort, (short)resultSet.getShort(3));
                        Assertions.assertEquals((short)bigShort, (short)resultSet.getShort("COLC"));
                        Assertions.assertEquals((Object)str, (Object)resultSet.getString(4));
                        Assertions.assertEquals((Object)str, (Object)resultSet.getString("COLD"));
                        Reader reader = resultSet.getCharacterStream("COLD");
                        char[] sample = new char[str.length()];
                        Assertions.assertEquals((int)str.length(), (int)reader.read(sample));
                        Assertions.assertEquals((char)str.charAt(0), (char)sample[0]);
                        Assertions.assertEquals((Object)str, (Object)new String(sample));
                        Assertions.assertEquals((float)bigFloat, (float)resultSet.getFloat(6), (float)0.0f);
                        Assertions.assertEquals((float)bigFloat, (float)resultSet.getFloat("COLF"), (float)0.0f);
                        Assertions.assertTrue((boolean)resultSet.getBoolean(7));
                        Assertions.assertTrue((boolean)resultSet.getBoolean("COLG"));
                        Assertions.assertEquals((Object)"hello world", (Object)resultSet.getClob("COLH").toString());
                        Assertions.assertEquals((Object)statement, (Object)resultSet.getStatement());
                    }
                }
            }
            finally {
                statement.execute("drop table if exists table_get");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetObjectOnDatabaseMetadataResultSet(String queryResultFormat) throws SQLException {
        Statement statement = this.createStatement(queryResultFormat);
        if (statement != null) {
            statement.close();
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        try (ResultSet resultSet = databaseMetaData.getTypeInfo();){
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertEquals((Object)1, (Object)resultSet.getObject("NULLABLE"));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetShort(String queryResultFormat) throws SQLException {
        try (ResultSet resultSet = this.numberCrossTesting(queryResultFormat);){
            SQLException ex;
            int finalI;
            int i;
            Assertions.assertTrue((boolean)resultSet.next());
            for (i = 1; i < 13; ++i) {
                Assertions.assertEquals((int)0, (int)resultSet.getShort(i));
            }
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertEquals((int)2, (int)resultSet.getShort(1));
            Assertions.assertEquals((int)5, (int)resultSet.getShort(2));
            Assertions.assertEquals((int)3, (int)resultSet.getShort(3));
            Assertions.assertEquals((int)1, (int)resultSet.getShort(4));
            Assertions.assertEquals((int)1, (int)resultSet.getShort(5));
            Assertions.assertEquals((int)1, (int)resultSet.getShort(6));
            Assertions.assertEquals((int)9126, (int)resultSet.getShort(7));
            for (i = 8; i < 13; ++i) {
                finalI = i;
                ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getShort(finalI), (String)("Failing on " + i));
                Assertions.assertEquals((int)200038, (int)ex.getErrorCode());
            }
            Assertions.assertTrue((boolean)resultSet.next());
            for (i = 5; i < 7; ++i) {
                finalI = i;
                ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getShort(finalI), (String)("Failing on " + i));
                Assertions.assertEquals((int)200038, (int)ex.getErrorCode());
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetInt(String queryResultFormat) throws SQLException {
        try (ResultSet resultSet = this.numberCrossTesting(queryResultFormat);){
            SQLException ex;
            int finalI;
            int i;
            Assertions.assertTrue((boolean)resultSet.next());
            for (i = 1; i < 13; ++i) {
                Assertions.assertEquals((int)0, (int)resultSet.getInt(i));
            }
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertEquals((int)2, (int)resultSet.getInt(1));
            Assertions.assertEquals((int)5, (int)resultSet.getInt(2));
            Assertions.assertEquals((int)3, (int)resultSet.getInt(3));
            Assertions.assertEquals((int)1, (int)resultSet.getInt(4));
            Assertions.assertEquals((int)1, (int)resultSet.getInt(5));
            Assertions.assertEquals((int)1, (int)resultSet.getInt(6));
            Assertions.assertEquals((int)9126, (int)resultSet.getInt(7));
            for (i = 8; i < 13; ++i) {
                finalI = i;
                ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getInt(finalI), (String)("Failing on " + i));
                Assertions.assertEquals((int)200038, (int)ex.getErrorCode());
            }
            Assertions.assertTrue((boolean)resultSet.next());
            for (i = 5; i < 7; ++i) {
                finalI = i;
                ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getInt(finalI), (String)("Failing on " + i));
                Assertions.assertEquals((int)200038, (int)ex.getErrorCode());
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetLong(String queryResultFormat) throws SQLException {
        try (ResultSet resultSet = this.numberCrossTesting(queryResultFormat);){
            SQLException ex;
            int finalI;
            int i;
            Assertions.assertTrue((boolean)resultSet.next());
            for (i = 1; i < 13; ++i) {
                Assertions.assertEquals((long)0L, (long)resultSet.getLong(i));
            }
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertEquals((long)2L, (long)resultSet.getLong(1));
            Assertions.assertEquals((long)5L, (long)resultSet.getLong(2));
            Assertions.assertEquals((long)3L, (long)resultSet.getLong(3));
            Assertions.assertEquals((long)1L, (long)resultSet.getLong(4));
            Assertions.assertEquals((long)1L, (long)resultSet.getLong(5));
            Assertions.assertEquals((long)1L, (long)resultSet.getLong(6));
            Assertions.assertEquals((long)9126L, (long)resultSet.getLong(7));
            for (i = 8; i < 13; ++i) {
                finalI = i;
                ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getLong(finalI), (String)("Failing on " + i));
                Assertions.assertEquals((int)200038, (int)ex.getErrorCode());
            }
            Assertions.assertTrue((boolean)resultSet.next());
            for (i = 5; i < 7; ++i) {
                finalI = i;
                ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getLong(finalI), (String)("Failing on " + i));
                Assertions.assertEquals((int)200038, (int)ex.getErrorCode());
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetFloat(String queryResultFormat) throws SQLException {
        try (ResultSet resultSet = this.numberCrossTesting(queryResultFormat);){
            SQLException ex;
            int finalI;
            int i;
            Assertions.assertTrue((boolean)resultSet.next());
            for (i = 1; i < 13; ++i) {
                Assertions.assertEquals((double)0.0, (double)resultSet.getFloat(i), (double)0.1);
            }
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertEquals((double)2.0, (double)resultSet.getFloat(1), (double)0.1);
            Assertions.assertEquals((double)5.0, (double)resultSet.getFloat(2), (double)0.1);
            Assertions.assertEquals((double)3.5, (double)resultSet.getFloat(3), (double)0.1);
            Assertions.assertEquals((double)1.0, (double)resultSet.getFloat(4), (double)0.1);
            Assertions.assertEquals((double)1.0, (double)resultSet.getFloat(5), (double)0.1);
            Assertions.assertEquals((double)1.0, (double)resultSet.getFloat(6), (double)0.1);
            Assertions.assertEquals((double)9126.0, (double)resultSet.getFloat(7), (double)0.1);
            for (i = 8; i < 13; ++i) {
                finalI = i;
                ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getFloat(finalI), (String)("Failing on " + i));
                Assertions.assertEquals((int)200038, (int)ex.getErrorCode());
            }
            Assertions.assertTrue((boolean)resultSet.next());
            for (i = 5; i < 7; ++i) {
                finalI = i;
                ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getFloat(finalI), (String)("Failing on " + i));
                Assertions.assertEquals((int)200038, (int)ex.getErrorCode());
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetDouble(String queryResultFormat) throws SQLException {
        try (ResultSet resultSet = this.numberCrossTesting(queryResultFormat);){
            SQLException ex;
            int finalI;
            int i;
            Assertions.assertTrue((boolean)resultSet.next());
            for (i = 1; i < 13; ++i) {
                Assertions.assertEquals((double)0.0, (double)resultSet.getDouble(i), (double)0.1);
            }
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertEquals((double)2.0, (double)resultSet.getDouble(1), (double)0.1);
            Assertions.assertEquals((double)5.0, (double)resultSet.getDouble(2), (double)0.1);
            Assertions.assertEquals((double)3.5, (double)resultSet.getDouble(3), (double)0.1);
            Assertions.assertEquals((double)1.0, (double)resultSet.getDouble(4), (double)0.1);
            Assertions.assertEquals((double)1.0, (double)resultSet.getDouble(5), (double)0.1);
            Assertions.assertEquals((double)1.0, (double)resultSet.getDouble(6), (double)0.1);
            Assertions.assertEquals((double)9126.0, (double)resultSet.getDouble(7), (double)0.1);
            for (i = 8; i < 13; ++i) {
                finalI = i;
                ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getDouble(finalI), (String)("Failing on " + i));
                Assertions.assertEquals((int)200038, (int)ex.getErrorCode());
            }
            Assertions.assertTrue((boolean)resultSet.next());
            for (i = 5; i < 7; ++i) {
                finalI = i;
                ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getDouble(finalI), (String)("Failing on " + i));
                Assertions.assertEquals((int)200038, (int)ex.getErrorCode());
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetBigDecimal(String queryResultFormat) throws SQLException {
        try (Statement statement = this.createStatement(queryResultFormat);){
            statement.execute("create or replace table test_get(colA number(38,9))");
            try (PreparedStatement preparedStatement = connection.prepareStatement("insert into test_get values(?)");){
                BigDecimal bigDecimal1 = new BigDecimal("10000000000");
                preparedStatement.setBigDecimal(1, bigDecimal1);
                preparedStatement.executeUpdate();
                BigDecimal bigDecimal2 = new BigDecimal("100000000.123456789");
                preparedStatement.setBigDecimal(1, bigDecimal2);
                preparedStatement.execute();
                statement.execute("select * from test_get order by 1");
                try (ResultSet resultSet = statement.getResultSet();){
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)bigDecimal2, (Object)resultSet.getBigDecimal(1));
                    Assertions.assertEquals((Object)bigDecimal2, (Object)resultSet.getBigDecimal("COLA"));
                }
            }
            statement.execute("drop table if exists test_get");
        }
        try (ResultSet resultSet = this.numberCrossTesting(queryResultFormat);){
            SQLException ex;
            int i;
            Assertions.assertTrue((boolean)resultSet.next());
            for (i = 1; i < 13; ++i) {
                Assertions.assertNull((Object)resultSet.getBigDecimal(i));
            }
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertEquals((Object)new BigDecimal(2), (Object)resultSet.getBigDecimal(1));
            Assertions.assertEquals((Object)new BigDecimal(5), (Object)resultSet.getBigDecimal(2));
            Assertions.assertEquals((Object)new BigDecimal(3.5), (Object)resultSet.getBigDecimal(3));
            Assertions.assertEquals((Object)new BigDecimal(1), (Object)resultSet.getBigDecimal(4));
            Assertions.assertEquals((Object)new BigDecimal(1), (Object)resultSet.getBigDecimal(5));
            Assertions.assertEquals((Object)new BigDecimal(1), (Object)resultSet.getBigDecimal(6));
            Assertions.assertEquals((Object)new BigDecimal(9126), (Object)resultSet.getBigDecimal(7));
            for (i = 8; i < 13; ++i) {
                int finalI = i;
                ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getBigDecimal(finalI), (String)("Failing on " + i));
                Assertions.assertEquals((int)200038, (int)ex.getErrorCode());
            }
            Assertions.assertTrue((boolean)resultSet.next());
            for (i = 5; i < 7; ++i) {
                int finalI = i;
                ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getBigDecimal(finalI), (String)("Failing on " + i));
                Assertions.assertEquals((int)200038, (int)ex.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetBigDecimalNegative(String queryResultFormat) throws SQLException {
        try (Statement statement = this.createStatement(queryResultFormat);){
            try {
                statement.execute("create or replace table test_dec(colA time)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into test_dec values(?)");){
                    Time time = new Time(System.currentTimeMillis());
                    preparedStatement.setTime(1, time);
                    preparedStatement.executeUpdate();
                    statement.execute("select * from test_dec order by 1");
                    try (ResultSet resultSet = statement.getResultSet();){
                        Assertions.assertTrue((boolean)resultSet.next());
                        SQLException ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getBigDecimal(2, 38));
                        Assertions.assertEquals((int)200032, (int)ex.getErrorCode());
                    }
                }
            }
            finally {
                statement.execute("drop table if exists test_dec");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testCursorPosition(String queryResultFormat) throws SQLException {
        try (Statement statement = this.createStatement(queryResultFormat);){
            statement.execute("select * from test_rs");
            try (ResultSet resultSet = statement.getResultSet();){
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertTrue((boolean)resultSet.isFirst());
                Assertions.assertEquals((int)1, (int)resultSet.getRow());
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertFalse((boolean)resultSet.isFirst());
                Assertions.assertEquals((int)2, (int)resultSet.getRow());
                Assertions.assertFalse((boolean)resultSet.isLast());
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((int)3, (int)resultSet.getRow());
                Assertions.assertTrue((boolean)resultSet.isLast());
                Assertions.assertFalse((boolean)resultSet.next());
                Assertions.assertTrue((boolean)resultSet.isAfterLast());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetBytes(String queryResultFormat) throws SQLException {
        Properties props = new Properties();
        try (Connection connection = this.init(props, queryResultFormat);
             Statement statement = connection.createStatement();){
            try {
                this.ingestBinaryTestData(connection);
                try (ResultSet resultSet = statement.executeQuery("select * from bin");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertArrayEquals((byte[])byteArrayTestCase1, (byte[])resultSet.getBytes(1));
                    Assertions.assertEquals((Object)"", (Object)resultSet.getString(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertArrayEquals((byte[])byteArrayTestCase2, (byte[])resultSet.getBytes(1));
                    Assertions.assertEquals((Object)"ABCD12", (Object)resultSet.getString(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertArrayEquals((byte[])byteArrayTestCase3, (byte[])resultSet.getBytes(1));
                    Assertions.assertEquals((Object)"00FF4201", (Object)resultSet.getString(1));
                }
            }
            finally {
                statement.execute("drop table if exists bin");
            }
        }
    }

    private void ingestBinaryTestData(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("create or replace table bin (b Binary)");
            try (PreparedStatement prepStatement = connection.prepareStatement("insert into bin values (?), (?), (?)");){
                prepStatement.setBytes(1, byteArrayTestCase1);
                prepStatement.setBytes(2, byteArrayTestCase2);
                prepStatement.setBytes(3, byteArrayTestCase3);
                prepStatement.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetBytesInBase64(String queryResultFormat) throws Exception {
        Properties props = new Properties();
        props.setProperty("binary_output_format", "BAse64");
        try (Connection connection = this.init(props, queryResultFormat);
             Statement statement = connection.createStatement();){
            try {
                this.ingestBinaryTestData(connection);
                try (ResultSet resultSet = statement.executeQuery("select * from bin");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertArrayEquals((byte[])byteArrayTestCase1, (byte[])resultSet.getBytes(1));
                    Assertions.assertEquals((Object)"", (Object)resultSet.getString(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertArrayEquals((byte[])byteArrayTestCase2, (byte[])resultSet.getBytes(1));
                    Assertions.assertEquals((Object)"q80S", (Object)resultSet.getString(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertArrayEquals((byte[])byteArrayTestCase3, (byte[])resultSet.getBytes(1));
                    Assertions.assertEquals((Object)"AP9CAQ==", (Object)resultSet.getString(1));
                }
            }
            finally {
                statement.execute("drop table if exists bin");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testColumnMetaWithZeroPrecision(String queryResultFormat) throws SQLException {
        try (Statement statement = this.createStatement(queryResultFormat);){
            try {
                statement.execute("create or replace table testColDecimal(cola number(38, 0), colb number(17, 5))");
                try (ResultSet resultSet = statement.executeQuery("select * from testColDecimal");){
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    MatcherAssert.assertThat((Object)resultSetMetaData.getColumnType(1), (Matcher)CoreMatchers.is((Object)-5));
                    MatcherAssert.assertThat((Object)resultSetMetaData.getColumnType(2), (Matcher)CoreMatchers.is((Object)3));
                    MatcherAssert.assertThat((Object)resultSetMetaData.isSigned(1), (Matcher)CoreMatchers.is((Object)true));
                    MatcherAssert.assertThat((Object)resultSetMetaData.isSigned(2), (Matcher)CoreMatchers.is((Object)true));
                }
            }
            finally {
                statement.execute("drop table if exists testColDecimal");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetObjectOnFixedView(String queryResultFormat) throws Exception {
        try (Statement statement = this.createStatement(queryResultFormat);){
            try {
                statement.execute("create or replace table testFixedView(C1 STRING NOT NULL COMMENT 'JDBC', C2 STRING, C3 STRING, C4 STRING, C5 STRING, C6 STRING, C7 STRING, C8 STRING, C9 STRING) stage_file_format = (field_delimiter='|' error_on_column_count_mismatch=false)");
                Assertions.assertTrue((boolean)statement.execute("PUT file://" + ResultSetIT.getFullPathFileInResource("orders_100.csv") + " @%testFixedView"), (String)"Failed to put a file");
                try (ResultSet resultSet = statement.executeQuery("PUT file://" + ResultSetIT.getFullPathFileInResource("orders_101.csv") + " @%testFixedView");){
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    while (resultSet.next()) {
                        for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                            Assertions.assertNotNull((Object)resultSet.getObject(i + 1));
                        }
                    }
                }
            }
            finally {
                statement.execute("drop table if exists testFixedView");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testGetColumnDisplaySizeAndPrecision(String queryResultFormat) throws SQLException {
        ResultSetMetaData resultSetMetaData = null;
        try (Statement statement = this.createStatement(queryResultFormat);){
            try (ResultSet resultSet = statement.executeQuery("select cast(1 as char)");){
                resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((int)1, (int)resultSetMetaData.getColumnDisplaySize(1));
                Assertions.assertEquals((int)1, (int)resultSetMetaData.getPrecision(1));
            }
            resultSet = statement.executeQuery("select cast(1 as number(38, 0))");
            try {
                resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((int)39, (int)resultSetMetaData.getColumnDisplaySize(1));
                Assertions.assertEquals((int)38, (int)resultSetMetaData.getPrecision(1));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = statement.executeQuery("select cast(1 as decimal(25, 15))");
            try {
                resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((int)27, (int)resultSetMetaData.getColumnDisplaySize(1));
                Assertions.assertEquals((int)25, (int)resultSetMetaData.getPrecision(1));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = statement.executeQuery("select cast(1 as string)");
            try {
                resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((int)1, (int)resultSetMetaData.getColumnDisplaySize(1));
                Assertions.assertEquals((int)1, (int)resultSetMetaData.getPrecision(1));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = statement.executeQuery("select cast(1 as string(30))");
            try {
                resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((int)1, (int)resultSetMetaData.getColumnDisplaySize(1));
                Assertions.assertEquals((int)1, (int)resultSetMetaData.getPrecision(1));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = statement.executeQuery("select to_date('2016-12-13', 'YYYY-MM-DD')");
            try {
                resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((int)10, (int)resultSetMetaData.getColumnDisplaySize(1));
                Assertions.assertEquals((int)10, (int)resultSetMetaData.getPrecision(1));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            resultSet = statement.executeQuery("select to_time('12:34:56', 'HH24:MI:SS')");
            try {
                resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((int)8, (int)resultSetMetaData.getColumnDisplaySize(1));
                Assertions.assertEquals((int)8, (int)resultSetMetaData.getPrecision(1));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetBoolean(String queryResultFormat) throws SQLException {
        try (Statement statement = this.createStatement(queryResultFormat);){
            statement.execute("create or replace table testBoolean(cola boolean)");
            statement.execute("insert into testBoolean values(false)");
            try (ResultSet resultSet = statement.executeQuery("select * from testBoolean");){
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertFalse((boolean)resultSet.getBoolean(1));
            }
            statement.execute("insert into testBoolean values(true)");
            resultSet = statement.executeQuery("select * from testBoolean");
            try {
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertFalse((boolean)resultSet.getBoolean(1));
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertTrue((boolean)resultSet.getBoolean(1));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            statement.execute("drop table if exists testBoolean");
            statement.execute("create or replace table test_types(c1 number, c2 integer,  c3 varchar, c4 char, c5 boolean, c6 float, c7 binary, c8 date, c9 datetime, c10 time, c11 timestamp_ltz, c12 timestamp_tz)");
            statement.execute("insert into test_types values (null, null, null, null, null, null, null, null, null, null, null, null)");
            statement.execute("insert into test_types (c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12) values(1, 1, '1','1', true, 1.0, '48454C4C4F', '1994-12-27', '1994-12-27 05:05:05', '05:05:05', '1994-12-27 05:05:05 +00:05', '1994-12-27 05:05:05')");
            statement.execute("insert into test_types (c1, c2, c3, c4) values(2, 3, '4', '5')");
            resultSet = statement.executeQuery("select * from test_types");
            try {
                SQLException ex;
                int finalI;
                int i;
                Assertions.assertTrue((boolean)resultSet.next());
                for (i = 1; i < 13; ++i) {
                    Assertions.assertFalse((boolean)resultSet.getBoolean(i));
                }
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertTrue((boolean)resultSet.getBoolean(1));
                Assertions.assertTrue((boolean)resultSet.getBoolean(2));
                Assertions.assertTrue((boolean)resultSet.getBoolean(3));
                Assertions.assertTrue((boolean)resultSet.getBoolean(4));
                Assertions.assertTrue((boolean)resultSet.getBoolean(5));
                for (i = 6; i < 13; ++i) {
                    finalI = i;
                    ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getBoolean(finalI), (String)("Failing on " + i));
                    Assertions.assertEquals((int)200038, (int)ex.getErrorCode());
                }
                Assertions.assertTrue((boolean)resultSet.next());
                for (i = 1; i < 5; ++i) {
                    finalI = i;
                    ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getBoolean(finalI), (String)("Failing on " + i));
                    Assertions.assertEquals((int)200038, (int)ex.getErrorCode());
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetClob(String queryResultFormat) throws Throwable {
        try (Statement statement = this.createStatement(queryResultFormat);){
            statement.execute("create or replace table testClob(cola text)");
            statement.execute("insert into testClob values('hello world')");
            statement.execute("insert into testClob values('hello world1')");
            statement.execute("insert into testClob values('hello world2')");
            statement.execute("insert into testClob values('hello world3')");
            try (ResultSet resultSet = statement.executeQuery("select * from testClob");){
                Assertions.assertTrue((boolean)resultSet.next());
                char[] chars = new char[100];
                Reader reader = resultSet.getClob(1).getCharacterStream();
                int charRead = reader.read(chars, 0, chars.length);
                Assertions.assertEquals((int)charRead, (int)11);
                Assertions.assertEquals((Object)"hello world", (Object)resultSet.getClob(1).toString());
                Assertions.assertTrue((boolean)resultSet.next());
                Clob clob = resultSet.getClob(1);
                Assertions.assertEquals((long)clob.length(), (long)12L);
                clob.truncate(5L);
                reader = clob.getCharacterStream();
                charRead = reader.read(chars, 0, chars.length);
                Assertions.assertEquals((int)charRead, (int)5);
                Assertions.assertTrue((boolean)resultSet.next());
                InputStream input = resultSet.getClob(1).getAsciiStream();
                InputStreamReader in = new InputStreamReader(input, StandardCharsets.UTF_8);
                charRead = ((Reader)in).read(chars, 0, chars.length);
                Assertions.assertEquals((int)charRead, (int)12);
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testFetchOnClosedResultSet(String queryResultFormat) throws SQLException {
        try (Statement statement = this.createStatement(queryResultFormat);){
            ResultSet resultSet = statement.executeQuery("select * from test_rs");
            Assertions.assertFalse((boolean)resultSet.isClosed());
            resultSet.close();
            Assertions.assertTrue((boolean)resultSet.isClosed());
            Assertions.assertFalse((boolean)resultSet.next());
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testReleaseDownloaderCurrentMemoryUsage(String queryResultFormat) throws SQLException {
        long initialMemoryUsage = SnowflakeChunkDownloader.getCurrentMemoryUsage();
        try (Statement statement = this.createStatement(queryResultFormat);){
            statement.executeQuery("select current_date(), true,2345234, 2343.0, 'testrgint\\n\\t' from table(generator(rowcount=>1000000))");
            MatcherAssert.assertThat((String)"hold memory usage for the resultSet before close", (SnowflakeChunkDownloader.getCurrentMemoryUsage() - initialMemoryUsage >= 0L ? 1 : 0) != 0);
        }
        MatcherAssert.assertThat((String)"closing statement didn't release memory allocated for result", (Object)SnowflakeChunkDownloader.getCurrentMemoryUsage(), (Matcher)CoreMatchers.equalTo((Object)initialMemoryUsage));
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testResultColumnSearchCaseSensitiveOld(String queryResultFormat) throws Exception {
        this.subTestResultColumnSearchCaseSensitive("JDBC_RS_COLUMN_CASE_INSENSITIVE", queryResultFormat);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testResultColumnSearchCaseSensitive(String queryResultFormat) throws Exception {
        this.subTestResultColumnSearchCaseSensitive("CLIENT_RESULT_COLUMN_CASE_INSENSITIVE", queryResultFormat);
    }

    private void subTestResultColumnSearchCaseSensitive(String parameterName, String queryResultFormat) throws Exception {
        Properties prop = new Properties();
        prop.put("tracing", "FINEST");
        try (Connection connection = this.init(prop, queryResultFormat);
             Statement statement = connection.createStatement();){
            try (ResultSet resultSet = statement.executeQuery("select 1 AS TESTCOL");){
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((Object)"1", (Object)resultSet.getString("TESTCOL"));
                Assertions.assertEquals((Object)"1", (Object)resultSet.getString("TESTCOL"));
                SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getString("testcol"));
                Assertions.assertEquals((Object)"Column not found: testcol", (Object)e.getMessage());
            }
            statement.executeQuery(String.format("alter session set %s=true", parameterName));
            resultSet = statement.executeQuery("select 1 AS TESTCOL");
            try {
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((Object)"1", (Object)resultSet.getString("TESTCOL"));
                Assertions.assertEquals((Object)"1", (Object)resultSet.getString("TESTCOL"));
                Assertions.assertEquals((Object)"1", (Object)resultSet.getString("testcol"));
                Assertions.assertEquals((Object)"1", (Object)resultSet.getString("testcol"));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testInvalidColumnIndex(String queryResultFormat) throws SQLException {
        try (Statement statement = this.createStatement(queryResultFormat);
             ResultSet resultSet = statement.executeQuery("select * from test_rs");){
            Assertions.assertTrue((boolean)resultSet.next());
            SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getString(0));
            Assertions.assertEquals((int)200032, (int)e.getErrorCode());
            e = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getString(2));
            Assertions.assertEquals((int)200032, (int)e.getErrorCode());
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testWasNull(String queryResultFormat) throws Exception {
        try (ResultSet ret = this.createStatement(queryResultFormat).executeQuery("select cast(1/nullif(0,0) as double),cast(1/nullif(0,0) as int), 100, cast(1/nullif(0,0) as number(8,2))");){
            Assertions.assertTrue((boolean)ret.next());
            MatcherAssert.assertThat((String)"Double value cannot be null", (Object)ret.getDouble(1), (Matcher)CoreMatchers.equalTo((Object)0.0));
            MatcherAssert.assertThat((String)"wasNull should be true", (boolean)ret.wasNull());
            MatcherAssert.assertThat((String)"Integer value cannot be null", (Object)ret.getInt(2), (Matcher)CoreMatchers.equalTo((Object)0));
            MatcherAssert.assertThat((String)"wasNull should be true", (boolean)ret.wasNull());
            MatcherAssert.assertThat((String)"Non null column", (Object)ret.getInt(3), (Matcher)CoreMatchers.equalTo((Object)100));
            MatcherAssert.assertThat((String)"wasNull should be false", (!ret.wasNull() ? 1 : 0) != 0);
            MatcherAssert.assertThat((String)"BigDecimal value must be null", (Object)ret.getBigDecimal(4), (Matcher)CoreMatchers.nullValue());
            MatcherAssert.assertThat((String)"wasNull should be true", (boolean)ret.wasNull());
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testParseInfAndNaNNumber(String queryResultFormat) throws Exception {
        try (Statement statement = this.createStatement(queryResultFormat);){
            try (ResultSet ret = statement.executeQuery("select to_double('inf'), to_double('-inf')");){
                Assertions.assertTrue((boolean)ret.next());
                MatcherAssert.assertThat((String)"Positive Infinite Number", (Object)ret.getDouble(1), (Matcher)CoreMatchers.equalTo((Object)Double.POSITIVE_INFINITY));
                MatcherAssert.assertThat((String)"Negative Infinite Number", (Object)ret.getDouble(2), (Matcher)CoreMatchers.equalTo((Object)Double.NEGATIVE_INFINITY));
                MatcherAssert.assertThat((String)"Positive Infinite Number", (Object)Float.valueOf(ret.getFloat(1)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(Float.POSITIVE_INFINITY)));
                MatcherAssert.assertThat((String)"Negative Infinite Number", (Object)Float.valueOf(ret.getFloat(2)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(Float.NEGATIVE_INFINITY)));
            }
            ret = statement.executeQuery("select to_double('nan')");
            try {
                Assertions.assertTrue((boolean)ret.next());
                MatcherAssert.assertThat((String)"Parse NaN", (Object)ret.getDouble(1), (Matcher)CoreMatchers.equalTo((Object)Double.NaN));
                MatcherAssert.assertThat((String)"Parse NaN", (Object)Float.valueOf(ret.getFloat(1)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(Float.NaN)));
            }
            finally {
                if (ret != null) {
                    ret.close();
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testTreatDecimalAsInt(String queryResultFormat) throws Exception {
        try (Statement statement = this.createStatement(queryResultFormat);){
            ResultSetMetaData metaData;
            try (ResultSet ret = statement.executeQuery("select 1");){
                metaData = ret.getMetaData();
                MatcherAssert.assertThat((Object)metaData.getColumnType(1), (Matcher)CoreMatchers.equalTo((Object)-5));
            }
            statement.execute("alter session set jdbc_treat_decimal_as_int = false");
            ret = statement.executeQuery("select 1");
            try {
                metaData = ret.getMetaData();
                MatcherAssert.assertThat((Object)metaData.getColumnType(1), (Matcher)CoreMatchers.equalTo((Object)3));
            }
            finally {
                if (ret != null) {
                    ret.close();
                }
            }
            statement.execute("alter session set jdbc_treat_decimal_as_int = true");
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testIsLast(String queryResultFormat) throws Exception {
        try (Statement statement = this.createStatement(queryResultFormat);){
            try (ResultSet ret = statement.executeQuery("select * from orders_jdbc");){
                Assertions.assertTrue((boolean)ret.isBeforeFirst(), (String)"should be before the first");
                Assertions.assertFalse((boolean)ret.isFirst(), (String)"should not be the first");
                Assertions.assertTrue((boolean)ret.next());
                Assertions.assertFalse((boolean)ret.isBeforeFirst(), (String)"should not be before the first");
                Assertions.assertTrue((boolean)ret.isFirst(), (String)"should be the first");
                int cnt = 0;
                while (ret.next()) {
                    if (++cnt != 72) continue;
                    Assertions.assertTrue((boolean)ret.isLast(), (String)"should be the last");
                    Assertions.assertFalse((boolean)ret.isAfterLast(), (String)"should not be after the last");
                }
                Assertions.assertEquals((int)72, (int)cnt);
                Assertions.assertFalse((boolean)ret.next());
                Assertions.assertFalse((boolean)ret.isLast(), (String)"should not be the last");
                Assertions.assertTrue((boolean)ret.isAfterLast(), (String)"should be afterthe last");
            }
            ret = statement.executeQuery("PUT file://" + ResultSetIT.getFullPathFileInResource("orders_100.csv") + " @~");
            try {
                Assertions.assertTrue((boolean)ret.isBeforeFirst(), (String)"should be before the first");
                Assertions.assertFalse((boolean)ret.isFirst(), (String)"should not be the first");
                Assertions.assertTrue((boolean)ret.next());
                Assertions.assertFalse((boolean)ret.isBeforeFirst(), (String)"should not be before the first");
                Assertions.assertTrue((boolean)ret.isFirst(), (String)"should be the first");
                Assertions.assertTrue((boolean)ret.isLast(), (String)"should be the last");
                Assertions.assertFalse((boolean)ret.isAfterLast(), (String)"should not be after the last");
                Assertions.assertFalse((boolean)ret.next());
                Assertions.assertFalse((boolean)ret.isLast(), (String)"should not be the last");
                Assertions.assertTrue((boolean)ret.isAfterLast(), (String)"should be after the last");
            }
            finally {
                if (ret != null) {
                    ret.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testUpdateCountOnCopyCmd(String queryResultFormat) throws Exception {
        try (Statement statement = this.createStatement(queryResultFormat);){
            try {
                statement.execute("create or replace table testcopy(cola string)");
                int rowCount = statement.executeUpdate("copy into testcopy");
                MatcherAssert.assertThat((Object)rowCount, (Matcher)CoreMatchers.is((Object)0));
                statement.execute("copy into @%testcopy from (select 'test_string')");
                rowCount = statement.executeUpdate("copy into testcopy");
                MatcherAssert.assertThat((Object)rowCount, (Matcher)CoreMatchers.is((Object)1));
            }
            finally {
                statement.execute("drop table if exists testcopy");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetTimeNullTimestampAndTimestampNullTime(String queryResultFormat) throws Throwable {
        try (Statement statement = this.createStatement(queryResultFormat);){
            try {
                statement.execute("create or replace table testnullts(c1 timestamp, c2 time)");
                statement.execute("insert into testnullts(c1, c2) values(null, null)");
                try (ResultSet rs = statement.executeQuery("select * from testnullts");){
                    Assertions.assertTrue((boolean)rs.next(), (String)"should return result");
                    Assertions.assertNull((Object)rs.getTime(1), (String)"return value must be null");
                    Assertions.assertNull((Object)rs.getTimestamp(2), (String)"return value must be null");
                }
            }
            finally {
                statement.execute("drop table if exists testnullts");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testNextNegative(String queryResultFormat) throws SQLException {
        try (ResultSet rs = this.createStatement(queryResultFormat).executeQuery("select 1");){
            Assertions.assertTrue((boolean)rs.next());
            System.setProperty("snowflake.enable_incident_test2", "true");
            SQLException ex = (SQLException)Assertions.assertThrows(SQLException.class, rs::next);
            Assertions.assertEquals((int)200014, (int)ex.getErrorCode());
            System.setProperty("snowflake.enable_incident_test2", "false");
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void shouldSerializeArrayAndObjectAsStringOnGetObject(String queryResultFormat) throws SQLException {
        try (Statement statement = this.createStatement(queryResultFormat);
             ResultSet resultSet = statement.executeQuery("select ARRAY_CONSTRUCT(1,2,3), OBJECT_CONSTRUCT('a', 4, 'b', 'test')");){
            Assertions.assertTrue((boolean)resultSet.next());
            String expectedArrayAsString = "[\n  1,\n  2,\n  3\n]";
            Assertions.assertEquals((Object)expectedArrayAsString, (Object)resultSet.getObject(1));
            Assertions.assertEquals((Object)expectedArrayAsString, (Object)resultSet.getString(1));
            String expectedObjectAsString = "{\n  \"a\": 4,\n  \"b\": \"test\"\n}";
            Assertions.assertEquals((Object)expectedObjectAsString, (Object)resultSet.getObject(2));
            Assertions.assertEquals((Object)expectedObjectAsString, (Object)resultSet.getString(2));
        }
    }
}

