/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.providers.SimpleResultFormatProvider;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="arrow")
public class ResultSetJsonVsArrowIT
extends BaseJDBCTest {
    public Connection init(String queryResultFormat) throws SQLException {
        Connection conn = ResultSetJsonVsArrowIT.getConnection(0);
        try (Statement stmt = conn.createStatement();){
            stmt.execute("alter session set jdbc_query_result_format = '" + queryResultFormat + "'");
        }
        return conn;
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGSResult(String queryResultFormat) throws SQLException {
        try (Connection con = this.init(queryResultFormat);
             Statement statement = con.createStatement();
             ResultSet rs = statement.executeQuery("select 1, 128, 65500, 10000000000000, 1000000000000000000000000000000000000, NULL, current_timestamp, current_timestamp(0), current_timestamp(5),current_date, current_time, current_time(0), current_time(5);");){
            Assertions.assertTrue((boolean)rs.next());
            Assertions.assertEquals((byte)1, (byte)rs.getByte(1));
            Assertions.assertEquals((short)128, (short)rs.getShort(2));
            Assertions.assertEquals((int)65500, (int)rs.getInt(3));
            Assertions.assertEquals((long)10000000000000L, (long)rs.getLong(4));
            Assertions.assertEquals((Object)new BigDecimal("1000000000000000000000000000000000000"), (Object)rs.getBigDecimal(5));
            Assertions.assertNull((Object)rs.getString(6));
            Assertions.assertNotNull((Object)rs.getTimestamp(7));
            Assertions.assertNotNull((Object)rs.getTimestamp(8));
            Assertions.assertNotNull((Object)rs.getTimestamp(9));
            Assertions.assertNotNull((Object)rs.getDate(10));
            Assertions.assertNotNull((Object)rs.getTime(11));
            Assertions.assertNotNull((Object)rs.getTime(12));
            Assertions.assertNotNull((Object)rs.getTime(13));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGSResultReal(String queryResultFormat) throws SQLException {
        try (Connection con = this.init(queryResultFormat);
             Statement statement = con.createStatement();){
            try {
                statement.execute("create or replace table t (a real)");
                statement.execute("insert into t values (123.456)");
                try (ResultSet rs = statement.executeQuery("select * from t;");){
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((double)123.456, (double)rs.getFloat(1), (double)0.001);
                }
            }
            finally {
                statement.execute("drop table if exists t");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGSResultScan(String queryResultFormat) throws SQLException {
        String queryId = null;
        try (Connection con = this.init(queryResultFormat);
             Statement statement = con.createStatement();){
            try {
                statement.execute("create or replace table t (a text)");
                statement.execute("insert into t values ('test')");
                try (ResultSet rs = statement.executeQuery("select count(*) from t;");){
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((int)1, (int)rs.getInt(1));
                    queryId = rs.unwrap(SnowflakeResultSet.class).getQueryID();
                }
                rs = statement.executeQuery("select * from table(result_scan('" + queryId + "'))");
                try {
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((int)1, (int)rs.getInt(1));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists t");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGSResultForEmptyAndSmallTable(String queryResultFormat) throws SQLException {
        try (Connection con = this.init(queryResultFormat);
             Statement statement = con.createStatement();){
            try {
                statement.execute("create or replace table t (a int)");
                try (ResultSet rs = statement.executeQuery("select * from t;");){
                    Assertions.assertFalse((boolean)rs.next());
                }
                statement.execute("insert into t values (1)");
                rs = statement.executeQuery("select * from t;");
                try {
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((int)1, (int)rs.getInt(1));
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                statement.execute("drop table if exists t");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testSNOW89737(String queryResultFormat) throws SQLException {
        try (Connection con = this.init(queryResultFormat);
             Statement statement = con.createStatement();){
            try {
                statement.execute("create or replace table test_types(c1 number, c2 integer, c3 float, c4 varchar, c5 char, c6 binary, c7 boolean, c8 date, c9 datetime, c10 time, c11 timestamp_ltz, c12 timestamp_tz, c13 variant, c14 object, c15 array)");
                statement.execute("insert into test_types values (null, null, null, null, null, null, null, null, null, null, null, null, null, null, null)");
                statement.execute("insert into test_types (c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12) values(5, 5, 5.0,'hello', 'h', '48454C4C4F', true, '1994-12-27', '1994-12-27 05:05:05', '05:05:05', '1994-12-27 05:05:05 +00:05', '1994-12-27 05:05:05')");
                statement.execute("insert into test_types(c13) select parse_json(' { \"key1\\x00\":\"value1\" } ')");
                statement.execute("insert into test_types(c14) select parse_json(' { \"key1\\x00\":\"value1\" } ')");
                statement.execute("insert into test_types(c15) select parse_json('{\"fruits\" : [\"apples\", \"pears\", \"oranges\"]}')");
                ResultSet resultSet = statement.executeQuery("select * from test_types");
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals(null, (Object)resultSet.getString(1));
                Assertions.assertEquals(null, (Object)resultSet.getString(2));
                Assertions.assertEquals(null, (Object)resultSet.getString(3));
                Assertions.assertEquals(null, (Object)resultSet.getString(4));
                Assertions.assertEquals(null, (Object)resultSet.getString(5));
                Assertions.assertEquals(null, (Object)resultSet.getString(6));
                Assertions.assertEquals(null, (Object)resultSet.getString(7));
                Assertions.assertEquals(null, (Object)resultSet.getString(8));
                Assertions.assertEquals(null, (Object)resultSet.getString(9));
                Assertions.assertEquals(null, (Object)resultSet.getString(10));
                Assertions.assertEquals(null, (Object)resultSet.getString(11));
                Assertions.assertEquals(null, (Object)resultSet.getString(12));
                Assertions.assertEquals(null, (Object)resultSet.getString(13));
                Assertions.assertEquals(null, (Object)resultSet.getString(14));
                Assertions.assertEquals(null, (Object)resultSet.getString(15));
            }
            finally {
                statement.execute("drop table if exists t");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testSemiStructuredData(String queryResultFormat) throws SQLException {
        try (Connection con = this.init(queryResultFormat);
             Statement statement = con.createStatement();
             ResultSet rs = statement.executeQuery("select array_construct(10, 20, 30), array_construct(null, 'hello', 3::double, 4, 5), array_construct(), object_construct('a',1,'b','BBBB', 'c',null),object_construct('Key_One', parse_json('NULL'), 'Key_Two', null, 'Key_Three', 'null'),to_variant(3.2),parse_json('{ \"a\": null}'), 100::variant;");){
            while (rs.next()) {
                Assertions.assertEquals((Object)"[\n  10,\n  20,\n  30\n]", (Object)rs.getString(1));
                Assertions.assertEquals((Object)"[\n  undefined,\n  \"hello\",\n  3.000000000000000e+00,\n  4,\n  5\n]", (Object)rs.getString(2));
                Assertions.assertEquals((Object)"{\n  \"a\": 1,\n  \"b\": \"BBBB\"\n}", (Object)rs.getString(4));
                Assertions.assertEquals((Object)"{\n  \"Key_One\": null,\n  \"Key_Three\": \"null\"\n}", (Object)rs.getString(5));
                Assertions.assertEquals((Object)"{\n  \"a\": null\n}", (Object)rs.getString(7));
                Assertions.assertEquals((Object)"[]", (Object)rs.getString(3));
                Assertions.assertEquals((Object)"3.2", (Object)rs.getString(6));
                Assertions.assertEquals((Object)"100", (Object)rs.getString(8));
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testStructuredTypes(String queryResultFormat) throws SQLException {
        try (Connection con = this.init(queryResultFormat);
             Statement stmt = con.createStatement();){
            stmt.execute("alter session set feature_structured_types = 'ENABLED';");
            try (ResultSet rs = stmt.executeQuery("select array_construct(10, 20, 30)::array(int), object_construct_keep_null('a', 1, 'b', 'BBBB', 'c', null)::object(a int, b varchar, c int), object_construct_keep_null('k1', 'v1', 'k2', null)::map(varchar, varchar);");){
                while (rs.next()) {
                    Assertions.assertEquals((Object)"[\n  10,\n  20,\n  30\n]", (Object)rs.getString(1));
                    Assertions.assertEquals((Object)"{\n  \"a\": 1,\n  \"b\": \"BBBB\",\n  \"c\": null\n}", (Object)rs.getString(2));
                    Assertions.assertEquals((Object)"{\n  \"k1\": \"v1\",\n  \"k2\": null\n}", (Object)rs.getString(3));
                }
            }
        }
    }

    private Connection init(String queryResultFormat, String table, String column, String values) throws SQLException {
        Connection con = this.init(queryResultFormat);
        try (Statement statement = con.createStatement();){
            statement.execute("create or replace table " + table + " " + column);
            statement.execute("insert into " + table + " values " + values);
        }
        return con;
    }

    private boolean isJSON(String queryResultFormat) {
        return queryResultFormat.equalsIgnoreCase("json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testTinyInt(String queryResultFormat) throws SQLException {
        int[] cases = new int[]{0, 1, -1, 127, -128};
        String table = "test_arrow_tiny_int";
        String column = "(a int)";
        String values = "(" + StringUtils.join((Object[])ArrayUtils.toObject((int[])cases), (String)"),(") + "), (NULL)";
        try (Connection con = this.init(queryResultFormat, table, column, values);
             Statement statement = con.createStatement();
             ResultSet rs = statement.executeQuery("select * from " + table);){
            try {
                double delta = 0.1;
                int columnType = rs.getMetaData().getColumnType(1);
                Assertions.assertEquals((int)-5, (int)columnType);
                for (int i = 0; i < cases.length; ++i) {
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((int)cases[i], (int)rs.getInt(1));
                    Assertions.assertEquals((short)((short)cases[i]), (short)rs.getShort(1));
                    Assertions.assertEquals((long)cases[i], (long)rs.getLong(1));
                    Assertions.assertEquals((Object)Integer.toString(cases[i]), (Object)rs.getString(1));
                    Assertions.assertEquals((double)cases[i], (double)rs.getFloat(1), (double)delta);
                    double val = cases[i];
                    Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                    Assertions.assertEquals((Object)new BigDecimal(Integer.toString(cases[i])), (Object)rs.getBigDecimal(1));
                    Assertions.assertEquals((Object)rs.getLong(1), (Object)rs.getObject(1));
                    Assertions.assertEquals((int)cases[i], (int)rs.getByte(1));
                    byte[] bytes = new byte[]{(byte)cases[i]};
                    Assertions.assertArrayEquals((byte[])bytes, (byte[])rs.getBytes(1));
                }
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)0, (int)rs.getInt(1));
                Assertions.assertEquals((short)0, (short)rs.getShort(1));
                Assertions.assertEquals((long)0L, (long)rs.getLong(1));
                Assertions.assertNull((Object)rs.getString(1));
                Assertions.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
                double val = 0.0;
                Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                Assertions.assertNull((Object)rs.getBigDecimal(1));
                Assertions.assertNull((Object)rs.getObject(1));
                Assertions.assertEquals((int)0, (int)rs.getByte(1));
                Assertions.assertNull((Object)rs.getBytes(1));
                Assertions.assertTrue((boolean)rs.wasNull());
            }
            finally {
                statement.execute("drop table if exists " + table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testScaledTinyInt(String queryResultFormat) throws SQLException {
        float[] cases = new float[]{0.0f, 0.11f, -0.11f, 1.27f, -1.28f};
        String table = "test_arrow_tiny_int";
        String column = "(a number(3,2))";
        String values = "(" + StringUtils.join((Object[])ArrayUtils.toObject((float[])cases), (String)"),(") + "), (null)";
        try (Connection con = this.init(queryResultFormat, table, column, values);
             Statement statement = con.createStatement();
             ResultSet rs = con.createStatement().executeQuery("select * from test_arrow_tiny_int");){
            try {
                double delta = 0.001;
                int columnType = rs.getMetaData().getColumnType(1);
                Assertions.assertEquals((int)3, (int)columnType);
                for (int i = 0; i < cases.length; ++i) {
                    Assertions.assertTrue((boolean)rs.next());
                    SQLException se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getInt(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getShort(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getLong(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    Assertions.assertEquals((Object)String.format("%.2f", Float.valueOf(cases[i])), (Object)rs.getString(1));
                    Assertions.assertEquals((double)cases[i], (double)rs.getFloat(1), (double)delta);
                    double val = cases[i];
                    Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                    Assertions.assertEquals((Object)new BigDecimal(rs.getString(1)), (Object)rs.getBigDecimal(1));
                    Assertions.assertEquals((Object)rs.getBigDecimal(1), (Object)rs.getObject(1));
                    if (this.isJSON(queryResultFormat)) {
                        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> rs.getByte(1));
                        Assertions.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                    } else {
                        Assertions.assertEquals((byte)((byte)(cases[i] * 100.0f)), (byte)rs.getByte(1));
                    }
                    if (this.isJSON(queryResultFormat)) continue;
                    byte[] bytes = new byte[]{rs.getByte(1)};
                    Assertions.assertArrayEquals((byte[])bytes, (byte[])rs.getBytes(1));
                }
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)0, (int)rs.getInt(1));
                Assertions.assertEquals((short)0, (short)rs.getShort(1));
                Assertions.assertEquals((long)0L, (long)rs.getLong(1));
                Assertions.assertNull((Object)rs.getString(1));
                Assertions.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
                double val = 0.0;
                Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                Assertions.assertNull((Object)rs.getBigDecimal(1));
                Assertions.assertNull((Object)rs.getObject(1));
                Assertions.assertEquals((int)0, (int)rs.getByte(1));
                Assertions.assertNull((Object)rs.getBytes(1));
                Assertions.assertTrue((boolean)rs.wasNull());
            }
            finally {
                statement.execute("drop table if exists " + table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testSmallInt(String queryResultFormat) throws SQLException {
        short[] cases = new short[]{0, 1, -1, 127, -128, 128, -129, Short.MAX_VALUE, Short.MIN_VALUE};
        String table = "test_arrow_small_int";
        String column = "(a int)";
        String values = "(" + StringUtils.join((Object[])ArrayUtils.toObject((short[])cases), (String)"),(") + "), (NULL)";
        try (Connection con = this.init(queryResultFormat, table, column, values);
             Statement statement = con.createStatement();
             ResultSet rs = statement.executeQuery("select * from " + table);){
            try {
                double delta = 0.1;
                int columnType = rs.getMetaData().getColumnType(1);
                Assertions.assertEquals((int)-5, (int)columnType);
                for (int i = 0; i < cases.length; ++i) {
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((int)cases[i], (int)rs.getInt(1));
                    Assertions.assertEquals((short)cases[i], (short)rs.getShort(1));
                    Assertions.assertEquals((long)cases[i], (long)rs.getLong(1));
                    Assertions.assertEquals((Object)Integer.toString(cases[i]), (Object)rs.getString(1));
                    Assertions.assertEquals((double)cases[i], (double)rs.getFloat(1), (double)delta);
                    double val = cases[i];
                    Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                    Assertions.assertEquals((Object)new BigDecimal(Integer.toString(cases[i])), (Object)rs.getBigDecimal(1));
                    Assertions.assertEquals((Object)rs.getLong(1), (Object)rs.getObject(1));
                    if (cases[i] <= 127 && cases[i] >= -128) {
                        Assertions.assertEquals((short)cases[i], (short)rs.getByte(1));
                    } else {
                        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> rs.getByte(1));
                        if (this.isJSON(queryResultFormat)) {
                            Assertions.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                        } else {
                            SQLException se = (SQLException)Assertions.assertInstanceOf(SQLException.class, (Object)e);
                            Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                            Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                        }
                    }
                    ByteBuffer bb = ByteBuffer.allocate(2);
                    bb.putShort(cases[i]);
                    if (this.isJSON(queryResultFormat)) {
                        byte[] res = rs.getBytes(1);
                        for (int j = res.length - 1; j >= 0; --j) {
                            Assertions.assertEquals((byte)bb.array()[2 - res.length + j], (byte)res[j]);
                        }
                        continue;
                    }
                    Assertions.assertArrayEquals((byte[])bb.array(), (byte[])rs.getBytes(1));
                }
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)0, (int)rs.getInt(1));
                Assertions.assertEquals((short)0, (short)rs.getShort(1));
                Assertions.assertEquals((long)0L, (long)rs.getLong(1));
                Assertions.assertNull((Object)rs.getString(1));
                Assertions.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
                double val = 0.0;
                Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                Assertions.assertNull((Object)rs.getBigDecimal(1));
                Assertions.assertNull((Object)rs.getObject(1));
                Assertions.assertEquals((int)0, (int)rs.getByte(1));
                Assertions.assertNull((Object)rs.getBytes(1));
                Assertions.assertTrue((boolean)rs.wasNull());
            }
            finally {
                statement.execute("drop table if exists " + table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testScaledSmallInt(String queryResultFormat) throws SQLException {
        float[] cases = new float[]{0.0f, 2.0f, -2.0f, 32.767f, -32.768f};
        short[] shortCompact = new short[]{0, 2000, -2000, Short.MAX_VALUE, Short.MIN_VALUE};
        String table = "test_arrow_small_int";
        String column = "(a number(5,3))";
        String values = "(" + StringUtils.join((Object[])ArrayUtils.toObject((float[])cases), (String)"),(") + "), (null)";
        try (Connection con = this.init(queryResultFormat, table, column, values);
             Statement statement = con.createStatement();
             ResultSet rs = con.createStatement().executeQuery("select * from test_arrow_small_int");){
            try {
                double delta = 1.0E-4;
                int columnType = rs.getMetaData().getColumnType(1);
                Assertions.assertEquals((int)3, (int)columnType);
                for (int i = 0; i < cases.length; ++i) {
                    Assertions.assertTrue((boolean)rs.next());
                    SQLException se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getInt(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getShort(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getLong(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    Assertions.assertEquals((Object)String.format("%.3f", Float.valueOf(cases[i])), (Object)rs.getString(1));
                    Assertions.assertEquals((double)cases[i], (double)rs.getFloat(1), (double)delta);
                    double val = cases[i];
                    Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                    Assertions.assertEquals((Object)new BigDecimal(rs.getString(1)), (Object)rs.getBigDecimal(1));
                    Assertions.assertEquals((Object)rs.getBigDecimal(1), (Object)rs.getObject(1));
                    Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> rs.getByte(1));
                    if (this.isJSON(queryResultFormat)) {
                        Assertions.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                    } else {
                        se = (SQLException)Assertions.assertInstanceOf(SQLException.class, (Object)e);
                        Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                        Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    }
                    ByteBuffer byteBuffer = ByteBuffer.allocate(2);
                    byteBuffer.putShort(shortCompact[i]);
                    if (this.isJSON(queryResultFormat)) {
                        se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getBytes(1));
                        Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                        Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                        continue;
                    }
                    Assertions.assertArrayEquals((byte[])byteBuffer.array(), (byte[])rs.getBytes(1));
                }
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)0, (int)rs.getInt(1));
                Assertions.assertEquals((short)0, (short)rs.getShort(1));
                Assertions.assertEquals((long)0L, (long)rs.getLong(1));
                Assertions.assertNull((Object)rs.getString(1));
                Assertions.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
                double val = 0.0;
                Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                Assertions.assertNull((Object)rs.getBigDecimal(1));
                Assertions.assertEquals(null, (Object)rs.getObject(1));
                Assertions.assertEquals((int)0, (int)rs.getByte(1));
                Assertions.assertNull((Object)rs.getBytes(1));
                Assertions.assertTrue((boolean)rs.wasNull());
            }
            finally {
                statement.execute("drop table if exists " + table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testInt(String queryResultFormat) throws SQLException {
        int[] cases = new int[]{0, 1, -1, 127, -128, 128, -129, Short.MAX_VALUE, Short.MIN_VALUE, 32768, -32769, Integer.MAX_VALUE, Integer.MIN_VALUE};
        String table = "test_arrow_int";
        String column = "(a int)";
        String values = "(" + StringUtils.join((Object[])ArrayUtils.toObject((int[])cases), (String)"),(") + "), (NULL)";
        try (Connection con = this.init(queryResultFormat, table, column, values);
             Statement statement = con.createStatement();
             ResultSet rs = con.createStatement().executeQuery("select * from " + table);){
            try {
                double delta = 0.1;
                int columnType = rs.getMetaData().getColumnType(1);
                Assertions.assertEquals((int)-5, (int)columnType);
                for (int i = 0; i < cases.length; ++i) {
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((int)cases[i], (int)rs.getInt(1));
                    if (cases[i] >= Short.MIN_VALUE && cases[i] <= Short.MAX_VALUE) {
                        Assertions.assertEquals((short)((short)cases[i]), (short)rs.getShort(1));
                    } else {
                        SQLException se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getShort(1));
                        Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                        Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    }
                    Assertions.assertEquals((long)cases[i], (long)rs.getLong(1));
                    Assertions.assertEquals((Object)Integer.toString(cases[i]), (Object)rs.getString(1));
                    Assertions.assertEquals((double)cases[i], (double)rs.getFloat(1), (double)delta);
                    double val = cases[i];
                    Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                    Assertions.assertEquals((Object)new BigDecimal(Integer.toString(cases[i])), (Object)rs.getBigDecimal(1));
                    Assertions.assertEquals((Object)rs.getLong(1), (Object)rs.getObject(1));
                    if (cases[i] <= 127 && cases[i] >= -128) {
                        Assertions.assertEquals((int)cases[i], (int)rs.getByte(1));
                    } else {
                        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> rs.getByte(1));
                        if (this.isJSON(queryResultFormat)) {
                            Assertions.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                        } else {
                            SQLException se = (SQLException)Assertions.assertInstanceOf(SQLException.class, (Object)e);
                            Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                            Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                        }
                    }
                    ByteBuffer bb = ByteBuffer.allocate(4);
                    bb.putInt(cases[i]);
                    if (this.isJSON(queryResultFormat)) {
                        byte[] res = rs.getBytes(1);
                        for (int j = res.length - 1; j >= 0; --j) {
                            Assertions.assertEquals((byte)bb.array()[4 - res.length + j], (byte)res[j]);
                        }
                        continue;
                    }
                    Assertions.assertArrayEquals((byte[])bb.array(), (byte[])rs.getBytes(1));
                }
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)0, (int)rs.getInt(1));
                Assertions.assertEquals((short)0, (short)rs.getShort(1));
                Assertions.assertEquals((long)0L, (long)rs.getLong(1));
                Assertions.assertNull((Object)rs.getString(1));
                Assertions.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
                double val = 0.0;
                Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                Assertions.assertNull((Object)rs.getBigDecimal(1));
                Assertions.assertNull((Object)rs.getObject(1));
                Assertions.assertEquals((int)0, (int)rs.getByte(1));
                Assertions.assertNull((Object)rs.getBytes(1));
                Assertions.assertTrue((boolean)rs.wasNull());
            }
            finally {
                statement.execute("drop table if exists " + table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testScaledInt(String queryResultFormat) throws SQLException {
        int scale = 9;
        int[] intCompacts = new int[]{0, 123456789, -123456789, Integer.MAX_VALUE, -2147483647};
        List caseList = Arrays.stream(intCompacts).mapToObj(x -> BigDecimal.valueOf(x, scale)).collect(Collectors.toList());
        Object[] cases = (BigDecimal[])caseList.stream().toArray(BigDecimal[]::new);
        String table = "test_arrow_int";
        String column = String.format("(a number(10,%d))", scale);
        String values = "(" + StringUtils.join((Object[])cases, (String)"),(") + "), (null)";
        try (Connection con = this.init(queryResultFormat, table, column, values);
             Statement statement = con.createStatement();
             ResultSet rs = con.createStatement().executeQuery("select * from test_arrow_int");){
            try {
                double delta = 1.0E-10;
                int columnType = rs.getMetaData().getColumnType(1);
                Assertions.assertEquals((int)3, (int)columnType);
                for (int i = 0; i < cases.length; ++i) {
                    Assertions.assertTrue((boolean)rs.next());
                    SQLException se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getInt(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getShort(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getLong(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    Assertions.assertEquals((Object)((BigDecimal)cases[i]).toPlainString(), (Object)rs.getString(1));
                    Assertions.assertEquals((double)Float.parseFloat(((BigDecimal)cases[i]).toString()), (double)rs.getFloat(1), (double)delta);
                    double val = Double.parseDouble(((BigDecimal)cases[i]).toString());
                    Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                    Assertions.assertEquals((Object)new BigDecimal(rs.getString(1)), (Object)rs.getBigDecimal(1));
                    Assertions.assertEquals((Object)rs.getBigDecimal(1), (Object)rs.getObject(1));
                    Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> rs.getByte(1));
                    if (this.isJSON(queryResultFormat)) {
                        Assertions.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                    } else {
                        se = (SQLException)Assertions.assertInstanceOf(SQLException.class, (Object)e);
                        Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                        Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    }
                    if (this.isJSON(queryResultFormat)) {
                        se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getBytes(1));
                        Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                        Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                        continue;
                    }
                    ByteBuffer byteBuffer = ByteBuffer.allocate(4);
                    byteBuffer.putInt(intCompacts[i]);
                    Assertions.assertArrayEquals((byte[])byteBuffer.array(), (byte[])rs.getBytes(1));
                }
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)0, (int)rs.getInt(1));
                Assertions.assertEquals((short)0, (short)rs.getShort(1));
                Assertions.assertEquals((long)0L, (long)rs.getLong(1));
                Assertions.assertNull((Object)rs.getString(1));
                Assertions.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
                double val = 0.0;
                Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                Assertions.assertNull((Object)rs.getBigDecimal(1));
                Assertions.assertEquals(null, (Object)rs.getObject(1));
                Assertions.assertEquals((int)0, (int)rs.getByte(1));
                Assertions.assertNull((Object)rs.getBytes(1));
                Assertions.assertTrue((boolean)rs.wasNull());
            }
            finally {
                statement.execute("drop table if exists " + table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testBigInt(String queryResultFormat) throws SQLException {
        long[] cases = new long[]{0L, 1L, -1L, 127L, -128L, 128L, -129L, 32767L, -32768L, 32768L, -32769L, Integer.MAX_VALUE, Integer.MIN_VALUE, 0x80000000L, -2147483649L, Long.MAX_VALUE, Long.MIN_VALUE};
        String table = "test_arrow_big_int";
        String column = "(a int)";
        String values = "(" + StringUtils.join((Object[])ArrayUtils.toObject((long[])cases), (String)"),(") + "), (NULL)";
        try (Connection con = this.init(queryResultFormat, table, column, values);
             Statement statement = con.createStatement();
             ResultSet rs = statement.executeQuery("select * from " + table);){
            try {
                double delta = 0.1;
                int columnType = rs.getMetaData().getColumnType(1);
                Assertions.assertEquals((int)-5, (int)columnType);
                for (int i = 0; i < cases.length; ++i) {
                    SQLException se;
                    Assertions.assertTrue((boolean)rs.next());
                    if (cases[i] >= Integer.MIN_VALUE && cases[i] <= Integer.MAX_VALUE) {
                        Assertions.assertEquals((long)cases[i], (long)rs.getInt(1));
                    } else {
                        se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getInt(1));
                        Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                        Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    }
                    if (cases[i] >= -32768L && cases[i] <= 32767L) {
                        Assertions.assertEquals((short)((short)cases[i]), (short)rs.getShort(1));
                    } else {
                        se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getShort(1));
                        Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                        Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    }
                    Assertions.assertEquals((long)cases[i], (long)rs.getLong(1));
                    Assertions.assertEquals((Object)Long.toString(cases[i]), (Object)rs.getString(1));
                    Assertions.assertEquals((double)cases[i], (double)rs.getFloat(1), (double)delta);
                    double val = cases[i];
                    Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                    Assertions.assertEquals((Object)new BigDecimal(Long.toString(cases[i])), (Object)rs.getBigDecimal(1));
                    Assertions.assertEquals((Object)rs.getLong(1), (Object)rs.getObject(1));
                    if (cases[i] <= 127L && cases[i] >= -128L) {
                        Assertions.assertEquals((long)cases[i], (long)rs.getByte(1));
                    } else {
                        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> rs.getByte(1));
                        if (this.isJSON(queryResultFormat)) {
                            Assertions.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                        } else {
                            SQLException se2 = (SQLException)Assertions.assertInstanceOf(SQLException.class, (Object)e);
                            Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se2.getErrorCode());
                            Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se2.getSQLState());
                        }
                    }
                    ByteBuffer bb = ByteBuffer.allocate(8);
                    bb.putLong(cases[i]);
                    byte[] res = rs.getBytes(1);
                    for (int j = res.length - 1; j >= 0; --j) {
                        Assertions.assertEquals((byte)bb.array()[8 - res.length + j], (byte)res[j]);
                    }
                }
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)0, (int)rs.getInt(1));
                Assertions.assertEquals((short)0, (short)rs.getShort(1));
                Assertions.assertEquals((long)0L, (long)rs.getLong(1));
                Assertions.assertNull((Object)rs.getString(1));
                Assertions.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
                double val = 0.0;
                Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                Assertions.assertNull((Object)rs.getBigDecimal(1));
                Assertions.assertEquals(null, (Object)rs.getObject(1));
                Assertions.assertEquals((int)0, (int)rs.getByte(1));
                Assertions.assertNull((Object)rs.getBytes(1));
                Assertions.assertTrue((boolean)rs.wasNull());
            }
            finally {
                statement.execute("drop table if exists " + table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testScaledBigInt(String queryResultFormat) throws SQLException {
        int scale = 18;
        long[] longCompacts = new long[]{0L, 123456789L, -123456789L, Integer.MAX_VALUE, -2147483647L, Long.MIN_VALUE, Long.MAX_VALUE};
        List caseList = Arrays.stream(longCompacts).mapToObj(x -> BigDecimal.valueOf(x, scale)).collect(Collectors.toList());
        Object[] cases = (BigDecimal[])caseList.stream().toArray(BigDecimal[]::new);
        String table = "test_arrow_big_int";
        String column = String.format("(a number(38,%d))", scale);
        String values = "(" + StringUtils.join((Object[])cases, (String)"),(") + "), (null)";
        try (Connection con = this.init(queryResultFormat, table, column, values);
             Statement statement = con.createStatement();
             ResultSet rs = statement.executeQuery("select * from " + table);){
            try {
                double delta = 1.0E-19;
                int columnType = rs.getMetaData().getColumnType(1);
                Assertions.assertEquals((int)3, (int)columnType);
                for (int i = 0; i < cases.length; ++i) {
                    Assertions.assertTrue((boolean)rs.next());
                    SQLException se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getInt(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getShort(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getLong(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    Assertions.assertEquals((Object)((BigDecimal)cases[i]).toPlainString(), (Object)rs.getString(1));
                    Assertions.assertEquals((double)Float.parseFloat(((BigDecimal)cases[i]).toString()), (double)rs.getFloat(1), (double)delta);
                    double val = Double.parseDouble(((BigDecimal)cases[i]).toString());
                    Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                    Assertions.assertEquals((Object)new BigDecimal(rs.getString(1)), (Object)rs.getBigDecimal(1));
                    Assertions.assertEquals((Object)rs.getBigDecimal(1), (Object)rs.getObject(1));
                    Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> rs.getByte(1));
                    if (this.isJSON(queryResultFormat)) {
                        Assertions.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                    } else {
                        se = (SQLException)Assertions.assertInstanceOf(SQLException.class, (Object)e);
                        Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                        Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    }
                    if (this.isJSON(queryResultFormat)) {
                        se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getBytes(1));
                        Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                        Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                        continue;
                    }
                    ByteBuffer byteBuffer = ByteBuffer.allocate(8);
                    byteBuffer.putLong(longCompacts[i]);
                    Assertions.assertArrayEquals((byte[])byteBuffer.array(), (byte[])rs.getBytes(1));
                }
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)0, (int)rs.getInt(1));
                Assertions.assertEquals((short)0, (short)rs.getShort(1));
                Assertions.assertEquals((long)0L, (long)rs.getLong(1));
                Assertions.assertNull((Object)rs.getString(1));
                Assertions.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
                double val = 0.0;
                Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                Assertions.assertNull((Object)rs.getBigDecimal(1));
                Assertions.assertEquals(null, (Object)rs.getObject(1));
                Assertions.assertEquals((int)0, (int)rs.getByte(1));
                Assertions.assertNull((Object)rs.getBytes(1));
                Assertions.assertTrue((boolean)rs.wasNull());
            }
            finally {
                statement.execute("drop table if exists " + table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testDecimalNoScale(String queryResultFormat) throws SQLException {
        int scale = 0;
        String[] longCompacts = new String[]{"10000000000000000000000000000000000000", "12345678901234567890123456789012345678", "99999999999999999999999999999999999999"};
        List caseList = Arrays.stream(longCompacts).map(x -> new BigDecimal((String)x)).collect(Collectors.toList());
        Object[] cases = (BigDecimal[])caseList.stream().toArray(BigDecimal[]::new);
        String table = "test_arrow_decimal";
        String column = String.format("(a number(38,%d))", scale);
        String values = "(" + StringUtils.join((Object[])cases, (String)"),(") + "), (null)";
        try (Connection con = this.init(queryResultFormat, table, column, values);
             Statement statement = con.createStatement();
             ResultSet rs = statement.executeQuery("select * from " + table);){
            try {
                double delta = 0.1;
                int columnType = rs.getMetaData().getColumnType(1);
                Assertions.assertEquals((int)-5, (int)columnType);
                for (int i = 0; i < cases.length; ++i) {
                    Assertions.assertTrue((boolean)rs.next());
                    SQLException se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getInt(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getShort(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getLong(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    Assertions.assertEquals((Object)((BigDecimal)cases[i]).toPlainString(), (Object)rs.getString(1));
                    Assertions.assertEquals((double)Float.parseFloat(((BigDecimal)cases[i]).toString()), (double)rs.getFloat(1), (double)delta);
                    double val = Double.parseDouble(((BigDecimal)cases[i]).toString());
                    Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                    Assertions.assertEquals((Object)new BigDecimal(rs.getString(1)), (Object)rs.getBigDecimal(1));
                    Assertions.assertEquals((Object)rs.getBigDecimal(1), (Object)rs.getObject(1));
                    Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> rs.getByte(1));
                    if (this.isJSON(queryResultFormat)) {
                        Assertions.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                    } else {
                        se = (SQLException)Assertions.assertInstanceOf(SQLException.class, (Object)e);
                        Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                        Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    }
                    Assertions.assertArrayEquals((byte[])((BigDecimal)cases[i]).toBigInteger().toByteArray(), (byte[])rs.getBytes(1));
                }
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)0, (int)rs.getInt(1));
                Assertions.assertEquals((short)0, (short)rs.getShort(1));
                Assertions.assertEquals((long)0L, (long)rs.getLong(1));
                Assertions.assertNull((Object)rs.getString(1));
                Assertions.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
                double val = 0.0;
                Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                Assertions.assertNull((Object)rs.getBigDecimal(1));
                Assertions.assertEquals(null, (Object)rs.getObject(1));
                Assertions.assertEquals((int)0, (int)rs.getByte(1));
                Assertions.assertNull((Object)rs.getBytes(1));
                Assertions.assertTrue((boolean)rs.wasNull());
            }
            finally {
                statement.execute("drop table if exists " + table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testDecimalWithLargeScale(String queryResultFormat) throws SQLException {
        int scale = 37;
        String[] longCompacts = new String[]{"1.0000000000000000000000000000000000000", "1.2345678901234567890123456789012345678", "9.9999999999999999999999999999999999999"};
        List caseList = Arrays.stream(longCompacts).map(x -> new BigDecimal((String)x)).collect(Collectors.toList());
        Object[] cases = (BigDecimal[])caseList.stream().toArray(BigDecimal[]::new);
        String table = "test_arrow_decimal";
        String column = String.format("(a number(38,%d))", scale);
        String values = "(" + StringUtils.join((Object[])cases, (String)"),(") + "), (null)";
        try (Connection con = this.init(queryResultFormat, table, column, values);
             Statement statement = con.createStatement();
             ResultSet rs = statement.executeQuery("select * from " + table);){
            try {
                double delta = 1.0E-38;
                int columnType = rs.getMetaData().getColumnType(1);
                Assertions.assertEquals((int)3, (int)columnType);
                for (int i = 0; i < cases.length; ++i) {
                    Assertions.assertTrue((boolean)rs.next());
                    SQLException se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getInt(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getShort(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getLong(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    Assertions.assertEquals((Object)((BigDecimal)cases[i]).toPlainString(), (Object)rs.getString(1));
                    Assertions.assertEquals((double)Float.parseFloat(((BigDecimal)cases[i]).toString()), (double)rs.getFloat(1), (double)delta);
                    double val = Double.parseDouble(((BigDecimal)cases[i]).toString());
                    Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                    Assertions.assertEquals((Object)new BigDecimal(rs.getString(1)), (Object)rs.getBigDecimal(1));
                    Assertions.assertEquals((Object)rs.getBigDecimal(1), (Object)rs.getObject(1));
                    Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> rs.getByte(1));
                    if (this.isJSON(queryResultFormat)) {
                        Assertions.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                    } else {
                        se = (SQLException)Assertions.assertInstanceOf(SQLException.class, (Object)e);
                        Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                        Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    }
                    if (this.isJSON(queryResultFormat)) {
                        se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getBytes(1));
                        Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                        Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                        continue;
                    }
                    Assertions.assertArrayEquals((byte[])((BigDecimal)cases[i]).toBigInteger().toByteArray(), (byte[])rs.getBytes(1));
                }
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)0, (int)rs.getInt(1));
                Assertions.assertEquals((short)0, (short)rs.getShort(1));
                Assertions.assertEquals((long)0L, (long)rs.getLong(1));
                Assertions.assertNull((Object)rs.getString(1));
                Assertions.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
                double val = 0.0;
                Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                Assertions.assertNull((Object)rs.getBigDecimal(1));
                Assertions.assertEquals(null, (Object)rs.getObject(1));
                Assertions.assertEquals((int)0, (int)rs.getByte(1));
                Assertions.assertNull((Object)rs.getBytes(1));
                Assertions.assertTrue((boolean)rs.wasNull());
            }
            finally {
                statement.execute("drop table if exists " + table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testDecimal(String queryResultFormat) throws SQLException {
        int scale = 37;
        long[] longCompacts = new long[]{0L, 123456789L, -123456789L, Integer.MAX_VALUE, -2147483647L, Long.MIN_VALUE, Long.MAX_VALUE};
        List caseList = Arrays.stream(longCompacts).mapToObj(x -> BigDecimal.valueOf(x, scale)).collect(Collectors.toList());
        Object[] cases = (BigDecimal[])caseList.stream().toArray(BigDecimal[]::new);
        String table = "test_arrow_big_int";
        String column = String.format("(a number(38,%d))", scale);
        String values = "(" + StringUtils.join((Object[])cases, (String)"),(") + "), (null)";
        try (Connection con = this.init(queryResultFormat, table, column, values);
             Statement statement = con.createStatement();
             ResultSet rs = con.createStatement().executeQuery("select * from " + table);){
            try {
                double delta = 1.0E-38;
                ByteBuffer byteBuf = ByteBuffer.allocate(8);
                int columnType = rs.getMetaData().getColumnType(1);
                Assertions.assertEquals((int)3, (int)columnType);
                for (int i = 0; i < cases.length; ++i) {
                    Assertions.assertTrue((boolean)rs.next());
                    SQLException se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getInt(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getShort(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getLong(1));
                    Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                    Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    Assertions.assertEquals((Object)((BigDecimal)cases[i]).toPlainString(), (Object)rs.getString(1));
                    Assertions.assertEquals((double)Float.parseFloat(((BigDecimal)cases[i]).toString()), (double)rs.getFloat(1), (double)delta);
                    double val = Double.parseDouble(((BigDecimal)cases[i]).toString());
                    Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                    Assertions.assertEquals((Object)new BigDecimal(rs.getString(1)), (Object)rs.getBigDecimal(1));
                    Assertions.assertEquals((Object)rs.getBigDecimal(1), (Object)rs.getObject(1));
                    Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> rs.getByte(1));
                    if (this.isJSON(queryResultFormat)) {
                        Assertions.assertTrue((boolean)e.toString().contains("NumberFormatException"));
                    } else {
                        se = (SQLException)Assertions.assertInstanceOf(SQLException.class, (Object)e);
                        Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                        Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                    }
                    if (this.isJSON(queryResultFormat)) {
                        se = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.getBytes(1));
                        Assertions.assertEquals((int)ErrorCode.INVALID_VALUE_CONVERT.getMessageCode(), (int)se.getErrorCode());
                        Assertions.assertEquals((Object)ErrorCode.INVALID_VALUE_CONVERT.getSqlState(), (Object)se.getSQLState());
                        continue;
                    }
                    Assertions.assertArrayEquals((byte[])byteBuf.putLong(0, longCompacts[i]).array(), (byte[])rs.getBytes(1));
                }
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)0, (int)rs.getInt(1));
                Assertions.assertEquals((short)0, (short)rs.getShort(1));
                Assertions.assertEquals((long)0L, (long)rs.getLong(1));
                Assertions.assertNull((Object)rs.getString(1));
                Assertions.assertEquals((double)0.0, (double)rs.getFloat(1), (double)delta);
                double val = 0.0;
                Assertions.assertEquals((double)val, (double)rs.getDouble(1), (double)delta);
                Assertions.assertNull((Object)rs.getBigDecimal(1));
                Assertions.assertEquals(null, (Object)rs.getObject(1));
                Assertions.assertEquals((int)0, (int)rs.getByte(1));
                Assertions.assertNull((Object)rs.getBytes(1));
                Assertions.assertTrue((boolean)rs.wasNull());
            }
            finally {
                statement.execute("drop table if exists " + table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testDoublePrecision(String queryResultFormat) throws SQLException {
        Object[] cases = new String[]{"-86.6426540296895", "3.14159265359", "1.7976931348623157E308", "1.7E308", "1.7976931348623151E308", "-1.7976931348623151E308", "-1.7E308", "-1.7976931348623157E308"};
        String[] json_results = new String[]{"-86.64265403", "3.141592654", "Infinity", "1.7E308", "Infinity", "-Infinity", "-1.7E308", "-Infinity"};
        String table = "test_arrow_double";
        String column = "(a double)";
        String values = "(" + StringUtils.join((Object[])cases, (String)"),(") + ")";
        try (Connection con = this.init(queryResultFormat, table, column, values);
             Statement statement = con.createStatement();
             ResultSet rs = statement.executeQuery("select * from " + table);){
            try {
                int i = 0;
                if (this.isJSON(queryResultFormat)) {
                    while (rs.next()) {
                        Assertions.assertEquals((Object)json_results[i++], (Object)Double.toString(rs.getDouble(1)));
                    }
                } else {
                    while (rs.next()) {
                        Assertions.assertEquals((Object)cases[i++], (Object)Double.toString(rs.getDouble(1)));
                    }
                }
            }
            finally {
                statement.execute("drop table if exists " + table);
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testBoolean(String queryResultFormat) throws SQLException {
        String table = "test_arrow_boolean";
        String column = "(a boolean)";
        String values = "(true),(null),(false)";
        try (Connection conn = this.init(queryResultFormat, table, column, values);
             Statement statement = conn.createStatement();
             ResultSet rs = statement.executeQuery("select * from " + table);){
            Assertions.assertTrue((boolean)rs.next());
            Assertions.assertTrue((boolean)rs.getBoolean(1));
            Assertions.assertEquals((Object)"TRUE", (Object)rs.getString(1));
            Assertions.assertTrue((boolean)rs.next());
            Assertions.assertFalse((boolean)rs.getBoolean(1));
            Assertions.assertTrue((boolean)rs.next());
            Assertions.assertFalse((boolean)rs.getBoolean(1));
            Assertions.assertEquals((Object)"FALSE", (Object)rs.getString(1));
            Assertions.assertFalse((boolean)rs.next());
            statement.execute("drop table if exists " + table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testClientSideSorting(String queryResultFormat) throws SQLException {
        String table = "test_arrow_sort_on";
        String column = "( a int, b double, c string)";
        String values = "(1,2.0,'test'),(0,2.0, 'test'),(1,2.0,'abc')";
        try (Connection conn = this.init(queryResultFormat, table, column, values);
             Statement statement = conn.createStatement();){
            try {
                statement.execute("set-sf-property sort on");
                try (ResultSet rs = statement.executeQuery("select * from " + table);){
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((Object)"0", (Object)rs.getString(1));
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((Object)"1", (Object)rs.getString(1));
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((Object)"test", (Object)rs.getString(3));
                }
            }
            finally {
                statement.execute("drop table if exists " + table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testClientSideSortingOnBatchedChunk(String queryResultFormat) throws SQLException {
        String[] queries = new String[]{"set-sf-property sort on", "alter session set populate_change_tracking_columns = true;", "alter session set create_change_tracking_columns = true;", "alter session set enable_stream = true;", "alter session set qa_mode=true;  -- used for row_id", "create or replace schema stream_get_table_timestamp;", "create or replace  table T(id int);", "create stream S on table T;", "select system$stream_get_table_timestamp('S');", "select system$last_change_commit_time('T');", "insert into T values (1);", "insert into T values (2);", "insert into T values (3);"};
        try (Connection conn = this.init(queryResultFormat);
             Statement stat = conn.createStatement();){
            try {
                for (String q : queries) {
                    stat.execute(q);
                }
                try (ResultSet rs = stat.executeQuery("select * from S");){
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((int)1, (int)rs.getInt(1));
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((int)2, (int)rs.getInt(1));
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((int)3, (int)rs.getInt(1));
                    Assertions.assertFalse((boolean)rs.next());
                }
            }
            finally {
                stat.execute("drop stream S");
                stat.execute("drop table T");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testTimestampNTZAreAllNulls(String queryResultFormat) throws SQLException {
        try (Connection con = this.init(queryResultFormat);
             Statement statement = con.createStatement();){
            try {
                statement.executeQuery("create or replace table test_null_ts_ntz (a timestampntz(9)) as select null from table(generator(rowcount => 1000000)) v order by 1;");
                try (ResultSet rs = statement.executeQuery("select * from test_null_ts_ntz");){
                    while (rs.next()) {
                        rs.getObject(1);
                    }
                }
            }
            finally {
                statement.executeQuery("drop table if exists test_null_ts_ntz");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void TestArrowStringRoundTrip(String queryResultFormat) throws SQLException {
        String big_number = "11111111112222222222333333333344444444";
        try (Connection con = this.init(queryResultFormat);
             Statement st = con.createStatement();){
            try {
                for (int i = 0; i < 38; ++i) {
                    StringBuilder to_insert = new StringBuilder(big_number);
                    if (i != 0) {
                        int insert_to = 38 - i;
                        to_insert.insert(insert_to, ".");
                    }
                    st.execute("create or replace table test_arrow_string (a NUMBER(38, " + i + ") )");
                    st.execute("insert into test_arrow_string values (" + to_insert + ")");
                    try (ResultSet rs = st.executeQuery("select * from test_arrow_string");){
                        Assertions.assertTrue((boolean)rs.next());
                        Assertions.assertEquals((Object)to_insert.toString(), (Object)rs.getString(1));
                        continue;
                    }
                }
            }
            finally {
                st.execute("drop table if exists test_arrow_string");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void TestArrowFloatRoundTrip(String queryResultFormat) throws SQLException {
        float[] cases = new float[]{Float.MAX_VALUE, Float.MIN_VALUE};
        try (Connection con = this.init(queryResultFormat);
             Statement st = con.createStatement();){
            try {
                for (float f : cases) {
                    st.executeQuery("create or replace table test_arrow_float (a FLOAT)");
                    st.executeQuery("insert into test_arrow_float values (" + f + ")");
                    try (ResultSet rs = st.executeQuery("select * from test_arrow_float");){
                        Assertions.assertTrue((boolean)rs.next());
                        Assertions.assertEquals((float)f, (float)rs.getFloat(1), (float)Float.MIN_VALUE);
                    }
                }
            }
            finally {
                st.executeQuery("drop table if exists test_arrow_float");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void TestTimestampNTZWithDLS(String queryResultFormat) throws SQLException {
        TimeZone origTz = TimeZone.getDefault();
        String[] timeZones = new String[]{"America/New_York", "America/Los_Angeles"};
        try (Connection con = this.init(queryResultFormat);
             Statement st = con.createStatement();){
            for (String timeZone : timeZones) {
                TimeZone.setDefault(TimeZone.getTimeZone(timeZone));
                st.execute("alter session set JDBC_USE_SESSION_TIMEZONE=false");
                st.execute("alter session set JDBC_TREAT_TIMESTAMP_NTZ_AS_UTC=true");
                st.execute("alter session set TIMEZONE='" + timeZone + "'");
                st.execute("create or replace table src_ts(col1 TIMESTAMP_NTZ, col2 TIMESTAMP_LTZ, col3 TIMESTAMP_TZ)");
                List<String> testTimestampNTZValues = Arrays.asList("2018-03-11 01:10:34.0123456", "2018-03-11 02:10:34.0", "2018-03-11 03:10:34.0", "2018-11-04 01:10:34.0", "2018-11-04 02:10:34.0", "2018-11-04 03:10:34.0", "2020-03-11 01:10:34.0", "2020-03-11 02:10:34.0", "2020-03-11 03:10:34.0", "2020-11-01 01:10:34.0", "2020-11-01 02:10:34.0", "2020-11-01 03:10:34.0");
                List testTimestampLTZValues = Arrays.asList({"2018-03-11 01:10:34.0123456", "2018-03-11 01:10:34.0123456"}, {"2018-03-11 02:10:34.0", "2018-03-11 01:10:34.0"}, {"2018-03-11 03:10:34.0", "2018-03-11 03:10:34.0"}, {"2018-11-04 01:10:34.0", "2018-11-04 01:10:34.0"}, {"2018-11-04 02:10:34.0", "2018-11-04 02:10:34.0"}, {"2018-11-04 03:10:34.0", "2018-11-04 03:10:34.0"}, {"2020-03-11 01:10:34.0", "2020-03-11 01:10:34.0"}, {"2020-03-11 02:10:34.0", "2020-03-11 02:10:34.0"}, {"2020-03-11 03:10:34.0", "2020-03-11 03:10:34.0"}, {"2020-11-01 01:10:34.0", "2020-11-01 01:10:34.0"}, {"2020-11-01 02:10:34.0", "2020-11-01 02:10:34.0"}, {"2020-11-01 03:10:34.0", "2020-11-01 03:10:34.0"});
                List<String> testTimestampTZValues = Arrays.asList("2018-03-11 01:10:34.0 +0200", "2018-03-11 02:10:34.0 +0200", "2018-03-11 03:10:34.0 +0200", "2018-11-04 01:10:34.0 +0200", "2018-11-04 02:10:34.0 +0200", "2018-11-04 03:10:34.0 +0200", "2020-03-11 01:10:34.0 +0200", "2020-03-11 02:10:34.0 +0200", "2020-03-11 03:10:34.0 +0200", "2020-11-01 01:10:34.0 +0200", "2020-11-01 02:10:34.0 +0200", "2020-11-01 03:10:34.0 +0200");
                for (int i = 0; i < testTimestampNTZValues.size(); ++i) {
                    st.execute("insert into src_ts(col1,col2,col3) values('" + testTimestampNTZValues.get(i) + "', '" + ((String[])testTimestampLTZValues.get(i))[0] + "', '" + testTimestampTZValues.get(i) + "')");
                }
                try (ResultSet resultSet = st.executeQuery("select col1, col2, col3 from src_ts");){
                    int j = 0;
                    while (resultSet.next()) {
                        Object data1 = resultSet.getObject(1);
                        Assertions.assertEquals((Object)testTimestampNTZValues.get(j), (Object)data1.toString());
                        Object data2 = resultSet.getObject(2);
                        Assertions.assertEquals((Object)((String[])testTimestampLTZValues.get(j))[1], (Object)data2.toString());
                        Object data3 = resultSet.getObject(3);
                        MatcherAssert.assertThat((Object)data3, (Matcher)IsInstanceOf.instanceOf(Timestamp.class));
                        Assertions.assertEquals((long)this.parseTimestampTZ(testTimestampTZValues.get(j)).toEpochSecond(), (long)(((Timestamp)data3).getTime() / 1000L));
                        ++j;
                    }
                }
            }
        }
        finally {
            TimeZone.setDefault(origTz);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void TestTimestampNTZBinding(String queryResultFormat) throws SQLException {
        TimeZone origTz = TimeZone.getDefault();
        try (Connection con = this.init(queryResultFormat);){
            TimeZone.setDefault(TimeZone.getTimeZone("PST"));
            try (Statement st = con.createStatement();){
                st.execute("alter session set CLIENT_TIMESTAMP_TYPE_MAPPING=TIMESTAMP_NTZ");
                st.execute("alter session set JDBC_TREAT_TIMESTAMP_NTZ_AS_UTC=true");
                st.execute("create or replace table src_ts(col1 TIMESTAMP_NTZ)");
                try (PreparedStatement prepst = con.prepareStatement("insert into src_ts values(?)");){
                    Timestamp tz = Timestamp.valueOf("2018-03-11 01:10:34.0");
                    prepst.setTimestamp(1, tz);
                    prepst.execute();
                }
                try (ResultSet resultSet = st.executeQuery("SELECT COL1 FROM SRC_TS");){
                    int i = 1;
                    while (resultSet.next()) {
                        Object data = resultSet.getObject(i);
                        System.out.println(data.toString());
                    }
                }
            }
        }
        TimeZone.setDefault(origTz);
    }
}

