/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import net.snowflake.client.TestUtil;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.ResultSet0IT;
import net.snowflake.client.jdbc.SnowflakeBaseResultSet;
import net.snowflake.client.jdbc.SnowflakeChunkDownloader;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaData;
import net.snowflake.client.jdbc.SnowflakeResultSetV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeTimestampWithTimezone;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryClient;
import net.snowflake.client.jdbc.telemetry.TelemetryData;
import net.snowflake.client.jdbc.telemetry.TelemetryField;
import net.snowflake.client.providers.SimpleResultFormatProvider;
import net.snowflake.common.core.SFBinary;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="resultSet")
public class ResultSetLatestIT
extends ResultSet0IT {
    private String createTableSql = "Create or replace table get_object_for_numeric_types (c1 INT, c2 BIGINT, c3 SMALLINT, c4 TINYINT) ";
    private String insertStmt = "Insert into get_object_for_numeric_types (c1, c2, c3, c4) values (1000000000, 2000000000000000000000000, 3, 4)";
    private String selectQuery = "Select * from get_object_for_numeric_types";
    private String setJdbcTreatDecimalAsIntFalse = "alter session set JDBC_TREAT_DECIMAL_AS_INT = false";

    private static void setQueryResultFormat(Statement stmt, String queryResultFormat) throws SQLException {
        stmt.execute("alter session set jdbc_query_result_format = '" + queryResultFormat + "'");
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testMemoryClearingAfterInterrupt(String queryResultFormat) throws Throwable {
        try (Statement statement = this.createStatement(queryResultFormat);){
            long initialMemoryUsage = SnowflakeChunkDownloader.getCurrentMemoryUsage();
            SnowflakeChunkDownloader.setInjectedDownloaderException((Throwable)new InterruptedException());
            SQLException ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> {
                try (ResultSet resultSet = statement.executeQuery("select seq8(), randstr(1000, random()) from table(generator(rowcount => 10000))");){
                    MatcherAssert.assertThat((String)"hold memory usage for the resultSet before close", (SnowflakeChunkDownloader.getCurrentMemoryUsage() - initialMemoryUsage >= 0L ? 1 : 0) != 0);
                }
            });
            Assertions.assertEquals((int)ErrorCode.INTERRUPTED.getMessageCode(), (int)ex.getErrorCode());
            MatcherAssert.assertThat((String)"closing statement didn't release memory allocated for result", (Object)SnowflakeChunkDownloader.getCurrentMemoryUsage(), (Matcher)CoreMatchers.equalTo((Object)initialMemoryUsage));
            SnowflakeChunkDownloader.setInjectedDownloaderException(null);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testChunkDownloaderNoHang(String queryResultFormat) throws SQLException {
        int stmtCount = 30;
        int rowCount = 170000;
        try (Statement stmt = this.createStatement(queryResultFormat);){
            int i;
            ArrayList<ResultSet> rsList = new ArrayList<ResultSet>();
            connection.unwrap(SnowflakeConnectionV1.class).getSFBaseSession().setMemoryLimitForTesting(2000000L);
            for (i = 0; i < stmtCount; ++i) {
                ResultSet resultSet = stmt.executeQuery("select randstr(100, random()) from table(generator(rowcount => " + rowCount + "))");
                rsList.add(resultSet);
            }
            for (i = 0; i < stmtCount; ++i) {
                ((ResultSet)rsList.get(i)).next();
                Assertions.assertTrue((boolean)Pattern.matches("[a-zA-Z0-9]{100}", ((ResultSet)rsList.get(i)).getString(1)));
                ((ResultSet)rsList.get(i)).close();
            }
            connection.unwrap(SnowflakeConnectionV1.class).getSFBaseSession().setMemoryLimitForTesting(SFBaseSession.MEMORY_LIMIT_UNSET);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testChunkDownloaderSetRetry(String queryResultFormat) throws SQLException {
        int stmtCount = 3;
        int rowCount = 170000;
        try (Statement stmt = this.createStatement(queryResultFormat);){
            connection.unwrap(SnowflakeConnectionV1.class).getSFBaseSession().setMemoryLimitForTesting(0x100000L);
            connection.unwrap(SnowflakeConnectionV1.class).getSFBaseSession().setOtherParameter("JDBC_CHUNK_DOWNLOADER_MAX_RETRY", (Object)1);
            for (int i = 0; i < stmtCount; ++i) {
                try (ResultSet resultSet = stmt.executeQuery("select randstr(100, random()) from table(generator(rowcount => " + rowCount + "))");){
                    for (int j = 0; j < rowCount / 2; ++j) {
                        resultSet.next();
                    }
                    Assertions.assertTrue((boolean)Pattern.matches("[a-zA-Z0-9]{100}", resultSet.getString(1)));
                    continue;
                }
            }
            connection.unwrap(SnowflakeConnectionV1.class).getSFBaseSession().setOtherParameter("JDBC_CHUNK_DOWNLOADER_MAX_RETRY", (Object)10);
            connection.unwrap(SnowflakeConnectionV1.class).getSFBaseSession().setMemoryLimitForTesting(SFBaseSession.MEMORY_LIMIT_UNSET);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testMetadataAPIMetricCollection(String queryResultFormat) throws SQLException, ExecutionException, InterruptedException {
        Statement stmt = this.createStatement(queryResultFormat);
        stmt.close();
        Telemetry telemetry = connection.unwrap(SnowflakeConnectionV1.class).getSfSession().getTelemetryClient();
        DatabaseMetaData metadata = connection.getMetaData();
        metadata.getColumns("fakecatalog", "fakeschema", null, null);
        LinkedList logs = ((TelemetryClient)telemetry).logBuffer();
        Assertions.assertEquals((int)logs.size(), (int)1);
        Assertions.assertEquals((Object)((TelemetryData)logs.get(0)).getMessage().get("type").textValue(), (Object)TelemetryField.METADATA_METRICS.toString());
        Assertions.assertEquals((Object)((TelemetryData)logs.get(0)).getMessage().get("function_name").textValue(), (Object)"getColumns");
        TestUtil.assertValidQueryId(((TelemetryData)logs.get(0)).getMessage().get("query_id").textValue());
        JsonNode parameterValues = ((TelemetryData)logs.get(0)).getMessage().get("function_parameters");
        Assertions.assertEquals((Object)parameterValues.get("catalog").textValue(), (Object)"fakecatalog");
        Assertions.assertEquals((Object)parameterValues.get("schema").textValue(), (Object)"fakeschema");
        Assertions.assertNull((Object)parameterValues.get("general_name_pattern").textValue());
        Assertions.assertNull((Object)parameterValues.get("specific_name_pattern").textValue());
        telemetry.sendBatchAsync().get();
        Assertions.assertEquals((int)0, (int)((TelemetryClient)telemetry).logBuffer().size());
        String catalog = connection.getCatalog();
        String schema = connection.getSchema();
        metadata.getColumns(catalog, schema, null, null);
        logs = ((TelemetryClient)telemetry).logBuffer();
        Assertions.assertEquals((int)logs.size(), (int)2);
        Assertions.assertEquals((Object)((TelemetryData)logs.get(0)).getMessage().get("type").textValue(), (Object)TelemetryField.TIME_CONSUME_FIRST_RESULT.toString());
        Assertions.assertEquals((Object)((TelemetryData)logs.get(1)).getMessage().get("type").textValue(), (Object)TelemetryField.METADATA_METRICS.toString());
        Assertions.assertEquals((Object)((TelemetryData)logs.get(1)).getMessage().get("function_name").textValue(), (Object)"getColumns");
        TestUtil.assertValidQueryId(((TelemetryData)logs.get(1)).getMessage().get("query_id").textValue());
        parameterValues = ((TelemetryData)logs.get(1)).getMessage().get("function_parameters");
        Assertions.assertEquals((Object)parameterValues.get("catalog").textValue(), (Object)catalog);
        Assertions.assertEquals((Object)parameterValues.get("schema").textValue(), (Object)schema);
        Assertions.assertNull((Object)parameterValues.get("general_name_pattern").textValue());
        Assertions.assertNull((Object)parameterValues.get("specific_name_pattern").textValue());
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetCharacterStreamNull(String queryResultFormat) throws SQLException {
        try (Statement statement = this.createStatement(queryResultFormat);){
            statement.execute("create or replace table JDBC_NULL_CHARSTREAM (col1 varchar(16))");
            statement.execute("insert into JDBC_NULL_CHARSTREAM values(NULL)");
            try (ResultSet rs = statement.executeQuery("select * from JDBC_NULL_CHARSTREAM");){
                rs.next();
                Assertions.assertNull((Object)rs.getCharacterStream(1));
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testMultipleChunks(String queryResultFormat) throws Exception {
        try (Statement statement = this.createStatement(queryResultFormat);
             ResultSet resultSet = statement.executeQuery("select seq8(), randstr(1000, random()) from table(generator(rowcount => 10000))");){
            int i;
            int cnt = 0;
            while (resultSet.next()) {
                ++cnt;
            }
            Assertions.assertTrue((cnt >= 0 ? 1 : 0) != 0);
            Telemetry telemetry = connection.unwrap(SnowflakeConnectionV1.class).getSfSession().getTelemetryClient();
            LinkedList logs = ((TelemetryClient)telemetry).logBuffer();
            TelemetryField[] expectedFields = new TelemetryField[]{TelemetryField.TIME_CONSUME_FIRST_RESULT, TelemetryField.TIME_CONSUME_LAST_RESULT, TelemetryField.TIME_WAITING_FOR_CHUNKS, TelemetryField.TIME_DOWNLOADING_CHUNKS, TelemetryField.TIME_PARSING_CHUNKS};
            boolean[] succeeded = new boolean[expectedFields.length];
            block11: for (i = 0; i < expectedFields.length; ++i) {
                succeeded[i] = false;
                for (TelemetryData log : logs) {
                    if (!log.getMessage().get("type").textValue().equals(expectedFields[i].field)) continue;
                    succeeded[i] = true;
                    continue block11;
                }
            }
            for (i = 0; i < expectedFields.length; ++i) {
                MatcherAssert.assertThat((String)String.format("%s field not found in telemetry logs\n", expectedFields[i].field), (boolean)succeeded[i]);
            }
            telemetry.sendBatchAsync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testResultSetMetadata(String queryResultFormat) throws SQLException {
        Map<String, String> params = ResultSetLatestIT.getConnectionParameters();
        try (Statement statement = this.createStatement(queryResultFormat);){
            try {
                statement.execute("create or replace table test_rsmd(colA number(20, 5), colB string)");
                statement.execute("insert into test_rsmd values(1.00, 'str'),(2.00, 'str2')");
                ResultSet resultSet = statement.executeQuery("select * from test_rsmd");
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((Object)params.get("database").toUpperCase(), (Object)resultSetMetaData.getCatalogName(1).toUpperCase());
                Assertions.assertEquals((Object)params.get("schema").toUpperCase(), (Object)resultSetMetaData.getSchemaName(1).toUpperCase());
                Assertions.assertEquals((Object)"TEST_RSMD", (Object)resultSetMetaData.getTableName(1));
                Assertions.assertEquals((Object)String.class.getName(), (Object)resultSetMetaData.getColumnClassName(2));
                Assertions.assertEquals((int)2, (int)resultSetMetaData.getColumnCount());
                Assertions.assertEquals((int)22, (int)resultSetMetaData.getColumnDisplaySize(1));
                Assertions.assertEquals((Object)"COLA", (Object)resultSetMetaData.getColumnLabel(1));
                Assertions.assertEquals((Object)"COLA", (Object)resultSetMetaData.getColumnName(1));
                Assertions.assertEquals((int)3, (int)resultSetMetaData.getColumnType(1));
                Assertions.assertEquals((Object)"NUMBER", (Object)resultSetMetaData.getColumnTypeName(1));
                Assertions.assertEquals((int)20, (int)resultSetMetaData.getPrecision(1));
                Assertions.assertEquals((int)5, (int)resultSetMetaData.getScale(1));
                Assertions.assertFalse((boolean)resultSetMetaData.isAutoIncrement(1));
                Assertions.assertFalse((boolean)resultSetMetaData.isCaseSensitive(1));
                Assertions.assertFalse((boolean)resultSetMetaData.isCurrency(1));
                Assertions.assertFalse((boolean)resultSetMetaData.isDefinitelyWritable(1));
                Assertions.assertEquals((int)1, (int)resultSetMetaData.isNullable(1));
                Assertions.assertTrue((boolean)resultSetMetaData.isReadOnly(1));
                Assertions.assertTrue((boolean)resultSetMetaData.isSearchable(1));
                Assertions.assertTrue((boolean)resultSetMetaData.isSigned(1));
                SnowflakeResultSetMetaData secretMetaData = resultSetMetaData.unwrap(SnowflakeResultSetMetaData.class);
                List colNames = secretMetaData.getColumnNames();
                Assertions.assertEquals((Object)"COLA", colNames.get(0));
                Assertions.assertEquals((Object)"COLB", colNames.get(1));
                Assertions.assertEquals((int)3, (int)secretMetaData.getInternalColumnType(1));
                Assertions.assertEquals((int)12, (int)secretMetaData.getInternalColumnType(2));
                TestUtil.assertValidQueryId(secretMetaData.getQueryID());
            }
            finally {
                statement.execute("drop table if exists test_rsmd");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testEmptyResultSet(String queryResultFormat) throws SQLException {
        try (Statement statement = this.createStatement(queryResultFormat);
             ResultSet rs = statement.getGeneratedKeys();){
            Assertions.assertFalse((boolean)rs.next());
            Assertions.assertFalse((boolean)rs.isClosed());
            Assertions.assertEquals((int)0, (int)rs.getInt(1));
            Assertions.assertEquals((int)0, (int)rs.getInt("col1"));
            Assertions.assertEquals((long)0L, (long)rs.getLong(2));
            Assertions.assertEquals((long)0L, (long)rs.getLong("col2"));
            Assertions.assertEquals((int)0, (int)rs.getShort(3));
            Assertions.assertEquals((int)0, (int)rs.getShort("col3"));
            Assertions.assertEquals((Object)"", (Object)rs.getString(4));
            Assertions.assertEquals((Object)"", (Object)rs.getString("col4"));
            Assertions.assertEquals((double)0.0, (double)rs.getDouble(5), (double)0.0);
            Assertions.assertEquals((double)0.0, (double)rs.getDouble("col5"), (double)0.0);
            Assertions.assertEquals((float)0.0f, (float)rs.getFloat(6), (float)0.0f);
            Assertions.assertEquals((float)0.0f, (float)rs.getFloat("col6"), (float)0.0f);
            Assertions.assertEquals((Object)false, (Object)rs.getBoolean(7));
            Assertions.assertEquals((Object)false, (Object)rs.getBoolean("col7"));
            Assertions.assertEquals((byte)0, (byte)rs.getByte(8));
            Assertions.assertEquals((byte)0, (byte)rs.getByte("col8"));
            Assertions.assertEquals(null, (Object)rs.getBinaryStream(9));
            Assertions.assertEquals(null, (Object)rs.getBinaryStream("col9"));
            Assertions.assertEquals(null, (Object)rs.getDate(10));
            Assertions.assertEquals(null, (Object)rs.getDate(10, (Calendar)new BaseJDBCTest.FakeCalendar(this)));
            Assertions.assertEquals(null, (Object)rs.getDate("col10"));
            Assertions.assertEquals(null, (Object)rs.getDate("col10", (Calendar)new BaseJDBCTest.FakeCalendar(this)));
            Assertions.assertEquals(null, (Object)rs.getTime(11));
            Assertions.assertEquals(null, (Object)rs.getTime(11, (Calendar)new BaseJDBCTest.FakeCalendar(this)));
            Assertions.assertEquals(null, (Object)rs.getTime("col11"));
            Assertions.assertEquals(null, (Object)rs.getTime("col11", (Calendar)new BaseJDBCTest.FakeCalendar(this)));
            Assertions.assertEquals(null, (Object)rs.getTimestamp(12));
            Assertions.assertEquals(null, (Object)rs.getTimestamp(12, (Calendar)new BaseJDBCTest.FakeCalendar(this)));
            Assertions.assertEquals(null, (Object)rs.getTimestamp("col12"));
            Assertions.assertEquals(null, (Object)rs.getTimestamp("col12", (Calendar)new BaseJDBCTest.FakeCalendar(this)));
            Assertions.assertEquals(null, (Object)rs.getDate(13));
            Assertions.assertEquals(null, (Object)rs.getDate("col13"));
            Assertions.assertEquals(null, (Object)rs.getAsciiStream(14));
            Assertions.assertEquals(null, (Object)rs.getAsciiStream("col14"));
            Assertions.assertArrayEquals((byte[])new byte[0], (byte[])rs.getBytes(15));
            Assertions.assertArrayEquals((byte[])new byte[0], (byte[])rs.getBytes("col15"));
            Assertions.assertNull((Object)rs.getBigDecimal(16));
            Assertions.assertNull((Object)rs.getBigDecimal(16, 38));
            Assertions.assertNull((Object)rs.getBigDecimal("col16"));
            Assertions.assertNull((Object)rs.getBigDecimal("col16", 38));
            Assertions.assertNull((Object)rs.getRef(17));
            Assertions.assertNull((Object)rs.getRef("col17"));
            Assertions.assertNull((Object)rs.getArray(18));
            Assertions.assertNull((Object)rs.getArray("col18"));
            Assertions.assertNull((Object)rs.getBlob(19));
            Assertions.assertNull((Object)rs.getBlob("col19"));
            Assertions.assertNull((Object)rs.getClob(20));
            Assertions.assertNull((Object)rs.getClob("col20"));
            Assertions.assertEquals((int)0, (int)rs.findColumn("col1"));
            Assertions.assertNull((Object)rs.getUnicodeStream(21));
            Assertions.assertNull((Object)rs.getUnicodeStream("col21"));
            Assertions.assertNull((Object)rs.getURL(22));
            Assertions.assertNull((Object)rs.getURL("col22"));
            Assertions.assertNull((Object)rs.getObject(23));
            Assertions.assertNull((Object)rs.getObject("col24"));
            Assertions.assertNull((Object)rs.getObject(23, SnowflakeResultSetV1.class));
            Assertions.assertNull((Object)rs.getObject("col23", SnowflakeResultSetV1.class));
            Assertions.assertNull((Object)rs.getNString(25));
            Assertions.assertNull((Object)rs.getNString("col25"));
            Assertions.assertNull((Object)rs.getNClob(26));
            Assertions.assertNull((Object)rs.getNClob("col26"));
            Assertions.assertNull((Object)rs.getNCharacterStream(27));
            Assertions.assertNull((Object)rs.getNCharacterStream("col27"));
            Assertions.assertNull((Object)rs.getCharacterStream(28));
            Assertions.assertNull((Object)rs.getCharacterStream("col28"));
            Assertions.assertNull((Object)rs.getSQLXML(29));
            Assertions.assertNull((Object)rs.getSQLXML("col29"));
            Assertions.assertNull((Object)rs.getStatement());
            Assertions.assertNull((Object)rs.getWarnings());
            Assertions.assertNull((Object)rs.getCursorName());
            Assertions.assertNull((Object)rs.getMetaData());
            Assertions.assertNull((Object)rs.getRowId(1));
            Assertions.assertNull((Object)rs.getRowId("col1"));
            Assertions.assertEquals((int)0, (int)rs.getRow());
            Assertions.assertEquals((int)0, (int)rs.getFetchDirection());
            Assertions.assertEquals((int)0, (int)rs.getFetchSize());
            Assertions.assertEquals((int)0, (int)rs.getType());
            Assertions.assertEquals((int)0, (int)rs.getConcurrency());
            Assertions.assertEquals((int)0, (int)rs.getHoldability());
            Assertions.assertNull((Object)rs.unwrap(SnowflakeResultSetV1.class));
            Assertions.assertFalse((boolean)rs.isWrapperFor(SnowflakeResultSetV1.class));
            Assertions.assertFalse((boolean)rs.wasNull());
            Assertions.assertFalse((boolean)rs.isFirst());
            Assertions.assertFalse((boolean)rs.isBeforeFirst());
            Assertions.assertFalse((boolean)rs.isLast());
            Assertions.assertFalse((boolean)rs.isAfterLast());
            Assertions.assertFalse((boolean)rs.first());
            Assertions.assertFalse((boolean)rs.last());
            Assertions.assertFalse((boolean)rs.previous());
            Assertions.assertFalse((boolean)rs.rowUpdated());
            Assertions.assertFalse((boolean)rs.rowInserted());
            Assertions.assertFalse((boolean)rs.rowDeleted());
            Assertions.assertFalse((boolean)rs.absolute(1));
            Assertions.assertFalse((boolean)rs.relative(1));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testBytesCrossTypeTests(String queryResultFormat) throws Exception {
        try (ResultSet resultSet = this.numberCrossTesting(queryResultFormat);){
            int i;
            Assertions.assertTrue((boolean)resultSet.next());
            for (i = 1; i < 13; ++i) {
                Assertions.assertArrayEquals(null, (byte[])resultSet.getBytes(i));
            }
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertArrayEquals((byte[])this.intToByteArray(2), (byte[])resultSet.getBytes(1));
            Assertions.assertArrayEquals((byte[])this.intToByteArray(5), (byte[])resultSet.getBytes(2));
            Assertions.assertArrayEquals((byte[])this.floatToByteArray(3.5f), (byte[])resultSet.getBytes(3));
            Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])resultSet.getBytes(4));
            Assertions.assertArrayEquals((byte[])new byte[]{49}, (byte[])resultSet.getBytes(5));
            Assertions.assertArrayEquals((byte[])"1".getBytes(), (byte[])resultSet.getBytes(6));
            for (i = 7; i < 12; ++i) {
                int finalI = i;
                SQLException ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getBytes(finalI), (String)("Failing on " + i));
                Assertions.assertEquals((int)200038, (int)ex.getErrorCode());
            }
            byte[] decoded = SFBinary.fromHex((String)"48454C4C4F").getBytes();
            Assertions.assertArrayEquals((byte[])decoded, (byte[])resultSet.getBytes(12));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @Timeout(value=30L)
    public void testResultChunkDownloaderException(String queryResultFormat) throws SQLException {
        try (Statement statement = this.createStatement(queryResultFormat);){
            String query = "select current_date(), true,2345234, 2343.0, 'testrgint\\n\\t' from table(generator(rowcount=>10000))";
            try (ResultSet resultSet = statement.executeQuery(query);){
                Assertions.assertTrue((boolean)resultSet.next());
            }
            try {
                SnowflakeChunkDownloader.setInjectedDownloaderException((Throwable)new OutOfMemoryError("Fake OOM error for testing"));
                resultSet = statement.executeQuery(query);
                try {
                    Assertions.assertThrows(SnowflakeSQLException.class, () -> {
                        while (resultSet.next()) {
                        }
                    }, (String)"Should not reach here. Last next() command is supposed to throw an exception");
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                SnowflakeChunkDownloader.setInjectedDownloaderException(null);
            }
        }
    }

    @Test
    public void testGetObjectWithBigInt() throws SQLException {
        try (Statement statement = this.createStatement("json");){
            String[] extremeNumbers = new String[]{"99999999999999999999999999999999999999", "-99999999999999999999999999999999999999"};
            for (int i = 0; i < extremeNumbers.length; ++i) {
                try (ResultSet resultSet = statement.executeQuery("select " + extremeNumbers[i]);){
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((int)-5, (int)resultSet.getMetaData().getColumnType(1));
                    Assertions.assertEquals((Object)new BigDecimal(extremeNumbers[i]), (Object)resultSet.getObject(1));
                    continue;
                }
            }
        }
    }

    private byte[] intToByteArray(int i) {
        return BigInteger.valueOf(i).toByteArray();
    }

    private byte[] floatToByteArray(float i) {
        return ByteBuffer.allocate(8).putDouble(0, i).array();
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetBigDecimalWithScale(String queryResultFormat) throws SQLException {
        try (Statement statement = this.createStatement(queryResultFormat);){
            statement.execute("create or replace table test_get(colA number(38,9))");
            try (PreparedStatement preparedStatement = connection.prepareStatement("insert into test_get values(?)");){
                preparedStatement.setBigDecimal(1, null);
                preparedStatement.addBatch();
                BigDecimal bigDecimal = new BigDecimal("100000000.123456789");
                preparedStatement.setBigDecimal(1, bigDecimal);
                preparedStatement.addBatch();
                preparedStatement.executeBatch();
                try (ResultSet resultSet = statement.executeQuery("select * from test_get");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals(null, (Object)resultSet.getBigDecimal(1, 5));
                    Assertions.assertEquals(null, (Object)resultSet.getBigDecimal("COLA", 5));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)bigDecimal.setScale(5, RoundingMode.HALF_UP), (Object)resultSet.getBigDecimal(1, 5));
                    Assertions.assertEquals((Object)bigDecimal.setScale(5, RoundingMode.HALF_UP), (Object)resultSet.getBigDecimal("COLA", 5));
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetDataTypeWithTimestampTz(String queryResultFormat) throws Exception {
        try (Connection connection = ResultSetLatestIT.getConnection();){
            ResultSetMetaData resultSetMetaData = null;
            try (Statement statement = connection.createStatement();){
                ResultSetLatestIT.setQueryResultFormat(statement, queryResultFormat);
                statement.executeQuery("create or replace table ts_test(ts timestamp_tz)");
                try (ResultSet resultSet = statement.executeQuery("select * from ts_test");){
                    resultSetMetaData = resultSet.getMetaData();
                    Assertions.assertEquals((int)resultSetMetaData.getColumnType(1), (int)2014);
                    Assertions.assertEquals((Object)resultSetMetaData.getColumnClassName(1), (Object)Timestamp.class.getName());
                }
            }
            SFBaseSession baseSession = connection.unwrap(SnowflakeConnectionV1.class).getSFBaseSession();
            Field field = SFBaseSession.class.getDeclaredField("enableReturnTimestampWithTimeZone");
            field.setAccessible(true);
            field.set(baseSession, false);
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery("select * from ts_test");){
                resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((int)resultSetMetaData.getColumnType(1), (int)93);
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetEmptyOrNullClob(String queryResultFormat) throws SQLException {
        Clob clob = connection.createClob();
        clob.setString(1L, "hello world");
        Clob emptyClob = connection.createClob();
        emptyClob.setString(1L, "");
        try (Statement statement = this.createStatement(queryResultFormat);){
            statement.execute("create or replace table test_get_clob(colA varchar, colNull varchar, colEmpty text)");
            try (PreparedStatement preparedStatement = connection.prepareStatement("insert into test_get_clob values(?, ?, ?)");){
                preparedStatement.setClob(1, clob);
                preparedStatement.setString(2, null);
                preparedStatement.setClob(3, emptyClob);
                preparedStatement.execute();
            }
            try (ResultSet resultSet = statement.executeQuery("select * from test_get_clob");){
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((Object)"hello world", (Object)resultSet.getClob(1).toString());
                Assertions.assertEquals((Object)"hello world", (Object)resultSet.getClob("COLA").toString());
                Assertions.assertNull((Object)resultSet.getClob(2));
                Assertions.assertNull((Object)resultSet.getClob("COLNULL"));
                Assertions.assertEquals((Object)"", (Object)resultSet.getClob(3).toString());
                Assertions.assertEquals((Object)"", (Object)resultSet.getClob("COLEMPTY").toString());
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testSetNullClob(String queryResultFormat) throws SQLException {
        Clob clob = null;
        try (Statement statement = this.createStatement(queryResultFormat);){
            statement.execute("create or replace table test_set_clob(colNull varchar)");
            try (PreparedStatement preparedStatement = connection.prepareStatement("insert into test_set_clob values(?)");){
                preparedStatement.setClob(1, clob);
                preparedStatement.execute();
            }
            try (ResultSet resultSet = statement.executeQuery("select * from test_set_clob");){
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertNull((Object)resultSet.getClob(1));
                Assertions.assertNull((Object)resultSet.getClob("COLNULL"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testCallStatementType(String queryResultFormat) throws SQLException {
        Properties props = new Properties();
        props.put("USE_STATEMENT_TYPE_CALL_FOR_STORED_PROC_CALLS", "true");
        try (Connection connection = ResultSetLatestIT.getConnection(props);
             Statement statement = connection.createStatement();){
            ResultSetLatestIT.setQueryResultFormat(statement, queryResultFormat);
            try {
                String sp = "CREATE OR REPLACE PROCEDURE \"SP_ZSDLEADTIME_ARCHIVE_DAILY\"()\nRETURNS VARCHAR\nLANGUAGE SQL\nEXECUTE AS CALLER\nAS \n'\ndeclare\nresult varchar;\n \n    begin\n        BEGIN TRANSACTION;\n      \n        --Delete records older than 1 year\n        DELETE FROM MYTABLE1 WHERE ID < 5;\n       \n        --Insert new records\n        INSERT INTO MYTABLE1\n            (ID,\n            NAME\n            )\n            SELECT   \n            SEQ,FIRST_NAME\n            FROM MYCSVTABLE;\n        \nCOMMIT;\nresult := ''SUCCESS'';\nreturn result;\nexception\n    when other then\n        begin\n        ROLLBACK;\n            --Insert record about error\n            let line := ''sp-sql-msg: '' || SQLERRM || '' code : '' || SQLCODE;\n\n            let sp_name := ''SP_ZSDLEADTIME_ARCHIVE_DAILY'';\n            INSERT into MYTABLE1 values (1000, :line);\n        raise;\n    end;\nend;\n';";
                statement.execute("create or replace table MYCSVTABLE (SEQ int, FIRST_NAME string)");
                statement.execute("create or replace table MYTABLE1 (ID int, NAME string)");
                statement.execute(sp);
                try (CallableStatement cs = connection.prepareCall("CALL SP_ZSDLEADTIME_ARCHIVE_DAILY()");){
                    cs.execute();
                    ResultSetMetaData resultSetMetaData = cs.getMetaData();
                    Assertions.assertEquals((Object)"SP_ZSDLEADTIME_ARCHIVE_DAILY", (Object)resultSetMetaData.getColumnName(1));
                    Assertions.assertEquals((Object)"VARCHAR", (Object)resultSetMetaData.getColumnTypeName(1));
                    Assertions.assertEquals((int)0, (int)resultSetMetaData.getScale(1));
                }
            }
            finally {
                statement.execute("drop procedure if exists SP_ZSDLEADTIME_ARCHIVE_DAILY()");
                statement.execute("drop table if exists MYTABLE1");
                statement.execute("drop table if exists MYCSVTABLE");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testNewFeaturesNotSupportedExeceptions(String queryResultFormat) throws SQLException {
        try (Statement statement = this.createStatement(queryResultFormat);
             ResultSet rs = statement.executeQuery("select 1");){
            TestUtil.expectSnowflakeLoggedFeatureNotSupportedException(() -> ((SnowflakeResultSet)rs.unwrap(SnowflakeResultSet.class)).getQueryErrorMessage());
            TestUtil.expectSnowflakeLoggedFeatureNotSupportedException(() -> ((SnowflakeResultSet)rs.unwrap(SnowflakeResultSet.class)).getStatus());
            TestUtil.expectSnowflakeLoggedFeatureNotSupportedException(() -> rs.getArray(1));
            TestUtil.expectSnowflakeLoggedFeatureNotSupportedException(() -> rs.unwrap(SnowflakeBaseResultSet.class).getList(1, String.class));
            TestUtil.expectSnowflakeLoggedFeatureNotSupportedException(() -> rs.unwrap(SnowflakeBaseResultSet.class).getArray(1, String.class));
            TestUtil.expectSnowflakeLoggedFeatureNotSupportedException(() -> rs.unwrap(SnowflakeBaseResultSet.class).getMap(1, String.class));
            TestUtil.expectSnowflakeLoggedFeatureNotSupportedException(() -> rs.unwrap(SnowflakeBaseResultSet.class).getUnicodeStream(1));
            TestUtil.expectSnowflakeLoggedFeatureNotSupportedException(() -> rs.unwrap(SnowflakeBaseResultSet.class).getUnicodeStream("column1"));
            TestUtil.expectSnowflakeLoggedFeatureNotSupportedException(() -> rs.unwrap(SnowflakeBaseResultSet.class).updateAsciiStream("column1", (InputStream)new BaseJDBCTest.FakeInputStream(this), 5L));
            TestUtil.expectSnowflakeLoggedFeatureNotSupportedException(() -> rs.unwrap(SnowflakeBaseResultSet.class).updateBinaryStream("column1", (InputStream)new BaseJDBCTest.FakeInputStream(this), 5L));
            TestUtil.expectSnowflakeLoggedFeatureNotSupportedException(() -> rs.unwrap(SnowflakeBaseResultSet.class).updateCharacterStream("column1", (Reader)new BaseJDBCTest.FakeReader(this), 5L));
            TestUtil.expectSnowflakeLoggedFeatureNotSupportedException(() -> rs.unwrap(SnowflakeBaseResultSet.class).updateAsciiStream(1, (InputStream)new BaseJDBCTest.FakeInputStream(this), 5L));
            TestUtil.expectSnowflakeLoggedFeatureNotSupportedException(() -> rs.unwrap(SnowflakeBaseResultSet.class).updateBinaryStream(1, (InputStream)new BaseJDBCTest.FakeInputStream(this), 5L));
            TestUtil.expectSnowflakeLoggedFeatureNotSupportedException(() -> rs.unwrap(SnowflakeBaseResultSet.class).updateCharacterStream(1, (Reader)new BaseJDBCTest.FakeReader(this), 5L));
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testInvalidUnWrap(String queryResultFormat) throws SQLException {
        try (ResultSet rs = this.createStatement(queryResultFormat).executeQuery("select 1");){
            SQLException ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> rs.unwrap(SnowflakeUtil.class));
            Assertions.assertEquals((Object)ex.getMessage(), (Object)"net.snowflake.client.jdbc.SnowflakeResultSetV1 not unwrappable from net.snowflake.client.jdbc.SnowflakeUtil");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetObjectJsonResult() throws SQLException {
        try (Statement statement = this.createStatement("json");){
            try {
                statement.execute("create or replace table testObj (colA double, colB boolean)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into testObj values(?, ?)");){
                    preparedStatement.setDouble(1, 22.2);
                    preparedStatement.setBoolean(2, true);
                    preparedStatement.executeQuery();
                }
                try (ResultSet resultSet = statement.executeQuery("select * from testObj");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)22.2, (Object)resultSet.getObject(1));
                    Assertions.assertEquals((Object)true, (Object)resultSet.getObject(2));
                }
            }
            finally {
                statement.execute("drop table if exists testObj");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testMetadataIsCaseSensitive(String queryResultFormat) throws SQLException {
        try (Statement statement = this.createStatement(queryResultFormat);){
            String sampleCreateTableWithAllColTypes = "CREATE or replace TABLE case_sensitive (  boolean_col BOOLEAN,  date_col DATE,  time_col TIME,  timestamp_col TIMESTAMP,  timestamp_ltz_col TIMESTAMP_LTZ,  timestamp_ntz_col TIMESTAMP_NTZ,  number_col NUMBER,  float_col FLOAT,  double_col DOUBLE,  binary_col BINARY,  geography_col GEOGRAPHY,  variant_col VARIANT,  object_col1 OBJECT,  array_col1 ARRAY,  text_col1 TEXT,  varchar_col VARCHAR(16777216),  char_col CHAR(16777216));";
            statement.execute(sampleCreateTableWithAllColTypes);
            try (ResultSet rs = statement.executeQuery("select * from case_sensitive");){
                ResultSetMetaData metaData = rs.getMetaData();
                Assertions.assertFalse((boolean)metaData.isCaseSensitive(1));
                Assertions.assertFalse((boolean)metaData.isCaseSensitive(2));
                Assertions.assertFalse((boolean)metaData.isCaseSensitive(3));
                Assertions.assertFalse((boolean)metaData.isCaseSensitive(4));
                Assertions.assertFalse((boolean)metaData.isCaseSensitive(5));
                Assertions.assertFalse((boolean)metaData.isCaseSensitive(6));
                Assertions.assertFalse((boolean)metaData.isCaseSensitive(7));
                Assertions.assertFalse((boolean)metaData.isCaseSensitive(8));
                Assertions.assertFalse((boolean)metaData.isCaseSensitive(9));
                Assertions.assertFalse((boolean)metaData.isCaseSensitive(10));
                Assertions.assertTrue((boolean)metaData.isCaseSensitive(11));
                Assertions.assertTrue((boolean)metaData.isCaseSensitive(12));
                Assertions.assertTrue((boolean)metaData.isCaseSensitive(13));
                Assertions.assertTrue((boolean)metaData.isCaseSensitive(14));
                Assertions.assertTrue((boolean)metaData.isCaseSensitive(15));
                Assertions.assertTrue((boolean)metaData.isCaseSensitive(16));
                Assertions.assertTrue((boolean)metaData.isCaseSensitive(17));
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testAutoIncrementResult(String queryResultFormat) throws SQLException {
        Properties paramProperties = new Properties();
        paramProperties.put("ENABLE_FIX_759900", (Object)true);
        try (Connection connection = this.init(paramProperties, queryResultFormat);
             Statement statement = connection.createStatement();){
            statement.execute("create or replace table auto_inc(id int autoincrement, name varchar(10), another_col int autoincrement)");
            statement.execute("insert into auto_inc(name) values('test1')");
            try (ResultSet resultSet = statement.executeQuery("select * from auto_inc");){
                Assertions.assertTrue((boolean)resultSet.next());
                ResultSetMetaData metaData = resultSet.getMetaData();
                Assertions.assertTrue((boolean)metaData.isAutoIncrement(1));
                Assertions.assertFalse((boolean)metaData.isAutoIncrement(2));
                Assertions.assertTrue((boolean)metaData.isAutoIncrement(3));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGranularTimeFunctionsInSessionTimezone(String queryResultFormat) throws SQLException {
        try (Statement statement = this.createStatement(queryResultFormat);){
            try {
                statement.execute("create or replace table testGranularTime(t time)");
                statement.execute("insert into testGranularTime values ('10:10:10')");
                try (ResultSet resultSet = statement.executeQuery("select * from testGranularTime");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)Time.valueOf("10:10:10"), (Object)resultSet.getTime(1));
                    Assertions.assertEquals((int)10, (int)resultSet.getTime(1).getHours());
                    Assertions.assertEquals((int)10, (int)resultSet.getTime(1).getMinutes());
                    Assertions.assertEquals((int)10, (int)resultSet.getTime(1).getSeconds());
                }
            }
            finally {
                statement.execute("drop table if exists testGranularTime");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testGranularTimeFunctionsInUTC(String queryResultFormat) throws SQLException {
        TimeZone origTz = TimeZone.getDefault();
        try (Statement statement = this.createStatement(queryResultFormat);){
            try {
                TimeZone.setDefault(TimeZone.getTimeZone("America/Los_Angeles"));
                statement.execute("alter session set JDBC_USE_SESSION_TIMEZONE=false");
                statement.execute("create or replace table testGranularTime(t time)");
                statement.execute("insert into testGranularTime values ('10:10:10')");
                try (ResultSet resultSet = statement.executeQuery("select * from testGranularTime");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)Time.valueOf("02:10:10"), (Object)resultSet.getTime(1));
                    Assertions.assertEquals((int)2, (int)resultSet.getTime(1).getHours());
                    Assertions.assertEquals((int)10, (int)resultSet.getTime(1).getMinutes());
                    Assertions.assertEquals((int)10, (int)resultSet.getTime(1).getSeconds());
                }
            }
            finally {
                TimeZone.setDefault(origTz);
                statement.execute("drop table if exists testGranularTime");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testLargeStringRetrieval(String queryResultFormat) throws SQLException {
        String originalMaxJsonStringLength = System.getProperty("net.snowflake.jdbc.objectMapper.maxJsonStringLength");
        System.clearProperty("net.snowflake.jdbc.objectMapper.maxJsonStringLength");
        String tableName = "maxJsonStringLength_table";
        int colLength = 0x1000000;
        try (Connection con = ResultSetLatestIT.getConnection();
             Statement statement = con.createStatement();){
            ResultSetLatestIT.setQueryResultFormat(statement, queryResultFormat);
            SFBaseSession session = con.unwrap(SnowflakeConnectionV1.class).getSFBaseSession();
            Integer maxVarcharSize = (Integer)session.getOtherParameter("VARCHAR_AND_BINARY_MAX_SIZE_IN_RESULT");
            if (maxVarcharSize != null) {
                colLength = maxVarcharSize;
            }
            statement.execute("create or replace table " + tableName + " (c1 string(" + colLength + "))");
            statement.execute("insert into " + tableName + " select randstr(" + colLength + ", random())");
            try (ResultSet rs = statement.executeQuery("select * from " + tableName);){
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((int)colLength, (int)rs.getString(1).length());
                Assertions.assertFalse((boolean)rs.next());
            }
        }
        finally {
            if (originalMaxJsonStringLength != null) {
                System.setProperty("net.snowflake.jdbc.objectMapper.maxJsonStringLength", originalMaxJsonStringLength);
            }
        }
    }

    private static void assertAllColumnsAreLongButBigIntIsBigDecimal(ResultSet rs) throws SQLException {
        while (rs.next()) {
            Assertions.assertEquals(Long.class, rs.getObject(1).getClass());
            Assertions.assertEquals(BigDecimal.class, rs.getObject(2).getClass());
            Assertions.assertEquals(Long.class, rs.getObject(3).getClass());
            Assertions.assertEquals(Long.class, rs.getObject(4).getClass());
        }
    }

    private static void assertAllColumnsAreBigDecimal(ResultSet rs) throws SQLException {
        while (rs.next()) {
            Assertions.assertEquals(BigDecimal.class, rs.getObject(1).getClass());
            Assertions.assertEquals(BigDecimal.class, rs.getObject(2).getClass());
            Assertions.assertEquals(BigDecimal.class, rs.getObject(3).getClass());
            Assertions.assertEquals(BigDecimal.class, rs.getObject(4).getClass());
        }
    }

    @Test
    public void testGetObjectForArrowResultFormatJDBCArrowDecimalAsIntFalse() throws SQLException {
        Properties properties = new Properties();
        properties.put("JDBC_ARROW_TREAT_DECIMAL_AS_INT", (Object)false);
        try (Connection con = ResultSetLatestIT.getConnection(properties);
             Statement stmt = con.createStatement();){
            stmt.execute("alter session set jdbc_query_result_format = 'ARROW'");
            stmt.execute(this.createTableSql);
            stmt.execute(this.insertStmt);
            try (ResultSet rs = stmt.executeQuery(this.selectQuery);){
                ResultSetLatestIT.assertAllColumnsAreLongButBigIntIsBigDecimal(rs);
            }
            stmt.execute(this.setJdbcTreatDecimalAsIntFalse);
            rs = stmt.executeQuery(this.selectQuery);
            try {
                ResultSetLatestIT.assertAllColumnsAreBigDecimal(rs);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testGetObjectForArrowResultFormatJDBCArrowDecimalAsIntTrue() throws SQLException {
        try (Connection con = BaseJDBCTest.getConnection();
             Statement stmt = con.createStatement();){
            stmt.execute("alter session set jdbc_query_result_format = 'ARROW'");
            stmt.execute(this.createTableSql);
            stmt.execute(this.insertStmt);
            try (ResultSet rs = stmt.executeQuery(this.selectQuery);){
                ResultSetLatestIT.assertAllColumnsAreLongButBigIntIsBigDecimal(rs);
            }
            stmt.execute(this.setJdbcTreatDecimalAsIntFalse);
            rs = stmt.executeQuery(this.selectQuery);
            try {
                ResultSetLatestIT.assertAllColumnsAreLongButBigIntIsBigDecimal(rs);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testGetObjectForJSONResultFormatUsingJDBCDecimalAsInt() throws SQLException {
        try (Connection con = BaseJDBCTest.getConnection();
             Statement stmt = con.createStatement();){
            stmt.execute("alter session set jdbc_query_result_format = 'JSON'");
            stmt.execute(this.createTableSql);
            stmt.execute(this.insertStmt);
            try (ResultSet rs = stmt.executeQuery(this.selectQuery);){
                ResultSetLatestIT.assertAllColumnsAreLongButBigIntIsBigDecimal(rs);
            }
            stmt.execute(this.setJdbcTreatDecimalAsIntFalse);
            rs = stmt.executeQuery(this.selectQuery);
            try {
                ResultSetLatestIT.assertAllColumnsAreBigDecimal(rs);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    public void testGetObjectWithType(String queryResultFormat) throws SQLException {
        try (Statement statement = this.createStatement(queryResultFormat);){
            statement.execute(" CREATE OR REPLACE TABLE test_all_types (                  string VARCHAR,                   b TINYINT,                   s SMALLINT,                   i INTEGER,                   l BIGINT,                   f FLOAT,                   d DOUBLE,                   bd DOUBLE,                   bool BOOLEAN,                   timestampLtz TIMESTAMP_LTZ,                   timestampNtz TIMESTAMP_NTZ,                   timestampTz TIMESTAMP_TZ,                   date DATE,                  time TIME                   )");
            statement.execute("insert into test_all_types values('aString',1,2,3,4,1.1,2.2,3.3, false, '2021-12-22 09:43:44','2021-12-22 09:43:44','2021-12-22 09:43:44', '2023-12-24','12:34:56')");
            this.assertResultValueAndType(statement, "aString", "string", String.class);
            this.assertResultValueAndType(statement, new Byte("1"), "b", Byte.class);
            this.assertResultValueAndType(statement, Short.valueOf("2"), "s", Short.class);
            this.assertResultValueAndType(statement, Integer.valueOf("2"), "s", Integer.class);
            this.assertResultValueAndType(statement, Integer.valueOf("3"), "i", Integer.class);
            this.assertResultValueAndType(statement, Long.valueOf("4"), "l", Long.class);
            this.assertResultValueAndType(statement, BigDecimal.valueOf(4L), "l", BigDecimal.class);
            this.assertResultValueAndType(statement, Float.valueOf("1.1"), "f", Float.class);
            this.assertResultValueAndType(statement, Double.valueOf("1.1"), "f", Double.class);
            this.assertResultValueAndType(statement, Double.valueOf("2.2"), "d", Double.class);
            this.assertResultValueAndType(statement, BigDecimal.valueOf(3.3), "bd", BigDecimal.class);
            this.assertResultValueAndType(statement, "FALSE", "bool", String.class);
            this.assertResultValueAndType(statement, Boolean.FALSE, "bool", Boolean.class);
            this.assertResultValueAndType(statement, 0L, "bool", Long.class);
            this.assertResultValueAsString(statement, new SnowflakeTimestampWithTimezone(Timestamp.valueOf(LocalDateTime.of(2021, 12, 22, 9, 43, 44)), TimeZone.getDefault()), "timestampLtz", Timestamp.class);
            this.assertResultValueAsString(statement, new SnowflakeTimestampWithTimezone(Timestamp.valueOf(LocalDateTime.of(2021, 12, 22, 9, 43, 44)), TimeZone.getDefault()), "timestampNtz", Timestamp.class);
            this.assertResultValueAsString(statement, new SnowflakeTimestampWithTimezone(Timestamp.valueOf(LocalDateTime.of(2021, 12, 22, 9, 43, 44)), TimeZone.getDefault()), "timestampTz", Timestamp.class);
            this.assertResultValueAndType(statement, Date.valueOf(LocalDate.of(2023, 12, 24)), "date", Date.class);
            this.assertResultValueAndType(statement, Time.valueOf(LocalTime.of(12, 34, 56)), "time", Time.class);
        }
    }

    private void assertResultValueAndType(Statement statement, Object expected, String columnName, Class<?> type) throws SQLException {
        try (ResultSet resultSetString = statement.executeQuery(String.format("select %s from test_all_types", columnName));){
            Assertions.assertTrue((boolean)resultSetString.next());
            Assertions.assertEquals((Object)expected, resultSetString.getObject(1, type));
        }
    }

    private void assertResultValueAsString(Statement statement, Object expected, String columnName, Class type) throws SQLException {
        try (ResultSet resultSetString = statement.executeQuery(String.format("select %s from test_all_types", columnName));){
            Assertions.assertTrue((boolean)resultSetString.next());
            Assertions.assertEquals((Object)expected.toString(), (Object)resultSetString.getObject(1, type).toString());
        }
    }
}

