/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageExtendedErrorInformation;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.InvalidKeyException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeStatementV1;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeAzureClient;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Tag(value="others")
public class SnowflakeAzureClientHandleExceptionLatestIT
extends AbstractDriverIT {
    @TempDir
    private File tmpFolder;
    private Connection connection;
    private SFStatement sfStatement;
    private SFSession sfSession;
    private String command;
    private SnowflakeAzureClient spyingClient;
    private int overMaxRetry;
    private int maxRetry;

    @BeforeEach
    public void setup() throws SQLException {
        this.connection = SnowflakeAzureClientHandleExceptionLatestIT.getConnection("azureaccount");
        this.sfSession = this.connection.unwrap(SnowflakeConnectionV1.class).getSfSession();
        Statement statement = this.connection.createStatement();
        this.sfStatement = statement.unwrap(SnowflakeStatementV1.class).getSfStatement();
        statement.execute("CREATE OR REPLACE STAGE testPutGet_stage");
        this.command = "PUT file://" + SnowflakeAzureClientHandleExceptionLatestIT.getFullPathFileInResource("orders_100.csv") + " @testPutGet_stage";
        SnowflakeFileTransferAgent agent = new SnowflakeFileTransferAgent(this.command, this.sfSession, this.sfStatement);
        SnowflakeAzureClient client = SnowflakeAzureClient.createSnowflakeAzureClient((StageInfo)agent.getStageInfo(), (RemoteStoreFileEncryptionMaterial)((RemoteStoreFileEncryptionMaterial)agent.getEncryptionMaterial().get(0)), (SFBaseSession)this.sfSession);
        this.maxRetry = client.getMaxRetries();
        this.overMaxRetry = this.maxRetry + 1;
        this.spyingClient = (SnowflakeAzureClient)Mockito.spy((Object)client);
    }

    @Test
    @DontRunOnGithubActions
    public void error403RenewExpired() throws SQLException, InterruptedException {
        this.spyingClient.handleStorageException((Exception)new StorageException("403", "Unauthenticated", 403, new StorageExtendedErrorInformation(), new Exception()), 0, "upload", this.sfSession, this.command, null);
        ((SnowflakeAzureClient)Mockito.verify((Object)this.spyingClient, (VerificationMode)Mockito.times((int)2))).renew(Mockito.anyMap());
        final Exception[] exceptionContainer = new Exception[1];
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SnowflakeAzureClientHandleExceptionLatestIT.this.spyingClient.handleStorageException((Exception)new StorageException("403", "Unauthenticated", 403, new StorageExtendedErrorInformation(), new Exception()), SnowflakeAzureClientHandleExceptionLatestIT.this.maxRetry, "upload", SnowflakeAzureClientHandleExceptionLatestIT.this.sfSession, SnowflakeAzureClientHandleExceptionLatestIT.this.command, null);
                }
                catch (SnowflakeSQLException e) {
                    exceptionContainer[0] = e;
                }
            }
        });
        thread.start();
        thread.interrupt();
        thread.join();
        Assertions.assertNull((Object)exceptionContainer[0], (String)"Exception must not have been thrown in here");
        ((SnowflakeAzureClient)Mockito.verify((Object)this.spyingClient, (VerificationMode)Mockito.times((int)4))).renew(Mockito.anyMap());
    }

    @Test
    @DontRunOnGithubActions
    public void error403OverMaxRetryThrow() {
        Assertions.assertThrows(SnowflakeSQLException.class, () -> this.spyingClient.handleStorageException((Exception)new StorageException("403", "Unauthenticated", 403, new StorageExtendedErrorInformation(), new Exception()), this.overMaxRetry, "upload", this.sfSession, this.command, null));
    }

    @Test
    @DontRunOnGithubActions
    public void error403NullSession() {
        Assertions.assertThrows(SnowflakeSQLException.class, () -> this.spyingClient.handleStorageException((Exception)new StorageException("403", "Unauthenticated", 403, new StorageExtendedErrorInformation(), new Exception()), 0, "upload", null, this.command, null));
    }

    @Test
    @DontRunOnGithubActions
    public void errorInvalidKey() {
        Assertions.assertThrows(SnowflakeSQLException.class, () -> this.spyingClient.handleStorageException(new Exception(new InvalidKeyException()), 0, "upload", this.sfSession, this.command, null));
    }

    @Test
    @DontRunOnGithubActions
    public void errorInterruptedException() throws SQLException {
        this.spyingClient.handleStorageException((Exception)new InterruptedException(), 0, "upload", this.sfSession, this.command, null);
        ((SnowflakeAzureClient)Mockito.verify((Object)this.spyingClient, (VerificationMode)Mockito.never())).renew(Mockito.anyMap());
        Assertions.assertThrows(SnowflakeSQLException.class, () -> this.spyingClient.handleStorageException((Exception)new InterruptedException(), 26, "upload", this.sfSession, this.command, null));
    }

    @Test
    @DontRunOnGithubActions
    public void errorSocketTimeoutException() throws SnowflakeSQLException {
        this.spyingClient.handleStorageException((Exception)new SocketTimeoutException(), 0, "upload", this.sfSession, this.command, null);
        ((SnowflakeAzureClient)Mockito.verify((Object)this.spyingClient, (VerificationMode)Mockito.never())).renew(Mockito.anyMap());
        Assertions.assertThrows(SnowflakeSQLException.class, () -> this.spyingClient.handleStorageException((Exception)new SocketTimeoutException(), 26, "upload", this.sfSession, this.command, null));
    }

    @Test
    @DontRunOnGithubActions
    public void errorUnknownException() {
        Assertions.assertThrows(SnowflakeSQLException.class, () -> this.spyingClient.handleStorageException(new Exception(), 0, "upload", this.sfSession, this.command, null));
    }

    @Test
    @DontRunOnGithubActions
    public void errorNoSpaceLeftOnDevice() throws IOException {
        File destFolder = new File(this.tmpFolder, "dest");
        destFolder.mkdirs();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        String getCommand = "get @testPutGet_stage/orders_100.csv 'file://" + destFolderCanonicalPath + "'";
        Assertions.assertThrows(SnowflakeSQLException.class, () -> this.spyingClient.handleStorageException((Exception)new StorageException("", "No space left on device", (Exception)new IOException("No space left on device")), 0, "download", null, getCommand, null));
    }

    @AfterEach
    public void cleanUp() throws SQLException {
        this.sfStatement.close();
        this.connection.close();
    }
}

