/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.SQLException;
import java.util.Properties;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.jdbc.SnowflakeBasicDataSource;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SnowflakeBasicDataSourceTest {
    @Test
    public void testSetLoginTimeout() throws SQLException {
        SnowflakeBasicDataSource ds = new SnowflakeBasicDataSource();
        ds.setLoginTimeout(10);
        MatcherAssert.assertThat((Object)ds.getLoginTimeout(), (Matcher)CoreMatchers.is((Object)10));
    }

    @Test
    public void testDataSourceSetters() {
        SnowflakeBasicDataSource ds = new SnowflakeBasicDataSource();
        ds.setTracing("all");
        ds.setApplication("application_name");
        ds.setAccount("testaccount");
        ds.setAuthenticator("snowflake");
        ds.setArrowTreatDecimalAsInt(true);
        ds.setAllowUnderscoresInHost(true);
        ds.setClientConfigFile("/some/path/file.json");
        ds.setDisableGcsDefaultCredentials(false);
        ds.setDisableSamlURLCheck(false);
        ds.setDisableSocksProxy(false);
        ds.setEnablePatternSearch(true);
        ds.setDatabaseName("DB_NAME");
        ds.setEnablePutGet(false);
        ds.setMaxHttpRetries(5);
        ds.setNetworkTimeout(10);
        ds.setOcspFailOpen(false);
        ds.setProxyHost("proxyHost.com");
        ds.setProxyPort(8080);
        ds.setProxyProtocol("http");
        ds.setProxyUser("proxyUser");
        ds.setProxyPassword("proxyPassword");
        ds.setPutGetMaxRetries(3);
        ds.setStringsQuotedForColumnDef(true);
        ds.setEnableDiagnostics(true);
        ds.setDiagnosticsAllowlistFile("/some/path/allowlist.json");
        Properties props = ds.getProperties();
        Assertions.assertEquals((Object)"testaccount", (Object)props.get("account"));
        Assertions.assertEquals((Object)"snowflake", (Object)props.get("authenticator"));
        Assertions.assertEquals((Object)"all", (Object)props.get("tracing"));
        Assertions.assertEquals((Object)"application_name", (Object)props.get(SFSessionProperty.APPLICATION.getPropertyKey()));
        Assertions.assertEquals((Object)"snowflake", (Object)props.get(SFSessionProperty.AUTHENTICATOR.getPropertyKey()));
        Assertions.assertEquals((Object)"true", (Object)props.get(SFSessionProperty.JDBC_ARROW_TREAT_DECIMAL_AS_INT.getPropertyKey()));
        Assertions.assertEquals((Object)"true", (Object)props.get(SFSessionProperty.ALLOW_UNDERSCORES_IN_HOST.getPropertyKey()));
        Assertions.assertEquals((Object)"/some/path/file.json", (Object)props.get(SFSessionProperty.CLIENT_CONFIG_FILE.getPropertyKey()));
        Assertions.assertEquals((Object)"false", (Object)props.get(SFSessionProperty.DISABLE_GCS_DEFAULT_CREDENTIALS.getPropertyKey()));
        Assertions.assertEquals((Object)"false", (Object)props.get(SFSessionProperty.DISABLE_SAML_URL_CHECK.getPropertyKey()));
        Assertions.assertEquals((Object)"false", (Object)props.get(SFSessionProperty.DISABLE_SOCKS_PROXY.getPropertyKey()));
        Assertions.assertEquals((Object)"true", (Object)props.get(SFSessionProperty.ENABLE_PATTERN_SEARCH.getPropertyKey()));
        Assertions.assertEquals((Object)"DB_NAME", (Object)props.get(SFSessionProperty.DATABASE.getPropertyKey()));
        Assertions.assertEquals((Object)"false", (Object)props.get(SFSessionProperty.ENABLE_PUT_GET.getPropertyKey()));
        Assertions.assertEquals((Object)"5", (Object)props.get(SFSessionProperty.MAX_HTTP_RETRIES.getPropertyKey()));
        Assertions.assertEquals((Object)"10", (Object)props.get(SFSessionProperty.NETWORK_TIMEOUT.getPropertyKey()));
        Assertions.assertEquals((Object)"false", (Object)props.get(SFSessionProperty.OCSP_FAIL_OPEN.getPropertyKey()));
        Assertions.assertEquals((Object)"proxyHost.com", (Object)props.get(SFSessionProperty.PROXY_HOST.getPropertyKey()));
        Assertions.assertEquals((Object)"8080", (Object)props.get(SFSessionProperty.PROXY_PORT.getPropertyKey()));
        Assertions.assertEquals((Object)"http", (Object)props.get(SFSessionProperty.PROXY_PROTOCOL.getPropertyKey()));
        Assertions.assertEquals((Object)"proxyUser", (Object)props.get(SFSessionProperty.PROXY_USER.getPropertyKey()));
        Assertions.assertEquals((Object)"proxyPassword", (Object)props.get(SFSessionProperty.PROXY_PASSWORD.getPropertyKey()));
        Assertions.assertEquals((Object)"3", (Object)props.get(SFSessionProperty.PUT_GET_MAX_RETRIES.getPropertyKey()));
        Assertions.assertEquals((Object)"true", (Object)props.get(SFSessionProperty.STRINGS_QUOTED.getPropertyKey()));
        Assertions.assertEquals((Object)"true", (Object)props.get(SFSessionProperty.ENABLE_DIAGNOSTICS.getPropertyKey()));
        Assertions.assertEquals((Object)"/some/path/allowlist.json", (Object)props.get(SFSessionProperty.DIAGNOSTICS_ALLOWLIST_FILE.getPropertyKey()));
        ds.setOauthToken("a_token");
        Assertions.assertEquals((Object)"OAUTH", (Object)props.get(SFSessionProperty.AUTHENTICATOR.getPropertyKey()));
        Assertions.assertEquals((Object)"a_token", (Object)props.get(SFSessionProperty.TOKEN.getPropertyKey()));
        ds.setPasscodeInPassword(true);
        Assertions.assertEquals((Object)"true", (Object)props.get(SFSessionProperty.PASSCODE_IN_PASSWORD.getPropertyKey()));
        Assertions.assertEquals((Object)"USERNAME_PASSWORD_MFA", (Object)props.get(SFSessionProperty.AUTHENTICATOR.getPropertyKey()));
        ds.setPrivateKeyFile("key.p8", "pwd");
        Assertions.assertEquals((Object)"key.p8", (Object)props.get(SFSessionProperty.PRIVATE_KEY_FILE.getPropertyKey()));
        Assertions.assertEquals((Object)"pwd", (Object)props.get(SFSessionProperty.PRIVATE_KEY_PWD.getPropertyKey()));
        Assertions.assertEquals((Object)"SNOWFLAKE_JWT", (Object)props.get(SFSessionProperty.AUTHENTICATOR.getPropertyKey()));
        ds.setPasscodeInPassword(false);
        ds.setPasscode("a_passcode");
        Assertions.assertEquals((Object)"false", (Object)props.get(SFSessionProperty.PASSCODE_IN_PASSWORD.getPropertyKey()));
        Assertions.assertEquals((Object)"USERNAME_PASSWORD_MFA", (Object)props.get(SFSessionProperty.AUTHENTICATOR.getPropertyKey()));
        Assertions.assertEquals((Object)"a_passcode", (Object)props.get(SFSessionProperty.PASSCODE.getPropertyKey()));
        ds.setPrivateKeyBase64("fake_key", "pwd");
        Assertions.assertEquals((Object)"fake_key", (Object)props.get(SFSessionProperty.PRIVATE_KEY_BASE64.getPropertyKey()));
        Assertions.assertEquals((Object)"pwd", (Object)props.get(SFSessionProperty.PRIVATE_KEY_PWD.getPropertyKey()));
        Assertions.assertEquals((Object)"SNOWFLAKE_JWT", (Object)props.get(SFSessionProperty.AUTHENTICATOR.getPropertyKey()));
    }

    @Test
    public void testDataSourceWithoutUsernameOrPasswordThrowsExplicitException() {
        SnowflakeBasicDataSource ds = new SnowflakeBasicDataSource();
        ds.setAccount("testaccount");
        ds.setAuthenticator("snowflake");
        Exception e = (Exception)Assertions.assertThrows(SnowflakeSQLException.class, () -> ((SnowflakeBasicDataSource)ds).getConnection());
        Assertions.assertEquals((Object)"Cannot create connection because username is missing in DataSource properties.", (Object)e.getMessage());
        ds.setUser("testuser");
        e = (Exception)Assertions.assertThrows(SnowflakeSQLException.class, () -> ((SnowflakeBasicDataSource)ds).getConnection());
        Assertions.assertEquals((Object)"Cannot create connection because password is missing in DataSource properties.", (Object)e.getMessage());
    }
}

