/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.nio.channels.FileChannel;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.annotations.DontRunOnTestaccount;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import org.apache.commons.io.FileUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

@Tag(value="others")
public class SnowflakeDriverIT
extends BaseJDBCTest {
    private static final int MAX_CONCURRENT_QUERIES_PER_USER = 50;
    private static final String getCurrenTransactionStmt = "SELECT CURRENT_TRANSACTION()";
    private static Logger logger = Logger.getLogger(SnowflakeDriverIT.class.getName());
    private static String ORDERS_JDBC = "ORDERS_JDBC";
    @TempDir
    private File tmpFolder;
    private ObjectMapper mapper = new ObjectMapper();
    @TempDir
    public File tmpFolder2;
    public String testStageName = String.format("test_stage_%s", UUID.randomUUID().toString()).replaceAll("-", "_");

    @BeforeAll
    public static void setUp() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("create or replace table orders_jdbc(C1 STRING NOT NULL COMMENT 'JDBC', C2 STRING, C3 STRING, C4 STRING, C5 STRING, C6 STRING, C7 STRING, C8 STRING, C9 STRING) stage_file_format = (field_delimiter='|' error_on_column_count_mismatch=false)");
            statement.execute("create or replace table clustered_jdbc (c1 number, c2 number) cluster by (c1)");
            Assertions.assertTrue((boolean)statement.execute("PUT file://" + SnowflakeDriverIT.getFullPathFileInResource("orders_100.csv") + " @%orders_jdbc"), (String)"Failed to put a file");
            Assertions.assertTrue((boolean)statement.execute("PUT file://" + SnowflakeDriverIT.getFullPathFileInResource("orders_101.csv") + " @%orders_jdbc"), (String)"Failed to put a file");
            int numRows = statement.executeUpdate("copy into orders_jdbc");
            Assertions.assertEquals((int)73, (int)numRows, (String)("Unexpected number of rows copied: " + numRows));
        }
    }

    @AfterAll
    public static void tearDown() throws SQLException {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("drop table if exists clustered_jdbc");
            statement.execute("drop table if exists orders_jdbc");
        }
    }

    public static Connection getConnection(int injectSocketTimeout) throws SQLException {
        Connection connection = AbstractDriverIT.getConnection(injectSocketTimeout);
        try (Statement statement = connection.createStatement();){
            statement.execute("alter session set TIMEZONE='America/Los_Angeles',TIMESTAMP_TYPE_MAPPING='TIMESTAMP_LTZ',TIMESTAMP_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_TZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_LTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM',TIMESTAMP_NTZ_OUTPUT_FORMAT='DY, DD MON YYYY HH24:MI:SS TZHTZM'");
        }
        return connection;
    }

    public static Connection getConnection() throws SQLException {
        return SnowflakeDriverIT.getConnection(0);
    }

    @Test
    @DontRunOnGithubActions
    public void testOauthConnection() throws SQLException {
        Map<String, String> params = SnowflakeDriverIT.getConnectionParameters();
        String role = null;
        String token = null;
        try (Connection con = SnowflakeDriverIT.getConnection("s3testaccount");
             Statement statement = con.createStatement();){
            statement.execute("use role accountadmin");
            statement.execute("create or replace security integration jdbc_oauth_integration\n  type=oauth\n  oauth_client=CUSTOM\n  oauth_client_type=CONFIDENTIAL\n  oauth_redirect_uri='https://localhost.com/oauth'\n  oauth_issue_refresh_tokens=true\n  enabled=true oauth_refresh_token_validity=86400;");
            role = params.get("role");
            try (ResultSet rs = statement.executeQuery("select system$it('create_oauth_access_token', 'JDBC_OAUTH_INTEGRATION', '" + role + "')");){
                Assertions.assertTrue((boolean)rs.next());
                token = rs.getString(1);
            }
        }
        Properties props = new Properties();
        props.put("authenticator", "OAUTH");
        props.put("token", token);
        props.put("role", role);
        try (Connection con = SnowflakeDriverIT.getConnection("s3testaccount", props);
             Statement statement = con.createStatement();){
            statement.execute("select 1");
        }
    }

    @Disabled
    @Test
    public void testConnections() throws Throwable {
        ExecutorService executorService = Executors.newFixedThreadPool(50);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        int idx = 0;
        while (idx < 50) {
            logger.info("open a new connection and submit query " + idx);
            int queryIdx = idx++;
            futures.add(executorService.submit(() -> {
                try (Connection connection = SnowflakeDriverIT.getConnection();
                     Statement statement = connection.createStatement();
                     ResultSet resultSet = statement.executeQuery("SELECT system$sleep(10) % 1");){
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    Assertions.assertEquals((int)1, (int)resultSetMetaData.getColumnCount());
                    for (int i = 0; i < 1; ++i) {
                        Assertions.assertTrue((boolean)resultSet.next());
                        for (int j = 1; j < 2; ++j) {
                            Assertions.assertEquals((int)0, (int)resultSet.getInt(j));
                        }
                    }
                    logger.info("Query " + queryIdx + " passed ");
                }
                return true;
            }));
        }
        executorService.shutdown();
        for (idx = 0; idx < 50; ++idx) {
            ((Future)futures.get(idx)).get();
        }
    }

    @Test
    public void testShowColumns() throws Throwable {
        Properties paramProperties = new Properties();
        try (Connection connection = SnowflakeDriverIT.getConnection(paramProperties);
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("show columns in clustered_jdbc");){
            Assertions.assertEquals((int)2, (int)this.countRows(resultSet), (String)"number of columns");
        }
    }

    private int countRows(ResultSet rset) throws Throwable {
        int cnt = 0;
        while (rset.next()) {
            ++cnt;
        }
        return cnt;
    }

    @Test
    public void testRowsPerResultset() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();){
            connection.createStatement().execute("alter session set rows_per_resultset=2048");
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT * FROM orders_jdbc");){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int numColumns = resultSetMetaData.getColumnCount();
                Assertions.assertEquals((int)9, (int)numColumns);
                Assertions.assertEquals((int)73, (int)this.countRows(resultSet), (String)"number of columns");
            }
        }
    }

    @Test
    public void testDDLs() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.execute("CREATE OR REPLACE TABLE testDDLs(version number, name string)");
            }
            finally {
                statement.execute("DROP TABLE testDDLs");
            }
        }
    }

    private long getCurrentTransaction(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute(getCurrenTransactionStmt);
            try (ResultSet rs = statement.getResultSet();){
                if (rs.next()) {
                    String txnId = rs.getString(1);
                    long l = txnId != null ? Long.valueOf(txnId) : 0L;
                    return l;
                }
            }
        }
        throw new SQLException("SELECT CURRENT_TRANSACTION() didn't return a result.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutocommit() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                connection.setTransactionIsolation(2);
                Assertions.assertEquals((int)2, (int)connection.getTransactionIsolation());
                connection.setAutoCommit(false);
                Assertions.assertFalse((boolean)connection.getAutoCommit());
                Assertions.assertEquals((long)0L, (long)this.getCurrentTransaction(connection));
                statement.executeUpdate("CREATE OR REPLACE TABLE AUTOCOMMIT_API_TEST (i int)");
                Assertions.assertEquals((long)0L, (long)this.getCurrentTransaction(connection));
                statement.executeUpdate("INSERT INTO AUTOCOMMIT_API_TEST VALUES (1)");
                Assertions.assertNotEquals((long)0L, (long)this.getCurrentTransaction(connection));
                connection.commit();
                Assertions.assertFalse((boolean)connection.getAutoCommit());
                Assertions.assertEquals((long)0L, (long)this.getCurrentTransaction(connection));
                try (ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM AUTOCOMMIT_API_TEST WHERE i = 1");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((int)1, (int)resultSet.getInt(1));
                }
                statement.executeUpdate("DELETE FROM AUTOCOMMIT_API_TEST");
                Assertions.assertNotEquals((long)0L, (long)this.getCurrentTransaction(connection));
                connection.rollback();
                Assertions.assertFalse((boolean)connection.getAutoCommit());
                Assertions.assertEquals((long)0L, (long)this.getCurrentTransaction(connection));
                resultSet = statement.executeQuery("SELECT COUNT(*) FROM AUTOCOMMIT_API_TEST WHERE i = 1");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((int)1, (int)resultSet.getInt(1));
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                statement.execute("DROP TABLE AUTOCOMMIT_API_TEST");
            }
        }
    }

    private void assertConstraintResults(ResultSet resultSet, int numRows, int numCols, String pkTableName, String fkTableName) throws Throwable {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Assertions.assertEquals((int)numCols, (int)resultSetMetaData.getColumnCount());
        for (int i = 0; i < numRows; ++i) {
            Assertions.assertTrue((boolean)resultSet.next(), (String)"get constraint result row count");
            if (pkTableName != null) {
                Assertions.assertTrue((boolean)pkTableName.equalsIgnoreCase(resultSet.getString(3)), (String)"get constraint result primary table name");
            }
            if (fkTableName == null) continue;
            Assertions.assertTrue((boolean)fkTableName.equalsIgnoreCase(resultSet.getString(7)), (String)"get constraint result foreign table name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBoolean() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.execute("alter SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=true");
                DatabaseMetaData metadata = connection.getMetaData();
                statement.execute("create or replace table testBooleanT1(c1 boolean)");
                statement.execute("insert into testBooleanT1 values(true), (false), (null)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("select c1 from testBooleanT1");
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    Assertions.assertEquals((int)16, (int)resultSetMetaData.getColumnType(1));
                    try (ResultSet columnMetaDataResultSet = metadata.getColumns(null, null, "TESTBOOLEANT1", null);){
                        resultSetMetaData = columnMetaDataResultSet.getMetaData();
                        Assertions.assertEquals((int)24, (int)resultSetMetaData.getColumnCount());
                        Assertions.assertTrue((boolean)columnMetaDataResultSet.next());
                        Assertions.assertEquals((int)16, (int)columnMetaDataResultSet.getInt(5));
                    }
                }
            }
            finally {
                statement.execute("drop table testBooleanT1");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstraints() throws Throwable {
        ResultSet manualResultSet = null;
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.execute("alter SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=true");
                DatabaseMetaData metadata = connection.getMetaData();
                statement.execute("CREATE OR REPLACE TABLE testConstraintsP1(c1 number unique, c2 number, constraint cons0 primary key (c1, c2))");
                statement.execute("CREATE OR REPLACE TABLE testConstraintsP2(c1 number constraint cons1 primary key, c2 number)");
                statement.execute("CREATE OR REPLACE TABLE testConstraintsF1(c1 number, c2 number, constraint cons3 foreign key (c1, c2) references testConstraintsP1(c1, c2))");
                statement.execute("CREATE OR REPLACE TABLE testConstraintsF2(c1 number, c2 number, constraint cons4 foreign key (c1, c2) references testConstraintsP1(c1, c2), constraint cons5 foreign key (c2) references testConstraintsP2(c1))");
                try (ResultSet resultSet = metadata.getPrimaryKeys(null, null, "TESTCONSTRAINTSP1");){
                    this.assertConstraintResults(resultSet, 2, 6, "testConstraintsP1", null);
                }
                ResultSet resultSet1 = metadata.getPrimaryKeys(null, null, "TESTCONSTRAINTSP2");
                this.assertConstraintResults(resultSet1, 1, 6, "testConstraintsP2", null);
                resultSet1.close();
                Assertions.assertFalse((boolean)resultSet1.next());
                try (ResultSet resultSet = metadata.getImportedKeys(null, null, "TESTCONSTRAINTSF1");){
                    this.assertConstraintResults(resultSet, 2, 14, null, "testConstraintsF1");
                }
                manualResultSet = metadata.getImportedKeys(null, null, "TESTCONSTRAINTSF2");
                this.assertConstraintResults(manualResultSet, 3, 14, null, "testConstraintsF2");
                manualResultSet.close();
                Assertions.assertFalse((boolean)manualResultSet.next());
                resultSet = metadata.getExportedKeys(null, null, "TESTCONSTRAINTSP1");
                try {
                    this.assertConstraintResults(resultSet, 4, 14, "testConstraintsP1", null);
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                manualResultSet = metadata.getExportedKeys(null, null, "TESTCONSTRAINTSP2");
                this.assertConstraintResults(manualResultSet, 1, 14, "testConstraintsP2", null);
                manualResultSet.close();
                Assertions.assertFalse((boolean)manualResultSet.next());
                resultSet = metadata.getCrossReference(null, null, "TESTCONSTRAINTSP1", null, null, "TESTCONSTRAINTSF1");
                try {
                    this.assertConstraintResults(resultSet, 2, 14, "testConstraintsP1", "testConstraintsF1");
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metadata.getCrossReference(null, null, "TESTCONSTRAINTSP2", null, null, "TESTCONSTRAINTSF2");
                try {
                    this.assertConstraintResults(resultSet, 1, 14, "testConstraintsP2", "testConstraintsF2");
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = metadata.getCrossReference(null, null, "TESTCONSTRAINTSP1", null, null, "TESTCONSTRAINTSF2");
                try {
                    this.assertConstraintResults(resultSet, 2, 14, "testConstraintsP1", "testConstraintsF2");
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                manualResultSet = metadata.getCrossReference(null, null, "TESTCONSTRAINTSP2", null, null, "TESTCONSTRAINTSF1");
                Assertions.assertFalse((boolean)manualResultSet.next(), (String)"cross reference from testConstraintsP2 to testConstraintsF2 should be empty");
                manualResultSet.close();
                Assertions.assertFalse((boolean)manualResultSet.next());
            }
            finally {
                statement.execute("DROP TABLE TESTCONSTRAINTSF1");
                statement.execute("DROP TABLE TESTCONSTRAINTSF2");
                statement.execute("DROP TABLE TESTCONSTRAINTSP1");
                statement.execute("DROP TABLE TESTCONSTRAINTSP2");
            }
        }
    }

    @Test
    public void testQueryWithMaxRows() throws Throwable {
        int maxRows = 30;
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            statement.setMaxRows(30);
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM orders_jdbc");){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((int)9, (int)resultSetMetaData.getColumnCount());
                Assertions.assertEquals((int)30, (int)this.countRows(resultSet));
            }
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testCancelQueryBySystemFunction() throws Throwable {
        try (final Connection connection = SnowflakeDriverIT.getConnection();
             Statement getSessionIdStmt = connection.createStatement();){
            getSessionIdStmt.setMaxRows(30);
            try (ResultSet resultSet = getSessionIdStmt.executeQuery("SELECT current_session()");){
                Assertions.assertTrue((boolean)resultSet.next());
                final long sessionId = resultSet.getLong(1);
                Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            PreparedStatement cancelAll = connection.prepareStatement("call system$cancel_all_queries(?)");
                            cancelAll.setLong(1, sessionId);
                            cancelAll.executeQuery();
                        }
                        catch (SQLException ex) {
                            logger.log(Level.SEVERE, "Cancel failed with exception {}", ex);
                        }
                    }
                }, 5000L);
            }
            try (Statement statement = connection.createStatement();){
                statement.setMaxRows(30);
                SQLException ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> statement.executeQuery("SELECT count(*) FROM TABLE(generator(timeLimit => 120))").close());
                Assertions.assertEquals((Object)"57014", (Object)ex.getSQLState(), (String)"sqlstate mismatch");
            }
        }
    }

    @Test
    public void testDBMetadata() throws Throwable {
        int cnt = 0;
        try (Connection connection = SnowflakeDriverIT.getConnection();){
            ResultSetMetaData resultSetMetaData;
            try (Statement statement = connection.createStatement();){
                statement.execute("alter SESSION set CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX=true");
            }
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet databaseSet = metaData.getCatalogs();){
                Assertions.assertTrue((boolean)databaseSet.next(), (String)"databases shouldn't be empty");
                ResultSet schemaSet = metaData.getSchemas(connection.getCatalog(), connection.getSchema());
                Assertions.assertTrue((boolean)schemaSet.next(), (String)"schemas shouldn't be empty");
                Assertions.assertTrue((boolean)connection.getCatalog().equalsIgnoreCase(schemaSet.getString(2)), (String)("database should be " + connection.getCatalog()));
                Assertions.assertTrue((boolean)connection.getSchema().equalsIgnoreCase(schemaSet.getString(1)), (String)("schema should be " + connection.getSchema()));
                try (ResultSet tableSet = metaData.getTables(connection.getCatalog(), connection.getSchema(), ORDERS_JDBC, null);){
                    Assertions.assertTrue((boolean)tableSet.next(), (String)String.format("table %s should exists in db: %s, schema: %s", ORDERS_JDBC, connection.getCatalog(), connection.getSchema()));
                    Assertions.assertTrue((boolean)connection.getCatalog().equalsIgnoreCase(schemaSet.getString(2)), (String)("database should be " + connection.getCatalog()));
                    Assertions.assertTrue((boolean)connection.getSchema().equalsIgnoreCase(schemaSet.getString(1)), (String)("schema should be " + connection.getSchema()));
                    Assertions.assertTrue((boolean)ORDERS_JDBC.equalsIgnoreCase(tableSet.getString(3)), (String)"table should be orders_jdbc");
                }
            }
            try (ResultSet tableMetaDataResultSet = metaData.getTables(null, null, ORDERS_JDBC, null);){
                resultSetMetaData = tableMetaDataResultSet.getMetaData();
                Assertions.assertEquals((int)10, (int)resultSetMetaData.getColumnCount());
                cnt = 0;
                while (tableMetaDataResultSet.next()) {
                    Assertions.assertTrue((boolean)ORDERS_JDBC.equalsIgnoreCase(tableMetaDataResultSet.getString(3)));
                    ++cnt;
                }
                Assertions.assertEquals((int)1, (int)cnt, (String)"number of tables");
            }
            tableMetaDataResultSet = metaData.getTables(null, null, "%", null);
            try {
                resultSetMetaData = tableMetaDataResultSet.getMetaData();
                Assertions.assertEquals((int)10, (int)resultSetMetaData.getColumnCount());
                boolean found = false;
                while (tableMetaDataResultSet.next()) {
                    if (!ORDERS_JDBC.equalsIgnoreCase(tableMetaDataResultSet.getString(3))) continue;
                    found = true;
                    break;
                }
                Assertions.assertTrue((boolean)found, (String)"orders_jdbc not found");
            }
            finally {
                if (tableMetaDataResultSet != null) {
                    tableMetaDataResultSet.close();
                }
            }
            try (ResultSet columnMetaDataResultSet = metaData.getColumns(null, null, ORDERS_JDBC, null);){
                resultSetMetaData = columnMetaDataResultSet.getMetaData();
                Assertions.assertEquals((int)24, (int)resultSetMetaData.getColumnCount());
                cnt = 0;
                while (columnMetaDataResultSet.next()) {
                    Assertions.assertTrue((boolean)connection.getCatalog().equalsIgnoreCase(columnMetaDataResultSet.getString(1)));
                    Assertions.assertTrue((boolean)ORDERS_JDBC.equalsIgnoreCase(columnMetaDataResultSet.getString(3)));
                    Assertions.assertTrue((boolean)columnMetaDataResultSet.getString(4).startsWith("C"));
                    Assertions.assertEquals((int)12, (int)columnMetaDataResultSet.getInt(5));
                    Assertions.assertTrue((boolean)"VARCHAR".equalsIgnoreCase(columnMetaDataResultSet.getString(6)));
                    if (cnt == 0) {
                        Assertions.assertEquals((Object)"JDBC", (Object)columnMetaDataResultSet.getString(12));
                        Assertions.assertEquals((int)0, (int)columnMetaDataResultSet.getInt(11));
                        Assertions.assertEquals((Object)"NO", (Object)columnMetaDataResultSet.getString(18));
                    }
                    ++cnt;
                }
                Assertions.assertEquals((int)9, (int)cnt);
            }
            try (Statement statement = connection.createStatement();){
                statement.execute("create or replace table \"testDBMetadata\" (a timestamp_ltz)");
                try (ResultSet columnMetaDataResultSet = metaData.getColumns(null, null, "testDBMetadata", null);){
                    cnt = 0;
                    while (columnMetaDataResultSet.next()) {
                        Assertions.assertTrue((boolean)"testDBMetadata".equalsIgnoreCase(columnMetaDataResultSet.getString(3)));
                        Assertions.assertEquals((int)93, (int)columnMetaDataResultSet.getInt(5));
                        Assertions.assertTrue((boolean)columnMetaDataResultSet.getString(4).equalsIgnoreCase("a"));
                        ++cnt;
                    }
                    Assertions.assertEquals((int)1, (int)cnt);
                }
            }
            connection.createStatement().execute("DROP TABLE IF EXISTS \"testDBMetadata\"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testPutWithWildcardGCP() throws Throwable {
        Properties _connectionProperties = new Properties();
        _connectionProperties.put("inject_wait_in_put", (Object)5);
        _connectionProperties.put("ssl", "off");
        try (Connection connection = SnowflakeDriverIT.getConnection(0, _connectionProperties, false, false, "gcpaccount");
             Statement statement = connection.createStatement();){
            try {
                String sourceFilePath = SnowflakeDriverIT.getFullPathFileInResource("orders_100.csv");
                sourceFilePath = sourceFilePath.replace("orders_100.csv", "orders_10*.csv");
                File destFolder = new File(this.tmpFolder, "dest");
                destFolder.mkdirs();
                String destFolderCanonicalPath = destFolder.getCanonicalPath();
                String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
                statement.execute("alter session set ENABLE_GCP_PUT_EXCEPTION_FOR_OLD_DRIVERS=false");
                statement.execute("CREATE OR REPLACE STAGE wildcard_stage");
                Assertions.assertTrue((boolean)statement.execute("PUT file://" + sourceFilePath + " @wildcard_stage"), (String)"Failed to put a file");
                SnowflakeDriverIT.findFile(statement, "ls @wildcard_stage/");
                Assertions.assertTrue((boolean)statement.execute("GET @wildcard_stage 'file://" + destFolderCanonicalPath + "' parallel=8"), (String)"Failed to get files");
                for (int i = 0; i < fileNames.length; ++i) {
                    File downloaded = new File(destFolderCanonicalPathWithSeparator + fileNames[i] + ".gz");
                    Assertions.assertTrue((boolean)downloaded.exists());
                    Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + fileNames[i] + ".gz");
                    p.waitFor();
                    String individualFilePath = sourceFilePath.replace("orders_10*.csv", fileNames[i]);
                    File original = new File(individualFilePath);
                    File unzipped = new File(destFolderCanonicalPathWithSeparator + fileNames[i]);
                    Assertions.assertEquals((long)original.length(), (long)unzipped.length());
                    Assertions.assertTrue((boolean)FileUtils.contentEquals((File)original, (File)unzipped));
                }
            }
            finally {
                statement.execute("DROP STAGE IF EXISTS wildcard_stage");
            }
        }
    }

    private void copyContentFrom(File file1, File file2) throws Exception {
        FileInputStream inputStream = new FileInputStream(file1);
        FileOutputStream outputStream = new FileOutputStream(file2);
        try (FileChannel fIn = inputStream.getChannel();
             FileChannel fOut = outputStream.getChannel();){
            fOut.transferFrom(fIn, 0L, fIn.size());
            fIn.position(0L);
            fOut.transferFrom(fIn, fIn.size(), fIn.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testPutGetLargeFileGCP() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection("gcpaccount");
             Statement statement = connection.createStatement();){
            try {
                File destFolder = new File(this.tmpFolder, "dest");
                destFolder.mkdirs();
                String destFolderCanonicalPath = destFolder.getCanonicalPath();
                String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
                File largeTempFile = new File(this.tmpFolder, "largeFile.csv");
                largeTempFile.createNewFile();
                try (BufferedWriter bw = new BufferedWriter(new FileWriter(largeTempFile));){
                    bw.write("Creating large test file for GCP PUT/GET test");
                    bw.write(System.lineSeparator());
                    bw.write("Creating large test file for GCP PUT/GET test");
                    bw.write(System.lineSeparator());
                }
                File largeTempFile2 = new File(this.tmpFolder, "largeFile2.csv");
                largeTempFile2.createNewFile();
                String sourceFilePath = largeTempFile.getCanonicalPath();
                for (int i = 0; i < 12; ++i) {
                    this.copyContentFrom(largeTempFile, largeTempFile2);
                    this.copyContentFrom(largeTempFile2, largeTempFile);
                }
                statement.execute("alter session set ENABLE_GCP_PUT_EXCEPTION_FOR_OLD_DRIVERS=false");
                statement.execute("CREATE OR REPLACE STAGE largefile_stage");
                Assertions.assertTrue((boolean)statement.execute("PUT file://" + sourceFilePath + " @largefile_stage"), (String)"Failed to put a file");
                SnowflakeDriverIT.findFile(statement, "ls @largefile_stage/");
                statement.execute("create or replace table large_table (colA string)");
                statement.execute("copy into large_table from @largefile_stage/largeFile.csv.gz");
                statement.execute("create or replace stage extra_stage");
                statement.execute("copy into @extra_stage/bigFile.csv.gz from large_table single=true");
                Assertions.assertTrue((boolean)statement.execute("GET @extra_stage 'file://" + destFolderCanonicalPath + "' parallel=8"), (String)"Failed to get files");
                File downloaded = new File(destFolderCanonicalPathWithSeparator + "bigFile.csv.gz");
                Assertions.assertTrue((boolean)downloaded.exists());
                Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + "bigFile.csv.gz");
                p.waitFor();
                File unzipped = new File(destFolderCanonicalPathWithSeparator + "bigFile.csv");
                Assertions.assertEquals((long)largeTempFile.length(), (long)unzipped.length());
                Assertions.assertTrue((boolean)FileUtils.contentEquals((File)largeTempFile, (File)unzipped));
            }
            finally {
                statement.execute("DROP STAGE IF EXISTS largefile_stage");
                statement.execute("DROP STAGE IF EXISTS extra_stage");
                statement.execute("DROP TABLE IF EXISTS large_table");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testPutOverwrite() throws Throwable {
        File file1 = new File(this.tmpFolder, "testfile.csv");
        file1.createNewFile();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file1));){
            bw.write("Writing original file content. This should get overwritten.");
        }
        File file2 = new File(this.tmpFolder2, "testfile.csv");
        file2.createNewFile();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file2));){
            bw.write("This is all new! This should be the result of the overwriting.");
        }
        String sourceFilePathOriginal = file1.getCanonicalPath();
        String sourceFilePathOverwrite = file2.getCanonicalPath();
        File destFolder = new File(this.tmpFolder, "dest");
        destFolder.mkdirs();
        String destFolderCanonicalPath = destFolder.getCanonicalPath();
        String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
        List<String> accounts = Arrays.asList(null, "s3testaccount", "azureaccount", "gcpaccount");
        for (int i = 0; i < accounts.size(); ++i) {
            try (Connection connection = SnowflakeDriverIT.getConnection(accounts.get(i));
                 Statement statement = connection.createStatement();){
                try {
                    statement.execute("alter session set ENABLE_GCP_PUT_EXCEPTION_FOR_OLD_DRIVERS=false");
                    statement.execute("CREATE OR REPLACE STAGE testing_stage");
                    Assertions.assertTrue((boolean)statement.execute("PUT file://" + sourceFilePathOriginal + " @testing_stage"), (String)"Failed to put a file");
                    SnowflakeDriverIT.findFile(statement, "ls @testing_stage/");
                    Assertions.assertTrue((boolean)statement.execute("PUT file://" + sourceFilePathOverwrite + " @testing_stage overwrite=true"), (String)"Failed to put a file");
                    SnowflakeDriverIT.findFile(statement, "ls @testing_stage/");
                    Assertions.assertTrue((boolean)statement.execute("GET @testing_stage 'file://" + destFolderCanonicalPath + "' parallel=8"), (String)"Failed to get files");
                    File downloaded = new File(destFolderCanonicalPathWithSeparator + "testfile.csv.gz");
                    Assertions.assertTrue((boolean)downloaded.exists());
                    Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + "testfile.csv.gz");
                    p.waitFor();
                    File unzipped = new File(destFolderCanonicalPathWithSeparator + "testfile.csv");
                    Assertions.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file2, (File)unzipped, null));
                    continue;
                }
                finally {
                    statement.execute("DROP TABLE IF EXISTS testLoadToLocalFS");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testPut() throws Throwable {
        List<String> accounts = Arrays.asList(null, "s3testaccount", "azureaccount", "gcpaccount");
        for (int i = 0; i < accounts.size(); ++i) {
            try (Connection connection = SnowflakeDriverIT.getConnection(accounts.get(i));
                 Statement statement = connection.createStatement();){
                try {
                    ResultSetMetaData resultSetMetaData;
                    statement.execute("alter session set ENABLE_GCP_PUT_EXCEPTION_FOR_OLD_DRIVERS=false");
                    statement.execute("CREATE OR REPLACE TABLE testLoadToLocalFS(a number)");
                    Assertions.assertTrue((boolean)statement.execute("PUT file://" + SnowflakeDriverIT.getFullPathFileInResource("orders_100.csv") + " @%testLoadToLocalFS/orders parallel=10"), (String)"Failed to put a file");
                    try (ResultSet resultSet = statement.getResultSet();){
                        resultSetMetaData = resultSet.getMetaData();
                        Assertions.assertTrue((resultSetMetaData.getColumnCount() > 0 ? 1 : 0) != 0);
                        Assertions.assertTrue((boolean)resultSet.next());
                        Assertions.assertFalse((boolean)resultSet.next());
                    }
                    SnowflakeDriverIT.findFile(statement, "ls @%testLoadToLocalFS/ pattern='.*orders/orders_100.csv.g.*'");
                    resultSet = statement.executeQuery("rm @%testLoadToLocalFS/ pattern='.*orders/orders_100.csv.g.*'");
                    try {
                        resultSetMetaData = resultSet.getMetaData();
                        Assertions.assertTrue((resultSetMetaData.getColumnCount() >= 1 ? 1 : 0) != 0);
                        Assertions.assertTrue((boolean)resultSet.next());
                        Assertions.assertNotNull((Object)resultSet.getString(1));
                        Assertions.assertFalse((boolean)resultSet.next());
                        SQLException ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> resultSet.getString(1));
                        Assertions.assertEquals((int)ErrorCode.COLUMN_DOES_NOT_EXIST.getMessageCode(), (int)ex.getErrorCode());
                        Thread.sleep(100L);
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    resultSet = statement.executeQuery("ls @%testLoadToLocalFS/ pattern='.*orders/orders.*'");
                    try {
                        Assertions.assertFalse((boolean)resultSet.next());
                        continue;
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    statement.execute("DROP TABLE IF EXISTS testLoadToLocalFS");
                }
            }
        }
    }

    static void findFile(Statement statement, String checkSQL) throws Throwable {
        boolean fileFound = false;
        for (int numSecs = 0; numSecs <= 60; ++numSecs) {
            try (ResultSet resultSet = statement.executeQuery(checkSQL);){
                if (resultSet.next()) {
                    fileFound = true;
                    break;
                }
                Thread.sleep(1000L);
                Assertions.assertTrue((boolean)fileFound, (String)"Could not find a file");
                Assertions.assertNotNull((Object)resultSet.getString(1), (String)"Null result");
                continue;
            }
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testSQLError42S02() throws SQLException {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            SQLException ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> statement.executeQuery("SELECT * FROM nonexistence").close());
            Assertions.assertEquals((Object)"42S02", (Object)ex.getSQLState(), (String)"sqlstate mismatch");
        }
    }

    @Test
    @DontRunOnGithubActions
    public void testExplainPlan() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("EXPLAIN PLAN FOR SELECT c1 FROM orders_jdbc");){
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            Assertions.assertTrue((resultSetMetaData.getColumnCount() >= 4 ? 1 : 0) != 0, (String)"must return more than 4 columns");
            Assertions.assertTrue((this.countRows(resultSet) > 3 ? 1 : 0) != 0, (String)"must return more than 3 rows");
        }
    }

    @Test
    public void testTimestampParsing() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select to_timestamp('2013-05-08T15:39:20.123-07:00') from orders_jdbc");){
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertEquals((Object)"Wed, 08 May 2013 15:39:20 -0700", (Object)resultSet.getString(1));
        }
    }

    @Test
    public void testDateParsing() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select to_date('0001-01-01')");){
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertEquals((Object)"0001-01-01", (Object)resultSet.getString(1));
        }
    }

    @Test
    public void testTimeParsing() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select to_time('15:39:20.123') from orders_jdbc");){
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertEquals((Object)"15:39:20", (Object)resultSet.getString(1));
        }
    }

    @Test
    public void testClientSideSorting() throws Throwable {
        ResultSetMetaData resultSetMetaData = null;
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            int i;
            statement.execute("set-sf-property sort on");
            try (ResultSet resultSet = statement.executeQuery("SELECT c3 FROM orders_jdbc");){
                resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((int)1, (int)resultSetMetaData.getColumnCount());
                for (i = 0; i < 5; ++i) {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"F", (Object)resultSet.getString(1));
                }
            }
            statement.execute("set-sf-property sort off");
            resultSet = statement.executeQuery("SELECT c3 FROM orders_jdbc order by c3 desc");
            try {
                resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((int)1, (int)resultSetMetaData.getColumnCount());
                for (i = 0; i < 4; ++i) {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"P", (Object)resultSet.getString(1));
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateCount() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.execute("CREATE OR REPLACE TABLE testUpdateCount(version number, name string)");
                int numRows = statement.executeUpdate("INSERT INTO testUpdateCount values (1, 'a'), (2, 'b')");
                Assertions.assertEquals((int)2, (int)numRows, (String)("Unexpected number of rows inserted: " + numRows));
            }
            finally {
                statement.execute("DROP TABLE if exists testUpdateCount");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnow4245() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.execute("alter session set timestamp_input_format = 'YYYY-MM-DD HH24:MI:SS';");
                String createSQL = "create or replace table testSnow4245(t timestamp with local time zone,ntz timestamp without time zone,tz  timestamp with time zone)";
                statement.execute(createSQL);
                int numRows = statement.executeUpdate("insert into testSnow4245 values(NULL,NULL,NULL),('2013-06-04 01:00:04','2013-06-04 01:00:04','2013-06-04 01:00:04'),('2013-06-05 23:00:05','2013-06-05 23:00:05','2013-06-05 23:00:05')");
                Assertions.assertEquals((int)3, (int)numRows, (String)("Unexpected number of rows inserted: " + numRows));
                try (ResultSet resultSet = statement.executeQuery("SELECT * FROM testSnow4245 order by 1 nulls first, 2 nulls first, 3 nulls first");){
                    int i = 0;
                    while (resultSet.next()) {
                        int j;
                        if (i == 0) {
                            for (j = 1; j < 4; ++j) {
                                Assertions.assertNull((Object)resultSet.getString(j), (String)resultSet.getString(j));
                            }
                        } else {
                            for (j = 1; j < 4; ++j) {
                                Assertions.assertNotNull((Object)resultSet.getString(j), (String)resultSet.getString(j));
                            }
                        }
                        ++i;
                    }
                }
            }
            finally {
                statement.execute("drop table testSnow4245");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnow4394() throws Throwable {
        String tableName = String.format("snow4394_%s", UUID.randomUUID().toString()).replaceAll("-", "_");
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.execute(String.format("CREATE OR REPLACE TABLE %s(str string)", tableName));
                String data = "What is \ud83d\ude12?";
                int numRows = statement.executeUpdate(String.format("INSERT INTO %s(str) values('%s')", tableName, data));
                Assertions.assertEquals((int)1, (int)numRows, (String)("Unexpected number of rows inserted: " + numRows));
                try (ResultSet rset = statement.executeQuery(String.format("SELECT str FROM %s", tableName));){
                    String ret = null;
                    while (rset.next()) {
                        ret = rset.getString(1);
                    }
                    Assertions.assertEquals((Object)data, (Object)ret, (String)("Unexpected string value: " + ret));
                }
            }
            catch (Throwable throwable) {
                statement.execute(String.format("DROP TABLE if exists %s", tableName));
                throw throwable;
            }
            statement.execute(String.format("DROP TABLE if exists %s", tableName));
        }
    }

    private void addBindBatch(PreparedStatement preparedStatement, Date sqlDate) throws SQLException {
        preparedStatement.setDouble(1, 1.2);
        preparedStatement.setString(2, "hello");
        preparedStatement.setDate(3, sqlDate);
        preparedStatement.setDate(4, sqlDate);
        preparedStatement.setString(5, "h");
        preparedStatement.setDate(6, sqlDate);
        preparedStatement.setString(7, "h");
        preparedStatement.setString(8, "h");
        preparedStatement.setString(9, "h");
        preparedStatement.setString(10, "h");
        preparedStatement.setString(11, "h");
        preparedStatement.setDate(12, sqlDate);
        preparedStatement.setString(13, "h");
        preparedStatement.setDouble(14, 1.2);
        preparedStatement.setString(15, "h");
        preparedStatement.setString(16, "h");
        preparedStatement.setString(17, "h");
        preparedStatement.setString(18, "h");
        preparedStatement.setString(19, "h");
        preparedStatement.setDate(20, sqlDate);
        preparedStatement.setString(21, "h");
        preparedStatement.addBatch();
    }

    @Test
    public void testBind() throws Throwable {
        ResultSetMetaData resultSetMetaData = null;
        Timestamp ts = null;
        Time tm = null;
        Date sqlDate = null;
        try (Connection connection = SnowflakeDriverIT.getConnection();){
            int[] updateCounts;
            PreparedStatement preparedStatement;
            ResultSet resultSet;
            try (PreparedStatement preparedStatement2 = connection.prepareStatement("SELECT ?, ?");){
                preparedStatement2.setInt(1, 1);
                preparedStatement2.setString(2, "hello");
                resultSet = preparedStatement2.executeQuery();
                try {
                    resultSetMetaData = resultSet.getMetaData();
                    Assertions.assertEquals((int)2, (int)resultSetMetaData.getColumnCount());
                    Assertions.assertEquals((int)-5, (int)resultSetMetaData.getColumnType(1));
                    Assertions.assertEquals((int)12, (int)resultSetMetaData.getColumnType(2));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((int)1, (int)resultSet.getInt(1), (String)"integer");
                    Assertions.assertEquals((Object)"hello", (Object)resultSet.getString(2), (String)"string");
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                preparedStatement2.setDouble(1, 1.2);
                resultSet = preparedStatement2.executeQuery();
                try {
                    resultSetMetaData = resultSet.getMetaData();
                    Assertions.assertEquals((int)2, (int)resultSetMetaData.getColumnCount());
                    Assertions.assertEquals((int)8, (int)resultSetMetaData.getColumnType(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((double)1.2, (double)resultSet.getDouble(1), (double)0.0, (String)"double");
                    Assertions.assertEquals((Object)"hello", (Object)resultSet.getString(2), (String)"string");
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                preparedStatement2.setString(1, "hello");
                resultSet = preparedStatement2.executeQuery();
                try {
                    resultSetMetaData = resultSet.getMetaData();
                    Assertions.assertEquals((int)2, (int)resultSetMetaData.getColumnCount());
                    Assertions.assertEquals((int)12, (int)resultSetMetaData.getColumnType(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"hello", (Object)resultSet.getString(1), (String)"string1");
                    Assertions.assertEquals((Object)"hello", (Object)resultSet.getString(2), (String)"string2");
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                sqlDate = Date.valueOf("2014-08-26");
                preparedStatement2.setDate(1, sqlDate);
                resultSet = preparedStatement2.executeQuery();
                try {
                    resultSetMetaData = resultSet.getMetaData();
                    Assertions.assertEquals((int)2, (int)resultSetMetaData.getColumnCount());
                    Assertions.assertEquals((int)91, (int)resultSetMetaData.getColumnType(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"2014-08-26", (Object)resultSet.getString(1), (String)"string");
                    Assertions.assertEquals((Object)"hello", (Object)resultSet.getString(2), (String)"string");
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                ts = SnowflakeDriverIT.buildTimestamp(2014, 7, 26, 3, 52, 0, 0);
                preparedStatement2.setTimestamp(1, ts);
                resultSet = preparedStatement2.executeQuery();
                try {
                    resultSetMetaData = resultSet.getMetaData();
                    Assertions.assertEquals((int)2, (int)resultSetMetaData.getColumnCount());
                    Assertions.assertEquals((int)93, (int)resultSetMetaData.getColumnType(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"Mon, 25 Aug 2014 20:52:00 -0700", (Object)resultSet.getString(1), (String)"Incorrect timestamp");
                    Assertions.assertEquals((Object)"hello", (Object)resultSet.getString(2), (String)"string");
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                tm = new Time(12345678L);
                preparedStatement2.setTime(1, tm);
                resultSet = preparedStatement2.executeQuery();
                try {
                    resultSetMetaData = resultSet.getMetaData();
                    Assertions.assertEquals((int)2, (int)resultSetMetaData.getColumnCount());
                    Assertions.assertEquals((int)92, (int)resultSetMetaData.getColumnType(1));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"03:25:45", (Object)resultSet.getString(1), (String)"Incorrect time");
                    Assertions.assertEquals((Object)"hello", (Object)resultSet.getString(2), (String)"string");
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            preparedStatement2 = connection.prepareStatement("SELECT * FROM orders_jdbc WHERE to_number(c1) = ?");
            try {
                preparedStatement2.setInt(1, 100);
                resultSet = preparedStatement2.executeQuery();
                try {
                    resultSetMetaData = resultSet.getMetaData();
                    Assertions.assertEquals((int)9, (int)resultSetMetaData.getColumnCount());
                    Assertions.assertEquals((int)12, (int)resultSetMetaData.getColumnType(1));
                    Assertions.assertEquals((int)12, (int)resultSetMetaData.getColumnType(2));
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"100", (Object)resultSet.getString(1), (String)"c1");
                    Assertions.assertEquals((Object)"147004", (Object)resultSet.getString(2), (String)"c2");
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (preparedStatement2 != null) {
                    preparedStatement2.close();
                }
            }
            try (Statement regularStatement = connection.createStatement();){
                regularStatement.executeUpdate("create or replace table testBind(a int, b string, c double, d date, e timestamp, f time, g date)");
                preparedStatement = connection.prepareStatement("insert into testBind(a, b, c, d, e, f) values(?, ?, ?, ?, ?, ?)");
                try {
                    preparedStatement.setInt(1, 1);
                    preparedStatement.setString(2, "hello");
                    preparedStatement.setDouble(3, 1.2);
                    preparedStatement.setDate(4, sqlDate);
                    preparedStatement.setTimestamp(5, ts);
                    preparedStatement.setTime(6, tm);
                    int rowCount = preparedStatement.executeUpdate();
                    Assertions.assertEquals((int)1, (int)rowCount, (String)"update count");
                    try (ResultSet resultSet2 = regularStatement.executeQuery("select * from testBind");){
                        Assertions.assertTrue((boolean)resultSet2.next());
                        Assertions.assertEquals((int)1, (int)resultSet2.getInt(1), (String)"int");
                        Assertions.assertEquals((Object)"hello", (Object)resultSet2.getString(2), (String)"string");
                        Assertions.assertEquals((double)1.2, (double)resultSet2.getDouble(3), (double)0.0, (String)"double");
                        Assertions.assertEquals((Object)"2014-08-26", (Object)resultSet2.getString(4), (String)"date");
                        Assertions.assertEquals((Object)"Mon, 25 Aug 2014 20:52:00 -0700", (Object)resultSet2.getString(5), (String)"timestamp");
                        Assertions.assertEquals((Object)"03:25:45", (Object)resultSet2.getString(6), (String)"time");
                        Assertions.assertNull((Object)resultSet2.getString(7), (String)"date");
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                preparedStatement = connection.prepareStatement("update testBind set b=? where a=?");
                try {
                    preparedStatement.setString(1, "world");
                    preparedStatement.setInt(2, 1);
                    preparedStatement.execute();
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                resultSet = regularStatement.executeQuery("select * from testBind");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((int)1, (int)resultSet.getInt(1), (String)"int");
                    Assertions.assertEquals((Object)"world", (Object)resultSet.getString(2), (String)"string");
                    Assertions.assertEquals((double)1.2, (double)resultSet.getDouble(3), (double)0.0, (String)"double");
                    Assertions.assertEquals((Object)"2014-08-26", (Object)resultSet.getString(4), (String)"date");
                    Assertions.assertEquals((Object)"Mon, 25 Aug 2014 20:52:00 -0700", (Object)resultSet.getString(5), (String)"timestamp");
                    Assertions.assertEquals((Object)"03:25:45", (Object)resultSet.getString(6), (String)"time");
                    Assertions.assertNull((Object)resultSet.getString(7), (String)"date");
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                preparedStatement = connection.prepareStatement("insert into testBind (a, b, c, d, e, f, g) values(?, ?, ?, ?, ?, ?, current_date())");
                try {
                    preparedStatement.setInt(1, 2);
                    preparedStatement.setString(2, "hello");
                    preparedStatement.setDouble(3, 1.2);
                    preparedStatement.setDate(4, sqlDate);
                    preparedStatement.setTimestamp(5, ts);
                    preparedStatement.setTime(6, tm);
                    preparedStatement.addBatch();
                    preparedStatement.setInt(1, 3);
                    preparedStatement.setString(2, "hello");
                    preparedStatement.setDouble(3, 1.2);
                    preparedStatement.setDate(4, sqlDate);
                    preparedStatement.setTimestamp(5, ts);
                    preparedStatement.setTime(6, tm);
                    preparedStatement.addBatch();
                    updateCounts = preparedStatement.executeBatch();
                    Assertions.assertEquals((int)2, (int)updateCounts.length, (String)"Number of update counts");
                    Assertions.assertEquals((int)1, (int)updateCounts[0], (String)"update count");
                    Assertions.assertEquals((int)1, (int)updateCounts[1], (String)"update count");
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                resultSet = regularStatement.executeQuery("select * from testBind where a = 2");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((int)2, (int)resultSet.getInt(1), (String)"int");
                    Assertions.assertEquals((Object)"hello", (Object)resultSet.getString(2), (String)"string");
                    Assertions.assertEquals((double)1.2, (double)resultSet.getDouble(3), (double)0.0, (String)"double");
                    Assertions.assertEquals((Object)"2014-08-26", (Object)resultSet.getString(4), (String)"date");
                    Assertions.assertEquals((Object)"Mon, 25 Aug 2014 20:52:00 -0700", (Object)resultSet.getString(5), (String)"timestamp");
                    Assertions.assertEquals((Object)"03:25:45", (Object)resultSet.getString(6), (String)"time");
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                resultSet = regularStatement.executeQuery("select * from testBind where a = 3");
                try {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((int)3, (int)resultSet.getInt(1), (String)"int");
                    Assertions.assertEquals((Object)"hello", (Object)resultSet.getString(2), (String)"string");
                    Assertions.assertEquals((double)1.2, (double)resultSet.getDouble(3), (double)0.0, (String)"double");
                    Assertions.assertEquals((Object)"2014-08-26", (Object)resultSet.getString(4), (String)"date");
                    Assertions.assertEquals((Object)"Mon, 25 Aug 2014 20:52:00 -0700", (Object)resultSet.getString(5), (String)"timestamp");
                    Assertions.assertEquals((Object)"03:25:45", (Object)resultSet.getString(6), (String)"time");
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                preparedStatement = connection.prepareStatement("select * from testBind WHERE to_number(a) = ?");
                try {
                    resultSetMetaData = preparedStatement.getMetaData();
                    Assertions.assertEquals((int)7, (int)resultSetMetaData.getColumnCount());
                    Assertions.assertEquals((int)-5, (int)resultSetMetaData.getColumnType(1));
                    Assertions.assertEquals((int)12, (int)resultSetMetaData.getColumnType(2));
                    Assertions.assertEquals((int)8, (int)resultSetMetaData.getColumnType(3));
                    Assertions.assertEquals((int)91, (int)resultSetMetaData.getColumnType(4));
                    Assertions.assertEquals((int)93, (int)resultSetMetaData.getColumnType(5));
                    Assertions.assertEquals((int)92, (int)resultSetMetaData.getColumnType(6));
                    Assertions.assertEquals((int)91, (int)resultSetMetaData.getColumnType(7));
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                preparedStatement = connection.prepareStatement("select ?, ?");
                try {
                    resultSetMetaData = preparedStatement.getMetaData();
                    Assertions.assertEquals((int)2, (int)resultSetMetaData.getColumnCount());
                    Assertions.assertEquals((int)12, (int)resultSetMetaData.getColumnType(1));
                    Assertions.assertEquals((int)12, (int)resultSetMetaData.getColumnType(2));
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                preparedStatement = connection.prepareStatement("select ?, ?");
                try {
                    preparedStatement.setInt(1, 1);
                    preparedStatement.setString(2, "hello");
                    ResultSet result = preparedStatement.executeQuery();
                    resultSetMetaData = result.getMetaData();
                    Assertions.assertEquals((int)2, (int)resultSetMetaData.getColumnCount());
                    Assertions.assertEquals((int)-5, (int)resultSetMetaData.getColumnType(1));
                    Assertions.assertEquals((int)12, (int)resultSetMetaData.getColumnType(2));
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                preparedStatement = connection.prepareStatement("select ?");
                try {
                    preparedStatement.setNull(1, 12);
                    try (ResultSet resultSet3 = preparedStatement.executeQuery();){
                        resultSetMetaData = resultSet3.getMetaData();
                        Assertions.assertEquals((int)1, (int)resultSetMetaData.getColumnCount());
                        Assertions.assertEquals((int)12, (int)resultSetMetaData.getColumnType(1));
                        Assertions.assertTrue((boolean)resultSet3.next());
                        Assertions.assertNull((Object)resultSet3.getObject(1));
                    }
                    preparedStatement.setNull(1, 4);
                    resultSet3 = preparedStatement.executeQuery();
                    try {
                        resultSetMetaData = resultSet3.getMetaData();
                        Assertions.assertEquals((int)1, (int)resultSetMetaData.getColumnCount());
                        Assertions.assertTrue((boolean)resultSet3.next());
                        Assertions.assertNull((Object)resultSet3.getObject(1));
                    }
                    finally {
                        if (resultSet3 != null) {
                            resultSet3.close();
                        }
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            regularStatement = connection.createStatement();
            try {
                regularStatement.executeUpdate("create or replace table testBind1(c1 double, c2 string, c3 date, c4 date, c5 string, c6 date, c7 string, c8 string, c9 string, c10 string, c11 string, c12 date, c13 string, c14 float, c15 string, c16 string, c17 string, c18 string,c19 string, c20 date, c21 string)");
                preparedStatement = connection.prepareStatement("insert into testBind1 (c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13, c14, c15, c16, c17, c18, c19, c20, c21) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                try {
                    int idx;
                    for (idx = 0; idx < 16; ++idx) {
                        this.addBindBatch(preparedStatement, sqlDate);
                    }
                    updateCounts = preparedStatement.executeBatch();
                    Assertions.assertEquals((int)16, (int)updateCounts.length, (String)"Number of update counts");
                    for (idx = 0; idx < 16; ++idx) {
                        Assertions.assertEquals((int)1, (int)updateCounts[idx], (String)"update count");
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            finally {
                if (regularStatement != null) {
                    regularStatement.close();
                }
            }
            connection.createStatement().execute("DROP TABLE testBind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableBind() throws Throwable {
        ResultSetMetaData resultSetMetaData = null;
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement regularStatement = connection.createStatement();){
            try {
                int i;
                ResultSet resultSet;
                try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT * from table(?)");){
                    resultSetMetaData = preparedStatement.getMetaData();
                    Assertions.assertEquals((int)0, (int)resultSetMetaData.getColumnCount());
                    preparedStatement.setString(1, ORDERS_JDBC);
                    resultSet = preparedStatement.executeQuery();
                    try {
                        resultSetMetaData = resultSet.getMetaData();
                        Assertions.assertEquals((int)9, (int)resultSetMetaData.getColumnCount());
                        for (i = 0; i < 73; ++i) {
                            Assertions.assertTrue((boolean)resultSet.next());
                        }
                        Assertions.assertFalse((boolean)resultSet.next());
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                preparedStatement = connection.prepareStatement("SELECT * from table(?) where c1 = 1");
                try {
                    preparedStatement.setString(1, ORDERS_JDBC);
                    resultSet = preparedStatement.executeQuery();
                    try {
                        resultSetMetaData = resultSet.getMetaData();
                        Assertions.assertEquals((int)9, (int)resultSetMetaData.getColumnCount());
                        Assertions.assertTrue((boolean)resultSet.next());
                        Assertions.assertFalse((boolean)resultSet.next());
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                preparedStatement = connection.prepareStatement("SELECT * from table(?) order by c3");
                try {
                    preparedStatement.setString(1, ORDERS_JDBC);
                    resultSet = preparedStatement.executeQuery();
                    try {
                        resultSetMetaData = resultSet.getMetaData();
                        Assertions.assertEquals((int)9, (int)resultSetMetaData.getColumnCount());
                        for (i = 0; i < 73; ++i) {
                            Assertions.assertTrue((boolean)resultSet.next());
                        }
                        Assertions.assertFalse((boolean)resultSet.next());
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                regularStatement.execute("create or replace table testTableBind(c integer, d string)");
                regularStatement.executeUpdate("insert into testTableBind (c, d) values (1, 'one')");
                preparedStatement = connection.prepareStatement("SELECT * from table(?), testTableBind");
                try {
                    preparedStatement.setString(1, ORDERS_JDBC);
                    resultSet = preparedStatement.executeQuery();
                    try {
                        resultSetMetaData = resultSet.getMetaData();
                        Assertions.assertEquals((int)11, (int)resultSetMetaData.getColumnCount());
                        for (i = 0; i < 73; ++i) {
                            Assertions.assertTrue((boolean)resultSet.next());
                        }
                        Assertions.assertFalse((boolean)resultSet.next());
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                preparedStatement = connection.prepareStatement("SELECT * from table(?), table(?)");
                try {
                    preparedStatement.setString(1, ORDERS_JDBC);
                    preparedStatement.setString(2, "testTableBind");
                    resultSet = preparedStatement.executeQuery();
                    try {
                        resultSetMetaData = resultSet.getMetaData();
                        Assertions.assertEquals((int)11, (int)resultSetMetaData.getColumnCount());
                        for (i = 0; i < 73; ++i) {
                            Assertions.assertTrue((boolean)resultSet.next());
                        }
                        Assertions.assertFalse((boolean)resultSet.next());
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                preparedStatement = connection.prepareStatement("SELECT a.c1, b.c from table(?) as a, table(?) as b");
                try {
                    preparedStatement.setString(1, ORDERS_JDBC);
                    preparedStatement.setString(2, "testTableBind");
                    resultSet = preparedStatement.executeQuery();
                    try {
                        resultSetMetaData = resultSet.getMetaData();
                        Assertions.assertEquals((int)2, (int)resultSetMetaData.getColumnCount());
                        for (i = 0; i < 73; ++i) {
                            Assertions.assertTrue((boolean)resultSet.next());
                        }
                        Assertions.assertFalse((boolean)resultSet.next());
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            finally {
                regularStatement.execute("DROP TABLE testTableBind");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBindInWithClause() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement regularStatement = connection.createStatement();){
            try {
                regularStatement.execute("create or replace table testBind2(a int, b string, c double, d date, e timestamp, f time, g date)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("WITH V AS (SELECT * FROM testBind2 WHERE a = ?) SELECT count(*) FROM V");){
                    preparedStatement.setInt(1, 100);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        Assertions.assertEquals((int)1, (int)resultSetMetaData.getColumnCount());
                        Assertions.assertTrue((boolean)resultSet.next());
                    }
                }
            }
            finally {
                regularStatement.execute("DROP TABLE testBind2");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBindTimestampNTZ() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement regularStatement = connection.createStatement();){
            try {
                regularStatement.executeUpdate("create or replace table testBindTimestampNTZ(a timestamp_ntz)");
                regularStatement.execute("alter session set client_timestamp_type_mapping='timestamp_ntz'");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into testBindTimestampNTZ values(?)");){
                    Timestamp ts = SnowflakeDriverIT.buildTimestamp(2014, 7, 26, 3, 52, 0, 0);
                    preparedStatement.setTimestamp(1, ts);
                    int updateCount = preparedStatement.executeUpdate();
                    Assertions.assertEquals((int)1, (int)updateCount, (String)"update count");
                    try (ResultSet resultSet = regularStatement.executeQuery("select * from testBindTimestampNTZ");){
                        Assertions.assertTrue((boolean)resultSet.next());
                        Assertions.assertEquals((Object)"Tue, 26 Aug 2014 03:52:00 Z", (Object)resultSet.getString(1), (String)"timestamp");
                        regularStatement.executeUpdate("truncate table testBindTimestampNTZ");
                        preparedStatement.setTimestamp(1, ts, Calendar.getInstance(TimeZone.getTimeZone("America/Los_Angeles")));
                        updateCount = preparedStatement.executeUpdate();
                        Assertions.assertEquals((int)1, (int)updateCount, (String)"update count");
                    }
                    resultSet = regularStatement.executeQuery("select * from testBindTimestampNTZ");
                    try {
                        Assertions.assertTrue((boolean)resultSet.next());
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
            }
            finally {
                regularStatement.execute("DROP TABLE testBindTimestampNTZ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullBind() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement regularStatement = connection.createStatement();){
            try {
                regularStatement.execute("create or replace table testNullBind(a double)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into testNullBind (a) values(?)");){
                    preparedStatement.setDouble(1, 1.2);
                    preparedStatement.addBatch();
                    preparedStatement.setObject(1, null);
                    preparedStatement.addBatch();
                    int[] updateCounts = preparedStatement.executeBatch();
                    Assertions.assertEquals((int)2, (int)updateCounts.length, (String)"Number of update counts");
                    Assertions.assertEquals((int)1, (int)updateCounts[0], (String)"update count");
                    Assertions.assertEquals((int)1, (int)updateCounts[1], (String)"update count");
                    preparedStatement.clearBatch();
                    preparedStatement.setObject(1, null);
                    preparedStatement.addBatch();
                    preparedStatement.setDouble(1, 1.2);
                    preparedStatement.addBatch();
                    updateCounts = preparedStatement.executeBatch();
                    Assertions.assertEquals((int)2, (int)updateCounts.length, (String)"Number of update counts");
                    Assertions.assertEquals((int)1, (int)updateCounts[0], (String)"update count");
                    Assertions.assertEquals((int)1, (int)updateCounts[1], (String)"update count");
                    preparedStatement.clearBatch();
                    preparedStatement.setObject(1, null);
                    preparedStatement.addBatch();
                    updateCounts = preparedStatement.executeBatch();
                    Assertions.assertEquals((int)1, (int)updateCounts.length, (String)"Number of update counts");
                    Assertions.assertEquals((int)1, (int)updateCounts[0], (String)"update count");
                    preparedStatement.clearBatch();
                    preparedStatement.setObject(1, (Object)"Null", 8);
                    preparedStatement.addBatch();
                    SnowflakeSQLException ex = (SnowflakeSQLException)Assertions.assertThrows(SnowflakeSQLException.class, preparedStatement::executeBatch);
                    Assertions.assertEquals((int)2086, (int)ex.getErrorCode());
                    preparedStatement.clearBatch();
                    preparedStatement.setString(1, "hello");
                    preparedStatement.addBatch();
                    preparedStatement.setDouble(1, 1.2);
                    ex = (SnowflakeSQLException)Assertions.assertThrows(SnowflakeSQLException.class, preparedStatement::addBatch);
                    Assertions.assertEquals((int)ErrorCode.ARRAY_BIND_MIXED_TYPES_NOT_SUPPORTED.getMessageCode(), (int)ex.getErrorCode());
                }
            }
            finally {
                regularStatement.execute("DROP TABLE testNullBind");
            }
        }
    }

    @Test
    public void testSnow12603() throws Throwable {
        ResultSetMetaData resultSetMetaData = null;
        try (Connection connection = SnowflakeDriverIT.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT ?, ?, ?, ?, ?, ?");){
            Date sqlDate = Date.valueOf("2014-08-26");
            Timestamp ts = SnowflakeDriverIT.buildTimestamp(2014, 7, 26, 3, 52, 0, 0);
            preparedStatement.setObject(1, 1);
            preparedStatement.setObject(2, "hello");
            preparedStatement.setObject(3, new BigDecimal("1.3"));
            preparedStatement.setObject(4, Float.valueOf("1.3"));
            preparedStatement.setObject(5, sqlDate);
            preparedStatement.setObject(6, ts);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((int)6, (int)resultSetMetaData.getColumnCount());
                Assertions.assertEquals((int)-5, (int)resultSetMetaData.getColumnType(1));
                Assertions.assertEquals((int)12, (int)resultSetMetaData.getColumnType(2));
                Assertions.assertEquals((int)3, (int)resultSetMetaData.getColumnType(3));
                Assertions.assertEquals((int)8, (int)resultSetMetaData.getColumnType(4));
                Assertions.assertEquals((int)91, (int)resultSetMetaData.getColumnType(5));
                Assertions.assertEquals((int)93, (int)resultSetMetaData.getColumnType(6));
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((int)1, (int)resultSet.getInt(1), (String)"integer");
                Assertions.assertEquals((Object)"hello", (Object)resultSet.getString(2), (String)"string");
                Assertions.assertEquals((Object)new BigDecimal("1.3"), (Object)resultSet.getBigDecimal(3), (String)"decimal");
                Assertions.assertEquals((double)1.3, (double)resultSet.getDouble(4), (double)0.0, (String)"double");
                Assertions.assertEquals((Object)"2014-08-26", (Object)resultSet.getString(5), (String)"date");
                Assertions.assertEquals((Object)"Mon, 25 Aug 2014 20:52:00 -0700", (Object)resultSet.getString(6), (String)"timestamp");
                preparedStatement.setObject(1, (Object)1, 4);
                preparedStatement.setObject(2, (Object)"hello", 12);
                preparedStatement.setObject(3, (Object)new BigDecimal("1.3"), 3);
                preparedStatement.setObject(4, (Object)Float.valueOf("1.3"), 8);
                preparedStatement.setObject(5, (Object)sqlDate, 91);
                preparedStatement.setObject(6, (Object)ts, 93);
            }
            resultSet = preparedStatement.executeQuery();
            try {
                resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((int)6, (int)resultSetMetaData.getColumnCount());
                Assertions.assertEquals((int)-5, (int)resultSetMetaData.getColumnType(1));
                Assertions.assertEquals((int)12, (int)resultSetMetaData.getColumnType(2));
                Assertions.assertEquals((int)3, (int)resultSetMetaData.getColumnType(3));
                Assertions.assertEquals((int)8, (int)resultSetMetaData.getColumnType(4));
                Assertions.assertEquals((int)91, (int)resultSetMetaData.getColumnType(5));
                Assertions.assertEquals((int)93, (int)resultSetMetaData.getColumnType(6));
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((int)1, (int)resultSet.getInt(1), (String)"integer");
                Assertions.assertEquals((Object)"hello", (Object)resultSet.getString(2), (String)"string");
                Assertions.assertEquals((Object)new BigDecimal("1.3"), (Object)resultSet.getBigDecimal(3), (String)"decimal");
                Assertions.assertEquals((double)1.3, (double)resultSet.getDouble(4), (double)0.0, (String)"double");
                Assertions.assertEquals((Object)"2014-08-26", (Object)resultSet.getString(5), (String)"date");
                Assertions.assertEquals((Object)"Mon, 25 Aug 2014 20:52:00 -0700", (Object)resultSet.getString(6), (String)"timestamp");
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnow6290() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.execute("CREATE OR REPLACE TABLE testSnow6290(ts timestamp)");
                PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO testSnow6290(ts) values(?)");
                Timestamp ts = new Timestamp(System.currentTimeMillis());
                preparedStatement.setTimestamp(1, ts);
                preparedStatement.executeUpdate();
                ResultSet res = statement.executeQuery("select ts from testSnow6290");
                Assertions.assertTrue((boolean)res.next(), (String)"expect a row");
                Timestamp tsFromDB = res.getTimestamp(1);
                Assertions.assertEquals((long)ts.getTime(), (long)tsFromDB.getTime(), (String)"timestamp mismatch");
            }
            finally {
                statement.execute("DROP TABLE if exists testSnow6290");
            }
        }
    }

    @Test
    public void testInvalidSQL() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            SnowflakeSQLException ex = (SnowflakeSQLException)Assertions.assertThrows(SnowflakeSQLException.class, () -> statement.executeQuery(null));
            Assertions.assertEquals((int)ErrorCode.INVALID_SQL.getMessageCode(), (int)ex.getErrorCode());
        }
    }

    @Test
    public void testGetObject() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT ?");){
            ResultSetMetaData resultSetMetaData;
            preparedStatement.setInt(1, 1);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((Object)Long.class.getName(), (Object)resultSetMetaData.getColumnClassName(1), (String)"column class name=BigDecimal");
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertTrue((boolean)(resultSet.getObject(1) instanceof Long), (String)"integer");
            }
            preparedStatement.setString(1, "hello");
            resultSet = preparedStatement.executeQuery();
            try {
                resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((Object)String.class.getName(), (Object)resultSetMetaData.getColumnClassName(1), (String)"column class name=String");
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertTrue((boolean)(resultSet.getObject(1) instanceof String), (String)"string");
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            preparedStatement.setDouble(1, 1.2);
            resultSet = preparedStatement.executeQuery();
            try {
                resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((Object)Double.class.getName(), (Object)resultSetMetaData.getColumnClassName(1), (String)"column class name=Double");
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertTrue((boolean)(resultSet.getObject(1) instanceof Double), (String)"double");
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            preparedStatement.setTimestamp(1, new Timestamp(0L));
            resultSet = preparedStatement.executeQuery();
            try {
                resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((Object)Timestamp.class.getName(), (Object)resultSetMetaData.getColumnClassName(1), (String)"column class name=Timestamp");
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertTrue((boolean)(resultSet.getObject(1) instanceof Timestamp), (String)"timestamp");
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            preparedStatement.setDate(1, new Date(0L));
            resultSet = preparedStatement.executeQuery();
            try {
                resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((Object)Date.class.getName(), (Object)resultSetMetaData.getColumnClassName(1), (String)"column class name=Date");
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertTrue((boolean)(resultSet.getObject(1) instanceof Date), (String)"date");
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    @Test
    public void testGetDoubleForNull() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement stmt = connection.createStatement();
             ResultSet resultSet = stmt.executeQuery("select cast(null as int) as null_int");){
            Assertions.assertTrue((boolean)resultSet.next());
            Assertions.assertEquals((double)0.0, (double)resultSet.getDouble(1), (double)1.0E-4, (String)"0 for null");
        }
    }

    @Test
    public void testGetDoubleForNaN() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement stmt = connection.createStatement();
             ResultSet resultSet = stmt.executeQuery("select 'nan'::float");){
            Assertions.assertTrue((boolean)resultSet.next());
            MatcherAssert.assertThat((String)"NaN for NaN", (Object)resultSet.getDouble(1), (Matcher)CoreMatchers.equalTo((Object)Double.NaN));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutViaExecuteQuery() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.execute("CREATE OR REPLACE TABLE testPutViaExecuteQuery(a number)");
                try (ResultSet resultSet = statement.executeQuery("PUT file://" + SnowflakeDriverIT.getFullPathFileInResource("orders_100.csv") + " @%testPutViaExecuteQuery/orders parallel=10");){
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    Assertions.assertTrue((resultSetMetaData.getColumnCount() > 0 ? 1 : 0) != 0);
                    for (int i = 0; i < 1; ++i) {
                        Assertions.assertTrue((boolean)resultSet.next());
                    }
                }
            }
            finally {
                statement.execute("DROP TABLE IF EXISTS testPutViaExecuteQuery");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Disabled(value="takes 7 min. enable this for long running tests")
    @Test
    public void testSnow16332() throws Throwable {
        try (Connection conn = SnowflakeDriverIT.getConnection();
             Statement stmt = conn.createStatement();){
            try {
                stmt.execute("CREATE OR REPLACE TABLE SNOW16332 (i int)");
                for (int stmtCounter = 2000; stmtCounter > 0; --stmtCounter) {
                    stmt.executeUpdate("INSERT INTO SNOW16332 VALUES (" + stmtCounter + ")");
                }
                try (Connection connWithNwError = SnowflakeDriverIT.getConnection(500);
                     Statement stmtWithNwError = connWithNwError.createStatement();){
                    stmtWithNwError.executeUpdate("INSERT INTO SNOW16332 SELECT seq8() FROM table(generator(timeLimit => 1))");
                    stmtWithNwError.executeUpdate("INSERT INTO SNOW16332 SELECT seq8() FROM table(generator(timeLimit => 1))");
                }
            }
            finally {
                stmt.executeQuery("DROP TABLE SNOW16332");
            }
        }
    }

    @Test
    public void testV1Query() throws Throwable {
        ResultSetMetaData resultSetMetaData = null;
        try (Connection connection = SnowflakeDriverIT.getConnection(200);
             Statement statement = connection.createStatement();){
            int i;
            try (ResultSet resultSet = statement.executeQuery("SELECT count(*) FROM table(generator(rowCount => 100000000))");){
                resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((int)1, (int)resultSetMetaData.getColumnCount());
                for (i = 0; i < 1; ++i) {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertTrue((resultSet.getInt(1) > 0 ? 1 : 0) != 0);
                }
            }
            resultSet = statement.executeQuery("SELECT 'Fri, 23 Oct 2015 12:35:38 -0700'::timestamp_tz");
            try {
                resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((int)1, (int)resultSetMetaData.getColumnCount());
                for (i = 0; i < 1; ++i) {
                    Assertions.assertTrue((boolean)resultSet.next());
                    Assertions.assertEquals((Object)"Fri, 23 Oct 2015 12:35:38 -0700", (Object)resultSet.getString(1));
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    @Test
    public void testCancelQuery() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             final Statement statement = connection.createStatement();){
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        statement.cancel();
                    }
                    catch (SQLException ex) {
                        logger.log(Level.SEVERE, "Cancel failed with exception {}", ex);
                    }
                }
            }, 5000L);
            SQLException ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> statement.executeQuery("SELECT count(*) FROM TABLE(generator(timeLimit => 120))").close());
            Assertions.assertEquals((Object)"57014", (Object)ex.getSQLState(), (String)"sqlstate mismatch");
        }
    }

    @Test
    public void testSnow14774() throws Throwable {
        Calendar calendar = null;
        Timestamp tsInUTC = null;
        Timestamp tsInLA = null;
        SimpleDateFormat sdf = null;
        String tsStrInLA = null;
        String tsStrInUTC = null;
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            try (ResultSet res = statement.executeQuery("select '2015-03-08 03:30:00'::timestamp_ntz");){
                Assertions.assertTrue((boolean)res.next());
                calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                tsInUTC = res.getTimestamp(1, calendar);
                sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                tsStrInUTC = sdf.format(tsInUTC);
                calendar.setTimeZone(TimeZone.getTimeZone("America/Los_Angeles"));
                tsInLA = res.getTimestamp(1, calendar);
                sdf.setTimeZone(TimeZone.getTimeZone("America/Los_Angeles"));
                tsStrInLA = sdf.format(tsInLA);
                Assertions.assertEquals((Object)tsStrInUTC, (Object)tsStrInLA, (String)"timestamp values not equal");
            }
            res = statement.executeQuery("select '2015-03-08 01:30:00'::timestamp_ntz");
            try {
                Assertions.assertTrue((boolean)res.next());
                calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
                tsInUTC = res.getTimestamp(1, calendar);
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                tsStrInUTC = sdf.format(tsInUTC);
                calendar.setTimeZone(TimeZone.getTimeZone("America/Los_Angeles"));
                tsInLA = res.getTimestamp(1, calendar);
                sdf.setTimeZone(TimeZone.getTimeZone("America/Los_Angeles"));
                tsStrInLA = sdf.format(tsInLA);
                Assertions.assertEquals((Object)tsStrInUTC, (Object)tsStrInLA, (String)"timestamp values not equal");
            }
            finally {
                if (res != null) {
                    res.close();
                }
            }
        }
    }

    @Test
    public void testSnow19172() throws SQLException {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeQuery("select 1");
            Assertions.assertTrue((!statement.getMoreResults() ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnow19819() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement regularStatement = connection.createStatement();){
            try {
                regularStatement.execute("create or replace table testSnow19819(\ns string,\nv variant,\nt timestamp_ltz)\n");
                try (PreparedStatement preparedStatement = connection.prepareStatement("insert into testSnow19819 (s, v, t)\nselect ?, parse_json(?), to_timestamp(?)");){
                    preparedStatement.setString(1, "foo");
                    preparedStatement.setString(2, "{ }");
                    preparedStatement.setString(3, "2016-05-12 12:15:00");
                    preparedStatement.addBatch();
                    preparedStatement.setString(1, "foo2");
                    preparedStatement.setString(2, "{ \"a\": 1 }");
                    preparedStatement.setString(3, "2016-05-12 12:16:00");
                    preparedStatement.addBatch();
                    preparedStatement.executeBatch();
                    try (ResultSet resultSet = connection.createStatement().executeQuery("SELECT s, v, t FROM testSnow19819 ORDER BY 1");){
                        MatcherAssert.assertThat((String)"next result", (boolean)resultSet.next());
                        MatcherAssert.assertThat((String)"String", (Object)resultSet.getString(1), (Matcher)CoreMatchers.equalTo((Object)"foo"));
                        MatcherAssert.assertThat((String)"Variant", (Object)resultSet.getString(2), (Matcher)CoreMatchers.equalTo((Object)"{}"));
                        MatcherAssert.assertThat((String)"next result", (boolean)resultSet.next());
                        MatcherAssert.assertThat((String)"String", (Object)resultSet.getString(1), (Matcher)CoreMatchers.equalTo((Object)"foo2"));
                        MatcherAssert.assertThat((String)"Variant", (Object)resultSet.getString(2), (Matcher)CoreMatchers.equalTo((Object)"{\n  \"a\": 1\n}"));
                        MatcherAssert.assertThat((String)"no more result", (!resultSet.next() ? 1 : 0) != 0);
                    }
                }
            }
            finally {
                regularStatement.execute("DROP TABLE testSnow19819");
            }
        }
    }

    @Test
    @DontRunOnTestaccount
    public void testClientInfo() throws Throwable {
        System.setProperty("snowflake.client.info", "{\"spark.version\":\"3.0.0\", \"spark.snowflakedb.version\":\"2.8.5\", \"spark.app.name\":\"SnowflakeSourceSuite\", \"scala.version\":\"2.12.11\", \"java.version\":\"1.8.0_221\", \"snowflakedb.jdbc.version\":\"3.13.2\"}");
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();
             ResultSet res = statement.executeQuery("select current_session_client_info()");){
            Assertions.assertTrue((boolean)res.next(), (String)"result expected");
            String clientInfoJSONStr = res.getString(1);
            JsonNode clientInfoJSON = this.mapper.readTree(clientInfoJSONStr);
            Assertions.assertEquals((Object)"3.0.0", (Object)clientInfoJSON.get("spark.version").asText(), (String)"spark version mismatch");
            Assertions.assertEquals((Object)"2.8.5", (Object)clientInfoJSON.get("spark.snowflakedb.version").asText(), (String)"snowflakedb version mismatch");
            Assertions.assertEquals((Object)"SnowflakeSourceSuite", (Object)clientInfoJSON.get("spark.app.name").asText(), (String)"spark app mismatch");
            this.closeSQLObjects(res, statement, connection);
        }
        System.clearProperty("snowflake.client.info");
    }

    @Test
    public void testLargeResultSet() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement statement = connection.createStatement();){
            String sql = "SELECT random()||random(), randstr(1000, random()) FROM table(generator(rowcount => 10000))";
            try (ResultSet result = statement.executeQuery(sql);){
                int cnt = 0;
                while (result.next()) {
                    ++cnt;
                }
                Assertions.assertEquals((int)10000, (int)cnt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testSnow26503() throws Throwable {
        String queryId = null;
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement regularStatement = connection.createStatement();){
            try {
                ResultSet resultSet;
                regularStatement.execute("create or replace table testBind2(a int) as select * from values(1),(2),(8),(10)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM testBind2 WHERE a between ? and ?");){
                    preparedStatement.setInt(1, 3);
                    preparedStatement.setInt(2, 9);
                    resultSet = preparedStatement.executeQuery();
                    try {
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        Assertions.assertEquals((int)1, (int)resultSetMetaData.getColumnCount());
                        Assertions.assertTrue((boolean)resultSet.next());
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                preparedStatement = connection.prepareStatement("SELECT last_query_id()");
                try {
                    resultSet = preparedStatement.executeQuery();
                    try {
                        Assertions.assertTrue((boolean)resultSet.next());
                        queryId = resultSet.getString(1);
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                try (Connection snowflakeConnection = SnowflakeDriverIT.getSnowflakeAdminConnection();){
                    try (Statement regularStatementSF = snowflakeConnection.createStatement();){
                        regularStatementSF.execute("create or replace warehouse wh26503 warehouse_size=xsmall");
                        try (PreparedStatement preparedStatement = snowflakeConnection.prepareStatement("select bv:\"1\":\"value\"::string, bv:\"2\":\"value\"::string from (select parse_json(system$get_bind_values(?)) bv)");){
                            preparedStatement.setString(1, queryId);
                            try (ResultSet resultSet2 = preparedStatement.executeQuery();){
                                Assertions.assertTrue((boolean)resultSet2.next());
                                Assertions.assertEquals((int)3, (int)resultSet2.getInt(1));
                                Assertions.assertEquals((int)9, (int)resultSet2.getInt(2));
                            }
                        }
                    }
                    snowflakeConnection.createStatement().execute("DROP warehouse wh26503");
                }
            }
            finally {
                regularStatement.execute("DROP TABLE testBind2");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnow28530() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             Statement regularStatement = connection.createStatement();){
            try {
                SnowflakeSQLException e;
                regularStatement.execute("create or replace table t(a number, b number)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("create or replace view v as select * from t where a=?");){
                    preparedStatement.setInt(1, 1);
                    e = (SnowflakeSQLException)Assertions.assertThrows(SnowflakeSQLException.class, preparedStatement::execute, (String)"Bind variable in view definition did not cause a user error");
                    Assertions.assertEquals((int)2210, (int)e.getErrorCode());
                }
                preparedStatement = connection.prepareStatement("create or replace function f(n number) returns number as 'n + ?'");
                try {
                    e = (SnowflakeSQLException)Assertions.assertThrows(SnowflakeSQLException.class, preparedStatement::execute, (String)"Bind variable in scalar UDF definition did not cause a user error");
                    Assertions.assertEquals((int)2210, (int)e.getErrorCode());
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                preparedStatement = connection.prepareStatement("create or replace function tf(n number) returns table(b number) as 'select b from t where a=?'");
                try {
                    e = (SnowflakeSQLException)Assertions.assertThrows(SnowflakeSQLException.class, preparedStatement::execute, (String)"Bind variable in table UDF definition did not cause a user error");
                    Assertions.assertEquals((int)2210, (int)e.getErrorCode());
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            finally {
                regularStatement.execute("drop table t");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnow31104() throws Throwable {
        Properties paramProperties = new Properties();
        paramProperties.put("TYPESYSTEM_WIDEN_CONSTANTS_EXACTLY", Boolean.TRUE.toString());
        try (Connection connection = SnowflakeDriverIT.getConnection(paramProperties);
             Statement regularStatement = connection.createStatement();){
            try {
                ResultSet resultSet;
                regularStatement.execute("create or replace table t(n number)");
                regularStatement.executeUpdate("insert into t values (1), (90000000000000000000000000000000000000)");
                try (PreparedStatement preparedStatement = connection.prepareStatement("select n, n > ? from t order by 1");){
                    preparedStatement.setString(1, "1");
                    resultSet = preparedStatement.executeQuery();
                    try {
                        Assertions.assertTrue((boolean)resultSet.next());
                        Assertions.assertFalse((boolean)resultSet.getBoolean(2));
                        Assertions.assertTrue((boolean)resultSet.next());
                        Assertions.assertTrue((boolean)resultSet.getBoolean(2));
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                preparedStatement = connection.prepareStatement("select n, '1' in (?, '256', n, 10) from t order by 1");
                try {
                    preparedStatement.setString(1, null);
                    resultSet = preparedStatement.executeQuery();
                    try {
                        Assertions.assertTrue((boolean)resultSet.next());
                        Assertions.assertTrue((boolean)resultSet.getBoolean(2));
                        Assertions.assertTrue((boolean)resultSet.next());
                        Assertions.assertNull((Object)resultSet.getObject(2));
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            finally {
                regularStatement.execute("drop table t");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testPutGet() throws Throwable {
        List<String> accounts = Arrays.asList(null, "s3testaccount", "azureaccount", "gcpaccount");
        for (int i = 0; i < accounts.size(); ++i) {
            try (Connection connection = SnowflakeDriverIT.getConnection(accounts.get(i));
                 Statement statement = connection.createStatement();){
                try {
                    String sourceFilePath = SnowflakeDriverIT.getFullPathFileInResource("orders_100.csv");
                    File destFolder = new File(this.tmpFolder, "dest");
                    destFolder.mkdirs();
                    String destFolderCanonicalPath = destFolder.getCanonicalPath();
                    String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
                    statement.execute("alter session set ENABLE_GCP_PUT_EXCEPTION_FOR_OLD_DRIVERS=false");
                    statement.execute("CREATE OR REPLACE STAGE testPutGet_stage");
                    Assertions.assertTrue((boolean)statement.execute("PUT file://" + sourceFilePath + " @testPutGet_stage"), (String)"Failed to put a file");
                    SnowflakeDriverIT.findFile(statement, "ls @testPutGet_stage/");
                    Assertions.assertTrue((boolean)statement.execute("GET @testPutGet_stage 'file://" + destFolderCanonicalPath + "' parallel=8"), (String)"Failed to get a file");
                    File downloaded = new File(destFolderCanonicalPathWithSeparator + "orders_100.csv" + ".gz");
                    Assertions.assertTrue((boolean)downloaded.exists());
                    Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + "orders_100.csv" + ".gz");
                    p.waitFor();
                    File original = new File(sourceFilePath);
                    File unzipped = new File(destFolderCanonicalPathWithSeparator + "orders_100.csv");
                    Assertions.assertEquals((long)original.length(), (long)unzipped.length());
                    continue;
                }
                finally {
                    statement.execute("DROP STAGE IF EXISTS testGetPut_stage");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testPutGetToUnencryptedStage() throws Throwable {
        List<String> accounts = Arrays.asList(null, "s3testaccount", "azureaccount", "gcpaccount");
        for (int i = 0; i < accounts.size(); ++i) {
            try (Connection connection = SnowflakeDriverIT.getConnection(accounts.get(i));
                 Statement statement = connection.createStatement();){
                try {
                    String sourceFilePath = SnowflakeDriverIT.getFullPathFileInResource("orders_100.csv");
                    File destFolder = new File(this.tmpFolder, "dest");
                    destFolder.mkdirs();
                    String destFolderCanonicalPath = destFolder.getCanonicalPath();
                    String destFolderCanonicalPathWithSeparator = destFolderCanonicalPath + File.separator;
                    statement.execute("alter session set ENABLE_UNENCRYPTED_INTERNAL_STAGES=true");
                    statement.execute("alter session set ENABLE_GCP_PUT_EXCEPTION_FOR_OLD_DRIVERS=false");
                    statement.execute("CREATE OR REPLACE STAGE testPutGet_unencstage encryption=(TYPE='SNOWFLAKE_SSE')");
                    Assertions.assertTrue((boolean)statement.execute("PUT file://" + sourceFilePath + " @testPutGet_unencstage"), (String)"Failed to put a file");
                    SnowflakeDriverIT.findFile(statement, "ls @testPutGet_unencstage/");
                    Assertions.assertTrue((boolean)statement.execute("GET @testPutGet_unencstage 'file://" + destFolderCanonicalPath + "' parallel=8"), (String)"Failed to get a file");
                    File downloaded = new File(destFolderCanonicalPathWithSeparator + "orders_100.csv" + ".gz");
                    Assertions.assertTrue((boolean)downloaded.exists());
                    Process p = Runtime.getRuntime().exec("gzip -d " + destFolderCanonicalPathWithSeparator + "orders_100.csv" + ".gz");
                    p.waitFor();
                    File original = new File(sourceFilePath);
                    File unzipped = new File(destFolderCanonicalPathWithSeparator + "orders_100.csv");
                    Assertions.assertEquals((long)original.length(), (long)unzipped.length());
                    continue;
                }
                finally {
                    statement.execute("DROP STAGE IF EXISTS testPutGet_unencstage");
                }
            }
        }
    }

    @Test
    public void testNotClosedSession() throws SQLException {
        Connection connection = SnowflakeDriverIT.getConnection();
        connection.close();
        Assertions.assertThrows(SnowflakeSQLException.class, () -> connection.prepareStatement("select 1"));
    }

    @Test
    @DontRunOnGithubActions
    public void testToTimestampNullBind() throws Throwable {
        try (Connection connection = SnowflakeDriverIT.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("select 3 where to_timestamp_ltz(?, 3) = '1970-01-01 00:00:12.345 +000'::timestamp_ltz");){
            preparedStatement.setInt(1, 12345);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                Assertions.assertEquals((int)1, (int)resultSetMetaData.getColumnCount());
                Assertions.assertTrue((boolean)resultSet.next());
                Assertions.assertEquals((int)3, (int)resultSet.getInt(1));
                Assertions.assertFalse((boolean)resultSet.next());
                preparedStatement.setNull(1, 4);
            }
            resultSet = preparedStatement.executeQuery();
            try {
                Assertions.assertFalse((boolean)resultSet.next());
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }
}

