/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializable;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import net.snowflake.client.jdbc.SnowflakeStatement;
import net.snowflake.client.providers.SimpleResultFormatProvider;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@Tag(value="resultSet")
public class SnowflakeResultSetSerializableIT
extends BaseJDBCTest {
    @TempDir
    private File tmpFolder;
    private static boolean developPrint = false;
    private String sfFullURL = "https://sfctest0.snowflakecomputing.com";

    public Connection init(String queryResultFormat) throws SQLException {
        return this.init(null, queryResultFormat);
    }

    public Connection init(@Nullable Properties properties, String queryResultFormat) throws SQLException {
        Connection conn = BaseJDBCTest.getConnection(properties);
        try (Statement stmt = conn.createStatement();){
            stmt.execute("alter session set jdbc_query_result_format = '" + queryResultFormat + "'");
            stmt.execute("alter session set result_first_chunk_max_size = 512");
            stmt.execute("alter session set result_min_chunk_size = 512");
            stmt.execute("alter session set arrow_result_rb_flush_size = 512");
            stmt.execute("alter session set result_chunk_size_multiplier = 1.2");
        }
        return conn;
    }

    private String generateCSVResult(ResultSet rs) throws Throwable {
        StringBuilder builder = new StringBuilder(0x100000);
        builder.append("==== result start ===\n");
        ResultSetMetaData metadata = rs.getMetaData();
        int colCount = metadata.getColumnCount();
        while (rs.next()) {
            for (int i = 1; i <= colCount; ++i) {
                rs.getObject(i);
                if (rs.wasNull()) {
                    builder.append("\"").append("null").append("\",");
                    continue;
                }
                builder.append("\"").append(rs.getString(i)).append("\",");
            }
            builder.append("\n");
        }
        builder.append("==== result end   ===\n");
        return builder.toString();
    }

    private List<String> serializeResultSet(SnowflakeResultSet rs, long maxSizeInBytes, String fileNameAppendix) throws Throwable {
        ArrayList<String> result = new ArrayList<String>();
        List resultSetChunks = rs.getResultSetSerializables(maxSizeInBytes);
        for (int i = 0; i < resultSetChunks.size(); ++i) {
            SnowflakeResultSetSerializable entry = (SnowflakeResultSetSerializable)resultSetChunks.get(i);
            String tmpFileName = this.tmpFolder.getPath() + "_result_" + i + "." + fileNameAppendix;
            try (FileOutputStream fo = new FileOutputStream(tmpFileName);
                 ObjectOutputStream so = new ObjectOutputStream(fo);){
                so.writeObject(entry);
                so.flush();
            }
            result.add(tmpFileName);
        }
        if (developPrint) {
            System.out.println("\nSplit ResultSet as " + result.size() + " parts.");
            for (String filename : result) {
                System.out.println(filename);
            }
        }
        return result;
    }

    private String deserializeResultSet(List<String> files) throws Throwable {
        return this.deserializeResultSetWithProperties(files, null);
    }

    private String deserializeResultSetWithProperties(List<String> files, Properties props) throws Throwable {
        StringBuilder builder = new StringBuilder(0x100000);
        builder.append("==== result start ===\n");
        for (String filename : files) {
            try (FileInputStream fi = new FileInputStream(filename);
                 ObjectInputStream si = new ObjectInputStream(fi);){
                SnowflakeResultSetSerializableV1 resultSetChunk = (SnowflakeResultSetSerializableV1)si.readObject();
                if (developPrint) {
                    System.out.println("\nFormat: " + resultSetChunk.getQueryResultFormat() + " UncompChunksize: " + resultSetChunk.getUncompressedDataSizeInBytes() + " firstChunkContent: " + (resultSetChunk.getFirstChunkStringData() == null ? " null " : " not null "));
                    for (SnowflakeResultSetSerializableV1.ChunkFileMetadata chunkFileMetadata : resultSetChunk.chunkFileMetadatas) {
                        System.out.println("RowCount=" + chunkFileMetadata.getRowCount() + ", cpsize=" + chunkFileMetadata.getCompressedByteSize() + ", uncpsize=" + chunkFileMetadata.getUncompressedByteSize() + ", URL= " + chunkFileMetadata.getFileURL());
                    }
                }
                ResultSet rs = resultSetChunk.getResultSet(SnowflakeResultSetSerializable.ResultSetRetrieveConfig.Builder.newInstance().setProxyProperties(props).setSfFullURL(this.sfFullURL).build());
                try {
                    ResultSetMetaData metadata = rs.getMetaData();
                    int colCount = metadata.getColumnCount();
                    if (developPrint) {
                        for (int j = 1; j <= colCount; ++j) {
                            System.out.print(" table: " + metadata.getTableName(j));
                            System.out.print(" schema: " + metadata.getSchemaName(j));
                            System.out.print(" type: " + metadata.getColumnTypeName(j));
                            System.out.print(" name: " + metadata.getColumnName(j));
                            System.out.print(" precision: " + metadata.getPrecision(j));
                            System.out.println(" scale:" + metadata.getScale(j));
                        }
                    }
                    while (rs.next()) {
                        for (int i = 1; i <= colCount; ++i) {
                            rs.getObject(i);
                            if (rs.wasNull()) {
                                builder.append("\"").append("null").append("\",");
                                continue;
                            }
                            builder.append("\"").append(rs.getString(i)).append("\",");
                        }
                        builder.append("\n");
                    }
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
        }
        builder.append("==== result end   ===\n");
        return builder.toString();
    }

    private void testBasicTableHarness(int rowCount, long maxSizeInBytes, String whereClause, boolean needSetupTable, boolean async, String queryResultFormat) throws Throwable {
        List<String> fileNameList = null;
        String originalResultCSVString = null;
        try (Connection connection = this.init(queryResultFormat);){
            Statement statement = connection.createStatement();
            if (developPrint) {
                System.out.println("testBasicTableHarness: rowCount=" + rowCount + ", maxSizeInBytes=" + maxSizeInBytes + ", whereClause=" + whereClause + ", needSetupTable=" + needSetupTable + ", async=" + async);
            }
            if (needSetupTable) {
                statement.execute("create or replace table table_basic  (int_c int, string_c string(128))");
                if (rowCount > 0) {
                    statement.execute("insert into table_basic select seq4(), 'arrow_1234567890arrow_1234567890arrow_1234567890arrow_1234567890' from table(generator(rowcount=>" + rowCount + "))");
                }
            }
            String sqlSelect = "select * from table_basic " + whereClause;
            try (ResultSet rs = async ? statement.unwrap(SnowflakeStatement.class).executeAsyncQuery(sqlSelect) : statement.executeQuery(sqlSelect);){
                fileNameList = this.serializeResultSet((SnowflakeResultSet)rs, maxSizeInBytes, "txt");
                originalResultCSVString = this.generateCSVResult(rs);
            }
        }
        String chunkResultString = this.deserializeResultSet(fileNameList);
        Assertions.assertEquals((Object)chunkResultString, (Object)originalResultCSVString);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testBasicTableWithEmptyResult(String queryResultFormat) throws Throwable {
        this.testBasicTableHarness(10, 1024L, "where int_c * int_c = 2", true, false, queryResultFormat);
        this.testBasicTableHarness(10, 1024L, "where int_c * int_c = 2", true, true, queryResultFormat);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testBasicTableWithOnlyFirstChunk(String queryResultFormat) throws Throwable {
        this.testBasicTableHarness(1, 1L, "", true, false, queryResultFormat);
        this.testBasicTableHarness(1, 1L, "", true, true, queryResultFormat);
        this.testBasicTableHarness(1, 0x100000L, "", false, false, queryResultFormat);
        this.testBasicTableHarness(1, 0x100000L, "", false, true, queryResultFormat);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testBasicTableWithOneFileChunk(String queryResultFormat) throws Throwable {
        this.testBasicTableHarness(300, 1L, "", true, false, queryResultFormat);
        this.testBasicTableHarness(300, 1L, "", true, true, queryResultFormat);
        this.testBasicTableHarness(300, 0x100000L, "", false, false, queryResultFormat);
        this.testBasicTableHarness(300, 0x100000L, "", false, true, queryResultFormat);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testBasicTableWithSomeFileChunks(String queryResultFormat) throws Throwable {
        this.testBasicTableHarness(90000, 1L, "", true, false, queryResultFormat);
        this.testBasicTableHarness(90000, 1L, "", true, true, queryResultFormat);
        this.testBasicTableHarness(90000, 0x300000L, "", false, false, queryResultFormat);
        this.testBasicTableHarness(90000, 0x300000L, "", false, true, queryResultFormat);
        this.testBasicTableHarness(90000, 0x6400000L, "", false, false, queryResultFormat);
        this.testBasicTableHarness(90000, 0x6400000L, "", false, true, queryResultFormat);
    }

    private void testTimestampHarness(int rowCount, long maxSizeInBytes, String whereClause, String format_date, String format_time, String format_ntz, String format_ltz, String format_tz, String timezone, String queryResultFormat) throws Throwable {
        List<String> fileNameList = null;
        String originalResultCSVString = null;
        try (Connection connection = this.init(queryResultFormat);
             Statement statement = connection.createStatement();){
            statement.execute("alter session set DATE_OUTPUT_FORMAT = '" + format_date + "'");
            statement.execute("alter session set TIME_OUTPUT_FORMAT = '" + format_time + "'");
            statement.execute("alter session set TIMESTAMP_NTZ_OUTPUT_FORMAT = '" + format_ntz + "'");
            statement.execute("alter session set TIMESTAMP_LTZ_OUTPUT_FORMAT = '" + format_ltz + "'");
            statement.execute("alter session set TIMESTAMP_TZ_OUTPUT_FORMAT = '" + format_tz + "'");
            statement.execute("alter session set TIMEZONE = '" + timezone + "'");
            statement.execute("Create or replace table all_timestamps (int_c int, date_c date, time_c time, time_c0 time(0), time_c3 time(3), time_c6 time(6), ts_ltz_c timestamp_ltz, ts_ltz_c0 timestamp_ltz(0), ts_ltz_c3 timestamp_ltz(3), ts_ltz_c6 timestamp_ltz(6), ts_ntz_c timestamp_ntz, ts_ntz_c0 timestamp_ntz(0), ts_ntz_c3 timestamp_ntz(3), ts_ntz_c6 timestamp_ntz(6) , ts_tz_c timestamp_tz, ts_tz_c0 timestamp_tz(0), ts_tz_c3 timestamp_tz(3), ts_tz_c6 timestamp_tz(6) )");
            if (rowCount > 0) {
                statement.execute("insert into all_timestamps select seq4(), '2015-10-25' , '23:59:59.123456789', '23:59:59', '23:59:59.123', '23:59:59.123456',    '2014-01-11 06:12:13.123456789', '2014-01-11 06:12:13',   '2014-01-11 06:12:13.123', '2014-01-11 06:12:13.123456',   '2014-01-11 06:12:13.123456789', '2014-01-11 06:12:13',   '2014-01-11 06:12:13.123', '2014-01-11 06:12:13.123456',   '2014-01-11 06:12:13.123456789', '2014-01-11 06:12:13',   '2014-01-11 06:12:13.123', '2014-01-11 06:12:13.123456' from table(generator(rowcount=>" + rowCount + "))");
            }
            String sqlSelect = "select * from all_timestamps " + whereClause;
            try (ResultSet rs = statement.executeQuery(sqlSelect);){
                fileNameList = this.serializeResultSet((SnowflakeResultSet)rs, maxSizeInBytes, "txt");
                originalResultCSVString = this.generateCSVResult(rs);
            }
        }
        String chunkResultString = this.deserializeResultSet(fileNameList);
        Assertions.assertEquals((Object)chunkResultString, (Object)originalResultCSVString);
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testTimestamp(String queryResultFormat) throws Throwable {
        String[] dateFormats = new String[]{"YYYY-MM-DD", "DD-MON-YYYY", "MM/DD/YYYY"};
        String[] timeFormats = new String[]{"HH24:MI:SS.FFTZH:TZM", "HH24:MI:SS.FF", "HH24:MI:SS"};
        String[] timestampFormats = new String[]{"YYYY-MM-DD HH24:MI:SS.FF3", "TZHTZM YYYY-MM-DD HH24:MI:SS.FF3", "DY, DD MON YYYY HH24:MI:SS.FF TZHTZM"};
        String[] timezones = new String[]{"America/Los_Angeles", "Europe/London", "GMT"};
        for (int i = 0; i < dateFormats.length; ++i) {
            this.testTimestampHarness(10, 1L, "", dateFormats[i], timeFormats[i], timestampFormats[i], timestampFormats[i], timestampFormats[i], timezones[i], queryResultFormat);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testBasicTableWithSerializeObjectsAfterReadResultSet(String queryResultFormat) throws Throwable {
        List<String> fileNameList = null;
        String originalResultCSVString = null;
        try (Connection connection = this.init(queryResultFormat);
             Statement statement = connection.createStatement();){
            statement.execute("create or replace schema testschema");
            statement.execute("create or replace table table_basic  (int_c int, string_c string(128))");
            int rowCount = 30000;
            statement.execute("insert into table_basic select seq4(), 'arrow_1234567890arrow_1234567890arrow_1234567890arrow_1234567890' from table(generator(rowcount=>" + rowCount + "))");
            String sqlSelect = "select * from table_basic ";
            try (ResultSet rs = statement.executeQuery(sqlSelect);){
                originalResultCSVString = this.generateCSVResult(rs);
                fileNameList = this.serializeResultSet((SnowflakeResultSet)rs, 0x100000L, "txt");
            }
        }
        String chunkResultString = this.deserializeResultSet(fileNameList);
        Assertions.assertEquals((Object)chunkResultString, (Object)originalResultCSVString);
    }

    private synchronized List<String> splitResultSetSerializables(List<String> files, long maxSizeInBytes) throws Throwable {
        ArrayList<String> resultFileList = new ArrayList<String>();
        for (String filename : files) {
            try (FileInputStream fi = new FileInputStream(filename);
                 ObjectInputStream si = new ObjectInputStream(fi);){
                SnowflakeResultSetSerializableV1 resultSetChunk = (SnowflakeResultSetSerializableV1)si.readObject();
                ResultSet rs = resultSetChunk.getResultSet(SnowflakeResultSetSerializable.ResultSetRetrieveConfig.Builder.newInstance().setProxyProperties(new Properties()).setSfFullURL(this.sfFullURL).build());
                try {
                    String[] filePathParts = filename.split(File.separator);
                    String appendix = filePathParts[filePathParts.length - 1];
                    List<String> thisFileList = this.serializeResultSet((SnowflakeResultSet)rs, maxSizeInBytes, appendix);
                    for (int i = 0; i < thisFileList.size(); ++i) {
                        resultFileList.add(thisFileList.get(i));
                    }
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
        }
        if (developPrint) {
            System.out.println("Split from " + files.size() + " files to " + resultFileList.size() + " files");
        }
        return resultFileList;
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testSplitResultSetSerializable(String queryResultFormat) throws Throwable {
        List<String> fileNameList = null;
        String originalResultCSVString = null;
        int rowCount = 90000;
        try (Connection connection = this.init(queryResultFormat);
             Statement statement = connection.createStatement();){
            statement.execute("create or replace table table_basic  (int_c int, string_c string(128))");
            statement.execute("insert into table_basic select seq4(), 'arrow_1234567890arrow_1234567890arrow_1234567890arrow_1234567890' from table(generator(rowcount=>" + rowCount + "))");
            String sqlSelect = "select * from table_basic ";
            try (ResultSet rs = statement.executeQuery(sqlSelect);){
                fileNameList = this.serializeResultSet((SnowflakeResultSet)rs, 0x6400000L, "txt");
                originalResultCSVString = this.generateCSVResult(rs);
            }
        }
        List<String> fileNameSplit3M = this.splitResultSetSerializables(fileNameList, 0x300000L);
        String chunkResultString = this.deserializeResultSet(fileNameSplit3M);
        Assertions.assertEquals((Object)chunkResultString, (Object)originalResultCSVString);
        List<String> fileNameSplit2M = this.splitResultSetSerializables(fileNameSplit3M, 0x200000L);
        chunkResultString = this.deserializeResultSet(fileNameSplit2M);
        Assertions.assertEquals((Object)chunkResultString, (Object)originalResultCSVString);
        List<String> fileNameSplit1M = this.splitResultSetSerializables(fileNameSplit2M, 0x100000L);
        chunkResultString = this.deserializeResultSet(fileNameSplit1M);
        Assertions.assertEquals((Object)chunkResultString, (Object)originalResultCSVString);
        List<String> fileNameSplitSmallest = this.splitResultSetSerializables(fileNameSplit1M, 1L);
        chunkResultString = this.deserializeResultSet(fileNameSplitSmallest);
        Assertions.assertEquals((Object)chunkResultString, (Object)originalResultCSVString);
    }

    private void hackToSetupWrongURL(List<SnowflakeResultSetSerializable> resultSetSerializables) {
        for (int i = 0; i < resultSetSerializables.size(); ++i) {
            SnowflakeResultSetSerializableV1 serializableV1 = (SnowflakeResultSetSerializableV1)resultSetSerializables.get(i);
            for (SnowflakeResultSetSerializableV1.ChunkFileMetadata chunkFileMetadata : serializableV1.getChunkFileMetadatas()) {
                chunkFileMetadata.setFileURL(chunkFileMetadata.getFileURL() + "_hacked_wrong_file");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testCloseUnconsumedResultSet(String queryResultFormat) throws Throwable {
        try (Connection connection = this.init(queryResultFormat);
             Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table table_basic  (int_c int, string_c string(128))");
                int rowCount = 100000;
                statement.execute("insert into table_basic select seq4(), 'arrow_1234567890arrow_1234567890arrow_1234567890arrow_1234567890' from table(generator(rowcount=>" + rowCount + "))");
                int testCount = 5;
                while (testCount-- > 0) {
                    String sqlSelect = "select * from table_basic ";
                    ResultSet rs = statement.executeQuery(sqlSelect);
                    if (rs == null) continue;
                    rs.close();
                }
            }
            finally {
                statement.execute("drop table if exists table_basic");
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testNegativeWithChunkFileNotExist(String queryResultFormat) throws Throwable {
        Properties properties = new Properties();
        properties.put("networkTimeout", (Object)10000);
        try (Connection connection = this.init(properties, queryResultFormat);
             Statement statement = connection.createStatement();){
            statement.execute("create or replace table table_basic  (int_c int, string_c string(128))");
            int rowCount = 300;
            statement.execute("insert into table_basic select seq4(), 'arrow_1234567890arrow_1234567890arrow_1234567890arrow_1234567890' from table(generator(rowcount=>" + rowCount + "))");
            String sqlSelect = "select * from table_basic ";
            try (ResultSet rs = statement.executeQuery(sqlSelect);){
                List resultSetSerializables = ((SnowflakeResultSet)rs).getResultSetSerializables(0x6400000L);
                this.hackToSetupWrongURL(resultSetSerializables);
                Assertions.assertEquals((int)resultSetSerializables.size(), (int)1);
                SnowflakeResultSetSerializable resultSetSerializable = (SnowflakeResultSetSerializable)resultSetSerializables.get(0);
                ResultSet resultSet = resultSetSerializable.getResultSet(SnowflakeResultSetSerializable.ResultSetRetrieveConfig.Builder.newInstance().setProxyProperties(new Properties()).setSfFullURL(this.sfFullURL).build());
                SQLException ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> {
                    while (resultSet.next()) {
                        resultSet.getString(1);
                    }
                }, (String)"error should happen when accessing the data because the file URL is corrupted.");
                Assertions.assertEquals((long)ErrorCode.INTERNAL_ERROR.getMessageCode().intValue(), (long)ex.getErrorCode());
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testNegativeWithClosedResultSet(String queryResultFormat) throws Throwable {
        try (Connection connection = this.init(queryResultFormat);){
            Statement statement = connection.createStatement();
            statement.execute("create or replace table table_basic  (int_c int, string_c string(128))");
            int rowCount = 300;
            statement.execute("insert into table_basic select seq4(), 'arrow_1234567890arrow_1234567890arrow_1234567890arrow_1234567890' from table(generator(rowcount=>" + rowCount + "))");
            String sqlSelect = "select * from table_basic ";
            ResultSet rs = statement.executeQuery(sqlSelect);
            rs.close();
            SQLException ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> ((SnowflakeResultSet)rs).getResultSetSerializables(0x6400000L));
            System.out.println("Negative test hits expected error: " + ex.getMessage());
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @Disabled
    @DontRunOnGithubActions
    public void testCustomProxyWithFiles(String queryResultFormat) throws Throwable {
        boolean generateFiles = false;
        boolean correctProxy = false;
        if (generateFiles) {
            this.generateTestFiles(queryResultFormat);
            Assertions.fail((String)"This is generate test file.");
        }
        Properties props = new Properties();
        props.put("useProxy", "true");
        props.put("proxyHost", "localhost");
        props.put("proxyPort", "3128");
        props.put("proxyUser", "testuser1");
        if (correctProxy) {
            props.put("proxyPassword", "test");
        } else {
            props.put("proxyPassword", "wrongPasswd");
        }
        props.put("nonProxyHosts", "*.foo.com");
        ArrayList<String> fileNameList = new ArrayList<String>();
        fileNameList.add("/tmp/junit16319222538342218700_result_0.txt");
        fileNameList.add("/tmp/junit16319222538342218700_result_1.txt");
        fileNameList.add("/tmp/junit16319222538342218700_result_2.txt");
        fileNameList.add("/tmp/junit16319222538342218700_result_3.txt");
        if (correctProxy) {
            String chunkResultString = this.deserializeResultSetWithProperties(fileNameList, props);
            System.out.println(chunkResultString.length());
        } else {
            Assertions.assertThrows(Exception.class, () -> this.deserializeResultSetWithProperties(fileNameList, props));
        }
    }

    private void generateTestFiles(String queryResultFormat) throws Throwable {
        try (Connection connection = this.init(queryResultFormat);
             Statement statement = connection.createStatement();){
            statement.execute("create or replace table table_basic  (int_c int, string_c string(128))");
            int rowCount = 60000;
            statement.execute("insert into table_basic select seq4(), 'arrow_1234567890arrow_1234567890arrow_1234567890arrow_1234567890' from table(generator(rowcount=>" + rowCount + "))");
            String sqlSelect = "select * from table_basic ";
            try (ResultSet rs = statement.executeQuery(sqlSelect);){
                developPrint = true;
                this.serializeResultSet((SnowflakeResultSet)rs, 0x200000L, "txt");
                System.exit(-1);
            }
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=SimpleResultFormatProvider.class)
    @DontRunOnGithubActions
    public void testRetrieveMetadata(String queryResultFormat) throws Throwable {
        List<String> fileNameList;
        int rowCount = 90000;
        long expectedTotalRowCount = 0L;
        long expectedTotalCompressedSize = 0L;
        long expectedTotalUncompressedSize = 0L;
        try (Connection connection = this.init(queryResultFormat);
             Statement statement = connection.createStatement();){
            statement.execute("create or replace table table_basic  (int_c int, string_c string(128))");
            statement.execute("insert into table_basic select seq4(), 'arrow_1234567890arrow_1234567890arrow_1234567890arrow_1234567890' from table(generator(rowcount=>" + rowCount + "))");
            String sqlSelect = "select * from table_basic ";
            try (ResultSet rs = statement.executeQuery(sqlSelect);){
                fileNameList = this.serializeResultSet((SnowflakeResultSet)rs, 0x6400000L, "txt");
                Assertions.assertEquals((int)fileNameList.size(), (int)1);
                try (FileInputStream fi = new FileInputStream(fileNameList.get(0));
                     ObjectInputStream si = new ObjectInputStream(fi);){
                    SnowflakeResultSetSerializableV1 wholeResultSetChunk = (SnowflakeResultSetSerializableV1)si.readObject();
                    expectedTotalRowCount = wholeResultSetChunk.getRowCount();
                    expectedTotalCompressedSize = wholeResultSetChunk.getCompressedDataSizeInBytes();
                    expectedTotalUncompressedSize = wholeResultSetChunk.getUncompressedDataSizeInBytes();
                }
                if (developPrint) {
                    System.out.println("Total statistic: RowCount=" + expectedTotalRowCount + " CompSize=" + expectedTotalCompressedSize + " UncompSize=" + expectedTotalUncompressedSize);
                }
            }
        }
        Assertions.assertEquals((long)expectedTotalRowCount, (long)rowCount);
        MatcherAssert.assertThat((Object)expectedTotalCompressedSize, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        MatcherAssert.assertThat((Object)expectedTotalUncompressedSize, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        List<String> fileNameSplit3M = this.splitResultSetSerializables(fileNameList, 0x300000L);
        Assertions.assertTrue((boolean)this.isMetadataConsistent(expectedTotalRowCount, expectedTotalCompressedSize, expectedTotalUncompressedSize, fileNameSplit3M, null));
        List<String> fileNameSplit2M = this.splitResultSetSerializables(fileNameSplit3M, 0x200000L);
        Assertions.assertTrue((boolean)this.isMetadataConsistent(expectedTotalRowCount, expectedTotalCompressedSize, expectedTotalUncompressedSize, fileNameSplit2M, null));
        List<String> fileNameSplit1M = this.splitResultSetSerializables(fileNameSplit2M, 0x100000L);
        Assertions.assertTrue((boolean)this.isMetadataConsistent(expectedTotalRowCount, expectedTotalCompressedSize, expectedTotalUncompressedSize, fileNameSplit1M, null));
        List<String> fileNameSplitSmallest = this.splitResultSetSerializables(fileNameSplit1M, 1L);
        Assertions.assertTrue((boolean)this.isMetadataConsistent(expectedTotalRowCount, expectedTotalCompressedSize, expectedTotalUncompressedSize, fileNameSplitSmallest, null));
    }

    private boolean isMetadataConsistent(long expectedTotalRowCount, long expectedTotalCompressedSize, long expectedTotalUncompressedSize, List<String> files, Properties props) throws Throwable {
        long actualRowCountFromMetadata = 0L;
        long actualTotalCompressedSize = 0L;
        long actualTotalUncompressedSize = 0L;
        long actualRowCount = 0L;
        long chunkFileCount = 0L;
        for (String filename : files) {
            try (FileInputStream fi = new FileInputStream(filename);
                 ObjectInputStream si = new ObjectInputStream(fi);){
                SnowflakeResultSetSerializableV1 resultSetChunk = (SnowflakeResultSetSerializableV1)si.readObject();
                actualRowCountFromMetadata += resultSetChunk.getRowCount();
                actualTotalCompressedSize += resultSetChunk.getCompressedDataSizeInBytes();
                actualTotalUncompressedSize += resultSetChunk.getUncompressedDataSizeInBytes();
                chunkFileCount += (long)resultSetChunk.chunkFileCount;
                try (ResultSet rs = resultSetChunk.getResultSet(SnowflakeResultSetSerializable.ResultSetRetrieveConfig.Builder.newInstance().setProxyProperties(props).setSfFullURL(this.sfFullURL).build());){
                    while (rs.next()) {
                        ++actualRowCount;
                    }
                }
            }
            if (!developPrint) continue;
            System.out.println("isMetadataConsistent: FileCount=" + files.size() + " RowCounts=" + expectedTotalRowCount + " " + actualRowCountFromMetadata + " (" + actualRowCount + ") CompSize=" + expectedTotalCompressedSize + " " + actualTotalCompressedSize + " UncompSize=" + expectedTotalUncompressedSize + " " + actualTotalUncompressedSize + " chunkFileCount=" + chunkFileCount);
        }
        return actualRowCount == expectedTotalRowCount && actualRowCountFromMetadata == expectedTotalRowCount && actualTotalCompressedSize == expectedTotalCompressedSize && expectedTotalUncompressedSize == actualTotalUncompressedSize;
    }

    @Test
    public void testResultSetRetrieveConfig() throws Throwable {
        SnowflakeResultSetSerializable.ResultSetRetrieveConfig.Builder builder = SnowflakeResultSetSerializable.ResultSetRetrieveConfig.Builder.newInstance();
        boolean hitExpectedException = false;
        try {
            builder.setSfFullURL("sfctest0.snowflakecomputing.com");
            builder.build();
        }
        catch (Exception ex) {
            hitExpectedException = true;
        }
        Assertions.assertTrue((boolean)hitExpectedException);
    }
}

