/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.QueryResultFormat;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFBaseStatement;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.jdbc.DefaultResultStreamProvider;
import net.snowflake.client.jdbc.MockConnectionTest;
import net.snowflake.client.jdbc.ResultStreamProvider;
import net.snowflake.client.jdbc.SnowflakeChunkDownloader;
import net.snowflake.client.jdbc.SnowflakeColumnMetadata;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import net.snowflake.client.jdbc.SnowflakeRichResultSetSerializableV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SnowflakeSerializableTest {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.getObjectMapper();
    private static final String STANDARD_SERIALIZABLE_V1_JSON_STRING = "{\n  \"data\": {\n    \"parameters\": [\n      {\n        \"name\": \"CLIENT_PREFETCH_THREADS\",\n        \"value\": 4\n      },\n      {\n        \"name\": \"TIMESTAMP_OUTPUT_FORMAT\",\n        \"value\": \"YYYY-MM-DD HH24:MI:SS.FF3 TZHTZM\"\n      },\n      {\n        \"name\": \"CLIENT_RESULT_CHUNK_SIZE\",\n        \"value\": 128\n      }\n    ],\n    \"rowtype\": [\n      {\n        \"name\": \"1\",\n        \"database\": \"some-db\",\n        \"schema\": \"some-schema\",\n        \"table\": \"some-table\",\n        \"byteLength\": null,\n        \"type\": \"fixed\",\n        \"length\": 256,\n        \"scale\": 0,\n        \"precision\": 1,\n        \"nullable\": false,\n        \"collation\": null\n      }\n    ],\n    \"rowset\": [\n      [\n        \"1\"\n      ]\n    ],\n    \"qrmk\": \"ADCDEFGHIJdwadawYhiF81aC0wT0IU+NN8QtobPWCk=\",\n    \"chunkHeaders\": {\n      \"x-amz-server-side-encryption-customer-key-md5\": \"A2dDf2ff7HI8OCdsR3pK82g==\"\n    },\n    \"chunks\": [\n      {\n        \"url\": \"https://sfc-ds2-customer-stage.s3.us-west-2.amazonaws.com\",\n        \"rowCount\": 756,\n        \"uncompressedSize\": 312560,\n        \"compressedSize\": 26828\n      }\n    ],\n    \"total\": 1,\n    \"returned\": 1,\n    \"queryId\": \"01b341c1-0000-772f-0000-0004189328ca\",\n    \"databaseProvider\": \"some-db-provider\",\n    \"finalDatabaseName\": \"some-db\",\n    \"finalSchemaName\": \"some-schema\",\n    \"finalWarehouseName\": \"some-warehouse\",\n    \"finalRoleName\": \"ENG_OPS_RL\",\n    \"numberOfBinds\": 0,\n    \"arrayBindSupported\": false,\n    \"statementTypeId\": 4096,\n    \"version\": 1,\n    \"sendResultTime\": 1711499620154,\n    \"queryResultFormat\": \"json\",\n    \"queryContext\": {\n      \"entries\": [\n        {\n          \"id\": 0,\n          \"timestamp\": 55456940208204,\n          \"priority\": 0\n        }\n      ]\n    }\n  },\n  \"code\": null,\n  \"message\": null,\n  \"success\": true\n}";
    public static final String RICH_RESULTS_SERIALIZABLE_V1_JSON_STRING = "{\n  \"data\": {\n    \"parameters\": [\n      {\n        \"name\": \"CLIENT_PREFETCH_THREADS\",\n        \"value\": 4\n      },\n      {\n        \"name\": \"TIMESTAMP_OUTPUT_FORMAT\",\n        \"value\": \"YYYY-MM-DD HH24:MI:SS.FF3 TZHTZM\"\n      },\n      {\n        \"name\": \"CLIENT_RESULT_CHUNK_SIZE\",\n        \"value\": 128\n      }\n    ],\n    \"rowtype\": [\n      {\n        \"name\": \"1\",\n        \"database\": \"some-db\",\n        \"schema\": \"some-schema\",\n        \"table\": \"some-table\",\n        \"byteLength\": null,\n        \"type\": \"fixed\",\n        \"length\": 256,\n        \"scale\": 0,\n        \"precision\": 1,\n        \"nullable\": false,\n        \"collation\": null\n      }\n    ],\n    \"rowset\": [\n      [\n        \"1\"\n      ]\n    ],\n    \"qrmk\": \"ADCDEFGHIJdwadawYhiF81aC0wT0IU+NN8QtobPWCk=\",\n    \"chunkHeaders\": {\n      \"x-amz-server-side-encryption-customer-key-md5\": \"A2dDf2ff7HI8OCdsR3pK82g==\"\n    },\n    \"chunks\": [\n      {\n        \"url\": \"https://sfc-ds2-customer-stage.s3.us-west-2.amazonaws.com\",\n        \"rowCount\": 756,\n        \"uncompressedSize\": 312560,\n        \"compressedSize\": 26828\n      }\n    ],\n    \"total\": 1,\n    \"returned\": 1,\n    \"queryId\": \"01b341c1-0000-772f-0000-0004189328ca\",\n    \"databaseProvider\": \"some-db-provider\",\n    \"finalDatabaseName\": \"some-db\",\n    \"finalSchemaName\": \"some-schema\",\n    \"finalWarehouseName\": \"some-warehouse\",\n    \"finalRoleName\": \"ENG_OPS_RL\",\n    \"numberOfBinds\": 0,\n    \"arrayBindSupported\": false,\n    \"statementTypeId\": 4096,\n    \"version\": 1,\n    \"sendResultTime\": 1711499620154,\n    \"queryResultFormat\": \"json\",\n    \"queryContext\": {\n      \"entries\": [\n        {\n          \"id\": 0,\n          \"timestamp\": 55456940208204,\n          \"priority\": 0\n        }\n      ]\n    }\n  },\n  \"richResult\": {\n    \"rowtype\": [\n        {\n          \"name\": \"LOWER_BOUND\",\n          \"database\": \"TEMP\",\n          \"schema\": \"PUBLIC\",\n          \"table\": \"T_TEST\",\n          \"precision\": null,\n          \"byteLength\": 16777216,\n          \"type\": \"fixed\",\n          \"scale\": null,\n          \"nullable\": true,\n          \"collation\": null,\n          \"length\": 16777216,\n          \"columnIndexing\": 1\n      },\n      {\n          \"name\": \"UPPER_BOUND\",\n          \"database\": \"TEMP\",\n          \"schema\": \"PUBLIC\",\n          \"table\": \"T_TEST\",\n          \"precision\": null,\n          \"byteLength\": 16777216,\n          \"type\": \"fixed\",\n          \"scale\": null,\n          \"nullable\": true,\n          \"collation\": null,\n          \"length\": 16777216,\n          \"columnIndexing\": 1\n      }\n    ],\n    \"rowset\": [\n      [\n        \"value1_lower\",\n        \"value1_upper\"\n      ],\n      [\n        \"value2_lower\",\n        \"value2_upper\"\n      ]\n\n    ],\n    \"qrmk\": \"ZXYADCDEFGHIJdwadawYhiF81aC0wT0IU+NN8QtobPWCk=\",\n    \"chunkHeaders\": {\n      \"x-amz-server-side-encryption-customer-key-md5\": \"f342lkkftyf7HI8OCdsR3pK82g==\"\n    },\n    \"chunks\": [\n      {\n        \"url\": \"https://sfc-ds2-customer-stage.s3.us-west-2.amazonaws.com/rich-res\",\n        \"rowCount\": 756,\n        \"uncompressedSize\": 312560,\n        \"compressedSize\": 26828\n      }\n    ],\n    \"total\": 1,\n    \"queryId\": \"01b341c1-0000-772f-0000-0004189328ca\",\n    \"queryResultFormat\": \"json\"\n  },\n  \"code\": null,\n  \"message\": null,\n  \"success\": true\n}";
    private static final SFBaseSession MOCK_SESSION = new MockConnectionTest.MockSnowflakeConnectionImpl().getSFSession();
    private static final SFBaseStatement MOCK_STATEMENT = new MockConnectionTest.MockSnowflakeConnectionImpl().getSFStatement();

    @Test
    public void shouldProperlyCreateSerializableV1() throws JsonProcessingException, SnowflakeSQLException {
        JsonNode rootNode = OBJECT_MAPPER.readTree(STANDARD_SERIALIZABLE_V1_JSON_STRING);
        SnowflakeResultSetSerializableV1 s = SnowflakeResultSetSerializableV1.create((JsonNode)rootNode, (SFBaseSession)MOCK_SESSION, (SFBaseStatement)MOCK_STATEMENT, (ResultStreamProvider)new DefaultResultStreamProvider());
        this.assertRegularResultSetSerializable(s, SnowflakeChunkDownloader.class);
    }

    @Test
    public void shouldCreateSerializableWithNoOpChunksDownloader() throws JsonProcessingException, SnowflakeSQLException {
        JsonNode rootNode = OBJECT_MAPPER.readTree(STANDARD_SERIALIZABLE_V1_JSON_STRING);
        SnowflakeResultSetSerializableV1 s = SnowflakeResultSetSerializableV1.createWithChunksPrefetchDisabled((JsonNode)rootNode, (SFBaseSession)MOCK_SESSION, (SFBaseStatement)MOCK_STATEMENT);
        this.assertRegularResultSetSerializable(s, SnowflakeChunkDownloader.NoOpChunkDownloader.class);
    }

    @Test
    public void shouldProperlyCreateRichSerializableV1() throws JsonProcessingException, SnowflakeSQLException {
        JsonNode rootNode = OBJECT_MAPPER.readTree(RICH_RESULTS_SERIALIZABLE_V1_JSON_STRING);
        SnowflakeRichResultSetSerializableV1 s = SnowflakeRichResultSetSerializableV1.createWithChunksPrefetchDisabled((JsonNode)rootNode, (SFBaseSession)MOCK_SESSION, (SFBaseStatement)MOCK_STATEMENT);
        this.assertRegularResultSetSerializable((SnowflakeResultSetSerializableV1)s, SnowflakeChunkDownloader.NoOpChunkDownloader.class);
        this.assertRichResultSetSerializable(s);
    }

    private void assertRegularResultSetSerializable(SnowflakeResultSetSerializableV1 s, Class<?> expectedChunkDownloaderType) {
        Assertions.assertNotNull((Object)s);
        Assertions.assertEquals((Object)"01b341c1-0000-772f-0000-0004189328ca", (Object)s.getQueryId());
        Assertions.assertEquals((Object)"some-db", (Object)s.getFinalDatabaseName());
        Assertions.assertEquals((Object)"some-schema", (Object)s.getFinalSchemaName());
        Assertions.assertEquals((Object)"some-warehouse", (Object)s.getFinalWarehouseName());
        Assertions.assertEquals((Object)"ENG_OPS_RL", (Object)s.getFinalRoleName());
        Assertions.assertEquals((int)0, (int)s.getNumberOfBinds());
        Assertions.assertEquals((Object)QueryResultFormat.JSON, (Object)s.getQueryResultFormat());
        Assertions.assertEquals((Object)SFStatementType.SELECT, (Object)s.getStatementType());
        Assertions.assertEquals((Object)new HashMap<String, Object>(){
            {
                this.put("CLIENT_PREFETCH_THREADS", 4);
                this.put("TIMESTAMP_OUTPUT_FORMAT", "YYYY-MM-DD HH24:MI:SS.FF3 TZHTZM");
                this.put("CLIENT_RESULT_CHUNK_SIZE", 128);
            }
        }, (Object)s.getParameters());
        Assertions.assertEquals((Object)"ADCDEFGHIJdwadawYhiF81aC0wT0IU+NN8QtobPWCk=", (Object)s.getQrmk());
        Assertions.assertFalse((boolean)s.isArrayBindSupported());
        Assertions.assertEquals((long)1L, (long)s.getResultVersion());
        Assertions.assertEquals((int)1, (int)s.getColumnCount());
        Assertions.assertEquals((int)1, (int)s.getResultColumnMetadata().size());
        SnowflakeColumnMetadata column = (SnowflakeColumnMetadata)s.getResultColumnMetadata().get(0);
        Assertions.assertEquals((Object)"1", (Object)column.getName());
        Assertions.assertEquals((Object)"NUMBER", (Object)column.getTypeName());
        Assertions.assertEquals((int)-5, (int)column.getType());
        Assertions.assertFalse((boolean)column.isNullable());
        Assertions.assertEquals((int)256, (int)column.getLength());
        Assertions.assertEquals((int)0, (int)column.getScale());
        Assertions.assertEquals((int)1, (int)column.getPrecision());
        Assertions.assertEquals((Object)SnowflakeType.FIXED, (Object)column.getBase());
        Assertions.assertEquals((Object)"some-db", (Object)column.getColumnSrcDatabase());
        Assertions.assertEquals((Object)"some-schema", (Object)column.getColumnSrcSchema());
        Assertions.assertEquals((Object)"some-table", (Object)column.getColumnSrcTable());
        Assertions.assertEquals((Object)"[[\"1\"]]", (Object)s.getFirstChunkStringData());
        Assertions.assertEquals((int)1, (int)s.getChunkHeadersMap().size());
        Assertions.assertEquals((Object)"A2dDf2ff7HI8OCdsR3pK82g==", s.getChunkHeadersMap().get("x-amz-server-side-encryption-customer-key-md5"));
        Assertions.assertEquals((int)1, (int)s.getChunkFileCount());
        Assertions.assertEquals((int)1, (int)s.getChunkFileMetadatas().size());
        SnowflakeResultSetSerializableV1.ChunkFileMetadata chunkMeta = (SnowflakeResultSetSerializableV1.ChunkFileMetadata)s.getChunkFileMetadatas().get(0);
        Assertions.assertEquals((int)756, (int)chunkMeta.getRowCount());
        Assertions.assertEquals((int)26828, (int)chunkMeta.getCompressedByteSize());
        Assertions.assertEquals((int)312560, (int)chunkMeta.getUncompressedByteSize());
        Assertions.assertEquals((Object)"https://sfc-ds2-customer-stage.s3.us-west-2.amazonaws.com", (Object)chunkMeta.getFileURL());
        Assertions.assertNotNull((Object)s.chunkDownloader);
        Assertions.assertTrue((boolean)expectedChunkDownloaderType.isInstance(s.chunkDownloader));
    }

    private void assertRichResultSetSerializable(SnowflakeRichResultSetSerializableV1 s) {
        Assertions.assertEquals((int)2, (int)s.getRichResultsColumnCount());
        Assertions.assertEquals((int)2, (int)s.getRichResultsColumnMetadata().size());
        SnowflakeRichResultSetSerializableV1.SnowflakeRichResultsColumnMetadata lowerBound = (SnowflakeRichResultSetSerializableV1.SnowflakeRichResultsColumnMetadata)s.getRichResultsColumnMetadata().get(0);
        Assertions.assertEquals((Object)"LOWER_BOUND", (Object)lowerBound.getName());
        Assertions.assertEquals((Object)"NUMBER", (Object)lowerBound.getTypeName());
        Assertions.assertEquals((int)-5, (int)lowerBound.getType());
        Assertions.assertTrue((boolean)lowerBound.isNullable());
        Assertions.assertEquals((int)0x1000000, (int)lowerBound.getLength());
        Assertions.assertEquals((Object)SnowflakeType.FIXED, (Object)lowerBound.getBase());
        Assertions.assertEquals((Object)"TEMP", (Object)lowerBound.getColumnSrcDatabase());
        Assertions.assertEquals((Object)"PUBLIC", (Object)lowerBound.getColumnSrcSchema());
        Assertions.assertEquals((Object)"T_TEST", (Object)lowerBound.getColumnSrcTable());
        Assertions.assertEquals((int)1, (int)lowerBound.getColumnIndex());
        SnowflakeRichResultSetSerializableV1.SnowflakeRichResultsColumnMetadata upperBound = (SnowflakeRichResultSetSerializableV1.SnowflakeRichResultsColumnMetadata)s.getRichResultsColumnMetadata().get(1);
        Assertions.assertEquals((Object)"UPPER_BOUND", (Object)upperBound.getName());
        Assertions.assertEquals((Object)"NUMBER", (Object)upperBound.getTypeName());
        Assertions.assertEquals((int)-5, (int)upperBound.getType());
        Assertions.assertTrue((boolean)upperBound.isNullable());
        Assertions.assertEquals((int)0x1000000, (int)upperBound.getLength());
        Assertions.assertEquals((Object)SnowflakeType.FIXED, (Object)upperBound.getBase());
        Assertions.assertEquals((Object)"TEMP", (Object)upperBound.getColumnSrcDatabase());
        Assertions.assertEquals((Object)"PUBLIC", (Object)upperBound.getColumnSrcSchema());
        Assertions.assertEquals((Object)"T_TEST", (Object)upperBound.getColumnSrcTable());
        Assertions.assertEquals((int)1, (int)upperBound.getColumnIndex());
        Assertions.assertEquals((Object)"[[\"value1_lower\",\"value1_upper\"],[\"value2_lower\",\"value2_upper\"]]", (Object)s.getRichResultsFirstChunkStringData());
        Assertions.assertEquals((Object)"ZXYADCDEFGHIJdwadawYhiF81aC0wT0IU+NN8QtobPWCk=", (Object)s.getRichResultsQrmk());
        Assertions.assertEquals((int)1, (int)s.getRichResultsChunkHeadersMap().size());
        Assertions.assertEquals((Object)"f342lkkftyf7HI8OCdsR3pK82g==", s.getRichResultsChunkHeadersMap().get("x-amz-server-side-encryption-customer-key-md5"));
        Assertions.assertEquals((int)1, (int)s.getRichResultsChunkFileCount());
        Assertions.assertEquals((int)1, (int)s.getRichResultsChunkFilesMetadata().size());
        SnowflakeResultSetSerializableV1.ChunkFileMetadata chunkMeta = (SnowflakeResultSetSerializableV1.ChunkFileMetadata)s.getRichResultsChunkFilesMetadata().get(0);
        Assertions.assertEquals((int)756, (int)chunkMeta.getRowCount());
        Assertions.assertEquals((int)26828, (int)chunkMeta.getCompressedByteSize());
        Assertions.assertEquals((int)312560, (int)chunkMeta.getUncompressedByteSize());
        Assertions.assertEquals((Object)"https://sfc-ds2-customer-stage.s3.us-west-2.amazonaws.com/rich-res", (Object)chunkMeta.getFileURL());
    }
}

