/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.TimeZone;
import java.util.stream.Stream;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeTimestampWithTimezone;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class SnowflakeTimestampWithTimezoneTest
extends BaseJDBCTest {
    private static TimeZone orgTimeZone;

    @BeforeAll
    public static void keepOriginalTimeZone() {
        orgTimeZone = TimeZone.getDefault();
    }

    @AfterAll
    public static void restoreTimeZone() {
        TimeZone.setDefault(orgTimeZone);
    }

    @ParameterizedTest(name="{index}: {1} {0}")
    @ArgumentsSource(value=Params.class)
    public void testTimestampNTZ(String timeZone, String inputTimestamp, String outputTimestamp) {
        TimeZone.setDefault(TimeZone.getTimeZone(timeZone));
        LocalDateTime dt = this.parseTimestampNTZ(inputTimestamp);
        SnowflakeTimestampWithTimezone stn = new SnowflakeTimestampWithTimezone(dt.toEpochSecond(ZoneOffset.UTC) * 1000L, dt.getNano(), TimeZone.getTimeZone("UTC"));
        Assertions.assertEquals((Object)outputTimestamp, (Object)stn.toString());
    }

    @Test
    public void testGetTimezone() {
        String timezone = "Australia/Sydney";
        Long datetime = System.currentTimeMillis();
        Timestamp currentTimestamp = new Timestamp(datetime);
        SnowflakeTimestampWithTimezone ts = new SnowflakeTimestampWithTimezone(currentTimestamp, TimeZone.getTimeZone(timezone));
        Assertions.assertEquals((Object)ts.getTimezone().getID(), (Object)timezone);
    }

    @Test
    public void testToZonedDateTime() {
        String timezone = "Australia/Sydney";
        String zonedDateTime = "2022-03-17T10:10:08+11:00[Australia/Sydney]";
        Long datetime = 1647472208000L;
        Timestamp timestamp = new Timestamp(datetime);
        SnowflakeTimestampWithTimezone ts = new SnowflakeTimestampWithTimezone(timestamp, TimeZone.getTimeZone(timezone));
        ZonedDateTime zd = ts.toZonedDateTime();
        Assertions.assertEquals((Object)zd.toString(), (Object)zonedDateTime);
    }

    static class Params
    implements ArgumentsProvider {
        Params() {
        }

        public Stream<Arguments> provideArguments(ExtensionContext context) {
            String[] timeZoneList = new String[]{"PST", "America/New_York", "UTC", "Asia/Singapore"};
            String[] dateTimeList = new String[]{"2018-03-11 01:10:34.0123456", "2018-03-11 02:10:34.0123456", "2018-03-11 03:10:34.0123456", "2018-11-04 01:10:34.123", "2018-11-04 02:10:34.123", "2018-11-04 03:10:34.123", "2020-03-11 01:10:34.456", "2020-03-11 02:10:34.456", "2020-03-11 03:10:34.456", "2020-11-01 01:10:34.123", "2020-11-01 02:10:34.123", "2020-11-01 03:10:34.123"};
            ArrayList<Arguments> testCases = new ArrayList<Arguments>();
            for (String timeZone : timeZoneList) {
                for (String dateTime : dateTimeList) {
                    testCases.add(Arguments.of((Object[])new Object[]{timeZone, dateTime, dateTime}));
                }
            }
            return testCases.stream();
        }
    }
}

