/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SnowflakeTypeTest {
    @Test
    public void testSnowflakeType() {
        Assertions.assertEquals((Object)SnowflakeType.getJavaType((SnowflakeType)SnowflakeType.CHAR, (boolean)false), (Object)SnowflakeType.JavaDataType.JAVA_STRING);
        Assertions.assertEquals((Object)SnowflakeType.getJavaType((SnowflakeType)SnowflakeType.INTEGER, (boolean)false), (Object)SnowflakeType.JavaDataType.JAVA_LONG);
        Assertions.assertEquals((Object)SnowflakeType.getJavaType((SnowflakeType)SnowflakeType.FIXED, (boolean)false), (Object)SnowflakeType.JavaDataType.JAVA_BIGDECIMAL);
        Assertions.assertEquals((Object)SnowflakeType.getJavaType((SnowflakeType)SnowflakeType.TIMESTAMP, (boolean)false), (Object)SnowflakeType.JavaDataType.JAVA_TIMESTAMP);
        Assertions.assertEquals((Object)SnowflakeType.getJavaType((SnowflakeType)SnowflakeType.TIME, (boolean)false), (Object)SnowflakeType.JavaDataType.JAVA_TIMESTAMP);
        Assertions.assertEquals((Object)SnowflakeType.getJavaType((SnowflakeType)SnowflakeType.TIMESTAMP_LTZ, (boolean)false), (Object)SnowflakeType.JavaDataType.JAVA_TIMESTAMP);
        Assertions.assertEquals((Object)SnowflakeType.getJavaType((SnowflakeType)SnowflakeType.TIMESTAMP_NTZ, (boolean)false), (Object)SnowflakeType.JavaDataType.JAVA_TIMESTAMP);
        Assertions.assertEquals((Object)SnowflakeType.getJavaType((SnowflakeType)SnowflakeType.TIMESTAMP_TZ, (boolean)false), (Object)SnowflakeType.JavaDataType.JAVA_TIMESTAMP);
        Assertions.assertEquals((Object)SnowflakeType.getJavaType((SnowflakeType)SnowflakeType.DATE, (boolean)false), (Object)SnowflakeType.JavaDataType.JAVA_TIMESTAMP);
        Assertions.assertEquals((Object)SnowflakeType.getJavaType((SnowflakeType)SnowflakeType.BOOLEAN, (boolean)false), (Object)SnowflakeType.JavaDataType.JAVA_BOOLEAN);
        Assertions.assertEquals((Object)SnowflakeType.getJavaType((SnowflakeType)SnowflakeType.VECTOR, (boolean)false), (Object)SnowflakeType.JavaDataType.JAVA_STRING);
        Assertions.assertEquals((Object)SnowflakeType.getJavaType((SnowflakeType)SnowflakeType.BINARY, (boolean)false), (Object)SnowflakeType.JavaDataType.JAVA_BYTES);
        Assertions.assertEquals((Object)SnowflakeType.getJavaType((SnowflakeType)SnowflakeType.ANY, (boolean)false), (Object)SnowflakeType.JavaDataType.JAVA_OBJECT);
        Assertions.assertEquals((Object)SnowflakeType.getJavaType((SnowflakeType)SnowflakeType.OBJECT, (boolean)true), (Object)SnowflakeType.JavaDataType.JAVA_OBJECT);
        Assertions.assertEquals((Object)SnowflakeType.getJavaType((SnowflakeType)SnowflakeType.OBJECT, (boolean)false), (Object)SnowflakeType.JavaDataType.JAVA_STRING);
        Assertions.assertEquals((Object)SnowflakeType.getJavaType((SnowflakeType)SnowflakeType.GEOMETRY, (boolean)false), (Object)SnowflakeType.JavaDataType.JAVA_STRING);
    }

    @Test
    public void testConvertStringToType() {
        Assertions.assertEquals((int)SnowflakeType.convertStringToType(null), (int)0);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"decimal"), (int)3);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"int"), (int)4);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"integer"), (int)4);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"byteint"), (int)4);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"smallint"), (int)5);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"bigint"), (int)-5);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"double"), (int)8);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"double precision"), (int)8);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"real"), (int)7);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"char"), (int)1);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"character"), (int)1);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"varbinary"), (int)-3);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"boolean"), (int)16);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"date"), (int)91);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"time"), (int)92);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"timestamp"), (int)93);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"datetime"), (int)93);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"timestamp_ntz"), (int)93);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"timestamp_ltz"), (int)2014);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"timestamp_tz"), (int)2014);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"variant"), (int)1111);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"object"), (int)2000);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"vector"), (int)50003);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"array"), (int)2003);
        Assertions.assertEquals((int)SnowflakeType.convertStringToType((String)"default"), (int)1111);
    }

    @Test
    public void testJavaSQLTypeFind() {
        Assertions.assertNull((Object)SnowflakeType.JavaSQLType.find((int)200000));
    }

    @Test
    public void testJavaSQLTypeLexicalValue() {
        Assertions.assertEquals((Object)SnowflakeType.lexicalValue((Object)Float.valueOf(1.0f), null, null, null, null), (Object)"0x1.0p0");
        Assertions.assertEquals((Object)SnowflakeType.lexicalValue((Object)new BigDecimal(100.0), null, null, null, null), (Object)"100");
        Assertions.assertEquals((Object)SnowflakeType.lexicalValue((Object)"random".getBytes(), null, null, null, null), (Object)"72616E646F6D");
    }

    @Test
    public void testJavaTypeToSFType() throws SnowflakeSQLException {
        Assertions.assertEquals((Object)SnowflakeType.javaTypeToSFType((int)0, null), (Object)SnowflakeType.ANY);
        Assertions.assertThrows(SnowflakeSQLLoggedException.class, () -> SnowflakeType.javaTypeToSFType((int)2000000, null));
    }

    @Test
    public void testJavaTypeToClassName() throws SQLException {
        Assertions.assertEquals((Object)SnowflakeType.javaTypeToClassName((int)3), (Object)BigDecimal.class.getName());
        Assertions.assertEquals((Object)SnowflakeType.javaTypeToClassName((int)92), (Object)Time.class.getName());
        Assertions.assertEquals((Object)SnowflakeType.javaTypeToClassName((int)16), (Object)Boolean.class.getName());
        Assertions.assertThrows(SQLFeatureNotSupportedException.class, () -> SnowflakeType.javaTypeToClassName((int)-2000000));
    }
}

