/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.ColumnTypeInfo;
import net.snowflake.client.jdbc.FieldMetadata;
import net.snowflake.client.jdbc.SnowflakeColumnMetadata;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.SnowflakeUtil;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="core")
public class SnowflakeUtilTest
extends BaseJDBCTest {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.getObjectMapper();

    @Test
    public void testCreateMetadata() throws Throwable {
        ObjectNode rootNode = SnowflakeUtilTest.createRootNode();
        ArrayNode fields = OBJECT_MAPPER.createArrayNode();
        ObjectNode fieldOne = SnowflakeUtilTest.createFieldNode("name1", null, 256, null, "text", false, "collation", 256);
        fields.add((JsonNode)fieldOne);
        ObjectNode fieldTwo = SnowflakeUtilTest.createFieldNode("name2", 5, 128, 2, "real", true, "collation", 256);
        fields.add((JsonNode)fieldTwo);
        rootNode.putIfAbsent("fields", (JsonNode)fields);
        SnowflakeColumnMetadata expectedColumnMetadata = SnowflakeUtilTest.createExpectedMetadata((JsonNode)rootNode, (JsonNode)fieldOne, (JsonNode)fieldTwo);
        SnowflakeColumnMetadata columnMetadata = SnowflakeUtil.extractColumnMetadata((JsonNode)rootNode, (boolean)false, null);
        Assertions.assertNotNull((Object)columnMetadata);
        Assertions.assertEquals((Object)OBJECT_MAPPER.writeValueAsString((Object)expectedColumnMetadata), (Object)OBJECT_MAPPER.writeValueAsString((Object)columnMetadata));
    }

    @Test
    public void testCreateFieldsMetadataForObject() throws Throwable {
        ObjectNode rootNode = SnowflakeUtilTest.createRootNode();
        ArrayNode fields = OBJECT_MAPPER.createArrayNode();
        fields.add(OBJECT_MAPPER.readTree("{\"fieldName\":\"name1\", \"fieldType\": {\"type\":\"text\",\"precision\":null,\"length\":256,\"scale\":null,\"nullable\":false}}"));
        fields.add(OBJECT_MAPPER.readTree("{\"fieldName\":\"name2\", \"fieldType\": {\"type\":\"real\",\"precision\":5,\"length\":128,\"scale\":null,\"nullable\":true}}"));
        rootNode.putIfAbsent("fields", (JsonNode)fields);
        SnowflakeColumnMetadata columnMetadata = SnowflakeUtil.extractColumnMetadata((JsonNode)rootNode, (boolean)false, null);
        Assertions.assertNotNull((Object)columnMetadata);
        Assertions.assertEquals((Object)"OBJECT", (Object)columnMetadata.getTypeName());
        FieldMetadata firstField = (FieldMetadata)columnMetadata.getFields().get(0);
        Assertions.assertEquals((Object)"name1", (Object)firstField.getName());
        Assertions.assertEquals((Object)SnowflakeType.TEXT, (Object)firstField.getBase());
        Assertions.assertEquals((int)256, (int)firstField.getByteLength());
        Assertions.assertFalse((boolean)firstField.isNullable());
        FieldMetadata secondField = (FieldMetadata)columnMetadata.getFields().get(1);
        Assertions.assertEquals((Object)"name2", (Object)secondField.getName());
        Assertions.assertEquals((Object)SnowflakeType.REAL, (Object)secondField.getBase());
        Assertions.assertEquals((int)128, (int)secondField.getByteLength());
        Assertions.assertEquals((int)5, (int)secondField.getPrecision());
        Assertions.assertTrue((boolean)secondField.isNullable());
    }

    @Test
    public void shouldConvertCreateCaseInsensitiveMap() {
        Map<String, String> map = new HashMap<String, String>();
        map.put("key1", "value1");
        map = SnowflakeUtil.createCaseInsensitiveMap(map);
        Assertions.assertTrue((boolean)(map instanceof TreeMap));
        Assertions.assertEquals((Object)String.CASE_INSENSITIVE_ORDER, ((TreeMap)map).comparator());
        Assertions.assertEquals((Object)"value1", map.get("key1"));
        Assertions.assertEquals((Object)"value1", map.get("Key1"));
        Assertions.assertEquals((Object)"value1", map.get("KEy1"));
        map.put("KEY1", "changed_value1");
        Assertions.assertEquals((Object)"changed_value1", map.get("KEY1"));
    }

    @Test
    public void shouldConvertHeadersCreateCaseInsensitiveMap() {
        Header[] headers = new Header[]{new BasicHeader("key1", "value1"), new BasicHeader("key2", "value2")};
        Map map = SnowflakeUtil.createCaseInsensitiveMap((Header[])headers);
        Assertions.assertTrue((boolean)(map instanceof TreeMap));
        Assertions.assertEquals((Object)String.CASE_INSENSITIVE_ORDER, ((TreeMap)map).comparator());
        Assertions.assertEquals((Object)"value1", map.get("key1"));
        Assertions.assertEquals((Object)"value2", map.get("key2"));
        Assertions.assertEquals((Object)"value1", map.get("Key1"));
        Assertions.assertEquals((Object)"value2", map.get("Key2"));
    }

    private static SnowflakeColumnMetadata createExpectedMetadata(JsonNode rootNode, JsonNode fieldOne, JsonNode fieldTwo) throws SnowflakeSQLLoggedException {
        ColumnTypeInfo columnTypeInfo = SnowflakeUtil.getSnowflakeType((String)rootNode.path("type").asText(), null, null, null, (int)0, (boolean)true, (boolean)false);
        ColumnTypeInfo columnTypeInfoNodeOne = SnowflakeUtil.getSnowflakeType((String)fieldOne.path("type").asText(), null, null, null, (int)-5, (boolean)true, (boolean)false);
        ColumnTypeInfo columnTypeInfoNodeTwo = SnowflakeUtil.getSnowflakeType((String)fieldTwo.path("type").asText(), null, null, null, (int)3, (boolean)true, (boolean)false);
        SnowflakeColumnMetadata expectedColumnMetadata = new SnowflakeColumnMetadata(rootNode.path("name").asText(), columnTypeInfo.getColumnType(), rootNode.path("nullable").asBoolean(), rootNode.path("length").asInt(), rootNode.path("precision").asInt(), rootNode.path("scale").asInt(), columnTypeInfo.getExtColTypeName(), false, columnTypeInfo.getSnowflakeType(), Arrays.asList(new FieldMetadata(fieldOne.path("name").asText(), columnTypeInfoNodeOne.getExtColTypeName(), columnTypeInfoNodeOne.getColumnType(), fieldOne.path("nullable").asBoolean(), fieldOne.path("length").asInt(), fieldOne.path("precision").asInt(), fieldOne.path("scale").asInt(), fieldOne.path("fixed").asBoolean(), columnTypeInfoNodeOne.getSnowflakeType(), new ArrayList()), new FieldMetadata(fieldTwo.path("name").asText(), columnTypeInfoNodeTwo.getExtColTypeName(), columnTypeInfoNodeTwo.getColumnType(), fieldTwo.path("nullable").asBoolean(), fieldTwo.path("length").asInt(), fieldTwo.path("precision").asInt(), fieldTwo.path("scale").asInt(), fieldTwo.path("fixed").asBoolean(), columnTypeInfoNodeTwo.getSnowflakeType(), new ArrayList())), rootNode.path("database").asText(), rootNode.path("schema").asText(), rootNode.path("table").asText(), false, rootNode.path("dimension").asInt());
        return expectedColumnMetadata;
    }

    private static ObjectNode createRootNode() {
        ObjectNode rootNode = SnowflakeUtilTest.createFieldNode("STRUCT", 2, 128, 8, "object", false, null, 42);
        rootNode.put("database", "databaseName");
        rootNode.put("schema", "schemaName");
        rootNode.put("table", "tableName");
        return rootNode;
    }

    private static ObjectNode createFieldNode(String name, Integer precision, Integer byteLength, Integer scale, String type, boolean nullable, String collation, Integer length) {
        ObjectNode fieldNode = OBJECT_MAPPER.createObjectNode();
        fieldNode.put("name", name);
        fieldNode.put("type", type);
        fieldNode.put("precision", precision);
        fieldNode.put("byteLength", byteLength);
        fieldNode.put("scale", scale);
        fieldNode.put("type", type);
        fieldNode.put("nullable", nullable);
        fieldNode.put("collation", collation);
        fieldNode.put("length", length);
        return fieldNode;
    }
}

