/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Connection;
import java.sql.Statement;
import net.snowflake.client.jdbc.BaseJDBCTest;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="statement")
public class StatementFeatureNotSupportedIT
extends BaseJDBCTest {
    @Test
    public void testFeatureNotSupportedException() throws Throwable {
        try (Connection connection = StatementFeatureNotSupportedIT.getConnection();
             Statement statement = connection.createStatement();){
            this.expectFeatureNotSupportedException(() -> statement.execute("select 1", new int[0]));
            this.expectFeatureNotSupportedException(() -> statement.execute("select 1", new String[0]));
            this.expectFeatureNotSupportedException(() -> statement.executeUpdate("insert into a values(1)", 1));
            this.expectFeatureNotSupportedException(() -> statement.executeUpdate("insert into a values(1)", new int[0]));
            this.expectFeatureNotSupportedException(() -> statement.executeUpdate("insert into a values(1)", new String[0]));
            this.expectFeatureNotSupportedException(() -> statement.executeLargeUpdate("insert into a values(1)", 1));
            this.expectFeatureNotSupportedException(() -> statement.executeLargeUpdate("insert into a values(1)", new int[0]));
            this.expectFeatureNotSupportedException(() -> statement.executeLargeUpdate("insert into a values(1)", new String[0]));
            this.expectFeatureNotSupportedException(() -> statement.setCursorName("curname"));
            this.expectFeatureNotSupportedException(() -> statement.setFetchDirection(1001));
            this.expectFeatureNotSupportedException(() -> statement.setFetchDirection(1002));
            this.expectFeatureNotSupportedException(() -> statement.setMaxFieldSize(10));
            this.expectFeatureNotSupportedException(statement::closeOnCompletion);
            this.expectFeatureNotSupportedException(statement::isCloseOnCompletion);
        }
    }
}

