/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.File;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.time.Duration;
import java.util.List;
import net.snowflake.client.AbstractDriverIT;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.BaseJDBCWithSharedConnectionIT;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeStatement;
import net.snowflake.client.jdbc.SnowflakeStatementV1;
import net.snowflake.client.jdbc.telemetry.Telemetry;
import net.snowflake.client.jdbc.telemetry.TelemetryClient;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

@Tag(value="statement")
public class StatementIT
extends BaseJDBCWithSharedConnectionIT {
    protected static String queryResultFormat = "json";
    @TempDir
    private File tmpFolder;

    public static Connection getConnection() throws SQLException {
        Connection conn = BaseJDBCTest.getConnection();
        try (Statement stmt = conn.createStatement();){
            stmt.execute("alter session set jdbc_query_result_format = '" + queryResultFormat + "'");
        }
        return conn;
    }

    @Test
    public void testFetchDirection() throws SQLException {
        try (Statement statement = connection.createStatement();){
            Assertions.assertEquals((int)1000, (int)statement.getFetchDirection());
            Assertions.assertThrows(SQLFeatureNotSupportedException.class, () -> statement.setFetchDirection(1001));
        }
    }

    @Disabled(value="Not working for setFetchSize")
    @Test
    public void testFetchSize() throws SQLException {
        try (Statement statement = connection.createStatement();){
            Assertions.assertEquals((int)50, (int)statement.getFetchSize());
            statement.setFetchSize(1);
            ResultSet rs = statement.executeQuery("select * from JDBC_STATEMENT");
            Assertions.assertEquals((int)1, (int)this.getSizeOfResultSet(rs));
        }
    }

    @Test
    public void testMaxRows() throws SQLException {
        try (Statement statement = connection.createStatement();){
            String sqlSelect = "select seq4() from table(generator(rowcount=>3))";
            Assertions.assertEquals((int)0, (int)statement.getMaxRows());
            try (ResultSet rs = statement.executeQuery(sqlSelect);){
                int n = this.getSizeOfResultSet(rs);
            }
            statement.setMaxRows(0);
            rs = statement.executeQuery(sqlSelect);
            if (rs != null) {
                rs.close();
            }
            statement.setMaxRows(-1);
            rs = statement.executeQuery(sqlSelect);
            if (rs != null) {
                rs.close();
            }
        }
    }

    @Test
    public void testQueryTimeOut() throws SQLException {
        try (Statement statement = connection.createStatement();){
            Assertions.assertEquals((int)0, (int)statement.getQueryTimeout());
            statement.setQueryTimeout(5);
            Assertions.assertEquals((int)5, (int)statement.getQueryTimeout());
            SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> statement.executeQuery("select count(*) from table(generator(timeLimit => 100))"));
            Assertions.assertTrue((boolean)true);
            Assertions.assertEquals((Object)"57014", (Object)e.getSQLState());
            Assertions.assertEquals((Object)"SQL execution canceled", (Object)e.getMessage());
        }
    }

    @Test
    public void testStatementClose() throws SQLException {
        try (Statement statement = connection.createStatement();){
            Assertions.assertEquals((Object)connection, (Object)statement.getConnection());
            Assertions.assertTrue((!statement.isClosed() ? 1 : 0) != 0);
            statement.close();
            Assertions.assertTrue((boolean)statement.isClosed());
        }
    }

    @Test
    public void testExecuteSelect() throws SQLException {
        try (Statement statement = connection.createStatement();){
            String sqlSelect = "select seq4() from table(generator(rowcount=>3))";
            boolean success = statement.execute(sqlSelect);
            Assertions.assertTrue((boolean)success);
            String queryID1 = statement.unwrap(SnowflakeStatement.class).getQueryID();
            Assertions.assertNotNull((Object)queryID1);
            try (ResultSet rs = statement.getResultSet();){
                Assertions.assertEquals((int)3, (int)this.getSizeOfResultSet(rs));
                Assertions.assertEquals((int)-1, (int)statement.getUpdateCount());
                Assertions.assertEquals((long)-1L, (long)statement.getLargeUpdateCount());
                String queryID2 = rs.unwrap(SnowflakeResultSet.class).getQueryID();
                Assertions.assertEquals((Object)queryID2, (Object)queryID1);
            }
            rs = statement.executeQuery(sqlSelect);
            try {
                Assertions.assertEquals((int)3, (int)this.getSizeOfResultSet(rs));
                String queryID4 = rs.unwrap(SnowflakeResultSet.class).getQueryID();
                Assertions.assertNotEquals((Object)queryID4, (Object)queryID1);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteInsert() throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_insert(cola number)");
                String insertSQL = "insert into test_insert values(2),(3)";
                int updateCount = statement.executeUpdate(insertSQL);
                Assertions.assertEquals((int)2, (int)updateCount);
                boolean success = statement.execute(insertSQL);
                Assertions.assertFalse((boolean)success);
                Assertions.assertEquals((int)2, (int)statement.getUpdateCount());
                Assertions.assertEquals((long)2L, (long)statement.getLargeUpdateCount());
                Assertions.assertNull((Object)statement.getResultSet());
                try (ResultSet rs = statement.executeQuery("select count(*) from test_insert");){
                    Assertions.assertTrue((boolean)rs.next());
                    Assertions.assertEquals((int)4, (int)rs.getInt(1));
                }
                Assertions.assertTrue((boolean)statement.execute("select 1"));
                try (ResultSet rs0 = statement.getResultSet();){
                    Assertions.assertTrue((boolean)rs0.next());
                    Assertions.assertEquals((int)rs0.getInt(1), (int)1);
                }
            }
            finally {
                statement.execute("drop table if exists test_insert");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteUpdateAndDelete() throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_update(cola number, colb string) as select 1, 'str1'");
                statement.execute("insert into test_update values(2, 'str2')");
                int updateCount = statement.executeUpdate("update test_update set COLB = 'newStr' where COLA = 1");
                Assertions.assertEquals((int)1, (int)updateCount);
                boolean success = statement.execute("update test_update set COLB = 'newStr' where COLA = 2");
                Assertions.assertFalse((boolean)success);
                Assertions.assertEquals((int)1, (int)statement.getUpdateCount());
                Assertions.assertEquals((long)1L, (long)statement.getLargeUpdateCount());
                Assertions.assertNull((Object)statement.getResultSet());
                updateCount = statement.executeUpdate("delete from test_update where colA = 1");
                Assertions.assertEquals((int)1, (int)updateCount);
                success = statement.execute("delete from test_update where colA = 2");
                Assertions.assertFalse((boolean)success);
                Assertions.assertEquals((int)1, (int)statement.getUpdateCount());
                Assertions.assertEquals((long)1L, (long)statement.getLargeUpdateCount());
                Assertions.assertNull((Object)statement.getResultSet());
            }
            finally {
                statement.execute("drop table if exists test_update");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteMerge() throws SQLException {
        try (Statement statement = connection.createStatement();){
            String mergeSQL = "merge into target using source on target.id = source.id when matched and source.sb =22 then update set ta = 'newStr' when not matched then insert (ta, tb) values (source.sa, source.sb)";
            try {
                statement.execute("create or replace table target(id integer, ta string, tb integer)");
                statement.execute("create or replace table source(id integer, sa string, sb integer)");
                statement.execute("insert into target values(1, 'str', 1)");
                statement.execute("insert into target values(2, 'str', 2)");
                statement.execute("insert into target values(3, 'str', 3)");
                statement.execute("insert into source values(1, 'str1', 11)");
                statement.execute("insert into source values(2, 'str2', 22)");
                statement.execute("insert into source values(3, 'str3', 33)");
                int updateCount = statement.executeUpdate(mergeSQL);
                Assertions.assertEquals((int)1, (int)updateCount);
            }
            finally {
                statement.execute("drop table if exists target");
                statement.execute("drop table if exists source");
            }
        }
    }

    @Test
    public void testAutogenerateKey() throws Throwable {
        try (Statement statement = connection.createStatement();){
            statement.execute("create or replace table t(c1 int)");
            statement.execute("insert into t values(1)", 2);
            Assertions.assertThrows(SQLFeatureNotSupportedException.class, () -> statement.execute("insert into t values(2)", 1));
            try (ResultSet rset = statement.getGeneratedKeys();){
                Assertions.assertFalse((boolean)rset.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteMultiInsert() throws SQLException {
        try (Statement statement = connection.createStatement();){
            String multiInsertionSQL = " insert all into foo into foo1 into bar (b1, b2, b3) values (s3, s2, s1) select s1, s2, s3 from source";
            try {
                Assertions.assertFalse((boolean)statement.execute("create or replace table foo (f1 integer, f2 integer, f3 integer)"));
                Assertions.assertFalse((boolean)statement.execute("create or replace table foo1 (f1 integer, f2 integer, f3 integer)"));
                Assertions.assertFalse((boolean)statement.execute("create or replace table bar (b1 integer, b2 integer, b3 integer)"));
                Assertions.assertFalse((boolean)statement.execute("create or replace table source(s1 integer, s2 integer, s3 integer)"));
                Assertions.assertFalse((boolean)statement.execute("insert into source values(1, 2, 3)"));
                Assertions.assertFalse((boolean)statement.execute("insert into source values(11, 22, 33)"));
                Assertions.assertFalse((boolean)statement.execute("insert into source values(111, 222, 333)"));
                int updateCount = statement.executeUpdate(multiInsertionSQL);
                Assertions.assertEquals((int)9, (int)updateCount);
            }
            finally {
                statement.execute("drop table if exists foo");
                statement.execute("drop table if exists foo1");
                statement.execute("drop table if exists bar");
                statement.execute("drop table if exists source");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteBatch() throws Exception {
        try (Statement statement = connection.createStatement();){
            try {
                connection.setAutoCommit(false);
                statement.addBatch("create or replace table test_batch(a string, b integer)");
                statement.addBatch("insert into test_batch values('str1', 1), ('str2', 2)");
                statement.addBatch("update test_batch set test_batch.b = src.b + 5 from (select 'str1' as a, 2 as b) src where test_batch.a = src.a");
                int[] rowCounts = statement.executeBatch();
                connection.commit();
                MatcherAssert.assertThat((Object)rowCounts.length, (Matcher)CoreMatchers.is((Object)3));
                MatcherAssert.assertThat((Object)rowCounts[0], (Matcher)CoreMatchers.is((Object)0));
                MatcherAssert.assertThat((Object)rowCounts[1], (Matcher)CoreMatchers.is((Object)2));
                MatcherAssert.assertThat((Object)rowCounts[2], (Matcher)CoreMatchers.is((Object)1));
                List batchQueryIDs = statement.unwrap(SnowflakeStatement.class).getBatchQueryIDs();
                Assertions.assertEquals((int)3, (int)batchQueryIDs.size());
                Assertions.assertEquals((Object)statement.unwrap(SnowflakeStatement.class).getQueryID(), batchQueryIDs.get(2));
                try (ResultSet resultSet = statement.executeQuery("select * from test_batch order by b asc");){
                    Assertions.assertTrue((boolean)resultSet.next());
                    MatcherAssert.assertThat((Object)resultSet.getInt("B"), (Matcher)CoreMatchers.is((Object)2));
                    Assertions.assertTrue((boolean)resultSet.next());
                    MatcherAssert.assertThat((Object)resultSet.getInt("B"), (Matcher)CoreMatchers.is((Object)7));
                    statement.clearBatch();
                    statement.addBatch("insert into test_batch values('str3', 3)");
                    statement.addBatch("select * from test_batch");
                    statement.addBatch("select * from test_batch_not_exist");
                    statement.addBatch("insert into test_batch values('str4', 4)");
                    BatchUpdateException e = (BatchUpdateException)Assertions.assertThrows(BatchUpdateException.class, statement::executeBatch);
                    rowCounts = e.getUpdateCounts();
                    MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)2003));
                    MatcherAssert.assertThat((Object)rowCounts[0], (Matcher)CoreMatchers.is((Object)1));
                    MatcherAssert.assertThat((Object)rowCounts[1], (Matcher)CoreMatchers.is((Object)-2));
                    MatcherAssert.assertThat((Object)rowCounts[2], (Matcher)CoreMatchers.is((Object)-3));
                    MatcherAssert.assertThat((Object)rowCounts[3], (Matcher)CoreMatchers.is((Object)1));
                    connection.rollback();
                    statement.clearBatch();
                    statement.addBatch("put file://" + StatementIT.getFullPathFileInResource("orders_100.csv") + " @%test_batch auto_compress=false");
                    File tempFolder = new File(this.tmpFolder, "test_downloads_folder");
                    tempFolder.mkdirs();
                    statement.addBatch("get @%test_batch file://" + tempFolder.getCanonicalPath());
                    rowCounts = statement.executeBatch();
                    MatcherAssert.assertThat((Object)rowCounts.length, (Matcher)CoreMatchers.is((Object)2));
                    MatcherAssert.assertThat((Object)rowCounts[0], (Matcher)CoreMatchers.is((Object)-2));
                    MatcherAssert.assertThat((Object)rowCounts[0], (Matcher)CoreMatchers.is((Object)-2));
                    statement.clearBatch();
                }
            }
            finally {
                statement.execute("drop table if exists test_batch");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecuteLargeBatch() throws SQLException {
        try (Statement statement = connection.createStatement();){
            try {
                statement.execute("create or replace table test_large_batch (a number) as (select * from (select 5 from table(generator(rowcount => 15)) v));");
                statement.addBatch("update test_large_batch set a = 7 where a = 5;");
                long[] rowsUpdated = statement.executeLargeBatch();
                MatcherAssert.assertThat((Object)rowsUpdated.length, (Matcher)CoreMatchers.is((Object)1));
                long testVal = 15L;
                MatcherAssert.assertThat((Object)rowsUpdated[0], (Matcher)CoreMatchers.is((Object)testVal));
                statement.clearBatch();
            }
            finally {
                statement.execute("drop table if exists test_large_batch");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testExecuteUpdateZeroCount() throws SQLException {
        try (Connection connection = StatementIT.getConnection();){
            String[] testCommands = new String[]{"use role accountadmin", "use database testdb", "use schema testschema", "create or replace table testExecuteUpdate(cola number)", "comment on table testExecuteUpdate is 'comments'", "alter table testExecuteUpdate rename column cola to colb", "create or replace role testRole", "create or replace user testuser", "grant SELECT on table testExecuteUpdate to role testrole", "grant role testrole to user testuser", "revoke SELECT on table testExecuteUpdate from role testrole", "revoke role testrole from user testuser", "truncate table testExecuteUpdate", "alter session set autocommit=false", "alter session unset autocommit", "drop table if exists testExecuteUpdate", "set v1 = 10", "unset v1", "undrop table testExecuteUpdate"};
            try {
                for (String testCommand : testCommands) {
                    try (Statement statement = connection.createStatement();){
                        int updateCount = statement.executeUpdate(testCommand);
                        MatcherAssert.assertThat((Object)updateCount, (Matcher)CoreMatchers.is((Object)0));
                    }
                }
            }
            finally {
                try (Statement statement = connection.createStatement();){
                    statement.execute("use role accountadmin");
                    statement.execute("drop table if exists testExecuteUpdate");
                    statement.execute("drop role if exists testrole");
                    statement.execute("drop user if exists testuser");
                }
            }
        }
    }

    @Test
    public void testExecuteUpdateFail() throws Exception {
        try (Statement statement = connection.createStatement();){
            String[] testCommands;
            for (String testCommand : testCommands = new String[]{"list @~", "ls @~", "remove @~/testfile", "rm @~/testfile", "select 1", "show databases", "desc database " + AbstractDriverIT.getConnectionParameters().get("database")}) {
                SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> statement.executeUpdate(testCommand), (String)("TestCommand: " + testCommand + " is expected to be failed to execute"));
                MatcherAssert.assertThat((String)testCommand, (Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.UNSUPPORTED_STATEMENT_TYPE_IN_EXECUTION_API.getMessageCode()));
            }
        }
    }

    @Test
    public void testTelemetryBatch() throws SQLException {
        Telemetry telemetryClient = null;
        try (Statement statement = connection.createStatement();){
            String sqlSelect = "select seq4() from table(generator(rowcount=>3))";
            statement.execute(sqlSelect);
            try (ResultSet rs = statement.getResultSet();){
                Assertions.assertEquals((int)3, (int)this.getSizeOfResultSet(rs));
                Assertions.assertEquals((int)-1, (int)statement.getUpdateCount());
                Assertions.assertEquals((long)-1L, (long)statement.getLargeUpdateCount());
            }
            rs = statement.executeQuery(sqlSelect);
            try {
                Assertions.assertEquals((int)3, (int)this.getSizeOfResultSet(rs));
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            telemetryClient = ((SnowflakeStatementV1)statement).connection.getSfSession().getTelemetryClient();
            Assertions.assertTrue((((TelemetryClient)telemetryClient).bufferSize() > 0 ? 1 : 0) != 0);
        }
        Telemetry finalTelemetryClient = telemetryClient;
        Awaitility.await().atMost(Duration.ofSeconds(10L)).until(() -> ((TelemetryClient)finalTelemetryClient).bufferSize(), CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testMultiStmtNotEnabled() throws SQLException {
        try (Statement statement = connection.createStatement();){
            String multiStmtQuery = "create or replace temporary table test_multi (cola int);\ninsert into test_multi VALUES (1), (2);\nselect cola from test_multi order by cola asc";
            SnowflakeSQLException ex = (SnowflakeSQLException)Assertions.assertThrows(SnowflakeSQLException.class, () -> statement.execute(multiStmtQuery), (String)"Using a multi-statement query without the parameter set should fail");
            Assertions.assertEquals((Object)"0A000", (Object)ex.getSQLState());
        }
    }

    @Test
    public void testCallStoredProcedure() throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("create or replace procedure SP()\nreturns string not null\nlanguage javascript\nas $$\n  snowflake.execute({sqlText:'select seq4() from table(generator(rowcount=>5))'});\n  return 'done';\n$$");
            Assertions.assertTrue((boolean)statement.execute("call SP()"));
            try (ResultSet rs = statement.getResultSet();){
                Assertions.assertNotNull((Object)rs);
                Assertions.assertTrue((boolean)rs.next());
                Assertions.assertEquals((Object)"done", (Object)rs.getString(1));
                Assertions.assertFalse((boolean)rs.next());
                Assertions.assertFalse((boolean)statement.getMoreResults());
                Assertions.assertEquals((int)-1, (int)statement.getUpdateCount());
                Assertions.assertEquals((long)-1L, (long)statement.getLargeUpdateCount());
            }
        }
    }

    @Test
    public void testCreateStatementWithParameters() throws Throwable {
        try (Connection connection = StatementIT.getConnection();){
            connection.createStatement(1003, 1007);
            SQLException ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> connection.createStatement(1003, 1008));
            Assertions.assertEquals((int)ErrorCode.FEATURE_UNSUPPORTED.getMessageCode(), (int)ex.getErrorCode());
            connection.createStatement(1003, 1007, 2);
            ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> connection.createStatement(1003, 1007, 1));
            Assertions.assertEquals((int)ErrorCode.FEATURE_UNSUPPORTED.getMessageCode(), (int)ex.getErrorCode());
        }
    }

    @Test
    public void testUnwrapper() throws Throwable {
        try (Statement statement = connection.createStatement();){
            Assertions.assertTrue((boolean)statement.isWrapperFor(SnowflakeStatementV1.class));
            statement.execute("select 1");
            SnowflakeStatement sfstatement = statement.unwrap(SnowflakeStatement.class);
            Assertions.assertNotNull((Object)sfstatement.getQueryID());
            Assertions.assertThrows(SQLException.class, () -> statement.unwrap(SnowflakeConnectionV1.class));
        }
    }

    @Test
    public void testQueryIdIsNullOnFreshStatement() throws SQLException {
        try (Statement stmt = connection.createStatement();){
            Assertions.assertNull((Object)stmt.unwrap(SnowflakeStatement.class).getQueryID());
        }
    }
}

