/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.TestUtil;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.annotations.DontRunOnJenkins;
import net.snowflake.client.core.QueryStatus;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.bind.BindUploader;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.BaseJDBCWithSharedConnectionIT;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakePreparedStatementV1;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeStatement;
import net.snowflake.client.jdbc.SnowflakeStatementV1;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.StatementIT;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

@Tag(value="statement")
public class StatementLatestIT
extends BaseJDBCWithSharedConnectionIT {
    protected static String queryResultFormat = "json";
    @TempDir
    private File tmpFolder;

    public static Connection getConnection() throws SQLException {
        Connection conn = BaseJDBCTest.getConnection();
        try (Statement stmt = conn.createStatement();){
            stmt.execute("alter session set jdbc_query_result_format = '" + queryResultFormat + "'");
        }
        return conn;
    }

    @Test
    public void testExecuteCreateAndDrop() throws SQLException {
        try (Statement statement = connection.createStatement();){
            boolean success = statement.execute("create or replace table test_create(colA integer)");
            Assertions.assertFalse((boolean)success);
            Assertions.assertEquals((int)0, (int)statement.getUpdateCount());
            Assertions.assertEquals((long)0L, (long)statement.getLargeUpdateCount());
            Assertions.assertNull((Object)statement.getResultSet());
            int rowCount = statement.executeUpdate("create or replace table test_create_2(colA integer)");
            Assertions.assertEquals((int)0, (int)rowCount);
            Assertions.assertEquals((int)0, (int)statement.getUpdateCount());
            success = statement.execute("drop table if exists TEST_CREATE");
            Assertions.assertFalse((boolean)success);
            Assertions.assertEquals((int)0, (int)statement.getUpdateCount());
            Assertions.assertEquals((long)0L, (long)statement.getLargeUpdateCount());
            Assertions.assertNull((Object)statement.getResultSet());
            rowCount = statement.executeUpdate("drop table if exists TEST_CREATE_2");
            Assertions.assertEquals((int)0, (int)rowCount);
            Assertions.assertEquals((int)0, (int)statement.getUpdateCount());
            Assertions.assertEquals((long)0L, (long)statement.getLargeUpdateCount());
            Assertions.assertNull((Object)statement.getResultSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testCopyAndUpload() throws Exception {
        File tempFolder = new File(this.tmpFolder, "test_downloads_folder");
        tempFolder.mkdirs();
        List<String> accounts = Arrays.asList(null, "s3testaccount", "azureaccount", "gcpaccount");
        for (int i = 0; i < accounts.size(); ++i) {
            String fileName = "test_copy.csv";
            URL resource = StatementIT.class.getResource(fileName);
            try (Connection connection = StatementLatestIT.getConnection(accounts.get(i));
                 Statement statement = connection.createStatement();){
                try {
                    statement.execute("create or replace table test_copy(c1 number, c2 number, c3 string)");
                    Assertions.assertEquals((int)0, (int)statement.getUpdateCount());
                    Assertions.assertEquals((long)0L, (long)statement.getLargeUpdateCount());
                    String path = resource.getFile();
                    try (ResultSet rset = statement.executeQuery("PUT file://" + path + " @%test_copy");){
                        SQLException ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> rset.getString(1));
                        MatcherAssert.assertThat((String)"No row found error", (Object)ex.getErrorCode(), (Matcher)CoreMatchers.equalTo((Object)ErrorCode.ROW_DOES_NOT_EXIST.getMessageCode()));
                        int cnt = 0;
                        while (rset.next()) {
                            MatcherAssert.assertThat((String)"uploaded file name", (Object)rset.getString(1), (Matcher)CoreMatchers.equalTo((Object)fileName));
                            ++cnt;
                        }
                        Assertions.assertEquals((int)0, (int)statement.getUpdateCount());
                        Assertions.assertEquals((long)0L, (long)statement.getLargeUpdateCount());
                        MatcherAssert.assertThat((String)"number of files", (Object)cnt, (Matcher)CoreMatchers.equalTo((Object)1));
                        int numRows = statement.executeUpdate("copy into test_copy");
                        Assertions.assertEquals((int)2, (int)numRows);
                        Assertions.assertEquals((int)2, (int)statement.getUpdateCount());
                        Assertions.assertEquals((long)2L, (long)statement.getLargeUpdateCount());
                        statement.executeQuery("get @%test_copy 'file://" + tempFolder.getCanonicalPath() + "' parallel=8");
                        File downloaded = new File(tempFolder.getCanonicalPath() + File.separator + fileName + ".gz");
                        Assertions.assertTrue((boolean)downloaded.exists());
                    }
                    Process p = Runtime.getRuntime().exec("gzip -d " + tempFolder.getCanonicalPath() + File.separator + fileName + ".gz");
                    p.waitFor();
                    File newCopy = new File(tempFolder.getCanonicalPath() + File.separator + fileName);
                    statement.execute("create or replace table test_copy_2(c1 number, c2 number, c3 string)");
                    statement.executeQuery("PUT file://" + newCopy.getPath() + " @%test_copy_2");
                    try (ResultSet rset = statement.executeQuery("select * from @%test_copy minus select * from @%test_copy_2");){
                        Assertions.assertFalse((boolean)rset.next());
                    }
                    rset = statement.executeQuery("select * from @%test_copy_2 minus select * from @%test_copy");
                    try {
                        Assertions.assertFalse((boolean)rset.next());
                        continue;
                    }
                    finally {
                        if (rset != null) {
                            rset.close();
                        }
                    }
                }
                finally {
                    statement.execute("drop table if exists test_copy");
                    statement.execute("drop table if exists test_copy_2");
                }
            }
        }
    }

    @Test
    public void testExecuteOpenResultSets() throws SQLException {
        int i;
        try (Statement statement = connection.createStatement();){
            for (i = 0; i < 10; ++i) {
                statement.execute("select 1");
                statement.getResultSet();
            }
            Assertions.assertEquals((int)9, (int)statement.unwrap(SnowflakeStatementV1.class).getOpenResultSets().size());
        }
        statement = connection.createStatement();
        try {
            for (i = 0; i < 10; ++i) {
                statement.execute("select 1");
                ResultSet resultSet = statement.getResultSet();
                resultSet.close();
            }
            Assertions.assertEquals((int)0, (int)statement.unwrap(SnowflakeStatementV1.class).getOpenResultSets().size());
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testPreparedStatementLogging() throws SQLException {
        try (Connection con = StatementLatestIT.getConnection();
             Statement stmt = con.createStatement();){
            try {
                SFSession sfSession = con.unwrap(SnowflakeConnectionV1.class).getSfSession();
                sfSession.setPreparedStatementLogging(true);
                stmt.execute("ALTER SESSION SET CLIENT_STAGE_ARRAY_BINDING_THRESHOLD = 1");
                stmt.executeQuery("create or replace table mytab(cola int, colb int, colc int, cold int, cole int, colf int, colg int, colh int)");
                PreparedStatement pstatement = con.prepareStatement("INSERT INTO mytab(cola, colb, colc, cold, cole, colf, colg, colh) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                for (int i = 1; i <= 1001; ++i) {
                    pstatement.setInt(1, i);
                    pstatement.setInt(2, i);
                    pstatement.setInt(3, i);
                    pstatement.setInt(4, i);
                    pstatement.setInt(5, i);
                    pstatement.setInt(6, i);
                    pstatement.setInt(7, i);
                    pstatement.setInt(8, i);
                    pstatement.addBatch();
                }
                Map bindings = pstatement.unwrap(SnowflakePreparedStatementV1.class).getBatchParameterBindings();
                Assertions.assertTrue((bindings.size() > 0 ? 1 : 0) != 0);
                int bindValues = BindUploader.arrayBindValueCount((Map)bindings);
                Assertions.assertEquals((int)8008, (int)bindValues);
                pstatement.executeBatch();
            }
            finally {
                stmt.execute("drop table if exists mytab");
            }
        }
    }

    @Test
    public void testSchemaWith255CharactersDoesNotCauseException() throws SQLException {
        String schemaName = "GENERATED_" + SnowflakeUtil.randomAlphaNumeric((int)(255 - "GENERATED_".length()));
        try (Statement stmt = connection.createStatement();){
            stmt.execute("create schema " + schemaName);
            stmt.execute("use schema " + schemaName);
            stmt.execute("drop schema " + schemaName);
        }
    }

    @Test
    public void testQueryIdIsSetOnFailedQueryExecute() throws SQLException {
        try (Statement stmt = connection.createStatement();){
            Assertions.assertNull((Object)stmt.unwrap(SnowflakeStatement.class).getQueryID());
            SnowflakeSQLException e = (SnowflakeSQLException)Assertions.assertThrows(SnowflakeSQLException.class, () -> stmt.execute("use database not_existing_database"));
            String queryID = stmt.unwrap(SnowflakeStatement.class).getQueryID();
            TestUtil.assertValidQueryId(queryID);
            Assertions.assertEquals((Object)queryID, (Object)e.getQueryId());
        }
    }

    @Test
    public void testQueryIdIsSetOnFailedExecuteUpdate() throws SQLException {
        try (Statement stmt = connection.createStatement();){
            Assertions.assertNull((Object)stmt.unwrap(SnowflakeStatement.class).getQueryID());
            SnowflakeSQLException e = (SnowflakeSQLException)Assertions.assertThrows(SnowflakeSQLException.class, () -> stmt.executeUpdate("update not_existing_table set a = 1 where id = 42"));
            String queryID = stmt.unwrap(SnowflakeStatement.class).getQueryID();
            TestUtil.assertValidQueryId(queryID);
            Assertions.assertEquals((Object)queryID, (Object)e.getQueryId());
        }
    }

    @Test
    public void testQueryIdIsSetOnFailedExecuteQuery() throws SQLException {
        try (Statement stmt = connection.createStatement();){
            Assertions.assertNull((Object)stmt.unwrap(SnowflakeStatement.class).getQueryID());
            SnowflakeSQLException e = (SnowflakeSQLException)Assertions.assertThrows(SnowflakeSQLException.class, () -> stmt.executeQuery("select * from not_existing_table"));
            String queryID = stmt.unwrap(SnowflakeStatement.class).getQueryID();
            TestUtil.assertValidQueryId(queryID);
            Assertions.assertEquals((Object)queryID, (Object)e.getQueryId());
        }
    }

    @Test
    public void testSetQueryTimeoutForAsyncQueryUsingConnectionProperty() throws SQLException {
        Properties p = new Properties();
        p.put("IMPLICIT_SERVER_SIDE_QUERY_TIMEOUT", (Object)true);
        try (Connection con = StatementLatestIT.getConnection(p);
             Statement statement = con.createStatement();){
            statement.setQueryTimeout(3);
            String sql = "select seq4() from table(generator(rowcount => 1000000000))";
            try (ResultSet resultSet = statement.unwrap(SnowflakeStatement.class).executeAsyncQuery(sql);){
                SnowflakeResultSet sfrs = resultSet.unwrap(SnowflakeResultSet.class);
                Awaitility.await().atMost(Duration.ofSeconds(10L)).until(() -> sfrs.getStatusV2().getStatus() == QueryStatus.FAILED_WITH_ERROR);
                Assertions.assertTrue((boolean)sfrs.getStatusV2().getErrorMessage().contains("Statement reached its statement or warehouse timeout of 3 second(s) and was canceled"));
            }
        }
    }

    @Test
    @DontRunOnJenkins
    public void testSetQueryTimeoutOnStatementWhenImplicitQueryTimeoutIsSet() throws SQLException, InterruptedException, ExecutionException {
        int threads = 20;
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        ArrayList futures = new ArrayList();
        Properties p = new Properties();
        p.put("IMPLICIT_SERVER_SIDE_QUERY_TIMEOUT", (Object)true);
        try (Connection con = StatementLatestIT.getConnection(p);){
            String sql = "select seq4() from table(generator(rowcount => 1000000000))";
            for (int i = 0; i < threads; ++i) {
                futures.add(executor.submit(() -> {
                    try (Statement statement = con.createStatement();){
                        statement.setQueryTimeout(3);
                        SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> statement.executeQuery(sql));
                        Assertions.assertEquals((Object)"57014", (Object)e.getSQLState());
                    }
                    catch (SQLException e) {
                        Assertions.fail((String)e.getMessage());
                    }
                }));
            }
            executor.shutdown();
            Assertions.assertTrue((boolean)executor.awaitTermination(60L, TimeUnit.SECONDS));
            for (Future future : futures) {
                Assertions.assertNull(future.get());
            }
        }
    }

    @Test
    @DontRunOnJenkins
    public void testSetQueryTimeoutOnConnectionWhenImplicitQueryTimeoutIsSet() throws SQLException, InterruptedException, ExecutionException {
        int threads = 20;
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        ArrayList futures = new ArrayList();
        Properties p = new Properties();
        p.put("IMPLICIT_SERVER_SIDE_QUERY_TIMEOUT", (Object)true);
        p.put("queryTimeout", (Object)3);
        try (Connection con = StatementLatestIT.getConnection(p);){
            String sql = "select seq4() from table(generator(rowcount => 1000000000))";
            for (int i = 0; i < threads; ++i) {
                futures.add(executor.submit(() -> {
                    try (Statement statement = con.createStatement();){
                        SQLException e = (SQLException)Assertions.assertThrows(SQLException.class, () -> statement.executeQuery(sql));
                        Assertions.assertEquals((Object)"57014", (Object)e.getSQLState());
                    }
                    catch (SQLException e) {
                        Assertions.fail((String)e.getMessage());
                    }
                }));
            }
            executor.shutdown();
            Assertions.assertTrue((boolean)executor.awaitTermination(60L, TimeUnit.SECONDS));
            for (Future future : futures) {
                Assertions.assertNull(future.get());
            }
        }
    }

    @Test
    public void testSetQueryTimeoutForAsyncQuery() throws SQLException {
        try (Connection con = StatementLatestIT.getConnection();
             Statement statement = con.createStatement();){
            SnowflakeStatement sfStmt = statement.unwrap(SnowflakeStatement.class);
            sfStmt.setAsyncQueryTimeout(3);
            String sql = "select seq4() from table(generator(rowcount => 1000000000))";
            try (ResultSet resultSet = sfStmt.executeAsyncQuery(sql);){
                SnowflakeResultSet sfrs = resultSet.unwrap(SnowflakeResultSet.class);
                Awaitility.await().atMost(Duration.ofSeconds(10L)).until(() -> sfrs.getStatusV2().getStatus() == QueryStatus.FAILED_WITH_ERROR);
                MatcherAssert.assertThat((Object)sfrs.getStatusV2().getErrorMessage(), (Matcher)CoreMatchers.containsString((String)"Statement reached its statement or warehouse timeout of 3 second(s) and was canceled"));
            }
        }
    }

    @Test
    public void testSetAsyncQueryTimeoutOverridesConnectionQueryTimeoutForAsyncQuery() throws SQLException {
        Properties p = new Properties();
        p.put("IMPLICIT_SERVER_SIDE_QUERY_TIMEOUT", (Object)true);
        p.put("queryTimeout", (Object)1);
        try (Connection con = StatementLatestIT.getConnection(p);
             Statement statement = con.createStatement();){
            SnowflakeStatement sfStmt = statement.unwrap(SnowflakeStatement.class);
            sfStmt.setAsyncQueryTimeout(3);
            String sql = "select seq4() from table(generator(rowcount => 1000000000))";
            try (ResultSet resultSet = sfStmt.executeAsyncQuery(sql);){
                SnowflakeResultSet sfrs = resultSet.unwrap(SnowflakeResultSet.class);
                Awaitility.await().atMost(Duration.ofSeconds(10L)).until(() -> sfrs.getStatusV2().getStatus() == QueryStatus.FAILED_WITH_ERROR);
                MatcherAssert.assertThat((Object)sfrs.getStatusV2().getErrorMessage(), (Matcher)CoreMatchers.containsString((String)"Statement reached its statement or warehouse timeout of 3 second(s) and was canceled"));
            }
        }
    }
}

