/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.SnowflakeStatementV1;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="statement")
public class StatementNoOpLatestIT {
    @Test
    public void testSnowflakeNoOpStatement() throws SQLException {
        SnowflakeStatementV1.NoOpSnowflakeStatementV1 statement = new SnowflakeStatementV1.NoOpSnowflakeStatementV1();
        this.expectSQLException(() -> statement.executeQuery("select 1"));
        this.expectSQLException(() -> statement.executeUpdate("insert into a values(1)"));
        this.expectSQLException(() -> statement.executeLargeUpdate("insert into a values(1)"));
        this.expectSQLException(() -> statement.execute("select 1"));
        this.expectSQLException(() -> statement.execute("select 1", 1));
        this.expectSQLException(() -> statement.execute("select 1", new int[0]));
        this.expectSQLException(() -> statement.execute("select 1", new String[0]));
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).executeBatch());
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).executeLargeBatch());
        this.expectSQLException(() -> statement.executeUpdate("insert into a values(1)", 1));
        this.expectSQLException(() -> statement.executeLargeUpdate("insert into a values(1)", 1));
        this.expectSQLException(() -> statement.executeUpdate("insert into a values(1)", new int[0]));
        this.expectSQLException(() -> statement.executeLargeUpdate("insert into a values(1)", new int[0]));
        this.expectSQLException(() -> statement.executeUpdate("insert into a values(1)", new String[0]));
        this.expectSQLException(() -> statement.executeLargeUpdate("insert into a values(1)", new String[0]));
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).getFetchDirection());
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).getFetchSize());
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).getGeneratedKeys());
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).getMaxFieldSize());
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).getMaxRows());
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).getMoreResults());
        this.expectSQLException(() -> statement.getMoreResults(1));
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).getQueryTimeout());
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).getResultSet());
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).getResultSetConcurrency());
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).getResultSetHoldability());
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).getResultSetType());
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).getUpdateCount());
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).getLargeUpdateCount());
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).getWarnings());
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).isClosed());
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).isPoolable());
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).isCloseOnCompletion());
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).getUpdateCount());
        this.expectSQLException(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).getConnection());
    }

    @Test
    public void testGetQueryID() throws SQLException {
        SnowflakeStatementV1.NoOpSnowflakeStatementV1 statement = new SnowflakeStatementV1.NoOpSnowflakeStatementV1();
        Assertions.assertEquals((Object)"invalid_query_id", (Object)statement.getQueryID());
        Assertions.assertEquals(new ArrayList(), (Object)statement.getBatchQueryIDs());
    }

    @Test
    public void testSetNoOp() throws SQLException {
        SnowflakeStatementV1.NoOpSnowflakeStatementV1 statement = new SnowflakeStatementV1.NoOpSnowflakeStatementV1();
        this.expectNoOp(() -> statement.setMaxRows(2));
        this.expectNoOp(() -> statement.setCursorName("a"));
        this.expectNoOp(() -> statement.setEscapeProcessing(false));
        this.expectNoOp(() -> statement.setFetchDirection(2));
        this.expectNoOp(() -> statement.setFetchSize(2));
        this.expectNoOp(() -> statement.setMaxFieldSize(2));
        this.expectNoOp(() -> statement.setPoolable(false));
        this.expectNoOp(() -> statement.setParameter("ab", (Object)3));
        this.expectNoOp(() -> statement.setQueryTimeout(2));
        this.expectNoOp(() -> statement.setMaxRows(2));
        this.expectNoOp(() -> statement.setMaxRows(2));
        this.expectNoOp(() -> statement.addBatch("select 1"));
        this.expectNoOp(() -> statement.close(false));
        this.expectNoOp(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).close());
        this.expectNoOp(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).closeOnCompletion());
        this.expectNoOp(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).cancel());
        this.expectNoOp(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).clearWarnings());
        this.expectNoOp(() -> ((SnowflakeStatementV1.NoOpSnowflakeStatementV1)statement).clearBatch());
    }

    protected void expectSQLException(BaseJDBCTest.MethodRaisesSQLException f) {
        Assertions.assertThrows(SQLException.class, f::run);
    }

    protected void expectNoOp(NoOpMethod f) throws SQLException {
        f.run();
    }

    protected static interface NoOpMethod {
        public void run() throws SQLException;
    }
}

