/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.FileBackedOutputStream;
import net.snowflake.client.jdbc.SnowflakeConnection;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="others")
public class StreamIT
extends BaseJDBCTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUploadStream() throws Throwable {
        String DEST_PREFIX = TEST_UUID + "/testUploadStream";
        try (Connection connection = StreamIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                FileBackedOutputStream outputStream = new FileBackedOutputStream(1000000);
                outputStream.write("hello".getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
                connection.unwrap(SnowflakeConnection.class).uploadStream("~", DEST_PREFIX, outputStream.asByteSource().openStream(), "hello.txt", false);
                try (ResultSet rset = statement.executeQuery("SELECT $1 FROM @~/" + DEST_PREFIX);){
                    String ret = null;
                    while (rset.next()) {
                        ret = rset.getString(1);
                    }
                    Assertions.assertEquals((Object)"hello", (Object)ret, (String)("Unexpected string value: " + ret + " expect: hello"));
                }
            }
            finally {
                statement.execute("rm @~/" + DEST_PREFIX);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testDownloadStream() throws Throwable {
        String DEST_PREFIX = TEST_UUID + "/testUploadStream";
        List<String> supportedAccounts = Arrays.asList("s3testaccount", "azureaccount");
        for (String accountName : supportedAccounts) {
            Connection connection = StreamIT.getConnection(accountName);
            try {
                Statement statement = connection.createStatement();
                try {
                    try {
                        ResultSet rset = statement.executeQuery("PUT file://" + StreamIT.getFullPathFileInResource("orders_100.csv") + " @~/" + DEST_PREFIX);
                        try {
                            Assertions.assertTrue((boolean)rset.next());
                            Assertions.assertEquals((Object)"UPLOADED", (Object)rset.getString(7));
                            InputStream out = connection.unwrap(SnowflakeConnection.class).downloadStream("~", DEST_PREFIX + "/" + "orders_100.csv" + ".gz", true);
                            StringWriter writer = new StringWriter();
                            IOUtils.copy((InputStream)out, (Writer)writer, (String)"UTF-8");
                            String output = writer.toString();
                            Assertions.assertEquals((Object)"1|", (Object)output.substring(0, 2));
                            String[] lines = output.split("\n");
                            Assertions.assertEquals((int)28, (int)lines.length);
                        }
                        finally {
                            if (rset == null) continue;
                            rset.close();
                        }
                    }
                    finally {
                        statement.execute("rm @~/" + DEST_PREFIX);
                    }
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
            finally {
                if (connection == null) continue;
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompressAndUploadStream() throws Throwable {
        String DEST_PREFIX = TEST_UUID + "/testCompressAndUploadStream";
        try (Connection connection = StreamIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                FileBackedOutputStream outputStream = new FileBackedOutputStream(1000000);
                outputStream.write("hello".getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
                connection.unwrap(SnowflakeConnectionV1.class).uploadStream("~", DEST_PREFIX, outputStream.asByteSource().openStream(), "hello.txt", true);
                try (ResultSet rset = statement.executeQuery("SELECT $1 FROM @~/" + DEST_PREFIX);){
                    String ret = null;
                    while (rset.next()) {
                        ret = rset.getString(1);
                    }
                    Assertions.assertEquals((Object)"hello", (Object)ret, (String)("Unexpected string value: " + ret + " expect: hello"));
                }
            }
            finally {
                statement.execute("rm @~/" + DEST_PREFIX);
            }
        }
    }
}

