/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import net.snowflake.client.annotations.DontRunOnGithubActions;
import net.snowflake.client.jdbc.BaseJDBCTest;
import net.snowflake.client.jdbc.FileBackedOutputStream;
import net.snowflake.client.jdbc.SnowflakeConnection;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

@Tag(value="others")
public class StreamLatestIT
extends BaseJDBCTest {
    @TempDir
    private File tmpFolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnusualStageName() throws Throwable {
        String ret = null;
        try (Connection connection = StreamLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                statement.execute("CREATE or replace TABLE \"ice cream (nice)\" (types STRING)");
                FileBackedOutputStream outputStream = new FileBackedOutputStream(1000000);
                outputStream.write("hello".getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
                connection.unwrap(SnowflakeConnection.class).uploadStream("'@%\"ice cream (nice)\"'", null, outputStream.asByteSource().openStream(), "hello.txt", false);
                try (ResultSet rset = statement.executeQuery("SELECT $1 FROM '@%\"ice cream (nice)\"/'");){
                    ret = null;
                    while (rset.next()) {
                        ret = rset.getString(1);
                    }
                    Assertions.assertEquals((Object)"hello", (Object)ret, (String)("Unexpected string value: " + ret + " expect: hello"));
                }
                statement.execute("CREATE or replace TABLE \"ice cream (nice)\" (types STRING)");
                connection.unwrap(SnowflakeConnection.class).uploadStream("$$@%\"ice cream (nice)\"$$", null, outputStream.asByteSource().openStream(), "hello.txt", false);
                rset = statement.executeQuery("SELECT $1 FROM $$@%\"ice cream (nice)\"/$$");
                try {
                    ret = null;
                    while (rset.next()) {
                        ret = rset.getString(1);
                    }
                    Assertions.assertEquals((Object)"hello", (Object)ret, (String)("Unexpected string value: " + ret + " expect: hello"));
                }
                finally {
                    if (rset != null) {
                        rset.close();
                    }
                }
            }
            finally {
                statement.execute("DROP TABLE IF EXISTS \"ice cream (nice)\"");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testDownloadToStreamBlobNotFoundGCS() throws SQLException {
        String DEST_PREFIX = TEST_UUID + "/testUploadStream";
        Properties paramProperties = new Properties();
        paramProperties.put("GCS_USE_DOWNSCOPED_CREDENTIAL", (Object)true);
        try (Connection connection = StreamLatestIT.getConnection("gcpaccount", paramProperties);
             Statement statement = connection.createStatement();){
            try {
                SQLException ex = (SQLException)Assertions.assertThrows(SQLException.class, () -> connection.unwrap(SnowflakeConnection.class).downloadStream("~", DEST_PREFIX + "/abc.gz", true));
                Assertions.assertTrue((boolean)ex.getMessage().contains("File not found"), (String)("Wrong exception message: " + ex.getMessage()));
            }
            finally {
                statement.execute("rm @~/" + DEST_PREFIX);
            }
        }
    }

    @Test
    @Disabled
    public void testDownloadToStreamGCSPresignedUrl() throws SQLException, IOException {
        String DEST_PREFIX = "testUploadStream";
        try (Connection connection = StreamLatestIT.getConnection("gcpaccount");
             Statement statement = connection.createStatement();){
            statement.execute("create or replace stage testgcpstage");
            try (ResultSet rset = statement.executeQuery("PUT file://" + StreamLatestIT.getFullPathFileInResource("orders_100.csv") + " @testgcpstage/" + "testUploadStream");){
                Assertions.assertTrue((boolean)rset.next());
                Assertions.assertEquals((Object)"UPLOADED", (Object)rset.getString(7), (String)("Error message:" + rset.getString(8)));
                InputStream out = connection.unwrap(SnowflakeConnection.class).downloadStream("@testgcpstage", "testUploadStream/orders_100.csv.gz", true);
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)out, (Writer)writer, (String)"UTF-8");
                String output = writer.toString();
                Assertions.assertEquals((Object)"1|", (Object)output.substring(0, 2));
                String[] lines = output.split("\n");
                Assertions.assertEquals((int)28, (int)lines.length);
            }
            statement.execute("rm @~/testUploadStream");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DontRunOnGithubActions
    public void testDownloadToStreamGCS() throws SQLException, IOException {
        String DEST_PREFIX = TEST_UUID + "/testUploadStream";
        Properties paramProperties = new Properties();
        paramProperties.put("GCS_USE_DOWNSCOPED_CREDENTIAL", (Object)true);
        try (Connection connection = StreamLatestIT.getConnection("gcpaccount", paramProperties);
             Statement statement = connection.createStatement();
             ResultSet rset = statement.executeQuery("PUT file://" + StreamLatestIT.getFullPathFileInResource("orders_100.csv") + " @~/" + DEST_PREFIX);){
            try {
                Assertions.assertTrue((boolean)rset.next());
                Assertions.assertEquals((Object)"UPLOADED", (Object)rset.getString(7));
                InputStream out = connection.unwrap(SnowflakeConnection.class).downloadStream("~", DEST_PREFIX + "/" + "orders_100.csv" + ".gz", true);
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)out, (Writer)writer, (String)"UTF-8");
                String output = writer.toString();
                Assertions.assertEquals((Object)"1|", (Object)output.substring(0, 2));
                String[] lines = output.split("\n");
                Assertions.assertEquals((int)28, (int)lines.length);
            }
            finally {
                statement.execute("rm @~/" + DEST_PREFIX);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSpecialCharactersInFileName() throws SQLException, IOException {
        try (Connection connection = StreamLatestIT.getConnection();
             Statement statement = connection.createStatement();){
            try {
                File specialCharFile = new File(this.tmpFolder, "(special char@).txt");
                specialCharFile.createNewFile();
                try (BufferedWriter bw = new BufferedWriter(new FileWriter(specialCharFile));){
                    bw.write("Creating test file for downloadStream test");
                }
                String sourceFilePath = specialCharFile.getCanonicalPath();
                String sourcePathEscaped = System.getProperty("file.separator").equals("\\") ? sourceFilePath.replace("\\", "\\\\") : sourceFilePath;
                statement.execute("CREATE OR REPLACE STAGE downloadStream_stage");
                statement.execute("PUT 'file://" + sourcePathEscaped + "' @~/downloadStream_stage auto_compress=false");
                try (InputStream out = connection.unwrap(SnowflakeConnection.class).downloadStream("~", "/downloadStream_stage/" + specialCharFile.getName(), false);){
                    StringWriter writer = new StringWriter();
                    IOUtils.copy((InputStream)out, (Writer)writer, (String)"UTF-8");
                    String output = writer.toString();
                    Assertions.assertEquals((Object)"Creating test file for downloadStream test", (Object)output);
                }
            }
            finally {
                statement.execute("DROP STAGE IF EXISTS downloadStream_stage");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDownloadStreamInDeterministicWay() throws Exception {
        try (Connection conn = StreamLatestIT.getConnection();
             Statement stat = conn.createStatement();){
            String randomStage = "test" + UUID.randomUUID().toString().replaceAll("-", "");
            try {
                stat.execute("CREATE OR REPLACE STAGE " + randomStage);
                String randomDir = UUID.randomUUID().toString();
                String sourceFilePathWithoutExtension = StreamLatestIT.getFullPathFileInResource("test_file");
                String sourceFilePathWithExtension = StreamLatestIT.getFullPathFileInResource("test_file.csv");
                String stageDest = String.format("@%s/%s", randomStage, randomDir);
                StreamLatestIT.putFile(stat, sourceFilePathWithExtension, stageDest, false);
                StreamLatestIT.putFile(stat, sourceFilePathWithoutExtension, stageDest, false);
                StreamLatestIT.putFile(stat, sourceFilePathWithExtension, stageDest, true);
                StreamLatestIT.putFile(stat, sourceFilePathWithoutExtension, stageDest, true);
                StreamLatestIT.expectsFilesOnStage(stat, stageDest, 4);
                String stageName = "@" + randomStage;
                StreamLatestIT.downloadStreamExpectingContent(conn, stageName, randomDir + "/test_file.gz", true, "I am a file without extension");
                StreamLatestIT.downloadStreamExpectingContent(conn, stageName, randomDir + "/test_file.csv.gz", true, "I am a file with extension");
                StreamLatestIT.downloadStreamExpectingContent(conn, stageName, randomDir + "/test_file", false, "I am a file without extension");
                StreamLatestIT.downloadStreamExpectingContent(conn, stageName, randomDir + "/test_file.csv", false, "I am a file with extension");
            }
            finally {
                stat.execute("DROP STAGE IF EXISTS " + randomStage);
            }
        }
    }

    private static void downloadStreamExpectingContent(Connection conn, String stageName, String fileName, boolean decompress, String expectedFileContent) throws IOException, SQLException {
        try (InputStream inputStream = conn.unwrap(SnowflakeConnectionV1.class).downloadStream(stageName, fileName, decompress);
             InputStreamReader isr = new InputStreamReader(inputStream);
             BufferedReader br = new BufferedReader(isr);){
            String content = br.lines().collect(Collectors.joining("\n"));
            Assertions.assertEquals((Object)expectedFileContent, (Object)content);
        }
    }

    private static void expectsFilesOnStage(Statement stmt, String stageDest, int expectCount) throws SQLException {
        int filesInStageDir = 0;
        try (ResultSet rs = stmt.executeQuery("LIST " + stageDest);){
            while (rs.next()) {
                ++filesInStageDir;
            }
        }
        Assertions.assertEquals((int)expectCount, (int)filesInStageDir);
    }

    private static boolean putFile(Statement stmt, String localFileName, String stageDest, boolean autoCompress) throws SQLException {
        return stmt.execute(String.format("PUT file://%s %s AUTO_COMPRESS=%s", localFileName, stageDest, String.valueOf(autoCompress).toUpperCase()));
    }
}

